/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.comm;

import com.tmax.tibero.Debug;
import com.tmax.tibero.jdbc.comm.TbStreamDataReader;
import com.tmax.tibero.jdbc.comm.TbStreamDataWriter;
import com.tmax.tibero.jdbc.data.ConnectionInfo;
import com.tmax.tibero.jdbc.data.DataTypeConverter;
import com.tmax.tibero.jdbc.data.StreamBuffer;
import com.tmax.tibero.jdbc.driver.TbConnection;
import com.tmax.tibero.jdbc.driver.TbKeepAlive;
import com.tmax.tibero.jdbc.driver.TbResultSetBase;
import com.tmax.tibero.jdbc.err.TbError;
import com.tmax.tibero.jdbc.msg.TbMsgFactory;
import com.tmax.tibero.jdbc.msg.common.TbMsg;
import com.tmax.tibero.jdbc.util.TbCommon;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.security.cert.X509Certificate;
import java.sql.SQLException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class TbStream {
    private Socket socket;
    private TbConnection conn;
    private InputStream input;
    private OutputStream output;
    private String host;
    private int port;
    private int tduSize = 0;
    private int msgType;
    private int msgBodySize = 0;
    private StreamBuffer readBuf;
    private StreamBuffer writeBuf;
    private TbStreamDataReader reader;
    private TbStreamDataWriter writer;
    private StreamBuffer dplBuf;
    private TbStreamDataWriter dplWriter;
    private boolean useSelfKeepAlive;
    private long selfKeepIdle;
    private long selfKeepInterval;
    private int selfKeepCount;
    private TbKeepAlive keepAlive;

    public TbStream(TbConnection conn1, Socket socket, DataTypeConverter typeConverter, ConnectionInfo info) throws SQLException {
        Debug.logMethod("TbStream", new Object[]{conn1, socket});
        try {
            this.conn = conn1;
            this.initTCP(socket, typeConverter, info);
        }
        catch (ConnectException ce) {
            Debug.logThrowable(ce);
            throw TbError.newSQLException(-90401, ce.getMessage());
        }
        catch (IOException ie) {
            Debug.logThrowable(ie);
            throw TbError.newSQLException(-90400, ie.getMessage());
        }
    }

    public TbStream(TbConnection conn1, String host1, int port1, DataTypeConverter typeConverter, ConnectionInfo info) throws SQLException {
        Debug.logMethod("TbStream", new Object[]{conn1, host1, new Integer(port1)});
        try {
            this.conn = conn1;
            this.host = host1;
            this.port = port1;
            if (info.getNetworkProtocol().equalsIgnoreCase("TCPS")) {
                this.initTCPS(typeConverter, info);
            } else {
                Socket socket = new Socket();
                InetSocketAddress address = this.host != null ? new InetSocketAddress(host1, port1) : new InetSocketAddress(InetAddress.getByName(null), port1);
                socket.connect(address, info.getLoginTimeout());
                this.initTCP(socket, typeConverter, info);
            }
        }
        catch (ConnectException ce) {
            throw TbError.newSQLException(-90401, ce.getMessage());
        }
        catch (IOException ie) {
            throw TbError.newSQLException(-90400, ie.getMessage());
        }
    }

    public void close() throws SQLException {
        Debug.logMethod("TbStream.close", new Object[]{this.conn});
        try {
            this.reset();
            IOException ioe = null;
            try {
                if (this.input != null) {
                    this.input.close();
                }
            }
            catch (IOException e) {
                ioe = e;
            }
            try {
                if (this.output != null) {
                    this.output.close();
                }
            }
            catch (IOException e) {
                ioe = e;
            }
            try {
                if (this.socket != null && !this.conn.info.isInternal()) {
                    this.socket.close();
                }
            }
            catch (IOException e) {
                ioe = e;
            }
            if (ioe != null) {
                throw ioe;
            }
        }
        catch (IOException ie) {
            throw TbError.newSQLException(-90409, ie.getMessage());
        }
    }

    public TbStreamDataWriter createDirPathWriter(int initBufSize) {
        if (this.dplBuf == null) {
            this.dplBuf = new StreamBuffer(initBufSize);
        } else if (initBufSize != this.dplBuf.getSize()) {
            this.dplBuf.resize(initBufSize);
        }
        if (this.dplWriter == null) {
            this.dplWriter = new TbStreamDataWriter(this.dplBuf);
        }
        return this.dplWriter;
    }

    public void flush() throws SQLException {
        this.flushInternal(this.writeBuf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush(TbStreamDataWriter writer) throws SQLException {
        StreamBuffer streamBuffer = this.writeBuf;
        synchronized (streamBuffer) {
            this.flushInternal(writer.getStreamBuf());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushInternal(StreamBuffer buf) throws SQLException {
        block10: {
            Debug.logMethod("TbStream.flushInternal", null);
            try {
                if (buf.getCurDataSize() <= 0) break block10;
                if (this.useSelfKeepAlive) {
                    try {
                        this.keepAlive = TbKeepAlive.register(this.socket, this.selfKeepIdle, this.selfKeepInterval, this.selfKeepCount, this.conn.getMthrPid(), this.conn.toString());
                        this.output.write(buf.getRawBytes(), 0, buf.getCurDataSize());
                        this.output.flush();
                        break block10;
                    }
                    finally {
                        if (this.keepAlive != null) {
                            TbKeepAlive.unregister(this.keepAlive);
                            this.keepAlive = null;
                        }
                    }
                }
                this.output.write(buf.getRawBytes(), 0, buf.getCurDataSize());
                this.output.flush();
            }
            catch (IOException ie) {
                SQLException ex = TbError.newSQLException(-90406, ie.getMessage());
                Debug.logMethod("TbStream.flushInternal", new Object[]{ex.getMessage()});
                this.conn.reconnect(this.conn.isMiddleOfFailover());
                if (this.conn.isClosed()) {
                    for (TbResultSetBase rsb : this.conn.getFOActiveRSetList()) {
                        rsb.setFOECode(-90406);
                    }
                    throw ex;
                }
                for (TbResultSetBase rsb : this.conn.getFOActiveRSetList()) {
                    rsb.setFOECode(-90700);
                }
                throw TbError.newSQLException(-90700, ex);
            }
        }
    }

    public int getMsgType() {
        return this.msgType;
    }

    public TbStreamDataWriter getMsgWriter() {
        return this.writer;
    }

    public StreamBuffer getReadStreamBuffer() {
        return this.readBuf;
    }

    public StreamBuffer getWriteStreamBuffer() {
        return this.writeBuf;
    }

    public void handshakeSSL() throws SQLException {
        try {
            ((SSLSocket)this.socket).setUseClientMode(true);
            ((SSLSocket)this.socket).setEnableSessionCreation(true);
            ((SSLSocket)this.socket).startHandshake();
        }
        catch (IOException e) {
            throw TbError.newSQLException(-90400, e.getMessage());
        }
    }

    private void initTCP(Socket sock, DataTypeConverter typeConverter, ConnectionInfo info) throws IOException {
        this.socket = sock;
        this.socket.setTcpNoDelay(true);
        this.socket.setKeepAlive(info.isFailoverSessionEnabled());
        this.socket.setSoTimeout(info.getLoginTimeout());
        this.input = sock.getInputStream();
        this.output = sock.getOutputStream();
        this.tduSize = info.getTDU();
        this.readBuf = new StreamBuffer(this.tduSize);
        this.writeBuf = new StreamBuffer(this.tduSize);
        this.reader = new TbStreamDataReader(this.readBuf, typeConverter);
        this.writer = new TbStreamDataWriter(this.writeBuf, typeConverter);
        this.useSelfKeepAlive = info.useSelfKeepAlive();
        this.selfKeepIdle = info.getSelfKeepIdle() * 1000;
        this.selfKeepInterval = info.getSelfKeepInterval() * 1000;
        this.selfKeepCount = info.getSelfKeepCount();
    }

    private void initTCPS(DataTypeConverter typeConverter, ConnectionInfo info) throws IOException {
        try {
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }

                @Override
                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }
            }};
            SSLContext ctx = SSLContext.getInstance("TLSv1");
            ctx.init(null, trustAllCerts, null);
            SSLSocketFactory socketfactory = ctx.getSocketFactory();
            this.port += 2;
            this.socket = socketfactory.createSocket(this.host, this.port);
            String[] newProtocols = new String[]{"TLSv1"};
            ((SSLSocket)this.socket).setEnabledProtocols(newProtocols);
            ((SSLSocket)this.socket).startHandshake();
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
        this.socket.setTcpNoDelay(true);
        this.socket.setKeepAlive(info.isFailoverSessionEnabled());
        this.socket.setSoTimeout(info.getLoginTimeout());
        this.input = this.socket.getInputStream();
        this.output = this.socket.getOutputStream();
        this.tduSize = info.getTDU();
        this.readBuf = new StreamBuffer(this.tduSize);
        this.writeBuf = new StreamBuffer(this.tduSize);
        this.reader = new TbStreamDataReader(this.readBuf, typeConverter);
        this.writer = new TbStreamDataWriter(this.writeBuf, typeConverter);
        this.useSelfKeepAlive = info.useSelfKeepAlive();
        this.useSelfKeepAlive = info.useSelfKeepAlive();
        this.selfKeepIdle = info.getSelfKeepIdle() * 1000;
        this.selfKeepInterval = info.getSelfKeepInterval() * 1000;
        this.selfKeepCount = info.getSelfKeepCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readChunkData(byte[] buf, int chunkSize) throws SQLException {
        Debug.logMethod("TbStream.readChunkData", new Object[]{Integer.toString(chunkSize)});
        StreamBuffer streamBuffer = this.readBuf;
        synchronized (streamBuffer) {
            if (this.readNBytes(buf, 0, chunkSize) != chunkSize) {
                throw TbError.newSQLException(-590729);
            }
            this.msgBodySize = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TbMsg readMsg() throws SQLException {
        TbMsg msg = null;
        StreamBuffer streamBuffer = this.readBuf;
        synchronized (streamBuffer) {
            byte[] header = new byte[16];
            this.readNBytes(header, 0, 16);
            this.msgType = TbCommon.bytes2Int(header, 0, 4);
            this.msgBodySize = TbCommon.bytes2Int(header, 4, 4);
            msg = TbMsgFactory.createMessage(this.msgType);
            msg.setTsn(TbCommon.bytes2Long(header, 8, 8));
            if (this.msgBodySize <= 0) {
                return msg;
            }
            this.readBuf.init(this.msgBodySize);
            if (this.readNBytes(this.readBuf.getRawBytes(), 0, this.msgBodySize) != this.msgBodySize) {
                throw TbError.newSQLException(-590729);
            }
            this.readBuf.setCurDataSize(this.msgBodySize);
            this.reader.initialize(this.readBuf);
            this.msgBodySize = 0;
            msg.deserialize(this.reader);
        }
        Debug.log("TbStream.readMsg: " + msg.toString());
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int readNBytes(byte[] bytes, int offset, int len) throws SQLException {
        Debug.logMethod("TbStream.readNBytes", new Object[]{bytes, new Integer(offset), new Integer(len)});
        try {
            long waitingTime = 0L;
            int totalRead = 0;
            if (this.conn.isActivatedTimer()) {
                waitingTime = System.currentTimeMillis();
            }
            if (this.useSelfKeepAlive) {
                int i = 0;
                while (totalRead != len) {
                    try {
                        this.keepAlive = TbKeepAlive.register(this.socket, this.selfKeepIdle, this.selfKeepInterval, this.selfKeepCount, this.conn.getMthrPid(), this.conn.toString());
                        i = this.input.read(bytes, offset + totalRead, len - totalRead);
                    }
                    finally {
                        if (this.keepAlive != null) {
                            TbKeepAlive.unregister(this.keepAlive);
                            this.keepAlive = null;
                        }
                    }
                    if (i == -1) {
                        throw new IOException("End Of Stream");
                    }
                    totalRead += i;
                }
            } else {
                int i = 0;
                while (totalRead != len) {
                    i = this.input.read(bytes, offset + totalRead, len - totalRead);
                    if (i == -1) {
                        throw new IOException("End Of Stream");
                    }
                    totalRead += i;
                }
            }
            if (this.conn.isActivatedTimer()) {
                this.conn.addWaitingTime(System.currentTimeMillis() - waitingTime);
            }
            return totalRead;
        }
        catch (IOException ie) {
            SQLException ex = TbError.newSQLException(-90405, ie.getMessage());
            Debug.logMethod("TbStream.readNBytes", new Object[]{ex.getMessage()});
            this.conn.reconnect(this.conn.isMiddleOfFailover());
            if (this.conn.isClosed()) {
                for (TbResultSetBase rsb : this.conn.getFOActiveRSetList()) {
                    rsb.setFOECode(-90405);
                }
                throw ex;
            }
            for (TbResultSetBase rsb : this.conn.getFOActiveRSetList()) {
                rsb.setFOECode(-90700);
            }
            throw TbError.newSQLException(-90700, ex);
        }
    }

    public void reset() {
        this.tduSize = 0;
        this.input = null;
        this.output = null;
        this.reader.reset();
        this.writer.reset();
    }

    public void setSoTimeout(int timeout) {
        try {
            this.socket.setSoTimeout(timeout);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setSelfKeepAliveEnabled(boolean enabled) {
        this.useSelfKeepAlive = enabled;
    }

    public void startWritingPacketData() {
        this.writer.initialize(this.writeBuf);
    }
}

