/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc;

import com.tmax.tibero.Debug;
import com.tmax.tibero.DriverConstants;
import com.tmax.tibero.jdbc.TbClob;
import com.tmax.tibero.jdbc.TbNClob;
import com.tmax.tibero.jdbc.comm.TbLobAccessor;
import com.tmax.tibero.jdbc.data.DataTypeConverter;
import com.tmax.tibero.jdbc.driver.TbConnection;
import com.tmax.tibero.jdbc.err.TbError;
import java.sql.SQLException;

public abstract class TbLob {
    public static final int MODE_READONLY = 0;
    public static final int MODE_READWRITE = 1;
    public static final int LOBLOC_LEN = 96;
    public static final int LOBLOC_DATA_APPENDED = 4;
    public static final int LOBLOC_IS_TEMPORARY = 4;
    private static int maxChunkSize = 32000;
    private TbConnection conn = null;
    private byte[] locator = null;
    private byte[] data = null;
    private boolean endOfStream = false;
    private boolean isEmpty = false;
    private boolean isDataAppendMode = false;
    private boolean isTempLob = false;
    private boolean freeTmpLobOnEOF = false;
    private long length = -1L;

    public TbLob(TbConnection conn, byte[] loc, boolean freeTmpLobOnEOF) {
        this.conn = conn;
        if (loc.length == 1) {
            this.locator = loc;
            this.isEmpty = true;
        } else if ((loc[5] & 4) == 4) {
            this.locator = new byte[96];
            System.arraycopy(loc, 0, this.locator, 0, 96);
            int dataLen = loc.length - 96;
            this.data = new byte[dataLen];
            System.arraycopy(loc, 96, this.data, 0, dataLen);
            this.isDataAppendMode = true;
        } else if ((loc[4] & 4) == 4) {
            this.locator = loc;
            this.freeTmpLobOnEOF = freeTmpLobOnEOF;
            this.isTempLob = true;
        } else {
            this.locator = loc;
        }
    }

    public void checkInvalidActionOnEmpty() throws SQLException {
        if (this.isEmpty) {
            throw TbError.newSQLException(-90629);
        }
    }

    public void close() throws SQLException {
        Debug.logMethod("TbLob.close", new Object[]{this});
        this.checkInvalidActionOnEmpty();
    }

    public void free() throws SQLException {
        Debug.logMethod("TbLob.free", new Object[]{this});
        this.checkInvalidActionOnEmpty();
        this.getLobAccessor().freeTemporary(this);
    }

    public TbConnection getConnection() {
        return this.conn;
    }

    public byte[] getLobData() {
        return this.data;
    }

    public byte[] getLocator() {
        return this.locator;
    }

    public boolean getIsTempLob() {
        return this.isTempLob;
    }

    public boolean freeTmpLobOnEOF() {
        return this.freeTmpLobOnEOF;
    }

    protected abstract TbLobAccessor getLobAccessor();

    private int getFixedSlobLen() {
        int slobLen = this.locator[0] << 8;
        return slobLen += this.locator[1];
    }

    public int getLocatorLength() {
        if (!this.isInline()) {
            return this.locator == null ? 0 : this.locator.length;
        }
        if ((this.locator[4] & 4) != 0) {
            return this.locator.length;
        }
        return this.getFixedSlobLen();
    }

    public boolean isEndOfStream() {
        return this.endOfStream;
    }

    public long length() throws SQLException {
        Debug.logMethod("TbLob.length", new Object[]{this});
        this.checkInvalidActionOnEmpty();
        if (this.length < 0L) {
            this.length = this.isDataAppendMode ? (this.data == null ? 0L : (long)this.data.length) : this.getLobAccessor().length(this);
        }
        return this.length;
    }

    protected long getLengthInternal() {
        return this.length;
    }

    public void open(int mode) throws SQLException {
        Debug.logMethod("TbLob.open", new Object[]{this, Integer.toString(mode)});
        this.checkInvalidActionOnEmpty();
        if (mode != 0 && mode != 1) {
            throw TbError.newSQLException(-590769);
        }
    }

    public long position(TbLob pattern, long start) throws SQLException {
        Debug.logMethod("TbLob.position", new Object[]{this, pattern, Long.toString(start)});
        this.checkInvalidActionOnEmpty();
        if (start < 1L) {
            throw TbError.newSQLException(-590766, start);
        }
        return this.getLobAccessor().position(this, pattern, start - 1L);
    }

    public void setEndOfStream(boolean flag) {
        this.endOfStream = flag;
    }

    public void setLocator(byte[] loc) {
        this.locator = loc;
    }

    public static void setMaxChunkSize(int size) {
        maxChunkSize = size >= 8 * DriverConstants.MEGA ? 8 * DriverConstants.MEGA : size;
    }

    public static int getMaxChunkSize() {
        return maxChunkSize;
    }

    public void truncate(long len) throws SQLException {
        Debug.logMethod("TbLob.truncate", new Object[]{this, Long.toString(len)});
        this.checkInvalidActionOnEmpty();
        if (len < 0L) {
            throw TbError.newSQLException(-590765, len);
        }
        this.getLobAccessor().truncate(this, len);
    }

    public boolean isInline() {
        return !this.isEmpty && (this.locator[5] & 0x10) != 0;
    }

    public boolean isXML() {
        return !this.isEmpty && (this.locator[5] & 8) != 0;
    }

    public boolean isRemote() {
        return !this.isEmpty && (this.locator[5] & 2) != 0;
    }

    public int getIlobLength() {
        return this.locator.length - this.getFixedSlobLen();
    }

    public int readIlob(int pos, char[] cbuf, byte[] bbuf, int bufOffset, int len, DataTypeConverter typeConverter, boolean is_remote) throws SQLException {
        int dataLen;
        int dataOff;
        int lobLen = 0;
        if (is_remote) {
            lobLen = this.getIlobLength() - this.getFixedSlobLen();
            if (pos > lobLen) {
                throw TbError.newSQLException(-590785, pos);
            }
            dataOff = 2 * this.getFixedSlobLen() + pos;
            dataLen = Math.min(len, lobLen - pos);
        } else {
            lobLen = this.getIlobLength();
            if (pos > lobLen) {
                throw TbError.newSQLException(-590785, pos);
            }
            dataOff = this.getFixedSlobLen() + pos;
            dataLen = Math.min(len, lobLen - pos);
        }
        if (dataLen == 0) {
            this.endOfStream = true;
            return 0;
        }
        if (dataLen < len) {
            this.endOfStream = true;
        }
        if (this instanceof TbClob || this instanceof TbNClob) {
            return typeConverter.fixedBytesToChars(this.locator, dataOff, dataLen, cbuf, bufOffset, cbuf.length - bufOffset);
        }
        System.arraycopy(this.locator, dataOff, bbuf, bufOffset, dataLen);
        return dataLen;
    }
}

