/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero;

import com.tmax.tibero.DriverConstants;
import com.tmax.tibero.jdbc.util.TbRandom;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.sql.DriverManager;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.zip.GZIPOutputStream;

public class Debug {
    public static final boolean TRACE = true;
    public static final boolean NETWORK = false;
    public static final boolean CONNECTION = true;
    public static final boolean FAILOVER = false;
    private static final int CAT_METHOD = 0;
    private static final int CAT_RETURN = 1;
    private static final int CAT_MSG = 2;
    private static SimpleDateFormat dateFormat;
    private static SimpleDateFormat logFileDateFormat;
    private static PrintWriter lw;
    private static String logFileName;
    private static final long DEFAULT_MAX_LOG_FILE_LENGTH;
    private static final int DEFAULT_LOG_ROTATION_PERIOD = -1;
    private static long lastCreateTime;
    private static String logDir;
    private static long logFileMax;
    private static int logRotationPeriod;
    private static boolean logFileCompression;
    private static boolean logFileOverwrite;
    private static String initMsg;

    private static String genNewFileName() {
        String fileSep = System.getProperty("file.separator");
        StringBuffer sbFile = new StringBuffer(128);
        sbFile.append(logDir).append(fileSep);
        sbFile.append(Debug.getLogFilePrefix()).append('-').append(Debug.getUniqueNumber()).append(".log");
        if (logFileCompression) {
            sbFile.append(".gz");
        }
        return sbFile.toString();
    }

    private static void genNewFile() {
        while (true) {
            try {
                lw = logFileCompression ? new PrintWriter(new GZIPOutputStream(new FileOutputStream(logFileName))) : new PrintWriter(new FileWriter(logFileName));
                lastCreateTime = System.currentTimeMillis();
                if (initMsg == null) break;
                lw.write(initMsg);
                lw.write("This file created: " + Debug.getTimeString() + "\n");
                lw.flush();
            }
            catch (IOException iOException) {
                continue;
            }
            break;
        }
    }

    private static String byteToString(byte b) {
        if (b >= 32 && b <= 125) {
            return String.valueOf((char)b);
        }
        return ".";
    }

    public static String getHexFromBytes(byte[] bytes) {
        return Debug.getHexFromBytes(bytes, bytes == null ? 0 : bytes.length);
    }

    private static String getHexFromBytes(byte[] bytes, int maxLength) {
        StringBuffer buf = new StringBuffer(128);
        if (bytes == null || maxLength < 0) {
            return null;
        }
        int prtLen = Math.min(bytes.length, maxLength);
        StringBuffer byteBuf = new StringBuffer(16);
        for (int i = 0; i < prtLen; ++i) {
            buf.append(Debug.hexFormat(0xFF & bytes[i]));
            buf.append(" ");
            byteBuf.append(Debug.byteToString(bytes[i]));
            if (i % 16 != 15 && i != prtLen - 1) continue;
            buf.append("  ");
            if (i == prtLen - 1) {
                for (int k = i % 16; k < 15; ++k) {
                    buf.append("   ");
                }
            }
            buf.append("; ").append(byteBuf.toString());
            buf.append("\n");
            byteBuf.setLength(0);
        }
        return buf.toString();
    }

    public static String getHexFromBytes(byte[] bytes, int offset, int len) {
        byte[] newbytes = new byte[len];
        System.arraycopy(bytes, offset, newbytes, 0, len);
        return Debug.getHexFromBytes(newbytes, len);
    }

    private static String getLogFilePrefix() {
        String prefix = logFileDateFormat.format(new Date());
        if (prefix.length() == 14) {
            return DriverConstants.JDBC_PRODUCT_NAME + "-" + prefix + "000";
        }
        if (prefix.length() == 15) {
            return DriverConstants.JDBC_PRODUCT_NAME + "-" + prefix + "00";
        }
        if (prefix.length() == 16) {
            return DriverConstants.JDBC_PRODUCT_NAME + "-" + prefix + "0";
        }
        return DriverConstants.JDBC_PRODUCT_NAME + "-" + prefix;
    }

    public static PrintWriter getLogWriter() {
        return lw;
    }

    private static String getTimeString() {
        String time;
        if (dateFormat == null) {
            dateFormat = new SimpleDateFormat("HH:mm:ss.S");
        }
        if ((time = dateFormat.format(new Date())).length() == 9) {
            return time + "000";
        }
        if (time.length() == 10) {
            return time + "00";
        }
        if (time.length() == 11) {
            return time + "0";
        }
        return time;
    }

    private static String getUniqueNumber() {
        int uniqueNumber = TbRandom.nextInt(65536);
        String uniqueString = Integer.toHexString(uniqueNumber).toUpperCase();
        if (uniqueString.length() == 1) {
            return "000" + uniqueString;
        }
        if (uniqueString.length() == 2) {
            return "00" + uniqueString;
        }
        if (uniqueString.length() == 3) {
            return "0" + uniqueString;
        }
        return uniqueString;
    }

    private static String hexFormat(int i) {
        String s = Integer.toHexString(i);
        if (s.length() == 1) {
            s = "0" + s;
        }
        return s;
    }

    public static void log(String msg) {
        Debug.print(2, msg + "\n");
    }

    public static void logMethod(String methodName, Object[] args) {
        StringBuffer sb = new StringBuffer(1024);
        sb.append(methodName + "(");
        if (args == null) {
            sb.append(")\n");
            Debug.print(0, sb.toString());
            return;
        }
        for (int i = 0; i < args.length; ++i) {
            if (args[i] != null) {
                sb.append("\"" + args[i].toString() + "\"");
            } else {
                sb.append("null");
            }
            if (i >= args.length - 1) continue;
            sb.append(", ");
        }
        sb.append(")\n");
        Debug.print(0, sb.toString());
    }

    public static void logMethod(String methodName, String[] names, Object[] args) {
        StringBuffer sb = new StringBuffer(1024);
        sb.append(methodName + "(");
        if (args == null) {
            sb.append(")\n");
            Debug.print(0, sb.toString());
            return;
        }
        for (int i = 0; i < args.length; ++i) {
            if (args[i] != null) {
                sb.append(args[i].toString());
            } else {
                sb.append("null");
            }
            if (i >= args.length - 1) continue;
            sb.append(", ");
        }
        sb.append(")\n");
        Debug.print(0, sb.toString());
    }

    public static void logReturn(String methodName, Object returnValue) {
        Debug.print(1, methodName + "() returns " + returnValue + "\n");
    }

    public static void logThrowable(Throwable t) {
        if (t == null) {
            return;
        }
        String msg = Debug.getPrintStackTraceString(t);
        Debug.print(2, msg + "\n");
    }

    public static String getPrintStackTraceString(Throwable t) {
        String ret = "";
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(out);
        t.printStackTrace(ps);
        ret = out.toString();
        return ret;
    }

    private static void print(int cat, String msg) {
        if (lw == null) {
            return;
        }
        StringBuffer buf = new StringBuffer(msg.length() + 64);
        buf.append(Debug.getTimeString());
        Thread curThr = Thread.currentThread();
        if (curThr != null) {
            buf.append(" [");
            buf.append(curThr.getName());
            buf.append("] ");
        }
        buf.append(msg);
        File logFile = new File(logFileName);
        if (logFile.length() + (long)buf.length() > logFileMax || logRotationPeriod > 0 && System.currentTimeMillis() - lastCreateTime > (long)logRotationPeriod) {
            lw.close();
            if (logFileOverwrite) {
                logFile.delete();
                Debug.genNewFile();
            } else {
                logFileName = Debug.genNewFileName();
                Debug.genNewFile();
            }
        }
        lw.write(buf.toString());
        lw.flush();
    }

    public static void setLogWriter(PrintWriter writer) {
        lw = writer;
    }

    static {
        String logPeriodInput;
        String logMaxInput;
        File dir;
        dateFormat = null;
        logFileDateFormat = null;
        lw = null;
        logFileName = null;
        DEFAULT_MAX_LOG_FILE_LENGTH = DriverConstants.GIGA * 1;
        lastCreateTime = 0L;
        logDir = null;
        logFileMax = -1L;
        logRotationPeriod = -1;
        logFileCompression = false;
        logFileOverwrite = true;
        initMsg = null;
        lw = DriverManager.getLogWriter();
        String branch = DriverConstants.BUILD_BRANCH.equals("UNKNOWN") ? "" : DriverConstants.BUILD_BRANCH;
        String patches = DriverConstants.BUILD_PATCHFILES.equals("UNKNOWN") ? "(none)" : DriverConstants.BUILD_PATCHFILES;
        StringBuffer sb = new StringBuffer();
        sb.append("********************************************************************************\n\n* ").append(DriverConstants.BRAND_NAME).append(" JDBC Trace Log\n* Driver version : ").append(DriverConstants.JDBC_MAJOR).append(".").append(DriverConstants.JDBC_MINOR).append(" ").append(branch).append(" (Rev.").append(DriverConstants.JDBC_REVISION).append(")\n* Patch files : ").append(patches).append("\n* Trace is started on ").append(Debug.getTimeString()).append("\n*\n********************************************************************************\n");
        initMsg = sb.toString();
        String logDirInput = System.getProperty(DriverConstants.JDBC_PACKAGE_NAME + ".jdbc.logging.basedir");
        String userHomeDir = null;
        if (logDirInput != null && (dir = new File(logDirInput)).isDirectory() && dir.canWrite()) {
            logDir = logDirInput;
        }
        if (logDir == null && (userHomeDir = System.getProperty("user.home")) != null) {
            logDir = userHomeDir;
        }
        if ((logMaxInput = System.getProperty(DriverConstants.JDBC_PACKAGE_NAME + ".jdbc.logging.file.maxsize")) != null) {
            try {
                logMaxInput = logMaxInput.trim();
                if (logMaxInput.length() > 0) {
                    char lastCh = logMaxInput.charAt(logMaxInput.length() - 1);
                    int multiply = 1;
                    switch (lastCh) {
                        case 'K': 
                        case 'k': {
                            multiply *= 1024;
                            logMaxInput = logMaxInput.substring(0, logMaxInput.length() - 1);
                            break;
                        }
                        case 'M': 
                        case 'm': {
                            multiply *= 0x100000;
                            logMaxInput = logMaxInput.substring(0, logMaxInput.length() - 1);
                            break;
                        }
                        case 'G': 
                        case 'g': {
                            multiply *= 0x40000000;
                            logMaxInput = logMaxInput.substring(0, logMaxInput.length() - 1);
                        }
                    }
                    logFileMax = Long.parseLong(logMaxInput) * (long)multiply;
                }
            }
            catch (Exception e) {
                logFileMax = DEFAULT_MAX_LOG_FILE_LENGTH;
            }
        }
        if (logFileMax <= 0L) {
            logFileMax = DEFAULT_MAX_LOG_FILE_LENGTH;
        }
        if ((logPeriodInput = System.getProperty(DriverConstants.JDBC_PACKAGE_NAME + ".jdbc.logging.rotation.period")) != null) {
            try {
                logPeriodInput = logPeriodInput.trim();
                if (logPeriodInput.length() > 0) {
                    char lastCh = logPeriodInput.charAt(logPeriodInput.length() - 1);
                    int multiply = 1000;
                    switch (lastCh) {
                        case 'S': 
                        case 's': {
                            logPeriodInput = logPeriodInput.substring(0, logPeriodInput.length() - 1);
                            break;
                        }
                        case 'M': 
                        case 'm': {
                            multiply *= 60;
                            logPeriodInput = logPeriodInput.substring(0, logPeriodInput.length() - 1);
                            break;
                        }
                        case 'H': 
                        case 'h': {
                            multiply *= 3600;
                            logPeriodInput = logPeriodInput.substring(0, logPeriodInput.length() - 1);
                            break;
                        }
                        case 'D': 
                        case 'd': {
                            multiply *= 86400;
                            logPeriodInput = logPeriodInput.substring(0, logPeriodInput.length() - 1);
                        }
                    }
                    logRotationPeriod = Integer.parseInt(logPeriodInput) * multiply;
                }
            }
            catch (Exception e) {
                logRotationPeriod = -1;
            }
        }
        if (logRotationPeriod <= 60000) {
            logRotationPeriod = -1;
        }
        if (logFileDateFormat == null) {
            logFileDateFormat = new SimpleDateFormat("yyMMdd-HHmmss-S");
        }
        logFileCompression = "true".equalsIgnoreCase(System.getProperty(DriverConstants.JDBC_PACKAGE_NAME + ".jdbc.logging.compression"));
        logFileOverwrite = !"false".equalsIgnoreCase(System.getProperty(DriverConstants.JDBC_PACKAGE_NAME + ".jdbc.logging.overwrite"));
        logFileName = Debug.genNewFileName();
        Debug.genNewFile();
    }
}

