/*
 * Decompiled with CFR 0.152.
 */
package core.log.util.format;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.StringTokenizer;

public class Formatter {
    private static final Set BEGIN_CLAUSES = new HashSet();
    private static final Set END_CLAUSES = new HashSet();
    private static final Set LOGICAL = new HashSet();
    private static final Set QUANTIFIERS = new HashSet();
    private static final Set DML = new HashSet();
    private static final Set MISC = new HashSet();
    String indentString = "    ";
    String initial = "\n    ";
    boolean beginLine = true;
    boolean afterBeginBeforeEnd = false;
    boolean afterByOrSetOrFromOrSelect = false;
    boolean afterValues = false;
    boolean afterOn = false;
    boolean afterBetween = false;
    boolean afterInsert = false;
    int inFunction = 0;
    int parensSinceSelect = 0;
    private LinkedList parenCounts = new LinkedList();
    private LinkedList afterByOrFromOrSelects = new LinkedList();
    int indent = 1;
    StringBuffer result = new StringBuffer();
    StringTokenizer tokens;
    String lastToken;
    String token;
    String lcToken;

    public Formatter(String sql) {
        this.tokens = new StringTokenizer(sql, "()+*/-=<>'`\"[]," + " \n\r\f\t", true);
    }

    public Formatter setInitialString(String initial) {
        this.initial = initial;
        return this;
    }

    public Formatter setIndentString(String indent) {
        this.indentString = indent;
        return this;
    }

    public String format() {
        this.result.append(this.initial);
        while (this.tokens.hasMoreTokens()) {
            String t;
            this.token = this.tokens.nextToken();
            this.lcToken = this.token.toLowerCase();
            if ("'".equals(this.token)) {
                do {
                    t = this.tokens.nextToken();
                    this.token = this.token + t;
                } while (!"'".equals(t) && this.tokens.hasMoreTokens());
            } else if ("\"".equals(this.token)) {
                do {
                    t = this.tokens.nextToken();
                    this.token = this.token + t;
                } while (!"\"".equals(t));
            }
            if (this.afterByOrSetOrFromOrSelect && ",".equals(this.token)) {
                this.commaAfterByOrFromOrSelect();
            } else if (this.afterOn && ",".equals(this.token)) {
                this.commaAfterOn();
            } else if ("(".equals(this.token)) {
                this.openParen();
            } else if (")".equals(this.token)) {
                this.closeParen();
            } else if (BEGIN_CLAUSES.contains(this.lcToken)) {
                this.beginNewClause();
            } else if (END_CLAUSES.contains(this.lcToken)) {
                this.endNewClause();
            } else if ("select".equals(this.lcToken)) {
                this.select();
            } else if (DML.contains(this.lcToken)) {
                this.updateOrInsertOrDelete();
            } else if ("values".equals(this.lcToken)) {
                this.values();
            } else if ("on".equals(this.lcToken)) {
                this.on();
            } else if (this.afterBetween && this.lcToken.equals("and")) {
                this.misc();
                this.afterBetween = false;
            } else if (LOGICAL.contains(this.lcToken)) {
                this.logical();
            } else if (Formatter.isWhitespace(this.token)) {
                this.white();
            } else {
                this.misc();
            }
            if (Formatter.isWhitespace(this.token)) continue;
            this.lastToken = this.lcToken;
        }
        return this.result.toString();
    }

    private void commaAfterOn() {
        this.out();
        --this.indent;
        this.newline();
        this.afterOn = false;
        this.afterByOrSetOrFromOrSelect = true;
    }

    private void commaAfterByOrFromOrSelect() {
        this.out();
        this.newline();
    }

    private void logical() {
        if ("end".equals(this.lcToken)) {
            --this.indent;
        }
        this.newline();
        this.out();
        this.beginLine = false;
    }

    private void on() {
        ++this.indent;
        this.afterOn = true;
        this.newline();
        this.out();
        this.beginLine = false;
    }

    private void misc() {
        this.out();
        if ("between".equals(this.lcToken)) {
            this.afterBetween = true;
        }
        if (this.afterInsert) {
            this.newline();
            this.afterInsert = false;
        } else {
            this.beginLine = false;
            if ("case".equals(this.lcToken)) {
                ++this.indent;
            }
        }
    }

    private void white() {
        if (!this.beginLine) {
            this.result.append(" ");
        }
    }

    private void updateOrInsertOrDelete() {
        this.out();
        ++this.indent;
        this.beginLine = false;
        if ("update".equals(this.lcToken)) {
            this.newline();
        }
        if ("insert".equals(this.lcToken)) {
            this.afterInsert = true;
        }
    }

    private void select() {
        this.out();
        ++this.indent;
        this.newline();
        this.parenCounts.addLast(new Integer(this.parensSinceSelect));
        this.afterByOrFromOrSelects.addLast(new Boolean(this.afterByOrSetOrFromOrSelect));
        this.parensSinceSelect = 0;
        this.afterByOrSetOrFromOrSelect = true;
    }

    private void out() {
        this.result.append(this.token);
    }

    private void endNewClause() {
        if (!this.afterBeginBeforeEnd) {
            --this.indent;
            if (this.afterOn) {
                --this.indent;
                this.afterOn = false;
            }
            this.newline();
        }
        this.out();
        if (!"union".equals(this.lcToken)) {
            ++this.indent;
        }
        this.newline();
        this.afterBeginBeforeEnd = false;
        this.afterByOrSetOrFromOrSelect = "by".equals(this.lcToken) || "set".equals(this.lcToken) || "from".equals(this.lcToken);
    }

    private void beginNewClause() {
        if (!this.afterBeginBeforeEnd) {
            if (this.afterOn) {
                --this.indent;
                this.afterOn = false;
            }
            --this.indent;
            this.newline();
        }
        this.out();
        this.beginLine = false;
        this.afterBeginBeforeEnd = true;
    }

    private void values() {
        --this.indent;
        this.newline();
        this.out();
        ++this.indent;
        this.newline();
        this.afterValues = true;
    }

    private void closeParen() {
        --this.parensSinceSelect;
        if (this.parensSinceSelect < 0) {
            --this.indent;
            this.parensSinceSelect = (Integer)this.parenCounts.removeLast();
            this.afterByOrSetOrFromOrSelect = (Boolean)this.afterByOrFromOrSelects.removeLast();
        }
        if (this.inFunction > 0) {
            --this.inFunction;
            this.out();
        } else {
            if (!this.afterByOrSetOrFromOrSelect) {
                --this.indent;
                this.newline();
            }
            this.out();
        }
        this.beginLine = false;
    }

    private void openParen() {
        if (Formatter.isFunctionName(this.lastToken) || this.inFunction > 0) {
            ++this.inFunction;
        }
        this.beginLine = false;
        if (this.inFunction > 0) {
            this.out();
        } else {
            this.out();
            if (!this.afterByOrSetOrFromOrSelect) {
                ++this.indent;
                this.newline();
                this.beginLine = true;
            }
        }
        ++this.parensSinceSelect;
    }

    private static boolean isFunctionName(String tok) {
        char begin = tok.charAt(0);
        boolean isIdentifier = Character.isJavaIdentifierStart(begin) || '\"' == begin;
        return isIdentifier && !LOGICAL.contains(tok) && !END_CLAUSES.contains(tok) && !QUANTIFIERS.contains(tok) && !DML.contains(tok) && !MISC.contains(tok);
    }

    private static boolean isWhitespace(String token) {
        return " \n\r\f\t".indexOf(token) >= 0;
    }

    private void newline() {
        this.result.append("\n");
        for (int i = 0; i < this.indent; ++i) {
            this.result.append(this.indentString);
        }
        this.beginLine = true;
    }

    public static void main(String[] args) {
        String query = " SELECT T.PLANID, T.PLANGBN, DECODE(T.PLANID, 'ONLINE', '', FN_COM_GETCODENAME(T.PLANGBN)) PLANGBNM, T.SECFLAG, T.SECGBN, T.SECAREA, T.OPENFLAG, T.REPEATKIND, T.RSDATE, T.REDATE, T.MONTH, T.WEEK, T.WEEKNAME, T.DAY, T.AUTOFLAG, T.INID, T.INNAME, T.EXEFLAG_LOGINID, T.REPEATID, T.PLANDATE, T.TITLE, T.PLACE, T.PLAN_ORDER, T.STARTTIME, T.ENDTIME, '' CONTENTS, T.UNCHFLAG, T.DELFLAG, T.ATTACHID, T.PERSONID, T.PERSONNM, T.EXEFLAG, T.OWNER_DEPTID, 'Y' IS_OPEN, T.RESULTID, T.REFLAG, T.DEPTID, T.DEPTNAME, T.OWNERID, T.OWNERNAME, T.DUTYNAME, T.POSITIONID, T.GRADEID, T.RESULT_TITLE, '' RESULT_CONTENTS, T.RESULTDATE, '' ETC, T.RESULT_ATTACHID, T.RESULT_INDT, T.RNUM, T.TASKCARDID, JT.CARDNAME TASKCARDNM, JT.STATUS TASKCARD_STATUS, T.PJTCARDID, JP.CARDNAME PJTCARDNM, JP.STATUS PJTCARD_STATUS, T.ORGCARDID, JO.CARDNAME ORGCARDNM, JO.STATUS ORGCARD_STATUS, JT.DELFLAG TASKCARD_DELFLAG, JP.DELFLAG PJTCARD_DELFLAG, JO.DELFLAG ORGCARD_DELFLAG FROM ( SELECT A.PLANID, A.PLANGBN, A.SECFLAG, A.SECGBN, A.SECAREA, A.OPENFLAG, A.REPEATKIND, A.RSDATE, A.REDATE, A.MONTH, A.WEEK, A.WEEKNAME, A.DAY, A.AUTOFLAG, A.INID, A.INNAME, A.EXEFLAG_LOGINID, A.REPEATID, A.PLANDATE, A.TITLE, A.PLACE, A.PLAN_ORDER, A.STARTTIME, A.ENDTIME, A.UNCHFLAG, A.DELFLAG, A.ATTACHID, A.PERSONID, A.PERSONNM, A.EXEFLAG, A.OWNER_DEPTID, A.RESULTID, A.REFLAG, A.DEPTID, A.DEPTNAME, A.OWNERID, A.OWNERNAME, A.DUTYNAME, A.POSITIONID, A.GRADEID, A.RESULT_TITLE, A.RESULTDATE, A.RESULT_ATTACHID, A.RESULT_INDT, IT.PJTCARDID TASKCARDID, IP.PJTCARDID PJTCARDID, IO.PJTCARDID ORGCARDID, ROW_NUMBER() OVER( ORDER BY A.PLANDATE, A.STARTTIME, A.ENDTIME, A.PLANID, A.REPEATID, A.RESULTDATE, A.RESULT_INDT, A.RESULTID) AS RNUM FROM ( SELECT A.PLANID, A.PLANGBN, A.SECFLAG, A.SECGBN, A.SECAREA, A.OPENFLAG, A.REPEATKIND, A.RSDATE, A.REDATE, A.MONTH , A.WEEK, A.WEEKNAME, A.DAY, A.AUTOFLAG, A.INID, A.INNAME, C.EXEFLAG EXEFLAG_LOGINID, B.REPEATID, B.PLANDATE, B.TITLE, B.PLACE, DECODE( B.UNCHFLAG , 'Y', 1, 2 ) PLAN_ORDER, B.STARTTIME, B.ENDTIME, B.UNCHFLAG, B.DELFLAG, B.ATTACHID, C.PERSONID, C.OWNERNAME PERSONNM, C.EXEFLAG, C.DEPTID OWNER_DEPTID, NVL(D.RESULTID, '0') RESULTID, D.REFLAG, D.DEPTID, D.DEPTNAME, D.OWNERID, D.OWNERNAME, D.DUTYNAME, D.POSITIONID, D.GRADEID, D.TITLE RESULT_TITLE, D.RESULTDATE, D.ATTACHID RESULT_ATTACHID, D.INDT RESULT_INDT FROM BMS_TASK_PERPLAN_BASIC A, BMS_TASK_PERPLAN_DETAIL B, BMS_TASK_PEROWNER C, BMS_TASK_PERRESULT D WHERE C.PERSONID = 'b7594604abf340288755060412104305' /**P*/ AND C.REDATE >= '20080411' /**P*/ AND C.RSDATE <= '20080411' /**P*/ AND C.DELFLAG = 'N' AND A.PLANID = C.PLANID AND A.DELFLAG = 'N' AND A.SECFLAG IN ( 'N', 'M' ) AND A.REPEATKIND NOT IN ( 'DY' ) AND ( C.EXEFLAG = 'Y' OR A.OPENFLAG = 'Y' ) AND B.PLANID = C.PLANID AND B.PLANDATE < C.INVALIDDT AND B.PLANDATE BETWEEN '20080411' /**P*/ AND '20080411' /**P*/ AND B.DELFLAG = 'N' AND D.REPEATID(+) = B.REPEATID AND D.DELFLAG (+) = 'N' UNION ALL SELECT 'ONLINE' PLANID, '' PLANGBN, '' SECFLAG, '' SECGBN, '' SECAREA, '' OPENFLAG, 'N' REPEATKIND, '' RSDATE, '' REDATE, '' MONTH, '' WEEK, '' WEEKNAME, '' DAY, '' AUTOFLAG, '' INID, '' INNAME, '' EXEFLAG_LOGINID, A.CONFTYPEID, B.OPENDATE, A.CONFTYPENAME, B.CONFLOCATION, 2, B.OPENSTIME, B.OPENETIME, 'N', 'N', null, '', '', 'Y', '', NVL(B.CONFID, '0') RESULTID, 'A' REFLAG, B.MANAGEDEPTID DEPTID, B.MANAGEDEPTNAME DEPTNAME, B.CHARGEUSERID OWNERID, B.CHARGEUSERNAME OWNERNAME, B.CHARGEDUTYNAME DUTYNAME, B.CHARGEPOSITIONID POSITIONID, B.CHARGEGRADEID GRADEID, B.CONFROUND||'|'||B.CONFNAME RESULT_TITLE, B.OPENDATE RESULTDATE, '', B.INDT FROM BMS_AGD_ACONFTYPE A, BMS_AGD_CONF B WHERE A.CONFTYPEID = B.CONFTYPEID AND B.CONFID IN ( SELECT ASUB.CONFID FROM BMS_AGD_CONF ASUB, BMS_AGD_AGENDA BSUB WHERE ASUB.CONFID = BSUB.CONFID AND BSUB.CONFID > ' ' AND BSUB.ISCANCEL = 'N' AND BSUB.ISDUMMY = 'N' AND ( ASUB.CHARGEUSERID = 'b7594604abf340288755060412104305' /**P*/ OR EXISTS ( SELECT 'X' FROM BMS_AGD_AGENDA_ATTE CSUB WHERE BSUB.AGDID = CSUB.AGDID AND CSUB.USERID = 'b7594604abf340288755060412104305' /**P*/ ) ) AND ASUB.OPENDATE BETWEEN '20080411' /**P*/ AND '20080411' /**P*/ ) ) A, BMS_TASK_CARD_HIS IT, BMS_TASK_CARD_HIS IP, BMS_TASK_CARD_HIS IO WHERE A.PLANID = IT.PLANID (+) AND IT.CARDTYPE (+) = 'T' AND IT.ORIGINFLAG (+) = 'Y' AND A.PLANID = IP.PLANID (+) AND IP.CARDTYPE (+) = 'P' AND IP.ORIGINFLAG (+) = 'Y' AND A.PLANID = IO.PLANID (+) AND IO.CARDTYPE (+) = 'O' AND IO.ORIGINFLAG (+) = 'Y' ) T, BMS_PJT_PJTCARD JT, BMS_PJT_PJTCARD JP, BMS_PJT_PJTCARD JO WHERE T.TASKCARDID = JT.PJTCARDID (+) AND T.PJTCARDID = JP.PJTCARDID (+) AND T.ORGCARDID = JO.PJTCARDID (+) AND RNUM BETWEEN 1 /**P*/ AND 10 /**P*/";
        System.out.println(new Formatter(query).format());
    }

    static {
        BEGIN_CLAUSES.add("left");
        BEGIN_CLAUSES.add("right");
        BEGIN_CLAUSES.add("inner");
        BEGIN_CLAUSES.add("outer");
        BEGIN_CLAUSES.add("group");
        BEGIN_CLAUSES.add("order");
        END_CLAUSES.add("where");
        END_CLAUSES.add("set");
        END_CLAUSES.add("having");
        END_CLAUSES.add("join");
        END_CLAUSES.add("from");
        END_CLAUSES.add("by");
        END_CLAUSES.add("join");
        END_CLAUSES.add("into");
        END_CLAUSES.add("union");
        LOGICAL.add("and");
        LOGICAL.add("or");
        LOGICAL.add("when");
        LOGICAL.add("else");
        LOGICAL.add("end");
        QUANTIFIERS.add("in");
        QUANTIFIERS.add("all");
        QUANTIFIERS.add("exists");
        QUANTIFIERS.add("some");
        QUANTIFIERS.add("any");
        DML.add("insert");
        DML.add("update");
        DML.add("delete");
        MISC.add("select");
        MISC.add("on");
    }
}

