/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import com.carrotsearch.randomizedtesting.LifecycleScope;
import com.carrotsearch.randomizedtesting.RandomizedContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.lucene.util.Constants;
import org.apache.lucene.util.LuceneTestCase;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;

public final class RunListenerPrintReproduceInfo
extends RunListener {
    private static List<String> testClassesRun = new ArrayList<String>();
    private LifecycleScope scope;
    private boolean testFailed;
    private boolean suiteFailed;
    private boolean printDiagnosticsAfterClass;
    private boolean suppressReproduceLine;

    public void testRunStarted(Description description) throws Exception {
        this.suiteFailed = false;
        this.testFailed = false;
        this.scope = LifecycleScope.SUITE;
        Class targetClass = RandomizedContext.current().getTargetClass();
        this.suppressReproduceLine = targetClass.isAnnotationPresent(LuceneTestCase.SuppressReproduceLine.class);
        testClassesRun.add(targetClass.getSimpleName());
    }

    public void testStarted(Description description) throws Exception {
        this.testFailed = false;
        this.scope = LifecycleScope.TEST;
    }

    public void testFailure(Failure failure) throws Exception {
        if (this.scope == LifecycleScope.TEST) {
            this.testFailed = true;
        } else {
            this.suiteFailed = true;
        }
        this.printDiagnosticsAfterClass = true;
    }

    public void testFinished(Description description) throws Exception {
        if (this.testFailed) {
            this.reportAdditionalFailureInfo(this.stripTestNameAugmentations(description.getMethodName()));
        }
        this.scope = LifecycleScope.SUITE;
        this.testFailed = false;
    }

    private String stripTestNameAugmentations(String methodName) {
        if (methodName != null) {
            methodName = methodName.replaceAll("\\s*\\{.+?\\}", "");
        }
        return methodName;
    }

    public void testRunFinished(Result result) throws Exception {
        if (this.printDiagnosticsAfterClass || LuceneTestCase.VERBOSE) {
            RunListenerPrintReproduceInfo.printDebuggingInformation();
        }
        if (this.suiteFailed) {
            this.reportAdditionalFailureInfo(null);
        }
    }

    private static void printDebuggingInformation() {
        if (LuceneTestCase.classEnvRule != null) {
            System.err.println("NOTE: test params are: codec=" + LuceneTestCase.classEnvRule.codec + ", sim=" + LuceneTestCase.classEnvRule.similarity + ", locale=" + LuceneTestCase.classEnvRule.locale + ", timezone=" + (LuceneTestCase.classEnvRule.timeZone == null ? "(null)" : LuceneTestCase.classEnvRule.timeZone.getID()));
        }
        System.err.println("NOTE: " + System.getProperty("os.name") + " " + System.getProperty("os.version") + " " + System.getProperty("os.arch") + "/" + System.getProperty("java.vendor") + " " + System.getProperty("java.version") + " " + (Constants.JRE_IS_64BIT ? "(64-bit)" : "(32-bit)") + "/" + "cpus=" + Runtime.getRuntime().availableProcessors() + "," + "threads=" + Thread.activeCount() + "," + "free=" + Runtime.getRuntime().freeMemory() + "," + "total=" + Runtime.getRuntime().totalMemory());
        System.err.println("NOTE: All tests run in this JVM: " + Arrays.toString(testClassesRun.toArray()));
    }

    private void reportAdditionalFailureInfo(String testName) {
        if (this.suppressReproduceLine) {
            return;
        }
        if (LuceneTestCase.TEST_LINE_DOCS_FILE.endsWith("enwiki.random.lines.txt")) {
            System.err.println("NOTE: download the large Jenkins line-docs file by running 'ant get-jenkins-line-docs' in the lucene directory.");
        }
        StringBuilder b = new StringBuilder();
        b.append("NOTE: reproduce with: ant test ");
        RunListenerPrintReproduceInfo.addVmOpt(b, "testcase", RandomizedContext.current().getTargetClass().getSimpleName());
        RunListenerPrintReproduceInfo.addVmOpt(b, "tests.method", testName);
        RunListenerPrintReproduceInfo.addVmOpt(b, "tests.seed", RandomizedContext.current().getRunnerSeedAsString());
        if (LuceneTestCase.RANDOM_MULTIPLIER > 1) {
            RunListenerPrintReproduceInfo.addVmOpt(b, "tests.multiplier", LuceneTestCase.RANDOM_MULTIPLIER);
        }
        if (LuceneTestCase.TEST_NIGHTLY) {
            RunListenerPrintReproduceInfo.addVmOpt(b, "tests.nightly", LuceneTestCase.TEST_NIGHTLY);
        }
        if (LuceneTestCase.TEST_WEEKLY) {
            RunListenerPrintReproduceInfo.addVmOpt(b, "tests.weekly", LuceneTestCase.TEST_WEEKLY);
        }
        if (LuceneTestCase.TEST_SLOW) {
            RunListenerPrintReproduceInfo.addVmOpt(b, "tests.slow", LuceneTestCase.TEST_SLOW);
        }
        if (LuceneTestCase.TEST_AWAITSFIX) {
            RunListenerPrintReproduceInfo.addVmOpt(b, "tests.awaitsfix", LuceneTestCase.TEST_AWAITSFIX);
        }
        if (!LuceneTestCase.TEST_CODEC.equals("random")) {
            RunListenerPrintReproduceInfo.addVmOpt(b, "tests.codec", LuceneTestCase.TEST_CODEC);
        }
        if (!LuceneTestCase.TEST_POSTINGSFORMAT.equals("random")) {
            RunListenerPrintReproduceInfo.addVmOpt(b, "tests.postingsformat", LuceneTestCase.TEST_POSTINGSFORMAT);
        }
        if (!LuceneTestCase.TEST_DOCVALUESFORMAT.equals("random")) {
            RunListenerPrintReproduceInfo.addVmOpt(b, "tests.docvaluesformat", LuceneTestCase.TEST_DOCVALUESFORMAT);
        }
        if (!LuceneTestCase.TEST_DIRECTORY.equals("random")) {
            RunListenerPrintReproduceInfo.addVmOpt(b, "tests.directory", LuceneTestCase.TEST_DIRECTORY);
        }
        if (!LuceneTestCase.TEST_LINE_DOCS_FILE.equals("europarl.lines.txt.gz")) {
            RunListenerPrintReproduceInfo.addVmOpt(b, "tests.linedocsfile", LuceneTestCase.TEST_LINE_DOCS_FILE);
        }
        if (LuceneTestCase.classEnvRule != null) {
            RunListenerPrintReproduceInfo.addVmOpt(b, "tests.locale", LuceneTestCase.classEnvRule.locale);
            if (LuceneTestCase.classEnvRule.timeZone != null) {
                RunListenerPrintReproduceInfo.addVmOpt(b, "tests.timezone", LuceneTestCase.classEnvRule.timeZone.getID());
            }
        }
        if (LuceneTestCase.assertsAreEnabled) {
            RunListenerPrintReproduceInfo.addVmOpt(b, "tests.asserts", "true");
        } else {
            RunListenerPrintReproduceInfo.addVmOpt(b, "tests.asserts", "false");
        }
        RunListenerPrintReproduceInfo.addVmOpt(b, "tests.file.encoding", System.getProperty("file.encoding"));
        System.err.println(b.toString());
    }

    static void addVmOpt(StringBuilder b, String key, Object value) {
        if (value == null) {
            return;
        }
        b.append(" -D").append(key).append("=");
        String v = value.toString();
        if (Pattern.compile("[\\s=']").matcher(v).find()) {
            v = '\"' + v + '\"';
        }
        b.append(v);
    }
}

