/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.lucene.analysis.MockAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.MergeScheduler;
import org.apache.lucene.index.MergeTrigger;
import org.apache.lucene.index.SerialMergeScheduler;
import org.apache.lucene.store.BaseDirectoryWrapper;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.LuceneTestCase;
import org.apache.lucene.util.TestUtil;

public abstract class BaseMergePolicyTestCase
extends LuceneTestCase {
    protected abstract MergePolicy mergePolicy();

    public void testForceMergeNotNeeded() throws IOException {
        int i;
        BaseDirectoryWrapper dir = BaseMergePolicyTestCase.newDirectory();
        final AtomicBoolean mayMerge = new AtomicBoolean(true);
        SerialMergeScheduler mergeScheduler = new SerialMergeScheduler(){

            public synchronized void merge(IndexWriter writer, MergeTrigger trigger, boolean newMergesFound) throws IOException {
                if (!mayMerge.get() && writer.getNextMerge() != null) {
                    throw new AssertionError();
                }
                super.merge(writer, trigger, newMergesFound);
            }
        };
        IndexWriter writer = new IndexWriter((Directory)dir, BaseMergePolicyTestCase.newIndexWriterConfig(new MockAnalyzer(BaseMergePolicyTestCase.random())).setMergeScheduler((MergeScheduler)mergeScheduler).setMergePolicy(this.mergePolicy()));
        writer.getConfig().getMergePolicy().setNoCFSRatio(BaseMergePolicyTestCase.random().nextBoolean() ? 0.0 : 1.0);
        int numSegments = TestUtil.nextInt(BaseMergePolicyTestCase.random(), 2, 20);
        for (i = 0; i < numSegments; ++i) {
            int numDocs = TestUtil.nextInt(BaseMergePolicyTestCase.random(), 1, 5);
            for (int j = 0; j < numDocs; ++j) {
                writer.addDocument((Iterable)new Document());
            }
            writer.getReader().close();
        }
        for (i = 5; i >= 0; --i) {
            int segmentCount = writer.getSegmentCount();
            int maxNumSegments = i == 0 ? 1 : TestUtil.nextInt(BaseMergePolicyTestCase.random(), 1, 10);
            mayMerge.set(segmentCount > maxNumSegments);
            writer.forceMerge(maxNumSegments);
        }
        writer.close();
        dir.close();
    }
}

