/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.PayloadAttribute;
import org.apache.lucene.util.BytesRef;

public final class SimplePayloadFilter
extends TokenFilter {
    int pos = 0;
    final PayloadAttribute payloadAttr;
    final CharTermAttribute termAttr;

    public SimplePayloadFilter(TokenStream input) {
        super(input);
        this.payloadAttr = (PayloadAttribute)input.addAttribute(PayloadAttribute.class);
        this.termAttr = (CharTermAttribute)input.addAttribute(CharTermAttribute.class);
    }

    public boolean incrementToken() throws IOException {
        if (this.input.incrementToken()) {
            this.payloadAttr.setPayload(new BytesRef(("pos: " + this.pos).getBytes(StandardCharsets.UTF_8)));
            ++this.pos;
            return true;
        }
        return false;
    }

    public void reset() throws IOException {
        super.reset();
        this.pos = 0;
    }
}

