/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.s9api;

import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.Navigator;

public class StaticError {
    XPathException exception;
    SourceLocator locator = null;
    boolean isWarning = false;

    public StaticError(TransformerException err, boolean isWarning) {
        this.exception = XPathException.makeXPathException(err);
        this.locator = this.exception.getLocator();
        this.isWarning = isWarning;
    }

    public StaticError(TransformerException err) {
        this.exception = XPathException.makeXPathException(err);
        this.locator = this.exception.getLocator();
    }

    public void setWarning(boolean warning) {
        this.isWarning = warning;
    }

    public QName getErrorCode() {
        return new QName(this.exception.getErrorCodeQName());
    }

    public String getMessage() {
        return this.exception.getMessage();
    }

    public String getModuleUri() {
        return this.exception.getLocator().getSystemId();
    }

    public int getColoumnNumber() {
        SourceLocator locator = this.exception.getLocator();
        if (locator != null) {
            return this.exception.getLocator().getColumnNumber();
        }
        return -1;
    }

    public int getLineNumber() {
        SourceLocator locator = this.exception.getLocator();
        if (locator != null) {
            return this.exception.getLocator().getLineNumber();
        }
        return -1;
    }

    public String getInstructionName() {
        return ((NodeInfo)((Object)this.locator)).getDisplayName();
    }

    public boolean isWarning() {
        return this.isWarning;
    }

    public boolean isTypeError() {
        return this.exception.isTypeError();
    }

    public String getPath() {
        NodeInfo node = null;
        if (this.locator instanceof NodeInfo) {
            node = (NodeInfo)((Object)this.locator);
            return Navigator.getPath(node);
        }
        return null;
    }

    public XPathException getUnderlyingException() {
        return this.exception;
    }
}

