/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.PathMap;
import net.sf.saxon.functions.SystemFunctionCall;
import net.sf.saxon.lib.ConversionRules;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ConversionResult;
import net.sf.saxon.type.Converter;
import net.sf.saxon.type.StringConverter;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AnyURIValue;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.StringValue;

public class NumberFn
extends SystemFunctionCall
implements Callable {
    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        this.useContextItemAsDefault(visitor);
        this.argument[0].setFlattened(true);
        return this.simplifyArguments(visitor);
    }

    public Expression typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        Expression e2 = super.typeCheck(visitor, contextInfo);
        if (e2 != this) {
            return e2;
        }
        if (this.argument[0] instanceof NumberFn) {
            this.argument[0] = ((NumberFn)this.argument[0]).argument[0];
        }
        return this;
    }

    public PathMap.PathMapNodeSet addDocToPathMap(PathMap pathMap, PathMap.PathMapNodeSet pathMapNodes) {
        PathMap.PathMapNodeSet result = this.argument[0].addToPathMap(pathMap, pathMapNodes);
        if (result != null) {
            result.setAtomized();
        }
        return null;
    }

    public DoubleValue evaluateItem(XPathContext context) throws XPathException {
        Item arg0 = this.argument[0].evaluateItem(context);
        if (arg0 == null) {
            return DoubleValue.NaN;
        }
        ConversionRules rules = context.getConfiguration().getConversionRules();
        if (arg0 instanceof BooleanValue) {
            return (DoubleValue)Converter.BOOLEAN_TO_DOUBLE.convert((AtomicValue)arg0).asAtomic();
        }
        if (arg0 instanceof NumericValue) {
            return (DoubleValue)Converter.NUMERIC_TO_DOUBLE.convert((AtomicValue)arg0).asAtomic();
        }
        if (arg0 instanceof StringValue && !(arg0 instanceof AnyURIValue)) {
            StringConverter sc = BuiltInAtomicType.DOUBLE.getStringConverter(rules);
            ConversionResult cr = sc.convert((AtomicValue)arg0);
            if (cr instanceof ValidationFailure) {
                return DoubleValue.NaN;
            }
            return (DoubleValue)cr;
        }
        return DoubleValue.NaN;
    }

    public static DoubleValue convert(AtomicValue value, Configuration config) {
        try {
            if (value == null) {
                return DoubleValue.NaN;
            }
            if (value instanceof BooleanValue) {
                return new DoubleValue(((BooleanValue)value).getBooleanValue() ? 1.0 : 0.0);
            }
            if (value instanceof DoubleValue) {
                return (DoubleValue)value;
            }
            if (value instanceof NumericValue) {
                return new DoubleValue(((NumericValue)value).getDoubleValue());
            }
            if (value instanceof StringValue && !(value instanceof AnyURIValue)) {
                double d = config.getConversionRules().getStringToDoubleConverter().stringToNumber(value.getStringValueCS());
                return new DoubleValue(d);
            }
            return DoubleValue.NaN;
        }
        catch (NumberFormatException e) {
            return DoubleValue.NaN;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DoubleValue call(XPathContext context, Sequence[] arguments) throws XPathException {
        AtomicValue in;
        if (arguments.length == 0) {
            Item c = context.getContextItem();
            if (c == null) {
                throw new XPathException("Context item for number() is absent");
            }
            if (c instanceof AtomicValue) {
                in = (AtomicValue)c;
                return NumberFn.convert(in, context.getConfiguration());
            } else {
                if (!(c instanceof NodeInfo)) throw new XPathException("Context item for number() cannot be atomized", "XPTY0004");
                AtomicSequence as = ((NodeInfo)c).atomize();
                if (as.getLength() == 0) {
                    return DoubleValue.NaN;
                }
                if (as.getLength() != 1) throw new XPathException("Atomization of context item for number() is a sequence containing more than one item", "XPTY0004");
                in = as.head();
            }
            return NumberFn.convert(in, context.getConfiguration());
        } else {
            in = (AtomicValue)arguments[0].head();
            if (in != null) return NumberFn.convert(in, context.getConfiguration());
            return DoubleValue.NaN;
        }
    }
}

