/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.PromotionOffer;
import net.sf.saxon.expr.parser.Token;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.Cardinality;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BinaryExpression
extends Expression {
    protected Expression operand0;
    protected Expression operand1;
    protected int operator;

    public BinaryExpression(Expression p0, int op, Expression p1) {
        this.operator = op;
        this.operand0 = p0;
        this.operand1 = p1;
        this.adoptChildExpression(p0);
        this.adoptChildExpression(p1);
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        this.operand0 = visitor.typeCheck(this.operand0, contextInfo);
        this.operand1 = visitor.typeCheck(this.operand1, contextInfo);
        try {
            if (this.operand0 instanceof Literal && this.operand1 instanceof Literal) {
                GroundedValue v = SequenceTool.toGroundedValue(this.evaluateItem(visitor.getStaticContext().makeEarlyEvaluationContext()));
                return Literal.makeLiteral(v, this.getContainer());
            }
        }
        catch (XPathException xPathException) {
            // empty catch block
        }
        return this;
    }

    @Override
    public Expression optimize(ExpressionVisitor visitor, ContextItemStaticInfo contextItemType) throws XPathException {
        this.operand0 = visitor.optimize(this.operand0, contextItemType);
        this.operand1 = visitor.optimize(this.operand1, contextItemType);
        try {
            Item item;
            if (this.operand0 instanceof Literal && this.operand1 instanceof Literal && (item = this.evaluateItem(visitor.getStaticContext().makeEarlyEvaluationContext())) != null) {
                GroundedValue v = SequenceTool.toGroundedValue(item);
                return Literal.makeLiteral(v, this.getContainer());
            }
        }
        catch (XPathException xPathException) {
            // empty catch block
        }
        return this;
    }

    @Override
    public void setFlattened(boolean flattened) {
        this.operand0.setFlattened(flattened);
        this.operand1.setFlattened(flattened);
    }

    @Override
    public Expression promote(PromotionOffer offer, Expression parent) throws XPathException {
        Expression exp = offer.accept(parent, this);
        if (exp != null) {
            return exp;
        }
        this.operand0 = this.doPromotion(this.operand0, offer);
        this.operand1 = this.doPromotion(this.operand1, offer);
        return this;
    }

    @Override
    public Iterable<Operand> operands() {
        return this.operandList(new Operand(this.operand0, OperandRole.SINGLE_ATOMIC), new Operand(this.operand1, OperandRole.SINGLE_ATOMIC));
    }

    public Expression[] getArguments() {
        return new Expression[]{this.operand0, this.operand1};
    }

    @Override
    public boolean replaceOperand(Expression original, Expression replacement) {
        boolean found = false;
        if (this.operand0 == original) {
            this.operand0 = replacement;
            found = true;
        }
        if (this.operand1 == original) {
            this.operand1 = replacement;
            found = true;
        }
        return found;
    }

    public int getOperator() {
        return this.operator;
    }

    public Expression[] getOperands() {
        return new Expression[]{this.operand0, this.operand1};
    }

    @Override
    public int computeCardinality() {
        if (Cardinality.allowsZero(this.operand0.getCardinality()) || Cardinality.allowsZero(this.operand1.getCardinality())) {
            return 24576;
        }
        return 16384;
    }

    @Override
    public int computeSpecialProperties() {
        int p = super.computeSpecialProperties();
        return p | 0x400000;
    }

    protected static boolean isCommutative(int operator) {
        return operator == 10 || operator == 9 || operator == 1 || operator == 23 || operator == 15 || operator == 17 || operator == 6 || operator == 50 || operator == 22 || operator == 51;
    }

    protected static boolean isAssociative(int operator) {
        return operator == 10 || operator == 9 || operator == 1 || operator == 23 || operator == 15 || operator == 17;
    }

    protected static boolean isInverse(int op1, int op2) {
        return op1 != op2 && op1 == Token.inverse(op2);
    }

    public boolean equals(Object other) {
        if (other instanceof BinaryExpression) {
            BinaryExpression b = (BinaryExpression)other;
            if (this.operator == b.operator) {
                if (this.operand0.equals(b.operand0) && this.operand1.equals(b.operand1)) {
                    return true;
                }
                if (BinaryExpression.isCommutative(this.operator) && this.operand0.equals(b.operand1) && this.operand1.equals(b.operand0)) {
                    return true;
                }
                if (BinaryExpression.isAssociative(this.operator) && this.pairwiseEqual(this.flattenExpression(new ArrayList<Expression>(4)), b.flattenExpression(new ArrayList<Expression>(4)))) {
                    return true;
                }
            }
            if (BinaryExpression.isInverse(this.operator, b.operator) && this.operand0.equals(b.operand1) && this.operand1.equals(b.operand0)) {
                return true;
            }
        }
        return false;
    }

    private List<Expression> flattenExpression(List<Expression> list) {
        int i;
        int h;
        if (this.operand0 instanceof BinaryExpression && ((BinaryExpression)this.operand0).operator == this.operator) {
            ((BinaryExpression)this.operand0).flattenExpression(list);
        } else {
            h = this.operand0.hashCode();
            list.add(this.operand0);
            for (i = list.size() - 1; i > 0 && h > list.get(i - 1).hashCode(); --i) {
                list.set(i, list.get(i - 1));
                list.set(i - 1, this.operand0);
            }
        }
        if (this.operand1 instanceof BinaryExpression && ((BinaryExpression)this.operand1).operator == this.operator) {
            ((BinaryExpression)this.operand1).flattenExpression(list);
        } else {
            h = this.operand1.hashCode();
            list.add(this.operand1);
            for (i = list.size() - 1; i > 0 && h > list.get(i - 1).hashCode(); --i) {
                list.set(i, list.get(i - 1));
                list.set(i - 1, this.operand1);
            }
        }
        return list;
    }

    private boolean pairwiseEqual(List a, List b) {
        if (a.size() != b.size()) {
            return false;
        }
        for (int i = 0; i < a.size(); ++i) {
            if (a.get(i).equals(b.get(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int op = Math.min(this.operator, Token.inverse(this.operator));
        return ("BinaryExpression " + op).hashCode() ^ this.operand0.hashCode() ^ this.operand1.hashCode();
    }

    @Override
    public String toString() {
        return ExpressionTool.parenthesize(this.operand0) + " " + this.displayOperator() + " " + ExpressionTool.parenthesize(this.operand1);
    }

    @Override
    public String toShortString() {
        return this.operand0.toShortString() + " " + this.displayOperator() + " " + this.operand1.toShortString();
    }

    @Override
    public void explain(ExpressionPresenter out) {
        out.startElement("operator");
        out.emitAttribute("op", this.displayOperator());
        this.explainExtraAttributes(out);
        this.operand0.explain(out);
        this.operand1.explain(out);
        out.endElement();
    }

    protected void explainExtraAttributes(ExpressionPresenter out) {
    }

    protected String displayOperator() {
        return Token.tokens[this.operator];
    }
}

