/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.EmptyTextNodeRemover;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.UnaryExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.Block;
import net.sf.saxon.expr.instruct.Choose;
import net.sf.saxon.expr.instruct.ValueOf;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AdjacentTextNodeMergingIterator;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Cardinality;

public class AdjacentTextNodeMerger
extends UnaryExpression {
    public AdjacentTextNodeMerger(Expression p0) {
        super(p0);
    }

    public static Expression makeAdjacentTextNodeMerger(Expression base) {
        if (base instanceof Literal && ((Literal)base).getValue() instanceof AtomicSequence) {
            return base;
        }
        return new AdjacentTextNodeMerger(base);
    }

    protected OperandRole getOperandRole() {
        return OperandRole.SAME_FOCUS_ACTION;
    }

    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        if (this.operand instanceof Literal && ((Literal)this.operand).getValue() instanceof AtomicValue) {
            return this.operand;
        }
        return super.simplify(visitor);
    }

    public Expression typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        Expression e = super.typeCheck(visitor, contextInfo);
        if (e != this) {
            return e;
        }
        TypeHierarchy th = visitor.getConfiguration().getTypeHierarchy();
        if (th.relationship(this.getBaseExpression().getItemType(), NodeKindTest.TEXT) == 4) {
            return this.getBaseExpression();
        }
        if (!Cardinality.allowsMany(this.getBaseExpression().getCardinality())) {
            return this.getBaseExpression();
        }
        if (this.getBaseExpression() instanceof Choose) {
            Choose choose = (Choose)this.getBaseExpression();
            Expression[] actions = choose.getActions();
            for (int i = 0; i < actions.length; ++i) {
                AdjacentTextNodeMerger atm2 = new AdjacentTextNodeMerger(actions[i]);
                actions[i] = atm2.typeCheck(visitor, contextInfo);
            }
            return choose;
        }
        if (this.getBaseExpression() instanceof Block) {
            Block block = (Block)this.getBaseExpression();
            Expression[] actions = block.getChildren();
            boolean prevtext = false;
            boolean needed = false;
            boolean maybeEmpty = false;
            for (int i = 0; i < actions.length; ++i) {
                boolean maybetext;
                if (actions[i] instanceof ValueOf) {
                    maybetext = true;
                    Expression content = ((ValueOf)actions[i]).getContentExpression();
                    maybeEmpty = content instanceof StringLiteral ? (maybeEmpty |= ((StringLiteral)content).getStringValue().length() == 0) : true;
                } else {
                    maybetext = th.relationship(actions[i].getItemType(), NodeKindTest.TEXT) != 4;
                    maybeEmpty |= maybetext;
                }
                if (prevtext && maybetext) {
                    needed = true;
                    break;
                }
                if (maybetext && Cardinality.allowsMany(actions[i].getCardinality())) {
                    needed = true;
                    break;
                }
                prevtext = maybetext;
            }
            if (!needed) {
                if (maybeEmpty) {
                    return new EmptyTextNodeRemover(block);
                }
                return block;
            }
        }
        return this;
    }

    public ItemType getItemType() {
        return this.getBaseExpression().getItemType();
    }

    public int computeCardinality() {
        return this.getBaseExpression().getCardinality() | 0x2000;
    }

    public Expression copy() {
        return new AdjacentTextNodeMerger(this.getBaseExpression().copy());
    }

    public int getImplementationMethod() {
        return 30;
    }

    public SequenceIterator iterate(XPathContext context) throws XPathException {
        return new AdjacentTextNodeMergingIterator(this.getBaseExpression().iterate(context));
    }

    public void process(XPathContext context, int locationId, int options) throws XPathException {
        Item item;
        SequenceReceiver out = context.getReceiver();
        FastStringBuffer fsb = new FastStringBuffer(256);
        SequenceIterator iter = this.getBaseExpression().iterate(context);
        boolean prevText = false;
        while ((item = iter.next()) != null) {
            if (AdjacentTextNodeMerger.isTextNode(item)) {
                CharSequence s = item.getStringValueCS();
                if (s.length() <= 0) continue;
                fsb.append(s);
                prevText = true;
                continue;
            }
            if (prevText) {
                out.characters(fsb, locationId, options);
            }
            prevText = false;
            fsb.setLength(0);
            out.append(item, locationId, options);
        }
        if (prevText) {
            out.characters(fsb, locationId, options);
        }
    }

    public String getExpressionName() {
        return "mergeAdjacentText";
    }

    public static boolean isTextNode(Item item) {
        return item instanceof NodeInfo && ((NodeInfo)item).getNodeKind() == 3;
    }
}

