/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.value.AtomicValue;

public class SequenceNormalizer
extends ProxyReceiver {
    private String separator;
    private int level = 0;
    private boolean first = true;

    public SequenceNormalizer(SequenceReceiver next, String separator) {
        super(next);
        this.separator = separator;
    }

    public void startDocument(int properties) throws XPathException {
        this.sep();
        ++this.level;
        this.getUnderlyingReceiver().startDocument(properties);
    }

    public void endDocument() throws XPathException {
        --this.level;
        this.getUnderlyingReceiver().endDocument();
    }

    public void startElement(NodeName elemName, SchemaType typeCode, int locationId, int properties) throws XPathException {
        this.sep();
        ++this.level;
        this.getUnderlyingReceiver().startElement(elemName, typeCode, locationId, properties);
    }

    public void endElement() throws XPathException {
        --this.level;
        super.endElement();
    }

    public void characters(CharSequence chars, int locationId, int properties) throws XPathException {
        this.sep();
        this.getUnderlyingReceiver().characters(chars, locationId, properties);
    }

    public void processingInstruction(String target, CharSequence data, int locationId, int properties) throws XPathException {
        this.sep();
        this.getUnderlyingReceiver().processingInstruction(target, data, locationId, properties);
    }

    public void comment(CharSequence chars, int locationId, int properties) throws XPathException {
        this.sep();
        this.getUnderlyingReceiver().comment(chars, locationId, properties);
    }

    public void append(Item item, int locationId, int copyNamespaces) throws XPathException {
        this.sep();
        if (this.level == 0 && item instanceof AtomicValue) {
            CharSequence cs = item.getStringValueCS();
            this.getUnderlyingReceiver().characters(cs, locationId, 0);
        } else {
            ((SequenceReceiver)this.getUnderlyingReceiver()).append(item, locationId, copyNamespaces);
        }
    }

    public void sep() throws XPathException {
        if (this.level == 0 && !this.first) {
            this.getUnderlyingReceiver().characters(this.separator, 0, 0);
        } else {
            this.first = false;
        }
    }
}

