/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.list;

import org.apache.mahout.collections.Arithmetic;
import org.apache.mahout.math.Arrays;
import org.apache.mahout.math.Sorting;
import org.apache.mahout.math.function.FloatProcedure;
import org.apache.mahout.math.list.AbstractFloatList;

public class FloatArrayList
extends AbstractFloatList
implements Cloneable {
    private float[] elements;

    public FloatArrayList() {
        this(10);
    }

    public FloatArrayList(float[] elements) {
        this.elements(elements);
    }

    public FloatArrayList(int initialCapacity) {
        this(new float[initialCapacity]);
        this.setSizeRaw(0);
    }

    public void add(float element) {
        if (this.size == this.elements.length) {
            this.ensureCapacity(this.size + 1);
        }
        this.elements[this.size++] = element;
    }

    public void beforeInsert(int index, float element) {
        if (this.size == index) {
            this.add(element);
            return;
        }
        if (index > this.size || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        this.ensureCapacity(this.size + 1);
        System.arraycopy(this.elements, index, this.elements, index + 1, this.size - index);
        this.elements[index] = element;
        ++this.size;
    }

    public int binarySearchFromTo(float key, int from, int to) {
        return Sorting.binarySearchFromTo(this.elements, key, from, to);
    }

    public Object clone() {
        FloatArrayList clone = new FloatArrayList((float[])this.elements.clone());
        clone.setSizeRaw(this.size);
        return clone;
    }

    public FloatArrayList copy() {
        return (FloatArrayList)this.clone();
    }

    public float[] elements() {
        return this.elements;
    }

    public AbstractFloatList elements(float[] elements) {
        this.elements = elements;
        this.size = elements.length;
        return this;
    }

    public void ensureCapacity(int minCapacity) {
        this.elements = Arrays.ensureCapacity(this.elements, minCapacity);
    }

    public boolean equals(Object otherObj) {
        if (otherObj == null) {
            return false;
        }
        if (!(otherObj instanceof FloatArrayList)) {
            return super.equals(otherObj);
        }
        if (this == otherObj) {
            return true;
        }
        FloatArrayList other = (FloatArrayList)otherObj;
        if (this.size() != other.size()) {
            return false;
        }
        float[] theElements = this.elements();
        float[] otherElements = other.elements();
        int i = this.size();
        while (--i >= 0) {
            if (theElements[i] == otherElements[i]) continue;
            return false;
        }
        return true;
    }

    public boolean forEach(FloatProcedure procedure) {
        float[] theElements = this.elements;
        int theSize = this.size;
        int i = 0;
        while (i < theSize) {
            if (procedure.apply(theElements[i++])) continue;
            return false;
        }
        return true;
    }

    public float get(int index) {
        if (index >= this.size || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        return this.elements[index];
    }

    public float getQuick(int index) {
        return this.elements[index];
    }

    public int indexOfFromTo(float element, int from, int to) {
        if (this.size == 0) {
            return -1;
        }
        FloatArrayList.checkRangeFromTo(from, to, this.size);
        float[] theElements = this.elements;
        for (int i = from; i <= to; ++i) {
            if (element != theElements[i]) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOfFromTo(float element, int from, int to) {
        if (this.size == 0) {
            return -1;
        }
        FloatArrayList.checkRangeFromTo(from, to, this.size);
        float[] theElements = this.elements;
        for (int i = to; i >= from; --i) {
            if (element != theElements[i]) continue;
            return i;
        }
        return -1;
    }

    public AbstractFloatList partFromTo(int from, int to) {
        if (this.size == 0) {
            return new FloatArrayList(0);
        }
        FloatArrayList.checkRangeFromTo(from, to, this.size);
        float[] part = new float[to - from + 1];
        System.arraycopy(this.elements, from, part, 0, to - from + 1);
        return new FloatArrayList(part);
    }

    public boolean removeAll(AbstractFloatList other) {
        double M;
        if (!(other instanceof FloatArrayList)) {
            return super.removeAll(other);
        }
        if (other.isEmpty()) {
            return false;
        }
        int limit = other.size() - 1;
        int j = 0;
        float[] theElements = this.elements;
        int mySize = this.size();
        double N = other.size();
        if ((N + (M = (double)mySize)) * Arithmetic.log2(N) < M * N) {
            FloatArrayList sortedList = (FloatArrayList)other.clone();
            sortedList.quickSort();
            for (int i = 0; i < mySize; ++i) {
                if (sortedList.binarySearchFromTo(theElements[i], 0, limit) >= 0) continue;
                theElements[j++] = theElements[i];
            }
        } else {
            for (int i = 0; i < mySize; ++i) {
                if (other.indexOfFromTo(theElements[i], 0, limit) >= 0) continue;
                theElements[j++] = theElements[i];
            }
        }
        boolean modified = j != mySize;
        this.setSize(j);
        return modified;
    }

    public void replaceFromToWithFrom(int from, int to, AbstractFloatList other, int otherFrom) {
        if (!(other instanceof FloatArrayList)) {
            super.replaceFromToWithFrom(from, to, other, otherFrom);
            return;
        }
        int length = to - from + 1;
        if (length > 0) {
            FloatArrayList.checkRangeFromTo(from, to, this.size());
            FloatArrayList.checkRangeFromTo(otherFrom, otherFrom + length - 1, other.size());
            System.arraycopy(((FloatArrayList)other).elements, otherFrom, this.elements, from, length);
        }
    }

    public boolean retainAll(AbstractFloatList other) {
        double M;
        if (!(other instanceof FloatArrayList)) {
            return super.retainAll(other);
        }
        int limit = other.size() - 1;
        int j = 0;
        float[] theElements = this.elements;
        int mySize = this.size();
        double N = other.size();
        if ((N + (M = (double)mySize)) * Arithmetic.log2(N) < M * N) {
            FloatArrayList sortedList = (FloatArrayList)other.clone();
            sortedList.quickSort();
            for (int i = 0; i < mySize; ++i) {
                if (sortedList.binarySearchFromTo(theElements[i], 0, limit) < 0) continue;
                theElements[j++] = theElements[i];
            }
        } else {
            for (int i = 0; i < mySize; ++i) {
                if (other.indexOfFromTo(theElements[i], 0, limit) < 0) continue;
                theElements[j++] = theElements[i];
            }
        }
        boolean modified = j != mySize;
        this.setSize(j);
        return modified;
    }

    public void reverse() {
        int limit = this.size / 2;
        int j = this.size - 1;
        float[] theElements = this.elements;
        int i = 0;
        while (i < limit) {
            float tmp = theElements[i];
            theElements[i++] = theElements[j];
            theElements[j--] = tmp;
        }
    }

    public void set(int index, float element) {
        if (index >= this.size || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        this.elements[index] = element;
    }

    public void setQuick(int index, float element) {
        this.elements[index] = element;
    }

    public void sortFromTo(int from, int to) {
        if (this.size == 0) {
            return;
        }
        FloatArrayList.checkRangeFromTo(from, to, this.size);
        float min = this.elements[from];
        float max = this.elements[from];
        float[] theElements = this.elements;
        int i = from + 1;
        while (i <= to) {
            int n = i++;
            float elem = theElements[n];
            if (elem > max) {
                max = elem;
                continue;
            }
            if (!(elem < min)) continue;
            min = elem;
        }
        this.quickSortFromTo(from, to);
    }

    public void trimToSize() {
        this.elements = Arrays.trimToCapacity(this.elements, this.size());
    }
}

