/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.util.xsltfilter;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.carrot2.util.xslt.TemplatesPool;
import org.carrot2.util.xsltfilter.XSLTFilterServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class XSLTFilter
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger(XSLTFilter.class);
    private static final String PARAM_TEMPLATE_CACHING = "template.caching";
    private TemplatesPool pool;
    private ServletContext context;
    private FilterConfig filterConfig;

    public void init(FilterConfig filterConfig) throws ServletException {
        if (filterConfig == null) {
            throw new IllegalArgumentException("FilterConfig must not be null.");
        }
        this.context = filterConfig.getServletContext();
        boolean templateCaching = this.getBooleanInit(filterConfig, PARAM_TEMPLATE_CACHING, true);
        this.filterConfig = filterConfig;
        try {
            this.pool = new TemplatesPool(templateCaching);
        }
        catch (Exception e) {
            String message = "Could not initialize XSLT transformers pool.";
            logger.error("Could not initialize XSLT transformers pool.", (Throwable)e);
            throw new ServletException("Could not initialize XSLT transformers pool.", (Throwable)e);
        }
    }

    private boolean getBooleanInit(FilterConfig config, String name, boolean defaultValue) {
        if (config.getInitParameter(name) != null) {
            return Boolean.valueOf(config.getInitParameter(name));
        }
        return defaultValue;
    }

    public void destroy() {
        this.pool = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        XSLTFilterServletResponse wrappedResponse = new XSLTFilterServletResponse(httpResponse, httpRequest, this.context, this.pool);
        try {
            chain.doFilter((ServletRequest)httpRequest, (ServletResponse)wrappedResponse);
        }
        catch (IOException t) {
            logger.info("I/O exception (doFilter): " + t.toString());
        }
        catch (Throwable t) {
            wrappedResponse.filterError("An unhandled exception occurred.", t);
        }
        finally {
            try {
                wrappedResponse.finishResponse();
            }
            catch (IOException e) {
                logger.info("I/O exception (finishResponse): " + e.toString());
            }
        }
    }
}

