/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.text.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public final class TabularOutput {
    private String columnSeparator = " ";
    final List<ColumnSpec> columns = Lists.newArrayList();
    final HashMap<String, ColumnSpec> columnsByName = Maps.newHashMap();
    final List<Object> currentRow = Lists.newArrayList();
    final List<List<Object>> data = Lists.newArrayList();
    private Writer writer;
    private int flushCount = 1;
    private int rowCount;
    private boolean outputEmitted;
    private ArrayList<RowListener> listeners = new ArrayList();
    private final LinkedHashMap<Class<?>, ColumnSpec> defaultFormats = new LinkedHashMap();
    private boolean autoAddColumns;
    private boolean columnsChanged;

    public TabularOutput(Writer writer) {
        this.defaultFormats.put(Object.class, this.defaultFormat(Object.class).format("%s"));
        this.autoAddColumns = true;
        this.columnsChanged = false;
        this.writer = writer;
    }

    public TabularOutput() {
        this(new PrintWriter(System.out));
    }

    private Object toStringAdapters(Object object) {
        if (object instanceof char[]) {
            return new String((char[])object);
        }
        if (object instanceof byte[]) {
            return Arrays.toString((byte[])object);
        }
        if (object instanceof short[]) {
            return Arrays.toString((short[])object);
        }
        if (object instanceof int[]) {
            return Arrays.toString((int[])object);
        }
        if (object instanceof long[]) {
            return Arrays.toString((long[])object);
        }
        if (object instanceof float[]) {
            return Arrays.toString((float[])object);
        }
        if (object instanceof double[]) {
            return Arrays.toString((double[])object);
        }
        return object;
    }

    public TabularOutput addListener(RowListener listener) {
        this.listeners.add(listener);
        return this;
    }

    ColumnSpec defaultSpec(Class<?> clazz) {
        ArrayList arrayList = new ArrayList(this.defaultFormats.entrySet());
        Collections.reverse(arrayList);
        for (Map.Entry<Class<?>, ColumnSpec> e : arrayList) {
            if (!e.getKey().isAssignableFrom(clazz)) continue;
            return e.getValue();
        }
        throw new IllegalStateException("No default column spec?");
    }

    public ColumnSpec defaultFormat(Class<?> valueClass) {
        ColumnSpec colSpec = this.defaultFormats.get(valueClass);
        if (colSpec == null) {
            colSpec = new ColumnSpec("default-" + valueClass.getSimpleName(), -1);
            this.defaultFormats.put(valueClass, colSpec);
        }
        return colSpec;
    }

    public ColumnSpec addColumn(String name) {
        if (!this.autoAddColumns) {
            this.checkNoDataAdded();
        }
        ColumnSpec cs = new ColumnSpec(name, this.columns.size());
        this.columns.add(cs);
        if (this.columnsByName.put(cs.name, cs) != null) {
            throw new IllegalArgumentException("Two columns with the same name: " + name);
        }
        this.columnsChanged = true;
        return cs;
    }

    public TabularOutput columnSeparator(String separator) {
        this.checkNoDataAdded();
        this.columnSeparator = separator;
        return this;
    }

    public TabularOutput nextRow() {
        this.data.add(Lists.newArrayList(this.currentRow));
        this.currentRow.clear();
        if (++this.rowCount >= this.flushCount) {
            this.rowCount = 0;
            this.flush();
        }
        return this;
    }

    public TabularOutput rowData(Object ... columnData) {
        if (this.currentRow.size() + columnData.length > this.columns.size()) {
            throw new IllegalStateException("Row would be larger than the number of columns: " + this.columns.size() + ", row: " + this.currentRow.size() + " attempted add: " + columnData.length);
        }
        this.currentRow.addAll(Arrays.asList(columnData));
        return this;
    }

    public TabularOutput rowData(String columnName, Object value) {
        ColumnSpec columnSpec = this.columnsByName.get(columnName);
        if (columnSpec == null) {
            if (this.autoAddColumns) {
                columnSpec = this.addColumn(columnName);
            } else {
                throw new IllegalArgumentException("No such column: " + columnName);
            }
        }
        int index = columnSpec.index;
        while (index >= this.currentRow.size()) {
            this.currentRow.add(null);
        }
        this.currentRow.set(index, value);
        return this;
    }

    public TabularOutput flushEvery(int n) {
        this.flushCount = n;
        return this;
    }

    public TabularOutput flush() {
        try {
            return this.flush0();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private TabularOutput flush0() throws IOException {
        if (this.data.size() > 0) {
            String formatted;
            ColumnSpec col;
            boolean widthsChanged = false;
            for (List<Object> row : this.data) {
                for (int i = 0; i < this.columns.size(); ++i) {
                    col = this.columns.get(i);
                    formatted = col.formatValue(i < row.size() ? row.get(i) : null);
                    widthsChanged |= col.updateWidth(formatted.length());
                    if (i < row.size()) continue;
                    row.add(null);
                }
            }
            if (widthsChanged || this.columnsChanged) {
                if (this.outputEmitted) {
                    this.writer.write("\n");
                }
                this.outputEmitted = true;
                for (int i = 0; i < this.columns.size(); ++i) {
                    ColumnSpec col2 = this.columns.get(i);
                    String header = col2.align(col2.name);
                    col2.updateWidth(header.length());
                    this.writer.write(header);
                    this.writer.write(this.columnSeparator);
                }
                this.writer.write("\n");
                this.columnsChanged = false;
            }
            for (List<Object> row : this.data) {
                for (RowListener listener : this.listeners) {
                    listener.newRow(this.columns, row);
                }
                for (int i = 0; i < row.size(); ++i) {
                    col = this.columns.get(i);
                    formatted = col.formatValue(i < row.size() ? row.get(i) : null);
                    this.writer.write(col.align(formatted));
                    this.writer.write(this.columnSeparator);
                }
                this.writer.write("\n");
            }
            this.data.clear();
            this.writer.flush();
        }
        return this;
    }

    private void checkNoDataAdded() {
        if (this.currentRow.size() != 0 || this.data.size() != 0) {
            throw new IllegalStateException("Data already added.");
        }
    }

    public List<ColumnSpec> getColumns() {
        return Collections.unmodifiableList(this.columns);
    }

    public final class ColumnSpec {
        public final String name;
        private Alignment alignment;
        String format;
        int maxWidth;
        public final int index;

        public ColumnSpec(String name, int index) {
            this.name = name;
            this.index = index;
        }

        public TabularOutput tabularOutput() {
            return TabularOutput.this;
        }

        public ColumnSpec alignLeft() {
            TabularOutput.this.checkNoDataAdded();
            this.alignment = Alignment.LEFT;
            return this;
        }

        public ColumnSpec alignRight() {
            TabularOutput.this.checkNoDataAdded();
            this.alignment = Alignment.RIGHT;
            return this;
        }

        public ColumnSpec alignCenter() {
            TabularOutput.this.checkNoDataAdded();
            this.alignment = Alignment.CENTER;
            return this;
        }

        public String toString() {
            return this.name;
        }

        public ColumnSpec format(String formatString) {
            if (this.format != null) {
                throw new IllegalStateException("Format already initialized to: " + this.format);
            }
            if (formatString == null) {
                formatString = "%s";
            }
            this.format = formatString;
            return this;
        }

        boolean updateWidth(int newLength) {
            if (newLength > this.maxWidth) {
                this.maxWidth = newLength;
                return true;
            }
            return false;
        }

        private String formatValue(Object object) {
            String formatted;
            if (object == null) {
                formatted = "--";
            } else {
                object = TabularOutput.this.toStringAdapters(object);
                if (this.format == null) {
                    this.format(TabularOutput.this.defaultSpec(object.getClass()).format);
                }
                if (this.alignment == null) {
                    this.alignment = TabularOutput.this.defaultSpec(object.getClass()).alignment;
                }
                formatted = String.format(this.format, object);
            }
            return formatted;
        }

        public String align(String text) {
            Alignment alignment = this.alignment;
            if (alignment == null) {
                alignment = Alignment.RIGHT;
            }
            return alignment.align(text, this.maxWidth);
        }
    }

    public static enum Alignment {
        LEFT,
        RIGHT,
        CENTER;


        public String align(String string, int size) {
            switch (this) {
                case LEFT: {
                    return StringUtils.rightPad((String)string, (int)size);
                }
                case RIGHT: {
                    return StringUtils.leftPad((String)string, (int)size);
                }
            }
            return StringUtils.center((String)string, (int)size);
        }
    }

    public static interface RowListener {
        public void newRow(List<ColumnSpec> var1, List<Object> var2);
    }
}

