/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.core;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.carrot2.core.Document;
import org.carrot2.util.MapUtils;
import org.carrot2.util.StringUtils;
import org.carrot2.util.simplexml.SimpleXmlWrapperValue;
import org.carrot2.util.simplexml.SimpleXmlWrappers;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonMethod;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.ElementMap;
import org.simpleframework.xml.Root;
import org.simpleframework.xml.core.Commit;
import org.simpleframework.xml.core.Persist;

@Root(name="group", strict=false)
@JsonAutoDetect(value={JsonMethod.NONE})
@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
public final class Cluster {
    public static final String OTHER_TOPICS = "other-topics";
    public static final String OTHER_TOPICS_LABEL = "Other Topics";
    public static final String SCORE = "score";
    @Attribute(required=false)
    Integer id;
    @ElementList(required=false, name="title", entry="phrase")
    private ArrayList<String> phrases = new ArrayList();
    private List<String> phrasesView = Collections.unmodifiableList(this.phrases);
    @ElementList(required=false, inline=true)
    private ArrayList<Cluster> subclusters = new ArrayList();
    private List<Cluster> subclustersView = Collections.unmodifiableList(this.subclusters);
    private final ArrayList<Document> documents = new ArrayList();
    private final List<Document> documentsView = Collections.unmodifiableList(this.documents);
    private Map<String, Object> attributes = new HashMap<String, Object>();
    private Map<String, Object> attributesView = Collections.unmodifiableMap(this.attributes);
    private String labelCache = null;
    private List<Document> allDocuments;
    @ElementMap(entry="attribute", key="key", attribute=true, inline=true, required=false)
    private HashMap<String, SimpleXmlWrapperValue> otherAttributesForSerialization;
    @ElementList(required=false, inline=true)
    List<DocumentRefid> documentIds;
    public static final Comparator<Cluster> BY_SIZE_COMPARATOR = Ordering.natural().nullsFirst().onResultOf((Function)new Function<Cluster, Integer>(){

        public Integer apply(Cluster cluster) {
            return cluster.size();
        }
    });
    public static final Comparator<Cluster> BY_SCORE_COMPARATOR = Ordering.natural().nullsFirst().onResultOf((Function)new Function<Cluster, Double>(){

        public Double apply(Cluster cluster) {
            return (Double)cluster.getAttribute(Cluster.SCORE);
        }
    });
    public static final Comparator<Cluster> BY_LABEL_COMPARATOR = Ordering.natural().nullsFirst().onResultOf((Function)new Function<Cluster, String>(){

        public String apply(Cluster cluster) {
            return cluster.getLabel();
        }
    });
    public static final Comparator<Cluster> BY_REVERSED_SIZE_AND_LABEL_COMPARATOR = Ordering.from(Collections.reverseOrder(BY_SIZE_COMPARATOR)).compound(BY_LABEL_COMPARATOR);
    public static final Comparator<Cluster> BY_REVERSED_SCORE_AND_LABEL_COMPARATOR = Ordering.from(Collections.reverseOrder(BY_SCORE_COMPARATOR)).compound(BY_LABEL_COMPARATOR);
    public static final Comparator<Cluster> OTHER_TOPICS_AT_THE_END = Ordering.natural().onResultOf((Function)new Function<Cluster, Double>(){

        public Double apply(Cluster cluster) {
            return cluster.isOtherTopics() ? 1.0 : -1.0;
        }
    });
    private static Function<Document, String> DOCUMENT_TO_ID = new Function<Document, String>(){

        public String apply(Document doc) {
            return doc.getStringId();
        }
    };

    public Cluster() {
    }

    public Cluster(String phrase, Document ... documents) {
        this.addPhrases(phrase);
        this.addDocuments(documents);
    }

    public Cluster(Integer id, String phrase, Document ... documents) {
        this(phrase, documents);
        this.id = id;
    }

    public String getLabel() {
        if (this.labelCache == null) {
            this.labelCache = StringUtils.toString(this.phrases, ", ");
        }
        return this.labelCache;
    }

    @JsonProperty
    public List<String> getPhrases() {
        return this.phrasesView;
    }

    public List<Cluster> getSubclusters() {
        return this.subclustersView;
    }

    @JsonProperty(value="clusters")
    private List<Cluster> getSubclustersForSerialization() {
        return this.subclustersView.isEmpty() ? null : this.subclustersView;
    }

    public List<Document> getDocuments() {
        return this.documentsView;
    }

    public List<Document> getAllDocuments() {
        if (this.allDocuments == null) {
            this.allDocuments = new ArrayList<Document>(Cluster.collectAllDocuments(this, new LinkedHashSet<Document>()));
        }
        return this.allDocuments;
    }

    public List<Document> getAllDocuments(Comparator<Document> comparator) {
        ArrayList sortedDocuments = Lists.newArrayList(this.getAllDocuments());
        Collections.sort(sortedDocuments, comparator);
        return sortedDocuments;
    }

    private static Set<Document> collectAllDocuments(Cluster cluster, Set<Document> docs) {
        if (cluster == null) {
            return docs;
        }
        docs.addAll(cluster.getDocuments());
        List<Cluster> subclusters = cluster.getSubclusters();
        for (Cluster subcluster : subclusters) {
            Cluster.collectAllDocuments(subcluster, docs);
        }
        return docs;
    }

    public Cluster addPhrases(String ... phrases) {
        this.labelCache = null;
        for (String phrase : phrases) {
            this.phrases.add(phrase);
        }
        return this;
    }

    public Cluster addPhrases(Iterable<String> phrases) {
        this.labelCache = null;
        for (String phrase : phrases) {
            this.phrases.add(phrase);
        }
        return this;
    }

    public Cluster addDocuments(Document ... documents) {
        for (Document document : documents) {
            this.documents.add(document);
        }
        this.allDocuments = null;
        return this;
    }

    public Cluster addDocument(Document document) {
        this.documents.add(document);
        this.allDocuments = null;
        return this;
    }

    public Cluster addDocuments(Iterable<Document> documents) {
        for (Document document : documents) {
            this.documents.add(document);
        }
        this.allDocuments = null;
        return this;
    }

    public Cluster addSubclusters(Cluster ... subclusters) {
        for (Cluster cluster : subclusters) {
            this.subclusters.add(cluster);
        }
        this.allDocuments = null;
        return this;
    }

    public Cluster addSubcluster(Cluster cluster) {
        this.subclusters.add(cluster);
        this.allDocuments = null;
        return this;
    }

    public Cluster addSubclusters(Iterable<Cluster> clusters) {
        for (Cluster cluster : clusters) {
            this.subclusters.add(cluster);
        }
        this.allDocuments = null;
        return this;
    }

    @JsonProperty
    @Attribute(required=false)
    public Double getScore() {
        return (Double)this.getAttribute(SCORE);
    }

    @Attribute(required=false)
    public Cluster setScore(Double score) {
        return this.setAttribute(SCORE, score);
    }

    public <T> T getAttribute(String key) {
        return (T)this.attributes.get(key);
    }

    public <T> Cluster setAttribute(String key, T value) {
        this.attributes.put(key, value);
        return this;
    }

    public <T> Cluster removeAttribute(String key) {
        this.attributes.remove(key);
        return this;
    }

    public Map<String, Object> getAttributes() {
        return this.attributesView;
    }

    public int size() {
        return this.getAllDocuments().size();
    }

    @JsonProperty
    @Attribute(required=false)
    private int getSize() {
        return this.size();
    }

    @Attribute(required=false)
    private void setSize(int size) {
    }

    @JsonProperty
    public Integer getId() {
        return this.id;
    }

    public boolean isOtherTopics() {
        Boolean otherTopics = (Boolean)this.getAttribute(OTHER_TOPICS);
        return otherTopics != null && otherTopics != false;
    }

    public Cluster setOtherTopics(boolean isOtherTopics) {
        if (isOtherTopics) {
            this.setAttribute(OTHER_TOPICS, Boolean.TRUE).setScore(0.0);
        } else {
            this.removeAttribute(OTHER_TOPICS);
        }
        return this;
    }

    public static Comparator<Cluster> byReversedWeightedScoreAndSizeComparator(final double scoreWeight) {
        if (scoreWeight < 0.0 || scoreWeight > 1.0) {
            throw new IllegalArgumentException("Score weight must be between 0.0 (inclusive) and 1.0 (inclusive) ");
        }
        return Ordering.natural().onResultOf((Function)new Function<Cluster, Double>(){

            public Double apply(Cluster cluster) {
                return -Math.pow(cluster.size(), 1.0 - scoreWeight) * Math.pow((Double)cluster.getAttribute(Cluster.SCORE), scoreWeight);
            }
        }).compound(BY_LABEL_COMPARATOR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void assignClusterIds(Collection<Cluster> clusters) {
        List<Cluster> flattened = Cluster.flatten(clusters);
        Collection<Cluster> collection = clusters;
        synchronized (collection) {
            boolean hadIds = false;
            for (Cluster cluster : flattened) {
                if (cluster.id == null) continue;
                hadIds = true;
                break;
            }
            if (hadIds) {
                HashSet ids = Sets.newHashSet();
                for (Cluster c : flattened) {
                    if (ids.add(c.id)) continue;
                    throw new IllegalArgumentException("Cluster identifiers must be unique, duplicated identifier: " + c.id);
                }
                if (ids.contains(null)) {
                    throw new IllegalArgumentException("Null cluster identifiers cannot be mixed with existing non-null identifiers.");
                }
            } else {
                int id = 0;
                for (Cluster c : flattened) {
                    if (c.id != null) continue;
                    c.id = id++;
                }
            }
        }
    }

    public static List<Cluster> flatten(Collection<Cluster> hierarchical) {
        return Cluster.flatten(hierarchical, Lists.newArrayList());
    }

    private static List<Cluster> flatten(Collection<Cluster> hierarchical, List<Cluster> flat) {
        for (Cluster c : hierarchical) {
            flat.add(c);
            Cluster.flatten(c.getSubclusters(), flat);
        }
        return flat;
    }

    public static Cluster find(int id, Collection<Cluster> clusters) {
        for (Cluster c : clusters) {
            Cluster sub;
            if (c == null) continue;
            if (c.id != null && c.id == id) {
                return c;
            }
            if (c.getSubclusters().isEmpty() || (sub = Cluster.find(id, c.getSubclusters())) == null) continue;
            return sub;
        }
        return null;
    }

    public static Cluster buildOtherTopics(List<Document> allDocuments, List<Cluster> clusters) {
        return Cluster.buildOtherTopics(allDocuments, clusters, OTHER_TOPICS_LABEL);
    }

    public static Cluster buildOtherTopics(List<Document> allDocuments, List<Cluster> clusters, String label) {
        LinkedHashSet unclusteredDocuments = Sets.newLinkedHashSet(allDocuments);
        HashSet assignedDocuments = Sets.newHashSet();
        for (Cluster cluster : clusters) {
            Cluster.collectAllDocuments(cluster, assignedDocuments);
        }
        unclusteredDocuments.removeAll(assignedDocuments);
        Cluster otherTopics = new Cluster(label, new Document[0]);
        otherTopics.addDocuments(unclusteredDocuments);
        otherTopics.setOtherTopics(true);
        return otherTopics;
    }

    public static Cluster appendOtherTopics(List<Document> allDocuments, List<Cluster> clusters) {
        return Cluster.appendOtherTopics(allDocuments, clusters, OTHER_TOPICS_LABEL);
    }

    public static Cluster appendOtherTopics(List<Document> allDocuments, List<Cluster> clusters, String label) {
        Cluster otherTopics = Cluster.buildOtherTopics(allDocuments, clusters, label);
        if (!otherTopics.getDocuments().isEmpty()) {
            clusters.add(otherTopics);
        }
        return otherTopics;
    }

    public void remapDocumentReferences(IdentityHashMap<Document, Document> docMapping) {
        if (this.id != null) {
            throw new IllegalStateException();
        }
        int i = this.documents.size();
        while (--i >= 0) {
            Document doc = this.documents.get(i);
            Document remapped = docMapping.get(doc);
            if (remapped == null) continue;
            this.documents.set(i, remapped);
        }
        this.allDocuments = null;
    }

    @Persist
    private void beforeSerialization() {
        this.documentIds = Lists.transform(this.documents, (Function)new Function<Document, DocumentRefid>(){

            public DocumentRefid apply(Document document) {
                return new DocumentRefid(document.getStringId());
            }
        });
        this.otherAttributesForSerialization = MapUtils.asHashMap(SimpleXmlWrappers.wrap(this.attributes));
        this.otherAttributesForSerialization.remove(SCORE);
        if (this.otherAttributesForSerialization.isEmpty()) {
            this.otherAttributesForSerialization = null;
        }
    }

    @Commit
    private void afterDeserialization() throws Exception {
        if (this.otherAttributesForSerialization != null) {
            this.attributes.putAll(SimpleXmlWrappers.unwrap(this.otherAttributesForSerialization));
        }
        this.phrasesView = Collections.unmodifiableList(this.phrases);
        this.subclustersView = Collections.unmodifiableList(this.subclusters);
    }

    @JsonProperty(value="documents")
    private List<String> getDocumentIds() {
        return Lists.transform(this.documents, DOCUMENT_TO_ID);
    }

    @JsonProperty(value="attributes")
    private Map<String, Object> getOtherAttributes() {
        HashMap otherAttributes = Maps.newHashMap(this.attributesView);
        return otherAttributes.isEmpty() ? null : otherAttributes;
    }

    public String toString() {
        return "[Cluster, label: " + this.getLabel() + ", docs: " + this.size() + ", subclusters: " + this.getSubclusters().size() + "]";
    }

    @Root(name="document")
    static class DocumentRefid {
        @Attribute
        String refid;

        DocumentRefid() {
        }

        DocumentRefid(String refid) {
            this.refid = refid;
        }
    }
}

