/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.stats;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.IndexReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermContext;
import org.apache.lucene.search.CollectionStatistics;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermStatistics;
import org.apache.solr.client.solrj.SolrResponse;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.PluginInfo;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.handler.component.ShardRequest;
import org.apache.solr.handler.component.ShardResponse;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.search.stats.CollectionStats;
import org.apache.solr.search.stats.StatsCache;
import org.apache.solr.search.stats.StatsSource;
import org.apache.solr.search.stats.StatsUtil;
import org.apache.solr.search.stats.TermStats;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExactStatsCache
extends StatsCache {
    private static final Logger LOG = LoggerFactory.getLogger(ExactStatsCache.class);
    private static final String CURRENT_GLOBAL_COL_STATS = "org.apache.solr.stats.currentGlobalColStats";
    private static final String CURRENT_GLOBAL_TERM_STATS = "org.apache.solr.stats.currentGlobalTermStats";
    private static final String PER_SHARD_TERM_STATS = "org.apache.solr.stats.perShardTermStats";
    private static final String PER_SHARD_COL_STATS = "org.apache.solr.stats.perShardColStats";

    @Override
    public StatsSource get(SolrQueryRequest req) {
        Map<String, CollectionStats> currentGlobalColStats = (Map<String, CollectionStats>)req.getContext().get(CURRENT_GLOBAL_COL_STATS);
        Map<String, TermStats> currentGlobalTermStats = (Map<String, TermStats>)req.getContext().get(CURRENT_GLOBAL_TERM_STATS);
        if (currentGlobalColStats == null) {
            currentGlobalColStats = Collections.emptyMap();
        }
        if (currentGlobalTermStats == null) {
            currentGlobalTermStats = Collections.emptyMap();
        }
        LOG.debug("Returning StatsSource. Collection stats={}, Term stats size= {}", currentGlobalColStats, (Object)currentGlobalTermStats.size());
        return new ExactStatsSource(currentGlobalTermStats, currentGlobalColStats);
    }

    @Override
    public void init(PluginInfo info) {
    }

    @Override
    public ShardRequest retrieveStatsRequest(ResponseBuilder rb) {
        ShardRequest sreq = new ShardRequest();
        sreq.purpose = 32768;
        sreq.params = new ModifiableSolrParams(rb.req.getParams());
        sreq.params.remove("shards");
        return sreq;
    }

    @Override
    public void mergeToGlobalStats(SolrQueryRequest req, List<ShardResponse> responses) {
        HashSet allTerms = new HashSet();
        for (ShardResponse r : responses) {
            LOG.debug("Merging to global stats, shard={}, response={}", (Object)r.getShard(), (Object)r.getSolrResponse().getResponse());
            String shard = r.getShard();
            SolrResponse res = r.getSolrResponse();
            NamedList nl = res.getResponse();
            String termStatsString = (String)nl.get("org.apache.solr.stats.termStats");
            if (termStatsString != null) {
                this.addToPerShardTermStats(req, shard, termStatsString);
            }
            List terms = nl.getAll("org.apache.solr.stats.terms");
            allTerms.addAll(terms);
            String colStatsString = (String)nl.get("org.apache.solr.stats.colStats");
            Map<String, CollectionStats> colStats = StatsUtil.colStatsMapFromString(colStatsString);
            if (colStats == null) continue;
            this.addToPerShardColStats(req, shard, colStats);
        }
        if (allTerms.size() > 0) {
            req.getContext().put("org.apache.solr.stats.terms", Lists.newArrayList(allTerms));
        }
        if (LOG.isDebugEnabled()) {
            this.printStats(req);
        }
    }

    protected void addToPerShardColStats(SolrQueryRequest req, String shard, Map<String, CollectionStats> colStats) {
        HashMap<String, Map<String, CollectionStats>> perShardColStats = (HashMap<String, Map<String, CollectionStats>>)req.getContext().get(PER_SHARD_COL_STATS);
        if (perShardColStats == null) {
            perShardColStats = new HashMap<String, Map<String, CollectionStats>>();
            req.getContext().put(PER_SHARD_COL_STATS, perShardColStats);
        }
        perShardColStats.put(shard, colStats);
    }

    protected void printStats(SolrQueryRequest req) {
        Map perShardColStats;
        Map perShardTermStats = (Map)req.getContext().get(PER_SHARD_TERM_STATS);
        if (perShardTermStats == null) {
            perShardTermStats = Collections.emptyMap();
        }
        if ((perShardColStats = (Map)req.getContext().get(PER_SHARD_COL_STATS)) == null) {
            perShardColStats = Collections.emptyMap();
        }
        LOG.debug("perShardColStats={}, perShardTermStats={}", perShardColStats, perShardTermStats);
    }

    protected void addToPerShardTermStats(SolrQueryRequest req, String shard, String termStatsString) {
        Map<String, TermStats> termStats = StatsUtil.termStatsMapFromString(termStatsString);
        if (termStats != null) {
            HashMap<String, Map<String, TermStats>> perShardTermStats = (HashMap<String, Map<String, TermStats>>)req.getContext().get(PER_SHARD_TERM_STATS);
            if (perShardTermStats == null) {
                perShardTermStats = new HashMap<String, Map<String, TermStats>>();
                req.getContext().put(PER_SHARD_TERM_STATS, perShardTermStats);
            }
            perShardTermStats.put(shard, termStats);
        }
    }

    @Override
    public void returnLocalStats(ResponseBuilder rb, SolrIndexSearcher searcher) {
        Query q = rb.getQuery();
        try {
            HashSet terms = new HashSet();
            searcher.createNormalizedWeight(q, true).extractTerms(terms);
            IndexReaderContext context = searcher.getTopReaderContext();
            HashMap<String, TermStats> statsMap = new HashMap<String, TermStats>();
            HashMap<String, CollectionStats> colMap = new HashMap<String, CollectionStats>();
            for (Term t : terms) {
                TermContext termContext;
                TermStatistics tst = searcher.localTermStatistics(t, termContext = TermContext.build((IndexReaderContext)context, (Term)t));
                if (tst.docFreq() == 0L) continue;
                statsMap.put(t.toString(), new TermStats(t.field(), tst));
                rb.rsp.add("org.apache.solr.stats.terms", t.toString());
                if (colMap.containsKey(t.field())) continue;
                colMap.put(t.field(), new CollectionStats(searcher.localCollectionStatistics(t.field())));
            }
            if (statsMap.size() != 0 && colMap.size() != 0) {
                String termStatsString = StatsUtil.termStatsMapToString(statsMap);
                rb.rsp.add("org.apache.solr.stats.termStats", termStatsString);
                String colStatsString = StatsUtil.colStatsMapToString(colMap);
                rb.rsp.add("org.apache.solr.stats.colStats", colStatsString);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("termStats=" + termStatsString + ", collectionStats=" + colStatsString + ", terms=" + terms + ", numDocs=" + searcher.maxDoc());
                }
            }
        }
        catch (IOException e) {
            LOG.error("Error collecting local stats, query='" + q.toString() + "'", (Throwable)e);
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error collecting local stats.", (Throwable)e);
        }
    }

    @Override
    public void sendGlobalStats(ResponseBuilder rb, ShardRequest outgoing) {
        outgoing.purpose |= 0x4000;
        ModifiableSolrParams params = outgoing.params;
        List terms = (List)rb.req.getContext().get("org.apache.solr.stats.terms");
        if (terms != null) {
            Object g;
            HashSet<String> fields = new HashSet<String>();
            for (String t : terms) {
                String[] fv = t.split(":");
                fields.add(fv[0]);
            }
            HashMap<String, TermStats> globalTermStats = new HashMap<String, TermStats>();
            HashMap<String, CollectionStats> globalColStats = new HashMap<String, CollectionStats>();
            for (String shard : rb.shards) {
                Map<String, CollectionStats> s = this.getPerShardColStats(rb, shard);
                if (s == null) continue;
                for (Map.Entry<String, CollectionStats> e : s.entrySet()) {
                    if (!fields.contains(e.getKey())) continue;
                    g = (CollectionStats)globalColStats.get(e.getKey());
                    if (g == null) {
                        g = new CollectionStats(e.getKey());
                        globalColStats.put(e.getKey(), (CollectionStats)g);
                    }
                    ((CollectionStats)g).add(e.getValue());
                }
            }
            params.add("org.apache.solr.stats.colStats", new String[]{StatsUtil.colStatsMapToString(globalColStats)});
            for (String t : terms) {
                params.add("org.apache.solr.stats.terms", new String[]{t});
                for (String shard : rb.shards) {
                    TermStats termStats = this.getPerShardTermStats(rb.req, t, shard);
                    if (termStats == null || termStats.docFreq == 0L) continue;
                    g = (TermStats)globalTermStats.get(t);
                    if (g == null) {
                        g = new TermStats(t);
                        globalTermStats.put(t, (TermStats)g);
                    }
                    ((TermStats)g).add(termStats);
                }
            }
            LOG.debug("terms={}, termStats={}", (Object)terms, globalTermStats);
            params.add("org.apache.solr.stats.termStats", new String[]{StatsUtil.termStatsMapToString(globalTermStats)});
        }
    }

    protected Map<String, CollectionStats> getPerShardColStats(ResponseBuilder rb, String shard) {
        Map perShardColStats = (Map)rb.req.getContext().get(PER_SHARD_COL_STATS);
        if (perShardColStats == null) {
            perShardColStats = Collections.emptyMap();
        }
        return (Map)perShardColStats.get(shard);
    }

    protected TermStats getPerShardTermStats(SolrQueryRequest req, String t, String shard) {
        Map cache;
        Map perShardTermStats = (Map)req.getContext().get(PER_SHARD_TERM_STATS);
        if (perShardTermStats == null) {
            perShardTermStats = Collections.emptyMap();
        }
        return (cache = (Map)perShardTermStats.get(shard)) != null ? (TermStats)cache.get(t) : null;
    }

    @Override
    public void receiveGlobalStats(SolrQueryRequest req) {
        Map<String, CollectionStats> colStats;
        String globalTermStats = req.getParams().get("org.apache.solr.stats.termStats");
        String globalColStats = req.getParams().get("org.apache.solr.stats.colStats");
        if (globalColStats != null && (colStats = StatsUtil.colStatsMapFromString(globalColStats)) != null) {
            for (Map.Entry<String, CollectionStats> entry : colStats.entrySet()) {
                this.addToGlobalColStats(req, entry);
            }
        }
        LOG.debug("Global collection stats={}", (Object)globalColStats);
        if (globalTermStats == null) {
            return;
        }
        Map<String, TermStats> termStats = StatsUtil.termStatsMapFromString(globalTermStats);
        if (termStats != null) {
            for (Map.Entry<String, Object> entry : termStats.entrySet()) {
                this.addToGlobalTermStats(req, entry);
            }
        }
    }

    protected void addToGlobalColStats(SolrQueryRequest req, Map.Entry<String, CollectionStats> e) {
        HashMap<String, CollectionStats> currentGlobalColStats = (HashMap<String, CollectionStats>)req.getContext().get(CURRENT_GLOBAL_COL_STATS);
        if (currentGlobalColStats == null) {
            currentGlobalColStats = new HashMap<String, CollectionStats>();
            req.getContext().put(CURRENT_GLOBAL_COL_STATS, currentGlobalColStats);
        }
        currentGlobalColStats.put(e.getKey(), e.getValue());
    }

    protected void addToGlobalTermStats(SolrQueryRequest req, Map.Entry<String, TermStats> e) {
        HashMap<String, TermStats> currentGlobalTermStats = (HashMap<String, TermStats>)req.getContext().get(CURRENT_GLOBAL_TERM_STATS);
        if (currentGlobalTermStats == null) {
            currentGlobalTermStats = new HashMap<String, TermStats>();
            req.getContext().put(CURRENT_GLOBAL_TERM_STATS, currentGlobalTermStats);
        }
        currentGlobalTermStats.put(e.getKey(), e.getValue());
    }

    protected static class ExactStatsSource
    extends StatsSource {
        private final Map<String, TermStats> termStatsCache;
        private final Map<String, CollectionStats> colStatsCache;

        public ExactStatsSource(Map<String, TermStats> termStatsCache, Map<String, CollectionStats> colStatsCache) {
            this.termStatsCache = termStatsCache;
            this.colStatsCache = colStatsCache;
        }

        @Override
        public TermStatistics termStatistics(SolrIndexSearcher localSearcher, Term term, TermContext context) throws IOException {
            TermStats termStats = this.termStatsCache.get(term.toString());
            if (termStats == null) {
                LOG.debug("Missing global termStats info for term={}, using local stats", (Object)term);
                return localSearcher.localTermStatistics(term, context);
            }
            return termStats.toTermStatistics();
        }

        @Override
        public CollectionStatistics collectionStatistics(SolrIndexSearcher localSearcher, String field) throws IOException {
            CollectionStats colStats = this.colStatsCache.get(field);
            if (colStats == null) {
                LOG.debug("Missing global colStats info for field={}, using local", (Object)field);
                return localSearcher.localCollectionStatistics(field);
            }
            return colStats.toCollectionStatistics();
        }
    }
}

