/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.join;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.join.JoinUtil;
import org.apache.lucene.search.join.ScoreMode;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.CommonParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.SolrCore;
import org.apache.solr.request.LocalSolrQueryRequest;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrRequestInfo;
import org.apache.solr.search.QParser;
import org.apache.solr.search.QParserPlugin;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.search.SyntaxError;
import org.apache.solr.search.join.ScoreModeParser;
import org.apache.solr.util.RefCounted;

public class ScoreJoinQParserPlugin
extends QParserPlugin {
    public static final String SCORE = "score";

    @Override
    public void init(NamedList args) {
    }

    @Override
    public QParser createParser(String qstr, SolrParams localParams, SolrParams params, SolrQueryRequest req) {
        return new QParser(qstr, localParams, params, req){

            @Override
            public Query parse() throws SyntaxError {
                String fromField = this.localParams.get("from");
                String fromIndex = this.localParams.get("fromIndex");
                String toField = this.localParams.get("to");
                ScoreMode scoreMode = ScoreModeParser.parse(this.getParam(ScoreJoinQParserPlugin.SCORE));
                String v = this.localParams.get("v");
                Query q = this.createQuery(fromField, v, fromIndex, toField, scoreMode, CommonParams.TRUE.equals(this.localParams.get("TESTenforceSameCoreAsAnotherOne")));
                return q;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Query createQuery(String fromField, String fromQueryStr, String fromIndex, String toField, ScoreMode scoreMode, boolean byPassShortCircutCheck) throws SyntaxError {
                String myCore = this.req.getCore().getCoreDescriptor().getName();
                if (fromIndex != null && (!fromIndex.equals(myCore) || byPassShortCircutCheck)) {
                    CoreContainer container = this.req.getCore().getCoreDescriptor().getCoreContainer();
                    SolrCore fromCore = container.getCore(fromIndex);
                    RefCounted<SolrIndexSearcher> fromHolder = null;
                    if (fromCore == null) {
                        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Cross-core join: no such core " + fromIndex);
                    }
                    long fromCoreOpenTime = 0L;
                    LocalSolrQueryRequest otherReq = new LocalSolrQueryRequest(fromCore, this.params);
                    try {
                        QParser fromQueryParser = QParser.getParser(fromQueryStr, "lucene", otherReq);
                        Query fromQuery = fromQueryParser.getQuery();
                        fromHolder = fromCore.getRegisteredSearcher();
                        if (fromHolder != null) {
                            fromCoreOpenTime = fromHolder.get().getOpenTime();
                        }
                        OtherCoreJoinQuery otherCoreJoinQuery = new OtherCoreJoinQuery(fromQuery, fromField, fromIndex, fromCoreOpenTime, scoreMode, toField);
                        return otherCoreJoinQuery;
                    }
                    finally {
                        otherReq.close();
                        fromCore.close();
                        if (fromHolder != null) {
                            fromHolder.decref();
                        }
                    }
                }
                QParser fromQueryParser = this.subQuery(fromQueryStr, null);
                Query fromQuery = fromQueryParser.getQuery();
                return new SameCoreJoinQuery(fromQuery, fromField, toField, scoreMode);
            }
        };
    }

    static class SameCoreJoinQuery
    extends Query {
        protected final Query fromQuery;
        protected final ScoreMode scoreMode;
        protected final String fromField;
        protected final String toField;

        SameCoreJoinQuery(Query fromQuery, String fromField, String toField, ScoreMode scoreMode) {
            this.fromQuery = fromQuery;
            this.scoreMode = scoreMode;
            this.fromField = fromField;
            this.toField = toField;
        }

        public Query rewrite(IndexReader reader) throws IOException {
            SolrRequestInfo info = SolrRequestInfo.getRequestInfo();
            Query jq = JoinUtil.createJoinQuery((String)this.fromField, (boolean)true, (String)this.toField, (Query)this.fromQuery, (IndexSearcher)info.getReq().getSearcher(), (ScoreMode)this.scoreMode);
            jq.setBoost(this.getBoost());
            return jq.rewrite(reader);
        }

        public String toString(String field) {
            return "SameCoreJoinQuery [fromQuery=" + this.fromQuery + ", fromField=" + this.fromField + ", toField=" + this.toField + ", scoreMode=" + this.scoreMode + "]";
        }

        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (this.fromField == null ? 0 : this.fromField.hashCode());
            result = 31 * result + (this.fromQuery == null ? 0 : this.fromQuery.hashCode());
            result = 31 * result + (this.scoreMode == null ? 0 : this.scoreMode.hashCode());
            result = 31 * result + (this.toField == null ? 0 : this.toField.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            SameCoreJoinQuery other = (SameCoreJoinQuery)((Object)obj);
            if (this.fromField == null ? other.fromField != null : !this.fromField.equals(other.fromField)) {
                return false;
            }
            if (this.fromQuery == null ? other.fromQuery != null : !this.fromQuery.equals((Object)other.fromQuery)) {
                return false;
            }
            if (this.scoreMode != other.scoreMode) {
                return false;
            }
            return !(this.toField == null ? other.toField != null : !this.toField.equals(other.toField));
        }
    }

    static class OtherCoreJoinQuery
    extends SameCoreJoinQuery {
        private final String fromIndex;
        private final long fromCoreOpenTime;

        public OtherCoreJoinQuery(Query fromQuery, String fromField, String fromIndex, long fromCoreOpenTime, ScoreMode scoreMode, String toField) {
            super(fromQuery, fromField, toField, scoreMode);
            this.fromIndex = fromIndex;
            this.fromCoreOpenTime = fromCoreOpenTime;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Query rewrite(IndexReader reader) throws IOException {
            Query joinQuery;
            SolrRequestInfo info = SolrRequestInfo.getRequestInfo();
            CoreContainer container = info.getReq().getCore().getCoreDescriptor().getCoreContainer();
            SolrCore fromCore = container.getCore(this.fromIndex);
            if (fromCore == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Cross-core join: no such core " + this.fromIndex);
            }
            RefCounted<SolrIndexSearcher> fromHolder = null;
            fromHolder = fromCore.getRegisteredSearcher();
            try {
                joinQuery = JoinUtil.createJoinQuery((String)this.fromField, (boolean)true, (String)this.toField, (Query)this.fromQuery, (IndexSearcher)fromHolder.get(), (ScoreMode)this.scoreMode);
            }
            finally {
                fromCore.close();
                fromHolder.decref();
            }
            joinQuery.setBoost(this.getBoost());
            return joinQuery.rewrite(reader);
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (int)(this.fromCoreOpenTime ^ this.fromCoreOpenTime >>> 32);
            result = 31 * result + (this.fromIndex == null ? 0 : this.fromIndex.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            OtherCoreJoinQuery other = (OtherCoreJoinQuery)((Object)obj);
            if (this.fromCoreOpenTime != other.fromCoreOpenTime) {
                return false;
            }
            return !(this.fromIndex == null ? other.fromIndex != null : !this.fromIndex.equals(other.fromIndex));
        }

        @Override
        public String toString(String field) {
            return "OtherCoreJoinQuery [fromIndex=" + this.fromIndex + ", fromCoreOpenTime=" + this.fromCoreOpenTime + " extends " + super.toString(field) + "]";
        }
    }
}

