/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.queries.function.valuesource.SortedSetFieldSource;
import org.apache.lucene.search.SortField;
import org.apache.lucene.uninverting.UninvertingReader;
import org.apache.lucene.util.AttributeFactory;
import org.apache.lucene.util.AttributeSource;
import org.apache.solr.analysis.SolrAnalyzer;
import org.apache.solr.response.TextResponseWriter;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.JsonPreAnalyzedParser;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.schema.SimplePreAnalyzedParser;
import org.apache.solr.search.QParser;
import org.apache.solr.search.Sorting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreAnalyzedField
extends FieldType {
    private static final Logger LOG = LoggerFactory.getLogger(PreAnalyzedField.class);
    public static final String PARSER_IMPL = "parserImpl";
    private static final String DEFAULT_IMPL = JsonPreAnalyzedParser.class.getName();
    private PreAnalyzedParser parser;
    private Analyzer analyzer;

    @Override
    public void init(IndexSchema schema, Map<String, String> args) {
        super.init(schema, args);
        String implName = args.get(PARSER_IMPL);
        if (implName == null) {
            this.parser = new JsonPreAnalyzedParser();
        } else {
            if ("json".equalsIgnoreCase(implName)) {
                this.parser = new JsonPreAnalyzedParser();
            } else if ("simple".equalsIgnoreCase(implName)) {
                this.parser = new SimplePreAnalyzedParser();
            } else {
                try {
                    Class<PreAnalyzedParser> implClazz = schema.getResourceLoader().findClass(implName, PreAnalyzedParser.class);
                    Constructor<PreAnalyzedParser> c = implClazz.getConstructor(new Class[0]);
                    this.parser = c.newInstance(new Object[0]);
                }
                catch (Exception e) {
                    LOG.warn("Can't use the configured PreAnalyzedParser class '" + implName + "', using default " + DEFAULT_IMPL, (Throwable)e);
                    this.parser = new JsonPreAnalyzedParser();
                }
            }
            args.remove(PARSER_IMPL);
        }
        this.analyzer = new SolrAnalyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                return new Analyzer.TokenStreamComponents((Tokenizer)new PreAnalyzedTokenizer(PreAnalyzedField.this.parser));
            }
        };
    }

    @Override
    public Analyzer getIndexAnalyzer() {
        return this.analyzer;
    }

    @Override
    public Analyzer getQueryAnalyzer() {
        return this.getIndexAnalyzer();
    }

    @Override
    public IndexableField createField(SchemaField field, Object value, float boost) {
        IndexableField f = null;
        try {
            f = this.fromString(field, String.valueOf(value), boost);
        }
        catch (Exception e) {
            LOG.warn("Error parsing pre-analyzed field '" + field.getName() + "'", (Throwable)e);
            return null;
        }
        return f;
    }

    @Override
    public SortField getSortField(SchemaField field, boolean top) {
        field.checkSortability();
        return Sorting.getTextSortField(field.getName(), top, field.sortMissingLast(), field.sortMissingFirst());
    }

    @Override
    public ValueSource getValueSource(SchemaField field, QParser parser) {
        return new SortedSetFieldSource(field.getName());
    }

    @Override
    public UninvertingReader.Type getUninversionType(SchemaField sf) {
        return UninvertingReader.Type.SORTED_SET_BINARY;
    }

    @Override
    public void write(TextResponseWriter writer, String name, IndexableField f) throws IOException {
        writer.writeStr(name, f.stringValue(), true);
    }

    public String toFormattedString(Field f) throws IOException {
        return this.parser.toFormattedString(f);
    }

    public static org.apache.lucene.document.FieldType createFieldType(SchemaField field) {
        if (!field.indexed() && !field.stored()) {
            if (log.isTraceEnabled()) {
                log.trace("Ignoring unindexed/unstored field: " + field);
            }
            return null;
        }
        org.apache.lucene.document.FieldType newType = new org.apache.lucene.document.FieldType();
        newType.setTokenized(field.isTokenized());
        newType.setStored(field.stored());
        newType.setOmitNorms(field.omitNorms());
        IndexOptions options = IndexOptions.DOCS_AND_FREQS_AND_POSITIONS;
        if (field.omitTermFreqAndPositions()) {
            options = IndexOptions.DOCS;
        } else if (field.omitPositions()) {
            options = IndexOptions.DOCS_AND_FREQS;
        } else if (field.storeOffsetsWithPositions()) {
            options = IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS;
        }
        newType.setIndexOptions(options);
        newType.setStoreTermVectors(field.storeTermVector());
        newType.setStoreTermVectorOffsets(field.storeTermOffsets());
        newType.setStoreTermVectorPositions(field.storeTermPositions());
        newType.setStoreTermVectorPayloads(field.storeTermPayloads());
        return newType;
    }

    public IndexableField fromString(SchemaField field, String val, float boost) throws Exception {
        if (val == null || val.trim().length() == 0) {
            return null;
        }
        PreAnalyzedTokenizer parse = new PreAnalyzedTokenizer(this.parser);
        parse.setReader(new StringReader(val));
        parse.reset();
        org.apache.lucene.document.FieldType type = PreAnalyzedField.createFieldType(field);
        if (type == null) {
            parse.close();
            return null;
        }
        Field f = null;
        if (parse.getStringValue() != null) {
            if (field.stored()) {
                f = new Field(field.getName(), parse.getStringValue(), type);
            } else {
                type.setStored(false);
            }
        } else if (parse.getBinaryValue() != null) {
            if (field.isBinary()) {
                f = new Field(field.getName(), parse.getBinaryValue(), type);
            }
        } else {
            type.setStored(false);
        }
        if (parse.hasTokenStream()) {
            if (field.indexed()) {
                type.setTokenized(true);
                if (f != null) {
                    f.setTokenStream((TokenStream)parse);
                } else {
                    f = new Field(field.getName(), (TokenStream)parse, type);
                }
            } else if (f != null) {
                f.fieldType().setIndexOptions(IndexOptions.NONE);
                f.fieldType().setTokenized(false);
            }
        }
        if (f != null) {
            f.setBoost(boost);
        }
        return f;
    }

    private static class PreAnalyzedTokenizer
    extends Tokenizer {
        private final List<AttributeSource.State> cachedStates = new LinkedList<AttributeSource.State>();
        private Iterator<AttributeSource.State> it = null;
        private String stringValue = null;
        private byte[] binaryValue = null;
        private PreAnalyzedParser parser;

        public PreAnalyzedTokenizer(PreAnalyzedParser parser) {
            super(AttributeFactory.DEFAULT_ATTRIBUTE_FACTORY);
            this.parser = parser;
        }

        public boolean hasTokenStream() {
            return !this.cachedStates.isEmpty();
        }

        public String getStringValue() {
            return this.stringValue;
        }

        public byte[] getBinaryValue() {
            return this.binaryValue;
        }

        public final boolean incrementToken() {
            if (this.it == null) {
                this.it = this.cachedStates.iterator();
            }
            if (!this.it.hasNext()) {
                return false;
            }
            AttributeSource.State state = this.it.next();
            this.restoreState(state.clone());
            return true;
        }

        public final void reset() throws IOException {
            if (this.it == null) {
                super.reset();
                this.cachedStates.clear();
                this.stringValue = null;
                this.binaryValue = null;
                ParseResult res = this.parser.parse(this.input, (AttributeSource)this);
                if (res != null) {
                    this.stringValue = res.str;
                    this.binaryValue = res.bin;
                    if (res.states != null) {
                        this.cachedStates.addAll(res.states);
                    }
                }
            }
            this.it = this.cachedStates.iterator();
        }
    }

    public static interface PreAnalyzedParser {
        public ParseResult parse(Reader var1, AttributeSource var2) throws IOException;

        public String toFormattedString(Field var1) throws IOException;
    }

    public static class ParseResult {
        public String str;
        public byte[] bin;
        public List<AttributeSource.State> states = new LinkedList<AttributeSource.State>();
    }
}

