/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.parser;

import java.io.StringReader;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.util.TokenFilterFactory;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.AutomatonQuery;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.FuzzyQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.MultiPhraseQuery;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.RegexpQuery;
import org.apache.lucene.search.WildcardQuery;
import org.apache.lucene.util.QueryBuilder;
import org.apache.lucene.util.ToStringUtils;
import org.apache.lucene.util.Version;
import org.apache.lucene.util.automaton.Automata;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.Operations;
import org.apache.solr.analysis.ReversedWildcardFilterFactory;
import org.apache.solr.analysis.TokenizerChain;
import org.apache.solr.common.SolrException;
import org.apache.solr.parser.CharStream;
import org.apache.solr.parser.FastCharStream;
import org.apache.solr.parser.ParseException;
import org.apache.solr.parser.QueryParser;
import org.apache.solr.parser.Token;
import org.apache.solr.parser.TokenMgrError;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.schema.TextField;
import org.apache.solr.search.QParser;
import org.apache.solr.search.SyntaxError;

public abstract class SolrQueryParserBase
extends QueryBuilder {
    static final int CONJ_NONE = 0;
    static final int CONJ_AND = 1;
    static final int CONJ_OR = 2;
    static final int MOD_NONE = 0;
    static final int MOD_NOT = 10;
    static final int MOD_REQ = 11;
    public static final QueryParser.Operator AND_OPERATOR = QueryParser.Operator.AND;
    public static final QueryParser.Operator OR_OPERATOR = QueryParser.Operator.OR;
    QueryParser.Operator operator = OR_OPERATOR;
    MultiTermQuery.RewriteMethod multiTermRewriteMethod = MultiTermQuery.CONSTANT_SCORE_REWRITE;
    boolean allowLeadingWildcard = true;
    String defaultField;
    int phraseSlop = 0;
    float fuzzyMinSim = 2.0f;
    int fuzzyPrefixLength = 0;
    boolean autoGeneratePhraseQueries = false;
    protected IndexSchema schema;
    protected QParser parser;
    private Map<FieldType, ReversedWildcardFilterFactory> leadingWildcards;
    protected String explicitField;
    private QParser subQParser = null;

    protected SolrQueryParserBase() {
        super(null);
    }

    public abstract void ReInit(CharStream var1);

    public abstract Query TopLevelQuery(String var1) throws ParseException, SyntaxError;

    public void init(Version matchVersion, String defaultField, QParser parser) {
        this.schema = parser.getReq().getSchema();
        this.parser = parser;
        this.defaultField = defaultField;
        this.setAnalyzer(this.schema.getQueryAnalyzer());
    }

    public Query parse(String query) throws SyntaxError {
        this.ReInit(new FastCharStream(new StringReader(query)));
        try {
            Query res = this.TopLevelQuery(null);
            return res != null ? res : this.newBooleanQuery(false).build();
        }
        catch (ParseException | TokenMgrError tme) {
            throw new SyntaxError("Cannot parse '" + query + "': " + tme.getMessage(), tme);
        }
        catch (BooleanQuery.TooManyClauses tmc) {
            throw new SyntaxError("Cannot parse '" + query + "': too many boolean clauses", tmc);
        }
    }

    public String getDefaultField() {
        return this.defaultField;
    }

    public String getField(String fieldName) {
        this.explicitField = fieldName;
        return fieldName != null ? fieldName : this.defaultField;
    }

    public String getExplicitField() {
        return this.explicitField;
    }

    public final boolean getAutoGeneratePhraseQueries() {
        return this.autoGeneratePhraseQueries;
    }

    public final void setAutoGeneratePhraseQueries(boolean value) {
        this.autoGeneratePhraseQueries = value;
    }

    public float getFuzzyMinSim() {
        return this.fuzzyMinSim;
    }

    public void setFuzzyMinSim(float fuzzyMinSim) {
        this.fuzzyMinSim = fuzzyMinSim;
    }

    public int getFuzzyPrefixLength() {
        return this.fuzzyPrefixLength;
    }

    public void setFuzzyPrefixLength(int fuzzyPrefixLength) {
        this.fuzzyPrefixLength = fuzzyPrefixLength;
    }

    public void setPhraseSlop(int phraseSlop) {
        this.phraseSlop = phraseSlop;
    }

    public int getPhraseSlop() {
        return this.phraseSlop;
    }

    public void setAllowLeadingWildcard(boolean allowLeadingWildcard) {
        this.allowLeadingWildcard = allowLeadingWildcard;
    }

    public boolean getAllowLeadingWildcard() {
        return this.allowLeadingWildcard;
    }

    public void setDefaultOperator(QueryParser.Operator op) {
        this.operator = op;
    }

    public QueryParser.Operator getDefaultOperator() {
        return this.operator;
    }

    public void setMultiTermRewriteMethod(MultiTermQuery.RewriteMethod method) {
        this.multiTermRewriteMethod = method;
    }

    public MultiTermQuery.RewriteMethod getMultiTermRewriteMethod() {
        return this.multiTermRewriteMethod;
    }

    protected void addClause(List<BooleanClause> clauses, int conj, int mods, Query q) {
        boolean required;
        boolean prohibited;
        BooleanClause c;
        if (clauses.size() > 0 && conj == 1 && !(c = clauses.get(clauses.size() - 1)).isProhibited()) {
            clauses.set(clauses.size() - 1, new BooleanClause(c.getQuery(), BooleanClause.Occur.MUST));
        }
        if (clauses.size() > 0 && this.operator == AND_OPERATOR && conj == 2 && !(c = clauses.get(clauses.size() - 1)).isProhibited()) {
            clauses.set(clauses.size() - 1, new BooleanClause(c.getQuery(), BooleanClause.Occur.SHOULD));
        }
        if (q == null) {
            return;
        }
        if (this.operator == OR_OPERATOR) {
            prohibited = mods == 10;
            boolean bl = required = mods == 11;
            if (conj == 1 && !prohibited) {
                required = true;
            }
        } else {
            prohibited = mods == 10;
            boolean bl = required = !prohibited && conj != 2;
        }
        if (required && !prohibited) {
            clauses.add(this.newBooleanClause(q, BooleanClause.Occur.MUST));
        } else if (!required && !prohibited) {
            clauses.add(this.newBooleanClause(q, BooleanClause.Occur.SHOULD));
        } else if (!required && prohibited) {
            clauses.add(this.newBooleanClause(q, BooleanClause.Occur.MUST_NOT));
        } else {
            throw new RuntimeException("Clause cannot be both required and prohibited");
        }
    }

    protected Query newFieldQuery(Analyzer analyzer, String field, String queryText, boolean quoted) throws SyntaxError {
        BooleanClause.Occur occur = this.operator == QueryParser.Operator.AND ? BooleanClause.Occur.MUST : BooleanClause.Occur.SHOULD;
        return this.createFieldQuery(analyzer, occur, field, queryText, quoted || this.autoGeneratePhraseQueries, this.phraseSlop);
    }

    protected Query getFieldQuery(String field, String queryText, int slop) throws SyntaxError {
        Query query = this.getFieldQuery(field, queryText, true);
        if (this.subQParser == null) {
            if (query instanceof PhraseQuery) {
                PhraseQuery pq = (PhraseQuery)query;
                Term[] terms = pq.getTerms();
                int[] positions = pq.getPositions();
                PhraseQuery.Builder builder = new PhraseQuery.Builder();
                for (int i = 0; i < terms.length; ++i) {
                    builder.add(terms[i], positions[i]);
                }
                builder.setSlop(slop);
                query = builder.build();
                query.setBoost(pq.getBoost());
            }
            if (query instanceof MultiPhraseQuery) {
                ((MultiPhraseQuery)query).setSlop(slop);
            }
        }
        return query;
    }

    protected BooleanClause newBooleanClause(Query q, BooleanClause.Occur occur) {
        return new BooleanClause(q, occur);
    }

    protected Query newPrefixQuery(Term prefix) {
        SchemaField sf = this.schema.getField(prefix.field());
        return sf.getType().getPrefixQuery(this.parser, sf, prefix.text());
    }

    protected Query newRegexpQuery(Term regexp) {
        RegexpQuery query = new RegexpQuery(regexp);
        SchemaField sf = this.schema.getField(regexp.field());
        query.setRewriteMethod(sf.getType().getRewriteMethod(this.parser, sf));
        return query;
    }

    protected Query newFuzzyQuery(Term term, float minimumSimilarity, int prefixLength) {
        String text = term.text();
        int numEdits = FuzzyQuery.floatToEdits((float)minimumSimilarity, (int)text.codePointCount(0, text.length()));
        return new FuzzyQuery(term, numEdits, prefixLength);
    }

    protected Query newMatchAllDocsQuery() {
        return new MatchAllDocsQuery();
    }

    protected Query newWildcardQuery(Term t) {
        WildcardQuery query = new WildcardQuery(t);
        SchemaField sf = this.schema.getField(t.field());
        query.setRewriteMethod(sf.getType().getRewriteMethod(this.parser, sf));
        return query;
    }

    protected Query getBooleanQuery(List<BooleanClause> clauses) throws SyntaxError {
        return this.getBooleanQuery(clauses, false);
    }

    protected Query getBooleanQuery(List<BooleanClause> clauses, boolean disableCoord) throws SyntaxError {
        if (clauses.size() == 0) {
            return null;
        }
        BooleanQuery.Builder query = this.newBooleanQuery(disableCoord);
        for (BooleanClause clause : clauses) {
            query.add(clause);
        }
        return query.build();
    }

    Query handleBareTokenQuery(String qfield, Token term, Token fuzzySlop, boolean prefix, boolean wildcard, boolean fuzzy, boolean regexp) throws SyntaxError {
        Query q;
        if (wildcard) {
            q = this.getWildcardQuery(qfield, term.image);
        } else if (prefix) {
            q = this.getPrefixQuery(qfield, this.discardEscapeChar(term.image.substring(0, term.image.length() - 1)));
        } else if (regexp) {
            q = this.getRegexpQuery(qfield, term.image.substring(1, term.image.length() - 1));
        } else if (fuzzy) {
            float fms = this.fuzzyMinSim;
            try {
                fms = Float.valueOf(fuzzySlop.image.substring(1)).floatValue();
            }
            catch (Exception ignored) {
                // empty catch block
            }
            if (fms < 0.0f) {
                throw new SyntaxError("Minimum similarity for a FuzzyQuery has to be between 0.0f and 1.0f !");
            }
            if (fms >= 1.0f && fms != (float)((int)fms)) {
                throw new SyntaxError("Fractional edit distances are not allowed!");
            }
            String termImage = this.discardEscapeChar(term.image);
            q = this.getFuzzyQuery(qfield, termImage, fms);
        } else {
            String termImage = this.discardEscapeChar(term.image);
            q = this.getFieldQuery(qfield, termImage, false);
        }
        return q;
    }

    Query handleQuotedTerm(String qfield, Token term, Token fuzzySlop) throws SyntaxError {
        int s = this.phraseSlop;
        if (fuzzySlop != null) {
            try {
                s = Float.valueOf(fuzzySlop.image.substring(1)).intValue();
            }
            catch (Exception ignored) {
                // empty catch block
            }
        }
        return this.getFieldQuery(qfield, this.discardEscapeChar(term.image.substring(1, term.image.length() - 1)), s);
    }

    Query handleBoost(Query q, Token boost) {
        if (boost == null || boost.image.length() == 0 || q == null) {
            return q;
        }
        if (boost.image.charAt(0) == '=') {
            float val = Float.parseFloat(boost.image.substring(1));
            Query newQ = q;
            if (q instanceof ConstantScoreQuery) {
                newQ.setBoost(val);
            } else {
                newQ = new ConstantScoreQuery(q);
                newQ.setBoost(val);
            }
            return newQ;
        }
        float boostVal = Float.parseFloat(boost.image);
        q.setBoost(q.getBoost() * boostVal);
        return q;
    }

    String discardEscapeChar(String input) throws SyntaxError {
        char[] output = new char[input.length()];
        int length = 0;
        boolean lastCharWasEscapeChar = false;
        int codePointMultiplier = 0;
        int codePoint = 0;
        for (int i = 0; i < input.length(); ++i) {
            char curChar = input.charAt(i);
            if (codePointMultiplier > 0) {
                codePoint += SolrQueryParserBase.hexToInt(curChar) * codePointMultiplier;
                if ((codePointMultiplier >>>= 4) != 0) continue;
                output[length++] = (char)codePoint;
                codePoint = 0;
                continue;
            }
            if (lastCharWasEscapeChar) {
                if (curChar == 'u') {
                    codePointMultiplier = 4096;
                } else {
                    output[length] = curChar;
                    ++length;
                }
                lastCharWasEscapeChar = false;
                continue;
            }
            if (curChar == '\\') {
                lastCharWasEscapeChar = true;
                continue;
            }
            output[length] = curChar;
            ++length;
        }
        if (codePointMultiplier > 0) {
            throw new SyntaxError("Truncated unicode escape sequence.");
        }
        if (lastCharWasEscapeChar) {
            throw new SyntaxError("Term can not end with escape character.");
        }
        return new String(output, 0, length);
    }

    static final int hexToInt(char c) throws SyntaxError {
        if ('0' <= c && c <= '9') {
            return c - 48;
        }
        if ('a' <= c && c <= 'f') {
            return c - 97 + 10;
        }
        if ('A' <= c && c <= 'F') {
            return c - 65 + 10;
        }
        throw new SyntaxError("Non-hex character in Unicode escape sequence: " + c);
    }

    public static String escape(String s) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\\' || c == '+' || c == '-' || c == '!' || c == '(' || c == ')' || c == ':' || c == '^' || c == '[' || c == ']' || c == '\"' || c == '{' || c == '}' || c == '~' || c == '*' || c == '?' || c == '|' || c == '&' || c == '/') {
                sb.append('\\');
            }
            sb.append(c);
        }
        return sb.toString();
    }

    protected ReversedWildcardFilterFactory getReversedWildcardFilterFactory(FieldType fieldType) {
        ReversedWildcardFilterFactory fac;
        if (this.leadingWildcards == null) {
            this.leadingWildcards = new HashMap<FieldType, ReversedWildcardFilterFactory>();
        }
        if ((fac = this.leadingWildcards.get(fieldType)) != null || this.leadingWildcards.containsKey((Object)fac)) {
            return fac;
        }
        Analyzer a = fieldType.getIndexAnalyzer();
        if (a instanceof TokenizerChain) {
            TokenFilterFactory[] factories;
            TokenizerChain tc = (TokenizerChain)a;
            for (TokenFilterFactory factory : factories = tc.getTokenFilterFactories()) {
                if (!(factory instanceof ReversedWildcardFilterFactory)) continue;
                fac = (ReversedWildcardFilterFactory)factory;
                break;
            }
        }
        this.leadingWildcards.put(fieldType, fac);
        return fac;
    }

    private void checkNullField(String field) throws SolrException {
        if (field == null && this.defaultField == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "no field name specified in query and no default specified via 'df' param");
        }
    }

    protected String analyzeIfMultitermTermText(String field, String part, FieldType fieldType) {
        if (part == null || !(fieldType instanceof TextField) || ((TextField)fieldType).getMultiTermAnalyzer() == null) {
            return part;
        }
        SchemaField sf = this.schema.getFieldOrNull(field);
        if (sf == null || !(fieldType instanceof TextField)) {
            return part;
        }
        String out = TextField.analyzeMultiTerm(field, part, ((TextField)fieldType).getMultiTermAnalyzer()).utf8ToString();
        return out;
    }

    protected Query getFieldQuery(String field, String queryText, boolean quoted) throws SyntaxError {
        MagicFieldName magic;
        this.checkNullField(field);
        if (field.charAt(0) == '_' && this.parser != null && null != (magic = MagicFieldName.get(field))) {
            this.subQParser = this.parser.subQuery(queryText, magic.subParser);
            return this.subQParser.getQuery();
        }
        SchemaField sf = this.schema.getFieldOrNull(field);
        if (sf != null) {
            FieldType ft = sf.getType();
            if (ft.isTokenized() && sf.indexed()) {
                return this.newFieldQuery(this.getAnalyzer(), field, queryText, quoted || ft instanceof TextField && ((TextField)ft).getAutoGeneratePhraseQueries());
            }
            return sf.getType().getFieldQuery(this.parser, sf, queryText);
        }
        return this.newFieldQuery(this.getAnalyzer(), field, queryText, quoted);
    }

    protected Query getRangeQuery(String field, String part1, String part2, boolean startInclusive, boolean endInclusive) throws SyntaxError {
        this.checkNullField(field);
        SchemaField sf = this.schema.getField(field);
        return sf.getType().getRangeQuery(this.parser, sf, part1, part2, startInclusive, endInclusive);
    }

    protected Query getPrefixQuery(String field, String termStr) throws SyntaxError {
        this.checkNullField(field);
        termStr = this.analyzeIfMultitermTermText(field, termStr, this.schema.getFieldType(field));
        return this.newPrefixQuery(new Term(field, termStr));
    }

    protected Query getWildcardQuery(String field, String termStr) throws SyntaxError {
        this.checkNullField(field);
        if ("*".equals(termStr) && ("*".equals(field) || this.getExplicitField() == null)) {
            return this.newMatchAllDocsQuery();
        }
        FieldType fieldType = this.schema.getFieldType(field);
        termStr = this.analyzeIfMultitermTermText(field, termStr, fieldType);
        ReversedWildcardFilterFactory factory = this.getReversedWildcardFilterFactory(fieldType);
        if (factory != null) {
            Term term = new Term(field, termStr);
            Automaton automaton = WildcardQuery.toAutomaton((Term)term);
            if (factory.shouldReverse(termStr)) {
                automaton = Operations.concatenate((Automaton)automaton, (Automaton)Automata.makeChar((int)factory.getMarkerChar()));
                automaton = Operations.reverse((Automaton)automaton);
            } else {
                Automaton falsePositives = Operations.concatenate((Automaton)Automata.makeChar((int)factory.getMarkerChar()), (Automaton)Automata.makeAnyString());
                automaton = Operations.minus((Automaton)automaton, (Automaton)falsePositives, (int)10000);
            }
            return new AutomatonQuery(term, automaton){

                public String toString(String field) {
                    StringBuilder buffer = new StringBuilder();
                    if (!this.getField().equals(field)) {
                        buffer.append(this.getField());
                        buffer.append(":");
                    }
                    buffer.append(this.term.text());
                    buffer.append(ToStringUtils.boost((float)this.getBoost()));
                    return buffer.toString();
                }
            };
        }
        return this.newWildcardQuery(new Term(field, termStr));
    }

    protected Query getRegexpQuery(String field, String termStr) throws SyntaxError {
        termStr = this.analyzeIfMultitermTermText(field, termStr, this.schema.getFieldType(field));
        return this.newRegexpQuery(new Term(field, termStr));
    }

    protected Query getFuzzyQuery(String field, String termStr, float minSimilarity) throws SyntaxError {
        termStr = this.analyzeIfMultitermTermText(field, termStr, this.schema.getFieldType(field));
        Term t = new Term(field, termStr);
        return this.newFuzzyQuery(t, minSimilarity, this.getFuzzyPrefixLength());
    }

    protected Query getLocalParams(String qfield, String lparams) throws SyntaxError {
        QParser nested = this.parser.subQuery(lparams, null);
        return nested.getQuery();
    }

    public static enum MagicFieldName {
        VAL("_val_", "func"),
        QUERY("_query_", null);

        public final String field;
        public final String subParser;
        private static final Map<String, MagicFieldName> lookup;

        private MagicFieldName(String field, String subParser) {
            this.field = field;
            this.subParser = subParser;
        }

        public String toString() {
            return this.field;
        }

        public static MagicFieldName get(String field) {
            return lookup.get(field);
        }

        static {
            lookup = new HashMap<String, MagicFieldName>();
            for (MagicFieldName s : EnumSet.allOf(MagicFieldName.class)) {
                lookup.put(s.toString(), s);
            }
        }
    }
}

