/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.component;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.apache.lucene.index.ExitableDirectoryReader;
import org.apache.lucene.util.Version;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.core.CloseHook;
import org.apache.solr.core.PluginInfo;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.handler.component.DebugComponent;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.handler.component.SearchComponent;
import org.apache.solr.handler.component.ShardHandler;
import org.apache.solr.handler.component.ShardHandlerFactory;
import org.apache.solr.handler.component.ShardRequest;
import org.apache.solr.handler.component.ShardResponse;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.search.SolrQueryTimeoutImpl;
import org.apache.solr.util.SolrPluginUtils;
import org.apache.solr.util.plugin.PluginInfoInitialized;
import org.apache.solr.util.plugin.SolrCoreAware;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchHandler
extends RequestHandlerBase
implements SolrCoreAware,
PluginInfoInitialized {
    static final String INIT_COMPONENTS = "components";
    static final String INIT_FIRST_COMPONENTS = "first-components";
    static final String INIT_LAST_COMPONENTS = "last-components";
    protected static Logger log = LoggerFactory.getLogger(SearchHandler.class);
    protected volatile List<SearchComponent> components;
    private ShardHandlerFactory shardHandlerFactory;
    private PluginInfo shfInfo;
    private SolrCore core;

    protected List<String> getDefaultComponents() {
        ArrayList<String> names = new ArrayList<String>(8);
        names.add("query");
        names.add("facet");
        names.add("facet_module");
        names.add("mlt");
        names.add("highlight");
        names.add("stats");
        names.add("debug");
        names.add("expand");
        return names;
    }

    @Override
    public void init(PluginInfo info) {
        this.init(info.initArgs);
        for (PluginInfo child : info.children) {
            if (!"shardHandlerFactory".equals(child.type)) continue;
            this.shfInfo = child;
            break;
        }
    }

    @Override
    public void inform(SolrCore core) {
        this.core = core;
        HashSet<String> missing = new HashSet<String>();
        List c = (List)this.initArgs.get(INIT_COMPONENTS);
        missing.addAll(core.getSearchComponents().checkContains(c));
        List first = (List)this.initArgs.get(INIT_FIRST_COMPONENTS);
        missing.addAll(core.getSearchComponents().checkContains(first));
        List last = (List)this.initArgs.get(INIT_LAST_COMPONENTS);
        missing.addAll(core.getSearchComponents().checkContains(last));
        if (!missing.isEmpty()) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Missing SearchComponents named : " + missing);
        }
        if (c != null && (first != null || last != null)) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "First/Last components only valid if you do not declare 'components'");
        }
        if (this.shfInfo == null) {
            this.shardHandlerFactory = core.getCoreDescriptor().getCoreContainer().getShardHandlerFactory();
        } else {
            this.shardHandlerFactory = core.createInitInstance(this.shfInfo, ShardHandlerFactory.class, null, null);
            core.addCloseHook(new CloseHook(){

                @Override
                public void preClose(SolrCore core) {
                    SearchHandler.this.shardHandlerFactory.close();
                }

                @Override
                public void postClose(SolrCore core) {
                }
            });
        }
    }

    private void initComponents() {
        Object declaredComponents = this.initArgs.get(INIT_COMPONENTS);
        List first = (List)this.initArgs.get(INIT_FIRST_COMPONENTS);
        List last = (List)this.initArgs.get(INIT_LAST_COMPONENTS);
        List list = null;
        boolean makeDebugLast = true;
        if (declaredComponents == null) {
            list = this.getDefaultComponents();
            if (first != null) {
                List clist = first;
                clist.addAll(list);
                list = clist;
            }
            if (last != null) {
                list.addAll(last);
            }
        } else {
            list = (List)declaredComponents;
            if (first != null || last != null) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "First/Last components only valid if you do not declare 'components'");
            }
            makeDebugLast = false;
        }
        ArrayList<SearchComponent> components = new ArrayList<SearchComponent>(list.size());
        DebugComponent dbgCmp = null;
        for (String c : list) {
            SearchComponent comp = this.core.getSearchComponent(c);
            if (comp instanceof DebugComponent && makeDebugLast) {
                dbgCmp = (DebugComponent)comp;
                continue;
            }
            components.add(comp);
            log.debug("Adding  component:" + comp);
        }
        if (makeDebugLast && dbgCmp != null) {
            components.add(dbgCmp);
            log.debug("Adding  debug component:" + dbgCmp);
        }
        this.components = components;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SearchComponent> getComponents() {
        List<SearchComponent> result = this.components;
        if (result == null) {
            SearchHandler searchHandler = this;
            synchronized (searchHandler) {
                if (this.components == null) {
                    this.initComponents();
                }
                result = this.components;
            }
        }
        return result;
    }

    private ShardHandler getAndPrepShardHandler(SolrQueryRequest req, ResponseBuilder rb) {
        ShardHandler shardHandler = null;
        rb.isDistrib = req.getParams().getBool("distrib", req.getCore().getCoreDescriptor().getCoreContainer().isZooKeeperAware());
        if (!rb.isDistrib) {
            String shards = req.getParams().get("shards");
            boolean bl = rb.isDistrib = shards != null && shards.indexOf(47) > 0;
        }
        if (rb.isDistrib) {
            shardHandler = this.shardHandlerFactory.getShardHandler();
            shardHandler.prepDistributed(rb);
            if (!rb.isDistrib) {
                shardHandler = null;
            }
        }
        return shardHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        components = this.getComponents();
        rb = new ResponseBuilder(req, rsp, components);
        if (rb.requestInfo != null) {
            rb.requestInfo.setResponseBuilder(rb);
        }
        dbg = req.getParams().getBool("debugQuery", false);
        rb.setDebug(dbg);
        if (!dbg) {
            SolrPluginUtils.getDebugInterests(req.getParams().getParams("debug"), rb);
        }
        timer = rb.isDebug() != false ? req.getRequestTimer() : null;
        shardHandler1 = this.getAndPrepShardHandler(req, rb);
        if (timer == null) {
            for (SearchComponent c : components) {
                c.prepare(rb);
            }
        } else {
            subt = timer.sub("prepare");
            for (SearchComponent c : components) {
                rb.setTimer(subt.sub(c.getName()));
                c.prepare(rb);
                rb.getTimer().stop();
            }
            subt.stop();
        }
        if (!rb.isDistrib) {
            timeAllowed = req.getParams().getLong("timeAllowed", -1L);
            if (timeAllowed > 0L) {
                SolrQueryTimeoutImpl.set(timeAllowed);
            }
            try {
                if (!rb.isDebug()) {
                    for (SearchComponent c : components) {
                        c.process(rb);
                    }
                }
                subt = timer.sub("process");
                for (SearchComponent c : components) {
                    rb.setTimer(subt.sub(c.getName()));
                    c.process(rb);
                    rb.getTimer().stop();
                }
                subt.stop();
                if (!rb.isDebugTimings()) ** GOTO lbl136
                rb.addDebugInfo("timing", timer.asNamedList());
            }
            catch (ExitableDirectoryReader.ExitingReaderException ex) {
                SearchHandler.log.warn("Query: " + req.getParamString() + "; " + ex.getMessage());
                r = (SolrDocumentList)rb.rsp.getValues().get("response");
                if (r == null) {
                    r = new SolrDocumentList();
                }
                r.setNumFound(0L);
                rb.rsp.add("response", r);
                if (rb.isDebug()) {
                    debug = new NamedList();
                    debug.add("explain", (Object)new NamedList());
                    rb.rsp.add("debug", debug);
                }
                rb.rsp.getResponseHeader().add("partialResults", (Object)Boolean.TRUE);
            }
            finally {
                SolrQueryTimeoutImpl.reset();
            }
        } else {
            if (rb.outgoing == null) {
                rb.outgoing = new LinkedList<ShardRequest>();
            }
            rb.finished = new ArrayList<ShardRequest>();
            nextStage = 0;
            do {
                rb.stage = nextStage;
                nextStage = ResponseBuilder.STAGE_DONE;
                for (SearchComponent c : components) {
                    nextStage = Math.min(nextStage, c.distributedProcess(rb));
                }
                while (rb.outgoing.size() > 0) {
                    while (rb.outgoing.size() > 0) {
                        sreq = rb.outgoing.remove(0);
                        sreq.actualShards = sreq.shards;
                        if (sreq.actualShards == ShardRequest.ALL_SHARDS) {
                            sreq.actualShards = rb.shards;
                        }
                        sreq.responses = new ArrayList<ShardResponse>(sreq.actualShards.length);
                        for (String shard : sreq.actualShards) {
                            params = new ModifiableSolrParams((SolrParams)sreq.params);
                            params.remove("shards");
                            params.set("distrib", new String[]{"false"});
                            params.remove("indent");
                            params.remove("echoParams");
                            params.set("isShard", true);
                            params.set("shards.purpose", sreq.purpose);
                            params.set("shard.url", new String[]{shard});
                            if (rb.requestInfo != null) {
                                params.set("NOW", new String[]{Long.toString(rb.requestInfo.getNOW().getTime())});
                            }
                            if ((shardQt = params.get("shards.qt")) != null) {
                                params.set("qt", new String[]{shardQt});
                            } else if (req.getCore().getSolrConfig().luceneMatchVersion.onOrAfter(Version.LUCENE_5_1_0)) {
                                reqPath = (String)req.getContext().get("path");
                                if (!"/select".equals(reqPath)) {
                                    params.set("qt", new String[]{reqPath});
                                }
                            } else {
                                params.remove("qt");
                            }
                            shardHandler1.submit(sreq, shard, params);
                        }
                    }
                    tolerant = rb.req.getParams().getBool("shards.tolerant", false);
                    while (rb.outgoing.size() == 0 && (srsp = tolerant != false ? shardHandler1.takeCompletedIncludingErrors() : shardHandler1.takeCompletedOrError()) != null) {
                        if (srsp.getException() != null) {
                            if (!tolerant) {
                                shardHandler1.cancelAll();
                                if (srsp.getException() instanceof SolrException) {
                                    throw (SolrException)srsp.getException();
                                }
                                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, srsp.getException());
                            }
                            if (rsp.getResponseHeader().get("partialResults") == null) {
                                rsp.getResponseHeader().add("partialResults", (Object)Boolean.TRUE);
                            }
                        }
                        rb.finished.add(srsp.getShardRequest());
                        for (SearchComponent c : components) {
                            c.handleResponses(rb, srsp.getShardRequest());
                        }
                    }
                }
                for (SearchComponent c : components) {
                    c.finishStage(rb);
                }
            } while (nextStage != 0x7FFFFFFF);
        }
lbl136:
        // 5 sources

        if (!rb.isDistrib && req.getParams().getBool("shards.info", false) && rb.shortCircuitedURL != null) {
            shardInfo = new SimpleOrderedMap();
            nl = new SimpleOrderedMap();
            if (rsp.getException() != null) {
                cause = rsp.getException();
                if (cause instanceof SolrServerException) {
                    cause = ((SolrServerException)cause).getRootCause();
                } else if (cause.getCause() != null) {
                    cause = cause.getCause();
                }
                nl.add("error", (Object)cause.toString());
                trace = new StringWriter();
                cause.printStackTrace(new PrintWriter(trace));
                nl.add("trace", (Object)trace.toString());
            } else {
                nl.add("numFound", (Object)rb.getResults().docList.matches());
                nl.add("maxScore", (Object)Float.valueOf(rb.getResults().docList.maxScore()));
            }
            nl.add("shardAddress", (Object)rb.shortCircuitedURL);
            nl.add("time", (Object)req.getRequestTimer().getTime());
            pos = rb.shortCircuitedURL.indexOf("://");
            shardInfoName = pos != -1 ? rb.shortCircuitedURL.substring(pos + 3) : rb.shortCircuitedURL;
            shardInfo.add(shardInfoName, (Object)nl);
            rsp.getValues().add("shards.info", (Object)shardInfo);
        }
    }

    @Override
    public String getDescription() {
        StringBuilder sb = new StringBuilder();
        sb.append("Search using components: ");
        if (this.components != null) {
            for (SearchComponent c : this.components) {
                sb.append(c.getName());
                sb.append(",");
            }
        }
        return sb.toString();
    }
}

