/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrResponse;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.request.CoreAdminRequest;
import org.apache.solr.cloud.DistributedMap;
import org.apache.solr.cloud.DistributedQueue;
import org.apache.solr.cloud.Overseer;
import org.apache.solr.cloud.OverseerSolrResponse;
import org.apache.solr.cloud.overseer.SliceMutator;
import org.apache.solr.cloud.rule.ReplicaAssigner;
import org.apache.solr.cloud.rule.Rule;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZkCmdExecutor;
import org.apache.solr.common.cloud.ZkCoreNodeProps;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.common.util.Utils;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.handler.admin.ClusterStatus;
import org.apache.solr.handler.admin.RebalanceLeaders;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollectionsHandler
extends RequestHandlerBase {
    protected static Logger log = LoggerFactory.getLogger(CollectionsHandler.class);
    protected final CoreContainer coreContainer;
    static final Set<String> KNOWN_ROLES = ImmutableSet.of((Object)"overseer");
    public static long DEFAULT_ZK_TIMEOUT = 180000L;
    public static final String SYSTEM_COLL = ".system";
    public static final List<String> MODIFIABLE_COLL_PROPS = ImmutableList.of((Object)"rule", (Object)"snitch", (Object)"replicationFactor", (Object)"maxShardsPerNode", (Object)"autoAddReplicas");

    public CollectionsHandler() {
        this.coreContainer = null;
    }

    public CollectionsHandler(CoreContainer coreContainer) {
        this.coreContainer = coreContainer;
    }

    @Override
    public final void init(NamedList args) {
    }

    public CoreContainer getCoreContainer() {
        return this.coreContainer;
    }

    @Override
    public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        CoreContainer cores = this.getCoreContainer();
        if (cores == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Core container instance missing");
        }
        if (!cores.isZooKeeperAware()) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Solr instance is not running in SolrCloud mode.");
        }
        SolrParams params = req.getParams();
        String a = params.get("action");
        if (a != null) {
            CollectionParams.CollectionAction action = CollectionParams.CollectionAction.get((String)a);
            if (action == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unknown action: " + a);
            }
            CollectionOperation operation = CollectionOperation.get(action);
            log.info("Invoked Collection Action :{} with params {} ", (Object)action.toLower(), (Object)req.getParamString());
            Map<String, Object> result = operation.call(req, rsp, this);
            if (result != null) {
                result.put("operation", operation.action.toLower());
                ZkNodeProps props = new ZkNodeProps(result);
                if (operation.sendToOCPQueue) {
                    this.handleResponse(operation.action.toLower(), props, rsp, operation.timeOut);
                } else {
                    Overseer.getInQueue(this.coreContainer.getZkController().getZkClient()).offer(Utils.toJSON((Object)props));
                }
            }
        } else {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "action is a required param");
        }
        rsp.setHttpCaching(false);
    }

    void handleResponse(String operation, ZkNodeProps m, SolrQueryResponse rsp) throws KeeperException, InterruptedException {
        this.handleResponse(operation, m, rsp, DEFAULT_ZK_TIMEOUT);
    }

    private void handleResponse(String operation, ZkNodeProps m, SolrQueryResponse rsp, long timeout) throws KeeperException, InterruptedException {
        long time = System.nanoTime();
        if (m.containsKey("async") && m.get("async") != null) {
            String asyncId = m.getStr("async");
            if (asyncId.equals("-1")) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "requestid can not be -1. It is reserved for cleanup purposes.");
            }
            NamedList r = new NamedList();
            if (this.coreContainer.getZkController().getOverseerCompletedMap().contains(asyncId) || this.coreContainer.getZkController().getOverseerFailureMap().contains(asyncId) || this.coreContainer.getZkController().getOverseerRunningMap().contains(asyncId) || this.overseerCollectionQueueContains(asyncId)) {
                r.add("error", (Object)"Task with the same requestid already exists.");
            } else {
                this.coreContainer.getZkController().getOverseerCollectionQueue().offer(Utils.toJSON((Object)m));
            }
            r.add("requestid", (Object)((String)m.get("async")));
            OverseerSolrResponse response = new OverseerSolrResponse(r);
            rsp.getValues().addAll(response.getResponse());
            return;
        }
        DistributedQueue.QueueEvent event = this.coreContainer.getZkController().getOverseerCollectionQueue().offer(Utils.toJSON((Object)m), timeout);
        if (event.getBytes() != null) {
            SolrResponse response = SolrResponse.deserialize((byte[])event.getBytes());
            rsp.getValues().addAll(response.getResponse());
            SimpleOrderedMap exp = (SimpleOrderedMap)response.getResponse().get("exception");
            if (exp != null) {
                Integer code = (Integer)exp.get("rspCode");
                rsp.setException((Exception)((Object)new SolrException(code != null && code != -1 ? SolrException.ErrorCode.getErrorCode((int)code) : SolrException.ErrorCode.SERVER_ERROR, (String)exp.get("msg"))));
            }
        } else {
            if (System.nanoTime() - time >= TimeUnit.NANOSECONDS.convert(timeout, TimeUnit.MILLISECONDS)) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, operation + " the collection time out:" + timeout / 1000L + "s");
            }
            if (event.getWatchedEvent() != null) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, operation + " the collection error [Watcher fired on path: " + event.getWatchedEvent().getPath() + " state: " + event.getWatchedEvent().getState() + " type " + event.getWatchedEvent().getType() + "]");
            }
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, operation + " the collection unkown case");
        }
    }

    private boolean overseerCollectionQueueContains(String asyncId) throws KeeperException, InterruptedException {
        DistributedQueue collectionQueue = this.coreContainer.getZkController().getOverseerCollectionQueue();
        return collectionQueue.containsTaskWithRequestId("async", asyncId);
    }

    private static Map<String, Object> copyPropertiesWithPrefix(SolrParams params, Map<String, Object> props, String prefix) {
        Iterator iter = params.getParameterNamesIterator();
        while (iter.hasNext()) {
            String param = (String)iter.next();
            if (!param.startsWith(prefix)) continue;
            props.put(param, params.get(param));
        }
        return props;
    }

    public static ModifiableSolrParams params(String ... params) {
        ModifiableSolrParams msp = new ModifiableSolrParams();
        for (int i = 0; i < params.length; i += 2) {
            msp.add(params[i], new String[]{params[i + 1]});
        }
        return msp;
    }

    @Override
    public String getDescription() {
        return "Manage SolrCloud Collections";
    }

    public static void verifyRuleParams(CoreContainer cc, Map<String, Object> m) {
        List l = (List)m.get("rule");
        if (l != null) {
            for (Object o : l) {
                Map map = (Map)o;
                try {
                    new Rule(map);
                }
                catch (Exception e) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Error in rule " + m, (Throwable)e);
                }
            }
        }
        ReplicaAssigner.verifySnitchConf(cc, (List)m.get("snitch"));
    }

    private static Map<String, Object> addMapObject(Map<String, Object> props, String key) {
        Object v = props.get(key);
        if (v == null) {
            return props;
        }
        ArrayList<String> val = new ArrayList<String>();
        if (v instanceof String[]) {
            val.addAll(Arrays.asList((String[])v));
        } else {
            val.add(v.toString());
        }
        if (val.size() > 0) {
            ArrayList<Map> l = new ArrayList<Map>();
            for (String rule : val) {
                l.add(Rule.parseRule(rule));
            }
            props.put(key, l);
        }
        return props;
    }

    static enum CollectionOperation {
        CREATE_OP(CollectionParams.CollectionAction.CREATE){

            @Override
            Map<String, Object> call(SolrQueryRequest req, SolrQueryResponse rsp, CollectionsHandler h) throws KeeperException, InterruptedException {
                Map props = req.getParams().required().getAll(null, new String[]{"name"});
                props.put("fromApi", "true");
                req.getParams().getAll(props, new String[]{"replicationFactor", "collection.configName", "numShards", "maxShardsPerNode", "createNodeSet", "createNodeSet.shuffle", "shards", "async", "stateFormat", "autoAddReplicas", "rule", "snitch"});
                if (props.get("stateFormat") == null) {
                    props.put("stateFormat", "2");
                }
                CollectionsHandler.addMapObject(props, "rule");
                CollectionsHandler.addMapObject(props, "snitch");
                CollectionsHandler.verifyRuleParams(h.coreContainer, props);
                if (CollectionsHandler.SYSTEM_COLL.equals(props.get("name"))) {
                    props.put("numShards", 1);
                    props.remove("shards");
                    this.createSysConfigSet(h.coreContainer);
                }
                CollectionsHandler.copyPropertiesWithPrefix(req.getParams(), props, "property.");
                return CollectionsHandler.copyPropertiesWithPrefix(req.getParams(), props, "router.");
            }

            private void createSysConfigSet(CoreContainer coreContainer) throws KeeperException, InterruptedException {
                SolrZkClient zk = coreContainer.getZkController().getZkStateReader().getZkClient();
                ZkCmdExecutor cmdExecutor = new ZkCmdExecutor(zk.getZkClientTimeout());
                cmdExecutor.ensureExists("/configs", zk);
                cmdExecutor.ensureExists("/configs/.system", zk);
                String path = "/configs/.system/schema.xml";
                byte[] data = "<?xml version='1.0' ?>\n<schema name='_system collection or core' version='1.1'>\n  <fieldtype name='string'  class='solr.StrField' sortMissingLast='true' omitNorms='true'/>\n  <fieldType name='long' class='solr.TrieLongField' precisionStep='0' positionIncrementGap='0'/>\n  <fieldType name='bytes' class='solr.BinaryField'/>\n  <fieldType name='date' class='solr.TrieDateField'/>\n  <field name='id'   type='string'   indexed='true'  stored='true'  multiValued='false' required='true'/>\n  <field name='md5'   type='string'   indexed='true'  stored='true'  multiValued='false' required='true'/>\n  <field name='blob'      type='bytes'   indexed='false' stored='true'  multiValued='false' />\n  <field name='size'      type='long'   indexed='true' stored='true'  multiValued='false' />\n  <field name='version'   type='long'     indexed='true'  stored='true'  multiValued='false' />\n  <field name='timestamp'   type='date'   indexed='true'  stored='true'  multiValued='false' />\n  <field name='blobName'      type='string'   indexed='true'  stored='true'  multiValued='false' />\n  <field name='_version_' type='long'     indexed='true'  stored='true'/>\n  <uniqueKey>id</uniqueKey>\n</schema>".replaceAll("'", "\"").getBytes(StandardCharsets.UTF_8);
                cmdExecutor.ensureExists(path, data, CreateMode.PERSISTENT, zk);
                path = "/configs/.system/solrconfig.xml";
                data = "<?xml version='1.0' ?>\n<config>\n<luceneMatchVersion>LATEST</luceneMatchVersion>\n<directoryFactory name='DirectoryFactory' class='${solr.directoryFactory:solr.StandardDirectoryFactory}'/>\n<updateHandler class='solr.DirectUpdateHandler2'>\n  <updateLog>\n    <str name='dir'>${solr.ulog.dir:}</str>\n  </updateLog>\n       <autoCommit> \n       <maxDocs>1</maxDocs> \n       <openSearcher>true</openSearcher> \n  </autoCommit></updateHandler>\n<requestHandler name='standard' class='solr.StandardRequestHandler' default='true' />\n<requestHandler name='/analysis/field' startup='lazy' class='solr.FieldAnalysisRequestHandler' />\n<requestHandler name='/blob' class='solr.BlobHandler'>\n  <lst name='invariants'>\n<str name='maxSize'>${blob.max.size.mb:5}</str>\n</lst>\n</requestHandler>\n</config>".replaceAll("'", "\"").getBytes(StandardCharsets.UTF_8);
                cmdExecutor.ensureExists(path, data, CreateMode.PERSISTENT, zk);
            }
        }
        ,
        DELETE_OP(CollectionParams.CollectionAction.DELETE){

            @Override
            Map<String, Object> call(SolrQueryRequest req, SolrQueryResponse rsp, CollectionsHandler handler) throws Exception {
                return req.getParams().required().getAll(null, new String[]{"name"});
            }
        }
        ,
        RELOAD_OP(CollectionParams.CollectionAction.RELOAD){

            @Override
            Map<String, Object> call(SolrQueryRequest req, SolrQueryResponse rsp, CollectionsHandler handler) throws Exception {
                return req.getParams().required().getAll(null, new String[]{"name"});
            }
        }
        ,
        SYNCSHARD_OP(CollectionParams.CollectionAction.SYNCSHARD){

            @Override
            Map<String, Object> call(SolrQueryRequest req, SolrQueryResponse rsp, CollectionsHandler h) throws Exception {
                String collection = req.getParams().required().get("collection");
                String shard = req.getParams().required().get("shard");
                ClusterState clusterState = h.coreContainer.getZkController().getClusterState();
                Replica leaderProps = clusterState.getLeader(collection, shard);
                ZkCoreNodeProps nodeProps = new ZkCoreNodeProps((ZkNodeProps)leaderProps);
                try (HttpSolrClient client = new HttpSolrClient(nodeProps.getBaseUrl());){
                    client.setConnectionTimeout(15000);
                    client.setSoTimeout(60000);
                    CoreAdminRequest.RequestSyncShard reqSyncShard = new CoreAdminRequest.RequestSyncShard();
                    reqSyncShard.setCollection(collection);
                    reqSyncShard.setShard(shard);
                    reqSyncShard.setCoreName(nodeProps.getCoreName());
                    client.request((SolrRequest)reqSyncShard);
                }
                return null;
            }
        }
        ,
        CREATEALIAS_OP(CollectionParams.CollectionAction.CREATEALIAS){

            @Override
            Map<String, Object> call(SolrQueryRequest req, SolrQueryResponse rsp, CollectionsHandler handler) throws Exception {
                return req.getParams().required().getAll(null, new String[]{"name", "collections"});
            }
        }
        ,
        DELETEALIAS_OP(CollectionParams.CollectionAction.DELETEALIAS){

            @Override
            Map<String, Object> call(SolrQueryRequest req, SolrQueryResponse rsp, CollectionsHandler handler) throws Exception {
                return req.getParams().required().getAll(null, new String[]{"name"});
            }
        }
        ,
        SPLITSHARD_OP(CollectionParams.CollectionAction.SPLITSHARD, DEFAULT_ZK_TIMEOUT * 5L, true){

            @Override
            Map<String, Object> call(SolrQueryRequest req, SolrQueryResponse rsp, CollectionsHandler h) throws Exception {
                String name = req.getParams().required().get("collection");
                String shard = req.getParams().get("shard");
                String rangesStr = req.getParams().get("ranges");
                String splitKey = req.getParams().get("split.key");
                if (splitKey == null && shard == null) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Missing required parameter: shard");
                }
                if (splitKey != null && shard != null) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Only one of 'shard' or 'split.key' should be specified");
                }
                if (splitKey != null && rangesStr != null) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Only one of 'ranges' or 'split.key' should be specified");
                }
                Map map = req.getParams().getAll(null, new String[]{"collection", "shard", "split.key", "ranges", "async"});
                return CollectionsHandler.copyPropertiesWithPrefix(req.getParams(), map, "property.");
            }
        }
        ,
        DELETESHARD_OP(CollectionParams.CollectionAction.DELETESHARD){

            @Override
            Map<String, Object> call(SolrQueryRequest req, SolrQueryResponse rsp, CollectionsHandler handler) throws Exception {
                return req.getParams().required().getAll(null, new String[]{"collection", "shard"});
            }
        }
        ,
        CREATESHARD_OP(CollectionParams.CollectionAction.CREATESHARD){

            @Override
            Map<String, Object> call(SolrQueryRequest req, SolrQueryResponse rsp, CollectionsHandler handler) throws Exception {
                Map map = req.getParams().required().getAll(null, new String[]{"collection", "shard"});
                ClusterState clusterState = handler.coreContainer.getZkController().getClusterState();
                if (!"implicit".equals(((Map)clusterState.getCollection(req.getParams().get("collection")).get("router")).get("name"))) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "shards can be added only to 'implicit' collections");
                }
                req.getParams().getAll(map, new String[]{"replicationFactor", "createNodeSet", "async"});
                return CollectionsHandler.copyPropertiesWithPrefix(req.getParams(), map, "property.");
            }
        }
        ,
        DELETEREPLICA_OP(CollectionParams.CollectionAction.DELETEREPLICA){

            @Override
            Map<String, Object> call(SolrQueryRequest req, SolrQueryResponse rsp, CollectionsHandler handler) throws Exception {
                Map map = req.getParams().required().getAll(null, new String[]{"collection", "shard", "replica"});
                return req.getParams().getAll(map, new String[]{"async", "onlyIfDown"});
            }
        }
        ,
        MIGRATE_OP(CollectionParams.CollectionAction.MIGRATE){

            @Override
            Map<String, Object> call(SolrQueryRequest req, SolrQueryResponse rsp, CollectionsHandler h) throws Exception {
                Map map = req.getParams().required().getAll(null, new String[]{"collection", "split.key", "target.collection"});
                return req.getParams().getAll(map, new String[]{"forward.timeout", "async"});
            }
        }
        ,
        ADDROLE_OP(CollectionParams.CollectionAction.ADDROLE){

            @Override
            Map<String, Object> call(SolrQueryRequest req, SolrQueryResponse rsp, CollectionsHandler handler) throws Exception {
                Map map = req.getParams().required().getAll(null, new String[]{"role", "node"});
                if (!KNOWN_ROLES.contains(map.get("role"))) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unknown role. Supported roles are ," + KNOWN_ROLES);
                }
                return map;
            }
        }
        ,
        REMOVEROLE_OP(CollectionParams.CollectionAction.REMOVEROLE){

            @Override
            Map<String, Object> call(SolrQueryRequest req, SolrQueryResponse rsp, CollectionsHandler h) throws Exception {
                Map map = req.getParams().required().getAll(null, new String[]{"role", "node"});
                if (!KNOWN_ROLES.contains(map.get("role"))) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unknown role. Supported roles are ," + KNOWN_ROLES);
                }
                return map;
            }
        }
        ,
        CLUSTERPROP_OP(CollectionParams.CollectionAction.CLUSTERPROP){

            @Override
            Map<String, Object> call(SolrQueryRequest req, SolrQueryResponse rsp, CollectionsHandler h) throws Exception {
                String name = req.getParams().required().get("name");
                String val = req.getParams().get("val");
                h.coreContainer.getZkController().getZkStateReader().setClusterProperty(name, val);
                return null;
            }
        }
        ,
        REQUESTSTATUS_OP(CollectionParams.CollectionAction.REQUESTSTATUS){

            @Override
            Map<String, Object> call(SolrQueryRequest req, SolrQueryResponse rsp, CollectionsHandler h) throws Exception {
                CoreContainer coreContainer = h.coreContainer;
                req.getParams().required().check(new String[]{"requestid"});
                String requestId = req.getParams().get("requestid");
                if (requestId.equals("-1")) {
                    if (requestId.equals("-1")) {
                        coreContainer.getZkController().getOverseerCompletedMap().clear();
                        coreContainer.getZkController().getOverseerFailureMap().clear();
                        return null;
                    }
                } else {
                    SimpleOrderedMap success;
                    NamedList results = new NamedList();
                    if (coreContainer.getZkController().getOverseerCompletedMap().contains(requestId)) {
                        DistributedMap.MapEvent mapEvent = coreContainer.getZkController().getOverseerCompletedMap().get(requestId);
                        SimpleOrderedMap success2 = new SimpleOrderedMap();
                        if (mapEvent != null) {
                            rsp.getValues().addAll(SolrResponse.deserialize((byte[])mapEvent.getBytes()).getResponse());
                        }
                        success2.add("state", (Object)"completed");
                        success2.add("msg", (Object)("found " + requestId + " in completed tasks"));
                        results.add("status", (Object)success2);
                    } else if (coreContainer.getZkController().getOverseerFailureMap().contains(requestId)) {
                        success = new SimpleOrderedMap();
                        DistributedMap.MapEvent mapEvent = coreContainer.getZkController().getOverseerFailureMap().get(requestId);
                        if (mapEvent != null) {
                            rsp.getValues().addAll(SolrResponse.deserialize((byte[])mapEvent.getBytes()).getResponse());
                        }
                        success.add("state", (Object)"failed");
                        success.add("msg", (Object)("found " + requestId + " in failed tasks"));
                        results.add("status", (Object)success);
                    } else if (coreContainer.getZkController().getOverseerRunningMap().contains(requestId)) {
                        success = new SimpleOrderedMap();
                        success.add("state", (Object)"running");
                        success.add("msg", (Object)("found " + requestId + " in running tasks"));
                        results.add("status", (Object)success);
                    } else if (h.overseerCollectionQueueContains(requestId)) {
                        success = new SimpleOrderedMap();
                        success.add("state", (Object)"submitted");
                        success.add("msg", (Object)("found " + requestId + " in submitted tasks"));
                        results.add("status", (Object)success);
                    } else {
                        SimpleOrderedMap failure = new SimpleOrderedMap();
                        failure.add("state", (Object)"notfound");
                        failure.add("msg", (Object)("Did not find taskid [" + requestId + "] in any tasks queue"));
                        results.add("status", (Object)failure);
                    }
                    OverseerSolrResponse response = new OverseerSolrResponse(results);
                    rsp.getValues().addAll(response.getResponse());
                }
                return null;
            }
        }
        ,
        ADDREPLICA_OP(CollectionParams.CollectionAction.ADDREPLICA){

            @Override
            Map<String, Object> call(SolrQueryRequest req, SolrQueryResponse rsp, CollectionsHandler h) throws Exception {
                Map props = req.getParams().getAll(null, new String[]{"collection", "node", "shard", "_route_", "name", "instanceDir", "dataDir", "async"});
                return CollectionsHandler.copyPropertiesWithPrefix(req.getParams(), props, "property.");
            }
        }
        ,
        OVERSEERSTATUS_OP(CollectionParams.CollectionAction.OVERSEERSTATUS){

            @Override
            Map<String, Object> call(SolrQueryRequest req, SolrQueryResponse rsp, CollectionsHandler h) throws Exception {
                return new LinkedHashMap<String, Object>();
            }
        }
        ,
        LIST_OP(CollectionParams.CollectionAction.LIST){

            @Override
            Map<String, Object> call(SolrQueryRequest req, SolrQueryResponse rsp, CollectionsHandler handler) throws Exception {
                NamedList results = new NamedList();
                Set collections = handler.coreContainer.getZkController().getZkStateReader().getClusterState().getCollections();
                ArrayList<String> collectionList = new ArrayList<String>();
                for (String collection : collections) {
                    collectionList.add(collection);
                }
                results.add("collections", collectionList);
                OverseerSolrResponse response = new OverseerSolrResponse(results);
                rsp.getValues().addAll(response.getResponse());
                return null;
            }
        }
        ,
        CLUSTERSTATUS_OP(CollectionParams.CollectionAction.CLUSTERSTATUS){

            @Override
            Map<String, Object> call(SolrQueryRequest req, SolrQueryResponse rsp, CollectionsHandler handler) throws KeeperException, InterruptedException {
                Map all = req.getParams().getAll(null, new String[]{"collection", "shard", "_route_"});
                new ClusterStatus(handler.coreContainer.getZkController().getZkStateReader(), new ZkNodeProps(all)).getClusterStatus(rsp.getValues());
                return null;
            }
        }
        ,
        ADDREPLICAPROP_OP(CollectionParams.CollectionAction.ADDREPLICAPROP){

            @Override
            Map<String, Object> call(SolrQueryRequest req, SolrQueryResponse rsp, CollectionsHandler h) throws Exception {
                Map map = req.getParams().required().getAll(null, new String[]{"collection", "property", "shard", "replica", "property.value"});
                req.getParams().getAll(map, new String[]{"shardUnique"});
                String property = (String)map.get("property");
                if (!property.startsWith("property.")) {
                    property = "property." + property;
                }
                boolean uniquePerSlice = Boolean.parseBoolean((String)map.get("shardUnique"));
                if (StringUtils.isNotBlank((String)((String)map.get("shardUnique"))) && SliceMutator.SLICE_UNIQUE_BOOLEAN_PROPERTIES.contains(property.toLowerCase(Locale.ROOT)) && !uniquePerSlice) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Overseer replica property command received for property " + property + " with the " + "shardUnique" + " parameter set to something other than 'true'. No action taken.");
                }
                return map;
            }
        }
        ,
        DELETEREPLICAPROP_OP(CollectionParams.CollectionAction.DELETEREPLICAPROP){

            @Override
            Map<String, Object> call(SolrQueryRequest req, SolrQueryResponse rsp, CollectionsHandler h) throws Exception {
                Map map = req.getParams().required().getAll(null, new String[]{"collection", "property", "shard", "replica"});
                return req.getParams().getAll(map, new String[]{"property"});
            }
        }
        ,
        BALANCESHARDUNIQUE_OP(CollectionParams.CollectionAction.BALANCESHARDUNIQUE){

            @Override
            Map<String, Object> call(SolrQueryRequest req, SolrQueryResponse rsp, CollectionsHandler h) throws Exception {
                Map map = req.getParams().required().getAll(null, new String[]{"collection", "property"});
                Boolean shardUnique = Boolean.parseBoolean(req.getParams().get("shardUnique"));
                String prop = req.getParams().get("property").toLowerCase(Locale.ROOT);
                if (!StringUtils.startsWith((String)prop, (String)"property.")) {
                    prop = "property." + prop;
                }
                if (!shardUnique.booleanValue() && !SliceMutator.SLICE_UNIQUE_BOOLEAN_PROPERTIES.contains(prop)) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Balancing properties amongst replicas in a slice requires that the property be pre-defined as a unique property (e.g. 'preferredLeader') or that 'shardUnique' be set to 'true'.  Property: " + prop + " shardUnique: " + Boolean.toString(shardUnique));
                }
                return req.getParams().getAll(map, new String[]{"onlyactivenodes", "shardUnique"});
            }
        }
        ,
        REBALANCELEADERS_OP(CollectionParams.CollectionAction.REBALANCELEADERS){

            @Override
            Map<String, Object> call(SolrQueryRequest req, SolrQueryResponse rsp, CollectionsHandler h) throws Exception {
                new RebalanceLeaders(req, rsp, h).execute();
                return null;
            }
        }
        ,
        MODIFYCOLLECTION_OP(CollectionParams.CollectionAction.MODIFYCOLLECTION, DEFAULT_ZK_TIMEOUT, false){

            @Override
            Map<String, Object> call(SolrQueryRequest req, SolrQueryResponse rsp, CollectionsHandler h) throws Exception {
                Map m = req.getParams().getAll(null, MODIFIABLE_COLL_PROPS.toArray(new String[0]));
                if (m.isEmpty()) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, StrUtils.formatString((String)"no supported values provided rule, snitch, masShardsPerNode, replicationFactor", (Object[])new Object[0]));
                }
                req.getParams().required().getAll(m, new String[]{"collection"});
                CollectionsHandler.addMapObject(m, "rule");
                CollectionsHandler.addMapObject(m, "snitch");
                for (String prop : MODIFIABLE_COLL_PROPS) {
                    DocCollection.verifyProp((Map)m, (String)prop);
                }
                CollectionsHandler.verifyRuleParams(h.coreContainer, m);
                return m;
            }
        };

        CollectionParams.CollectionAction action;
        long timeOut;
        boolean sendToOCPQueue;

        private CollectionOperation(CollectionParams.CollectionAction action) {
            this(action, DEFAULT_ZK_TIMEOUT, true);
        }

        private CollectionOperation(CollectionParams.CollectionAction action, long timeOut, boolean sendToOCPQueue) {
            this.action = action;
            this.timeOut = timeOut;
            this.sendToOCPQueue = sendToOCPQueue;
        }

        abstract Map<String, Object> call(SolrQueryRequest var1, SolrQueryResponse var2, CollectionsHandler var3) throws Exception;

        public static CollectionOperation get(CollectionParams.CollectionAction action) {
            for (CollectionOperation op : CollectionOperation.values()) {
                if (op.action != action) continue;
                return op;
            }
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "No such action" + action);
        }
    }
}

