/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.solr.cloud.ZkSolrResourceLoader;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.MapSolrParams;
import org.apache.solr.common.util.Utils;
import org.apache.solr.core.MapSerializable;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;
import org.noggit.JSONParser;
import org.noggit.ObjectBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestParams
implements MapSerializable {
    public static final Logger log = LoggerFactory.getLogger(RequestParams.class);
    private final Map data;
    private final Map<String, VersionedParams> paramsets = new LinkedHashMap<String, VersionedParams>();
    private final int znodeVersion;
    public static final String USEPARAM = "useParams";
    public static final String NAME = "params";
    public static final String RESOURCE = "params.json";

    public RequestParams(Map data, int znodeVersion) {
        if (data == null) {
            data = Collections.EMPTY_MAP;
        }
        this.data = data;
        Map paramsets = (Map)data.get(NAME);
        if (paramsets != null) {
            for (Map.Entry o : paramsets.entrySet()) {
                Map.Entry e = o;
                if (!(e.getValue() instanceof Map)) continue;
                Map value = (Map)e.getValue();
                Map copy = RequestParams.getMapCopy(value);
                Map meta = (Map)copy.remove("");
                this.paramsets.put((String)e.getKey(), new VersionedParams(Collections.unmodifiableMap(copy), meta));
            }
        }
        this.znodeVersion = znodeVersion;
    }

    private static Map getMapCopy(Map value) {
        LinkedHashMap copy = new LinkedHashMap();
        for (Map.Entry o1 : value.entrySet()) {
            Map.Entry entry = o1;
            if ("".equals(entry.getKey())) {
                copy.put(entry.getKey(), entry.getValue());
                continue;
            }
            if (entry.getValue() != null) {
                if (entry.getValue() instanceof List) {
                    List l = (List)entry.getValue();
                    String[] sarr = new String[l.size()];
                    for (int i = 0; i < l.size(); ++i) {
                        if (l.get(i) == null) continue;
                        sarr[i] = String.valueOf(l.get(i));
                    }
                    copy.put(entry.getKey(), sarr);
                    continue;
                }
                copy.put(entry.getKey(), String.valueOf(entry.getValue()));
                continue;
            }
            copy.put(entry.getKey(), entry.getValue());
        }
        return copy;
    }

    public VersionedParams getParams(String name) {
        return this.paramsets.get(name);
    }

    public int getZnodeVersion() {
        return this.znodeVersion;
    }

    @Override
    public Map<String, Object> toMap() {
        return RequestParams.getMapWithVersion(this.data, this.znodeVersion);
    }

    public static Map<String, Object> getMapWithVersion(Map<String, Object> data, int znodeVersion) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("znodeVersion", znodeVersion);
        result.putAll(data);
        return result;
    }

    public RequestParams setParams(String name, Map values) {
        Map deepCopy = Utils.getDeepCopy((Map)this.data, (int)3);
        LinkedHashMap p = (LinkedHashMap)deepCopy.get(NAME);
        if (p == null) {
            p = new LinkedHashMap();
            deepCopy.put(NAME, p);
        }
        if (values == null) {
            p.remove(name);
        } else {
            Map old = (Map)p.get(name);
            long version = 0L;
            Map<String, Long> meta = null;
            if (old != null) {
                Long oldVersion;
                meta = (Map)old.get("");
                if (meta != null && (oldVersion = (Long)old.get("v")) != null) {
                    version = oldVersion + 1L;
                }
                meta = new LinkedHashMap(meta);
            } else {
                meta = new LinkedHashMap();
            }
            meta.put("v", version);
            values = new LinkedHashMap<String, Map<String, Long>>(values);
            values.put("", meta);
            p.put(name, values);
        }
        return new RequestParams(deepCopy, this.znodeVersion);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RequestParams getFreshRequestParams(SolrResourceLoader loader, RequestParams requestParams) {
        if (loader instanceof ZkSolrResourceLoader) {
            ZkSolrResourceLoader resourceLoader = (ZkSolrResourceLoader)loader;
            try {
                Stat stat = resourceLoader.getZkController().getZkClient().exists(resourceLoader.getConfigSetZkPath() + "/" + RESOURCE, null, true);
                log.debug("latest version of {} in ZK  is : {}", (Object)(resourceLoader.getConfigSetZkPath() + "/" + RESOURCE), stat == null ? "" : Integer.valueOf(stat.getVersion()));
                if (stat == null) {
                    return new RequestParams(Collections.EMPTY_MAP, -1);
                }
                if (requestParams != null) {
                    if (stat.getVersion() <= requestParams.getZnodeVersion()) return requestParams;
                }
                Object[] o = RequestParams.getMapAndVersion(loader, RESOURCE);
                requestParams = new RequestParams((Map)o[0], (Integer)o[1]);
                log.info("request params refreshed to version {}", (Object)requestParams.getZnodeVersion());
                return requestParams;
            }
            catch (KeeperException e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
            }
        } else {
            Object[] o = RequestParams.getMapAndVersion(loader, RESOURCE);
            return new RequestParams((Map)o[0], (Integer)o[1]);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static Object[] getMapAndVersion(SolrResourceLoader loader, String name) {
        try {
            Throwable throwable = null;
            try (InputStream in = loader.openResource(name);){
                int version = 0;
                if (in instanceof ZkSolrResourceLoader.ZkByteArrayInputStream) {
                    version = ((ZkSolrResourceLoader.ZkByteArrayInputStream)in).getStat().getVersion();
                    log.info("conf resource {} loaded . version : {} ", (Object)name, (Object)version);
                }
                try {
                    Map m = (Map)ObjectBuilder.getVal((JSONParser)new JSONParser((Reader)new InputStreamReader(in, StandardCharsets.UTF_8)));
                    Object[] objectArray = new Object[]{m, version};
                    return objectArray;
                }
                catch (IOException e) {
                    try {
                        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error parsing conf resource " + name, (Throwable)e);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
            }
        }
        catch (IOException e) {
            return new Object[]{Collections.EMPTY_MAP, -1};
        }
    }

    public byte[] toByteArray() {
        return Utils.toJSON((Object)this.data);
    }

    public static class VersionedParams
    extends MapSolrParams {
        Map meta;

        public VersionedParams(Map<String, String> map, Map meta) {
            super(map);
            this.meta = meta;
        }

        public Map getRawMap() {
            return this.meta;
        }

        public Long getVersion() {
            return this.meta == null ? 0L : (Long)this.meta.get("v");
        }
    }
}

