/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.NRTCachingDirectory;
import org.apache.lucene.store.NoLockFactory;
import org.apache.lucene.store.SingleInstanceLockFactory;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.IOUtils;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.CachingDirectoryFactory;
import org.apache.solr.core.CoreDescriptor;
import org.apache.solr.core.DirectoryFactory;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrInfoMBean;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.store.blockcache.BlockCache;
import org.apache.solr.store.blockcache.BlockDirectory;
import org.apache.solr.store.blockcache.BlockDirectoryCache;
import org.apache.solr.store.blockcache.BufferStore;
import org.apache.solr.store.blockcache.Metrics;
import org.apache.solr.store.hdfs.HdfsDirectory;
import org.apache.solr.store.hdfs.HdfsLocalityReporter;
import org.apache.solr.store.hdfs.HdfsLockFactory;
import org.apache.solr.util.HdfsUtil;
import org.apache.solr.util.plugin.SolrCoreAware;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HdfsDirectoryFactory
extends CachingDirectoryFactory
implements SolrCoreAware {
    public static Logger LOG = LoggerFactory.getLogger(HdfsDirectoryFactory.class);
    public static final String BLOCKCACHE_SLAB_COUNT = "solr.hdfs.blockcache.slab.count";
    public static final String BLOCKCACHE_DIRECT_MEMORY_ALLOCATION = "solr.hdfs.blockcache.direct.memory.allocation";
    public static final String BLOCKCACHE_ENABLED = "solr.hdfs.blockcache.enabled";
    public static final String BLOCKCACHE_GLOBAL = "solr.hdfs.blockcache.global";
    public static final String BLOCKCACHE_READ_ENABLED = "solr.hdfs.blockcache.read.enabled";
    public static final String BLOCKCACHE_WRITE_ENABLED = "solr.hdfs.blockcache.write.enabled";
    public static final String NRTCACHINGDIRECTORY_ENABLE = "solr.hdfs.nrtcachingdirectory.enable";
    public static final String NRTCACHINGDIRECTORY_MAXMERGESIZEMB = "solr.hdfs.nrtcachingdirectory.maxmergesizemb";
    public static final String NRTCACHINGDIRECTORY_MAXCACHEMB = "solr.hdfs.nrtcachingdirectory.maxcachedmb";
    public static final String NUMBEROFBLOCKSPERBANK = "solr.hdfs.blockcache.blocksperbank";
    public static final String KERBEROS_ENABLED = "solr.hdfs.security.kerberos.enabled";
    public static final String KERBEROS_KEYTAB = "solr.hdfs.security.kerberos.keytabfile";
    public static final String KERBEROS_PRINCIPAL = "solr.hdfs.security.kerberos.principal";
    public static final String HDFS_HOME = "solr.hdfs.home";
    public static final String CONFIG_DIRECTORY = "solr.hdfs.confdir";
    private SolrParams params;
    private String hdfsDataDir;
    private String confDir;
    private static BlockCache globalBlockCache;
    public static Metrics metrics;
    private static Boolean kerberosInit;
    private Cache<String, FileSystem> tmpFsCache = CacheBuilder.newBuilder().concurrencyLevel(10).maximumSize(1000L).expireAfterAccess(5L, TimeUnit.MINUTES).removalListener((RemovalListener)new RemovalListener<String, FileSystem>(){

        public void onRemoval(RemovalNotification<String, FileSystem> rn) {
            IOUtils.closeQuietly((Closeable)((Closeable)rn.getValue()));
        }
    }).build();

    @Override
    public void close() throws IOException {
        super.close();
        Collection values = this.tmpFsCache.asMap().values();
        for (FileSystem fs : values) {
            IOUtils.closeQuietly((Closeable)fs);
        }
        this.tmpFsCache.invalidateAll();
        this.tmpFsCache.cleanUp();
    }

    @Override
    public void init(NamedList args) {
        this.params = SolrParams.toSolrParams((NamedList)args);
        this.hdfsDataDir = this.getConfig(HDFS_HOME, null);
        if (this.hdfsDataDir != null && this.hdfsDataDir.length() == 0) {
            this.hdfsDataDir = null;
        } else {
            LOG.info("solr.hdfs.home=" + this.hdfsDataDir);
        }
        boolean kerberosEnabled = this.getConfig(KERBEROS_ENABLED, false);
        LOG.info("Solr Kerberos Authentication " + (kerberosEnabled ? "enabled" : "disabled"));
        if (kerberosEnabled) {
            this.initKerberos();
        }
    }

    @Override
    protected LockFactory createLockFactory(String rawLockType) throws IOException {
        String lockType;
        if (null == rawLockType) {
            LOG.warn("No lockType configured, assuming 'hdfs'.");
            rawLockType = "hdfs";
        }
        switch (lockType = rawLockType.toLowerCase(Locale.ROOT).trim()) {
            case "hdfs": {
                return HdfsLockFactory.INSTANCE;
            }
            case "single": {
                return new SingleInstanceLockFactory();
            }
            case "none": {
                return NoLockFactory.INSTANCE;
            }
        }
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unrecognized lockType: " + rawLockType);
    }

    @Override
    protected Directory create(String path, LockFactory lockFactory, DirectoryFactory.DirContext dirContext) throws IOException {
        Object dir;
        HdfsDirectory hdfsDir;
        assert (this.params != null) : "init must be called before create";
        LOG.info("creating directory factory for path {}", (Object)path);
        Configuration conf = this.getConf();
        if (metrics == null) {
            metrics = MetricsHolder.metrics;
        }
        boolean blockCacheEnabled = this.getConfig(BLOCKCACHE_ENABLED, true);
        boolean blockCacheGlobal = this.getConfig(BLOCKCACHE_GLOBAL, false);
        boolean blockCacheReadEnabled = this.getConfig(BLOCKCACHE_READ_ENABLED, true);
        if (blockCacheEnabled && dirContext != DirectoryFactory.DirContext.META_DATA) {
            int numberOfBlocksPerBank = this.getConfig(NUMBEROFBLOCKSPERBANK, 16384);
            int blockSize = 8192;
            int bankCount = this.getConfig(BLOCKCACHE_SLAB_COUNT, 1);
            boolean directAllocation = this.getConfig(BLOCKCACHE_DIRECT_MEMORY_ALLOCATION, true);
            int slabSize = numberOfBlocksPerBank * blockSize;
            LOG.info("Number of slabs of block cache [{}] with direct memory allocation set to [{}]", (Object)bankCount, (Object)directAllocation);
            LOG.info("Block cache target memory usage, slab size of [{}] will allocate [{}] slabs and use ~[{}] bytes", new Object[]{slabSize, bankCount, (long)bankCount * (long)slabSize});
            int bufferSize = this.getConfig("solr.hdfs.blockcache.bufferstore.buffersize", 128);
            int bufferCount = this.getConfig("solr.hdfs.blockcache.bufferstore.buffercount", 16384);
            BlockCache blockCache = this.getBlockDirectoryCache(numberOfBlocksPerBank, blockSize, bankCount, directAllocation, slabSize, bufferSize, bufferCount, blockCacheGlobal);
            BlockDirectoryCache cache = new BlockDirectoryCache(blockCache, path, metrics, blockCacheGlobal);
            hdfsDir = new HdfsDirectory(new Path(path), lockFactory, conf);
            dir = new BlockDirectory(path, (Directory)hdfsDir, cache, null, blockCacheReadEnabled, false);
        } else {
            dir = hdfsDir = new HdfsDirectory(new Path(path), lockFactory, conf);
        }
        LocalityHolder.reporter.registerDirectory(hdfsDir);
        boolean nrtCachingDirectory = this.getConfig(NRTCACHINGDIRECTORY_ENABLE, true);
        if (nrtCachingDirectory) {
            double nrtCacheMaxMergeSizeMB = this.getConfig(NRTCACHINGDIRECTORY_MAXMERGESIZEMB, 16);
            double nrtCacheMaxCacheMB = this.getConfig(NRTCACHINGDIRECTORY_MAXCACHEMB, 192);
            return new NRTCachingDirectory((Directory)dir, nrtCacheMaxMergeSizeMB, nrtCacheMaxCacheMB);
        }
        return dir;
    }

    boolean getConfig(String name, boolean defaultValue) {
        String sysValue;
        Boolean value = this.params.getBool(name);
        if (value == null && (sysValue = System.getProperty(name)) != null) {
            value = Boolean.valueOf(sysValue);
        }
        return value == null ? defaultValue : value;
    }

    int getConfig(String name, int defaultValue) {
        String sysValue;
        Integer value = this.params.getInt(name);
        if (value == null && (sysValue = System.getProperty(name)) != null) {
            value = Integer.parseInt(sysValue);
        }
        return value == null ? defaultValue : value;
    }

    String getConfig(String name, String defaultValue) {
        String value = this.params.get(name);
        if (value == null) {
            value = System.getProperty(name);
        }
        return value == null ? defaultValue : value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BlockCache getBlockDirectoryCache(int numberOfBlocksPerBank, int blockSize, int bankCount, boolean directAllocation, int slabSize, int bufferSize, int bufferCount, boolean staticBlockCache) {
        if (!staticBlockCache) {
            LOG.info("Creating new single instance HDFS BlockCache");
            return this.createBlockCache(numberOfBlocksPerBank, blockSize, bankCount, directAllocation, slabSize, bufferSize, bufferCount);
        }
        Class<HdfsDirectoryFactory> clazz = HdfsDirectoryFactory.class;
        synchronized (HdfsDirectoryFactory.class) {
            if (globalBlockCache == null) {
                LOG.info("Creating new global HDFS BlockCache");
                globalBlockCache = this.createBlockCache(numberOfBlocksPerBank, blockSize, bankCount, directAllocation, slabSize, bufferSize, bufferCount);
            }
            // ** MonitorExit[var9_9] (shouldn't be in output)
            return globalBlockCache;
        }
    }

    private BlockCache createBlockCache(int numberOfBlocksPerBank, int blockSize, int bankCount, boolean directAllocation, int slabSize, int bufferSize, int bufferCount) {
        BlockCache blockCache;
        BufferStore.initNewBuffer(bufferSize, bufferCount, metrics);
        long totalMemory = (long)bankCount * (long)numberOfBlocksPerBank * (long)blockSize;
        try {
            blockCache = new BlockCache(metrics, directAllocation, totalMemory, slabSize, blockSize);
        }
        catch (OutOfMemoryError e) {
            throw new RuntimeException("The max direct memory is likely too low.  Either increase it (by adding -XX:MaxDirectMemorySize=<size>g -XX:+UseLargePages to your containers startup args) or disable direct allocation using solr.hdfs.blockcache.direct.memory.allocation=false in solrconfig.xml. If you are putting the block cache on the heap, your java heap size might not be large enough. Failed allocating ~" + (double)totalMemory / 1000000.0 + " MB.", e);
        }
        return blockCache;
    }

    @Override
    public boolean exists(String path) {
        final Path hdfsDirPath = new Path(path);
        final Configuration conf = this.getConf();
        FileSystem fileSystem = null;
        try {
            fileSystem = (FileSystem)this.tmpFsCache.get((Object)path, (Callable)new Callable<FileSystem>(){

                @Override
                public FileSystem call() throws IOException {
                    return FileSystem.get((URI)hdfsDirPath.toUri(), (Configuration)conf);
                }
            });
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        try {
            return fileSystem.exists(hdfsDirPath);
        }
        catch (IOException e) {
            LOG.error("Error checking if hdfs path exists", (Throwable)e);
            throw new RuntimeException("Error checking if hdfs path exists", e);
        }
    }

    private Configuration getConf() {
        Configuration conf = new Configuration();
        this.confDir = this.getConfig(CONFIG_DIRECTORY, null);
        HdfsUtil.addHdfsResources(conf, this.confDir);
        conf.setBoolean("fs.hdfs.impl.disable.cache", true);
        return conf;
    }

    @Override
    protected synchronized void removeDirectory(final CachingDirectoryFactory.CacheValue cacheValue) throws IOException {
        final Configuration conf = this.getConf();
        FileSystem fileSystem = null;
        try {
            fileSystem = (FileSystem)this.tmpFsCache.get((Object)cacheValue.path, (Callable)new Callable<FileSystem>(){

                @Override
                public FileSystem call() throws IOException {
                    return FileSystem.get((URI)new Path(cacheValue.path).toUri(), (Configuration)conf);
                }
            });
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        try {
            boolean success = fileSystem.delete(new Path(cacheValue.path), true);
            if (!success) {
                throw new RuntimeException("Could not remove directory");
            }
        }
        catch (Exception e) {
            LOG.error("Could not remove directory", (Throwable)e);
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Could not remove directory", (Throwable)e);
        }
    }

    @Override
    public boolean isAbsolute(String path) {
        return path.startsWith("hdfs:/");
    }

    @Override
    public boolean isPersistent() {
        return true;
    }

    @Override
    public boolean isSharedStorage() {
        return true;
    }

    @Override
    public boolean searchersReserveCommitPoints() {
        return true;
    }

    @Override
    public String getDataHome(CoreDescriptor cd) throws IOException {
        if (this.hdfsDataDir == null) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "You must set the " + this.getClass().getSimpleName() + " param " + HDFS_HOME + " for relative dataDir paths to work");
        }
        String path = cd.getCloudDescriptor() != null ? URLEncoder.encode(cd.getCloudDescriptor().getCollectionName(), "UTF-8") + "/" + URLEncoder.encode(cd.getCloudDescriptor().getCoreNodeName(), "UTF-8") : cd.getName();
        return this.normalize(SolrResourceLoader.normalizeDir(ZkController.trimLeadingAndTrailingSlashes(this.hdfsDataDir) + "/" + path + "/" + cd.getDataDir()));
    }

    public String getConfDir() {
        return this.confDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initKerberos() {
        String keytabFile = this.getConfig(KERBEROS_KEYTAB, "").trim();
        if (keytabFile.length() == 0) {
            throw new IllegalArgumentException("solr.hdfs.security.kerberos.keytabfile required because solr.hdfs.security.kerberos.enabled set to true");
        }
        String principal = this.getConfig(KERBEROS_PRINCIPAL, "");
        if (principal.length() == 0) {
            throw new IllegalArgumentException("solr.hdfs.security.kerberos.principal required because solr.hdfs.security.kerberos.enabled set to true");
        }
        Class<HdfsDirectoryFactory> clazz = HdfsDirectoryFactory.class;
        synchronized (HdfsDirectoryFactory.class) {
            if (kerberosInit == null) {
                kerberosInit = new Boolean(true);
                Configuration conf = this.getConf();
                String authVal = conf.get("hadoop.security.authentication");
                String kerberos = "kerberos";
                if (authVal != null && !authVal.equals("kerberos")) {
                    throw new IllegalArgumentException("hadoop.security.authentication set to: " + authVal + ", not kerberos, but attempting to " + " connect to HDFS via kerberos");
                }
                Configuration ugiConf = new Configuration(this.getConf());
                ugiConf.set("hadoop.security.authentication", "kerberos");
                UserGroupInformation.setConfiguration((Configuration)ugiConf);
                LOG.info("Attempting to acquire kerberos ticket with keytab: {}, principal: {} ", (Object)keytabFile, (Object)principal);
                try {
                    UserGroupInformation.loginUserFromKeytab((String)principal, (String)keytabFile);
                }
                catch (IOException ioe) {
                    throw new RuntimeException(ioe);
                }
                LOG.info("Got Kerberos ticket");
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    @Override
    public Collection<SolrInfoMBean> offerMBeans() {
        return Arrays.asList(MetricsHolder.metrics, LocalityHolder.reporter);
    }

    @Override
    public void inform(SolrCore core) {
        this.setHost(core.getCoreDescriptor().getCoreContainer().getHostName());
    }

    @VisibleForTesting
    void setHost(String hostname) {
        LocalityHolder.reporter.setHost(hostname);
    }

    @Override
    public void cleanupOldIndexDirectories(String dataDir, String currentIndexDir) {
        final Path dataDirPath = new Path(dataDir);
        final Configuration conf = this.getConf();
        FileSystem fileSystem = null;
        try {
            fileSystem = (FileSystem)this.tmpFsCache.get((Object)dataDir, (Callable)new Callable<FileSystem>(){

                @Override
                public FileSystem call() throws IOException {
                    return FileSystem.get((URI)dataDirPath.toUri(), (Configuration)conf);
                }
            });
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        boolean pathExists = false;
        try {
            pathExists = fileSystem.exists(dataDirPath);
        }
        catch (IOException e) {
            LOG.error("Error checking if hdfs path " + dataDir + " exists", (Throwable)e);
        }
        if (!pathExists) {
            LOG.warn("{} does not point to a valid data directory; skipping clean-up of old index directories.", (Object)dataDir);
            return;
        }
        final Path currentIndexDirPath = new Path(currentIndexDir);
        final FileSystem fs = fileSystem;
        FileStatus[] oldIndexDirs = null;
        try {
            oldIndexDirs = fileSystem.listStatus(dataDirPath, new PathFilter(){

                public boolean accept(Path path) {
                    boolean accept = false;
                    String pathName = path.getName();
                    try {
                        accept = fs.isDirectory(path) && !path.equals((Object)currentIndexDirPath) && (pathName.equals("index") || pathName.matches("index\\.[0-9]{17}"));
                    }
                    catch (IOException e) {
                        LOG.error("Error checking if path {} is an old index directory, caused by: {}", (Object)path, (Object)e);
                    }
                    return accept;
                }
            });
        }
        catch (IOException ioExc) {
            LOG.error("Error checking for old index directories to clean-up.", (Throwable)ioExc);
        }
        if (oldIndexDirs == null || oldIndexDirs.length == 0) {
            return;
        }
        Set<String> livePaths = this.getLivePaths();
        for (FileStatus oldDir : oldIndexDirs) {
            Path oldDirPath = oldDir.getPath();
            if (livePaths.contains(oldDirPath.toString())) {
                LOG.warn("Cannot delete directory {} because it is still being referenced in the cache.", (Object)oldDirPath);
                continue;
            }
            try {
                if (fileSystem.delete(oldDirPath, true)) {
                    LOG.info("Deleted old index directory {}", (Object)oldDirPath);
                    continue;
                }
                LOG.warn("Failed to delete old index directory {}", (Object)oldDirPath);
            }
            catch (IOException e) {
                LOG.error("Failed to delete old index directory {} due to: {}", (Object)oldDirPath, (Object)e);
            }
        }
    }

    private static final class LocalityHolder {
        public static final HdfsLocalityReporter reporter = new HdfsLocalityReporter();

        private LocalityHolder() {
        }
    }

    private static final class MetricsHolder {
        public static final Metrics metrics = new Metrics();

        private MetricsHolder() {
        }
    }
}

