/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import org.apache.lucene.util.IOUtils;
import org.apache.solr.client.solrj.impl.HttpClientConfigurer;
import org.apache.solr.client.solrj.impl.HttpClientUtil;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.util.ExecutorUtil;
import org.apache.solr.common.util.Utils;
import org.apache.solr.core.CloserThread;
import org.apache.solr.core.ConfigSet;
import org.apache.solr.core.ConfigSetService;
import org.apache.solr.core.CoreDescriptor;
import org.apache.solr.core.CorePropertiesLocator;
import org.apache.solr.core.CoresLocator;
import org.apache.solr.core.JarRepository;
import org.apache.solr.core.NodeConfig;
import org.apache.solr.core.PluginBag;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrCores;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.core.SolrXmlConfig;
import org.apache.solr.core.ZkContainer;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.handler.admin.CollectionsHandler;
import org.apache.solr.handler.admin.CoreAdminHandler;
import org.apache.solr.handler.admin.InfoHandler;
import org.apache.solr.handler.admin.SecurityConfHandler;
import org.apache.solr.handler.component.HttpShardHandlerFactory;
import org.apache.solr.handler.component.ShardHandlerFactory;
import org.apache.solr.logging.LogWatcher;
import org.apache.solr.logging.MDCLoggingContext;
import org.apache.solr.request.SolrRequestHandler;
import org.apache.solr.security.AuthenticationPlugin;
import org.apache.solr.security.AuthorizationPlugin;
import org.apache.solr.security.HttpClientInterceptorPlugin;
import org.apache.solr.security.PKIAuthenticationPlugin;
import org.apache.solr.security.SecurityPluginHolder;
import org.apache.solr.update.UpdateShardHandler;
import org.apache.solr.util.DefaultSolrThreadFactory;
import org.apache.solr.util.FileUtils;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoreContainer {
    protected static final Logger log = LoggerFactory.getLogger(CoreContainer.class);
    final SolrCores solrCores = new SolrCores(this);
    protected final Map<String, CoreLoadFailure> coreInitFailures = new ConcurrentHashMap<String, CoreLoadFailure>();
    protected CoreAdminHandler coreAdminHandler = null;
    protected CollectionsHandler collectionsHandler = null;
    private InfoHandler infoHandler;
    private PKIAuthenticationPlugin pkiAuthenticationPlugin;
    protected Properties containerProperties;
    private ConfigSetService coreConfigService;
    protected ZkContainer zkSys = new ZkContainer();
    protected ShardHandlerFactory shardHandlerFactory;
    private UpdateShardHandler updateShardHandler;
    private ExecutorService coreContainerWorkExecutor = ExecutorUtil.newMDCAwareCachedThreadPool((ThreadFactory)new DefaultSolrThreadFactory("coreContainerWorkExecutor"));
    protected LogWatcher logging = null;
    private CloserThread backgroundCloser = null;
    protected final NodeConfig cfg;
    protected final SolrResourceLoader loader;
    protected final String solrHome;
    protected final CoresLocator coresLocator;
    private String hostName;
    private final JarRepository jarRepository = new JarRepository(this);
    private PluginBag<SolrRequestHandler> containerHandlers = new PluginBag<SolrRequestHandler>(SolrRequestHandler.class, null);
    private boolean asyncSolrCoreLoad;
    protected SecurityConfHandler securityConfHandler;
    private SecurityPluginHolder<AuthorizationPlugin> authorizationPlugin;
    private SecurityPluginHolder<AuthenticationPlugin> authenticationPlugin;
    private volatile boolean isShutDown;

    public ExecutorService getCoreZkRegisterExecutorService() {
        return this.zkSys.getCoreZkRegisterExecutorService();
    }

    public SolrRequestHandler getRequestHandler(String path) {
        return RequestHandlerBase.getRequestHandler(path, this.containerHandlers);
    }

    public PluginBag<SolrRequestHandler> getRequestHandlers() {
        return this.containerHandlers;
    }

    public CoreContainer() {
        this(new SolrResourceLoader(SolrResourceLoader.locateSolrHome()));
    }

    public CoreContainer(SolrResourceLoader loader) {
        this(SolrXmlConfig.fromSolrHome(loader, loader.getInstanceDir()));
    }

    public CoreContainer(String solrHome) {
        this(new SolrResourceLoader(solrHome));
    }

    public CoreContainer(NodeConfig config) {
        this(config, new Properties());
    }

    public CoreContainer(NodeConfig config, Properties properties) {
        this(config, properties, new CorePropertiesLocator(config.getCoreRootDirectory()));
    }

    public CoreContainer(NodeConfig config, Properties properties, boolean asyncSolrCoreLoad) {
        this(config, properties, new CorePropertiesLocator(config.getCoreRootDirectory()), asyncSolrCoreLoad);
    }

    public CoreContainer(NodeConfig config, Properties properties, CoresLocator locator) {
        this(config, properties, locator, false);
    }

    public CoreContainer(NodeConfig config, Properties properties, CoresLocator locator, boolean asyncSolrCoreLoad) {
        log.info("New CoreContainer " + System.identityHashCode(this));
        this.isShutDown = false;
        this.loader = config.getSolrResourceLoader();
        this.solrHome = this.loader.getInstanceDir();
        this.cfg = (NodeConfig)Preconditions.checkNotNull((Object)config);
        this.coresLocator = locator;
        this.containerProperties = new Properties(properties);
        this.asyncSolrCoreLoad = asyncSolrCoreLoad;
    }

    private synchronized void initializeAuthorizationPlugin(Map<String, Object> authorizationConf) {
        authorizationConf = Utils.getDeepCopy(authorizationConf, (int)4);
        SecurityPluginHolder<AuthorizationPlugin> old = this.authorizationPlugin;
        SecurityPluginHolder<AuthorizationPlugin> authorizationPlugin = null;
        if (authorizationConf != null) {
            String klas = (String)authorizationConf.get("class");
            if (klas == null) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "class is required for authorization plugin");
            }
            if (old != null && old.getZnodeVersion() == CoreContainer.readVersion(authorizationConf)) {
                return;
            }
            log.info("Initializing authorization plugin: " + klas);
            authorizationPlugin = new SecurityPluginHolder<AuthorizationPlugin>(CoreContainer.readVersion(authorizationConf), this.getResourceLoader().newInstance(klas, AuthorizationPlugin.class));
            ((AuthorizationPlugin)authorizationPlugin.plugin).init(authorizationConf);
        } else {
            log.info("Security conf doesn't exist. Skipping setup for authorization module.");
        }
        this.authorizationPlugin = authorizationPlugin;
        if (old != null) {
            try {
                ((AuthorizationPlugin)old.plugin).close();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    private synchronized void initializeAuthenticationPlugin(Map<String, Object> authenticationConfig) {
        authenticationConfig = Utils.getDeepCopy(authenticationConfig, (int)4);
        String pluginClassName = null;
        if (authenticationConfig != null) {
            if (authenticationConfig.containsKey("class")) {
                pluginClassName = String.valueOf(authenticationConfig.get("class"));
            } else {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "No 'class' specified for authentication in ZK.");
            }
        }
        if (pluginClassName != null) {
            log.info("Authentication plugin class obtained from ZK: " + pluginClassName);
        } else if (System.getProperty("authenticationPlugin") != null) {
            pluginClassName = System.getProperty("authenticationPlugin");
            log.info("Authentication plugin class obtained from system property 'authenticationPlugin': " + pluginClassName);
        } else {
            log.info("No authentication plugin used.");
        }
        SecurityPluginHolder<AuthenticationPlugin> old = this.authenticationPlugin;
        SecurityPluginHolder<AuthenticationPlugin> authenticationPlugin = null;
        if (pluginClassName != null) {
            authenticationPlugin = new SecurityPluginHolder<AuthenticationPlugin>(CoreContainer.readVersion(authenticationConfig), this.getResourceLoader().newInstance(pluginClassName, AuthenticationPlugin.class));
        }
        if (authenticationPlugin != null) {
            ((AuthenticationPlugin)authenticationPlugin.plugin).init(authenticationConfig);
            this.addHttpConfigurer(authenticationPlugin.plugin);
        }
        this.authenticationPlugin = authenticationPlugin;
        try {
            if (old != null) {
                ((AuthenticationPlugin)old.plugin).close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private void addHttpConfigurer(Object authcPlugin) {
        if (authcPlugin instanceof HttpClientInterceptorPlugin) {
            HttpClientConfigurer configurer = ((HttpClientInterceptorPlugin)authcPlugin).getClientConfigurer();
            HttpClientUtil.setConfigurer((HttpClientConfigurer)configurer);
            log.info("Reconfiguring the shard handler factory and update shard handler.");
            if (this.getShardHandlerFactory() instanceof HttpShardHandlerFactory) {
                ((HttpShardHandlerFactory)this.getShardHandlerFactory()).reconfigureHttpClient(configurer);
            }
            this.getUpdateShardHandler().reconfigureHttpClient(configurer);
        } else if (this.pkiAuthenticationPlugin != null) {
            if (this.pkiAuthenticationPlugin.isInterceptorRegistered()) {
                return;
            }
            log.info("PKIAuthenticationPlugin is managing internode requests");
            this.addHttpConfigurer(this.pkiAuthenticationPlugin);
            this.pkiAuthenticationPlugin.setInterceptorRegistered();
        }
    }

    private static int readVersion(Map<String, Object> conf) {
        if (conf == null) {
            return -1;
        }
        Map meta = (Map)conf.get("");
        if (meta == null) {
            return -1;
        }
        Number v = (Number)meta.get("v");
        return v == null ? -1 : v.intValue();
    }

    protected CoreContainer(Object testConstructor) {
        log.info("New CoreContainer " + System.identityHashCode(this));
        this.isShutDown = false;
        this.solrHome = null;
        this.loader = null;
        this.coresLocator = null;
        this.cfg = null;
        this.containerProperties = null;
    }

    public static CoreContainer createAndLoad(String solrHome, File configFile) {
        SolrResourceLoader loader = new SolrResourceLoader(solrHome);
        CoreContainer cc = new CoreContainer(SolrXmlConfig.fromFile(loader, configFile));
        try {
            cc.load();
        }
        catch (Exception e) {
            cc.shutdown();
            throw e;
        }
        return cc;
    }

    public Properties getContainerProperties() {
        return this.containerProperties;
    }

    public PKIAuthenticationPlugin getPkiAuthenticationPlugin() {
        return this.pkiAuthenticationPlugin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() {
        block13: {
            ExecutorService coreLoadExecutor;
            block12: {
                log.info("Loading cores into CoreContainer [instanceDir={}]", (Object)this.loader.getInstanceDir());
                String libDir = this.cfg.getSharedLibDirectory();
                if (libDir != null) {
                    File f = FileUtils.resolvePath(new File(this.solrHome), libDir);
                    log.info("loading shared library: " + f.getAbsolutePath());
                    this.loader.addToClassLoader(libDir, null, false);
                    this.loader.reloadLuceneSPI();
                }
                this.shardHandlerFactory = ShardHandlerFactory.newInstance(this.cfg.getShardHandlerFactoryPluginInfo(), this.loader);
                this.updateShardHandler = new UpdateShardHandler(this.cfg.getUpdateShardHandlerConfig());
                this.solrCores.allocateLazyCores(this.cfg.getTransientCacheSize(), this.loader);
                this.logging = LogWatcher.newRegisteredLogWatcher(this.cfg.getLogWatcherConfig(), this.loader);
                this.hostName = this.cfg.getNodeName();
                this.zkSys.initZooKeeper(this, this.solrHome, this.cfg.getCloudConfig());
                if (this.isZooKeeperAware()) {
                    this.pkiAuthenticationPlugin = new PKIAuthenticationPlugin(this, this.zkSys.getZkController().getNodeName());
                }
                ZkStateReader.ConfigData securityConfig = this.isZooKeeperAware() ? this.getZkController().getZkStateReader().getSecurityProps(false) : new ZkStateReader.ConfigData(Collections.EMPTY_MAP, -1);
                this.initializeAuthorizationPlugin((Map)securityConfig.data.get("authorization"));
                this.initializeAuthenticationPlugin((Map)securityConfig.data.get("authentication"));
                this.securityConfHandler = new SecurityConfHandler(this);
                this.collectionsHandler = this.createHandler(this.cfg.getCollectionsHandlerClass(), CollectionsHandler.class);
                this.containerHandlers.put("/admin/collections", this.collectionsHandler);
                this.infoHandler = this.createHandler(this.cfg.getInfoHandlerClass(), InfoHandler.class);
                this.containerHandlers.put("/admin/info", this.infoHandler);
                this.coreAdminHandler = this.createHandler(this.cfg.getCoreAdminHandlerClass(), CoreAdminHandler.class);
                this.containerHandlers.put("/admin/cores", this.coreAdminHandler);
                this.containerHandlers.put("/admin/authorization", this.securityConfHandler);
                this.containerHandlers.put("/admin/authentication", this.securityConfHandler);
                if (this.pkiAuthenticationPlugin != null) {
                    this.containerHandlers.put("/admin/info/key", this.pkiAuthenticationPlugin.getRequestHandler());
                }
                this.coreConfigService = ConfigSetService.createConfigSetService(this.cfg, this.loader, this.zkSys.zkController);
                this.containerProperties.putAll((Map<?, ?>)this.cfg.getSolrProperties());
                coreLoadExecutor = ExecutorUtil.newMDCAwareFixedThreadPool((int)(this.zkSys.getZkController() == null ? this.cfg.getCoreLoadThreadCount() : Integer.MAX_VALUE), (ThreadFactory)new DefaultSolrThreadFactory("coreLoadExecutor"));
                ArrayList<Future<SolrCore>> futures = new ArrayList<Future<SolrCore>>();
                try {
                    List<CoreDescriptor> cds = this.coresLocator.discover(this);
                    CoreContainer.checkForDuplicateCoreNames(cds);
                    for (final CoreDescriptor cd : cds) {
                        if (cd.isTransient() || !cd.isLoadOnStartup()) {
                            this.solrCores.putDynamicDescriptor(cd.getName(), cd);
                        } else if (this.asyncSolrCoreLoad) {
                            this.solrCores.markCoreAsLoading(cd);
                        }
                        if (!cd.isLoadOnStartup()) continue;
                        futures.add(coreLoadExecutor.submit(new Callable<SolrCore>(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public SolrCore call() throws Exception {
                                SolrCore core;
                                try {
                                    if (CoreContainer.this.zkSys.getZkController() != null) {
                                        CoreContainer.this.zkSys.getZkController().throwErrorIfReplicaReplaced(cd);
                                    }
                                    core = CoreContainer.this.create(cd, false);
                                }
                                finally {
                                    if (CoreContainer.this.asyncSolrCoreLoad) {
                                        CoreContainer.this.solrCores.markCoreAsNotLoading(cd);
                                    }
                                }
                                try {
                                    CoreContainer.this.zkSys.registerInZk(core, true);
                                }
                                catch (Throwable t) {
                                    SolrException.log((Logger)log, (String)"Error registering SolrCore", (Throwable)t);
                                }
                                return core;
                            }
                        }));
                    }
                    this.backgroundCloser = new CloserThread(this, this.solrCores, this.cfg);
                    this.backgroundCloser.start();
                    if (!this.asyncSolrCoreLoad || futures == null) break block12;
                }
                catch (Throwable throwable) {
                    if (this.asyncSolrCoreLoad && futures != null) {
                        Thread shutdownThread = new Thread(futures, coreLoadExecutor){
                            final /* synthetic */ List val$futures;
                            final /* synthetic */ ExecutorService val$coreLoadExecutor;
                            {
                                this.val$futures = list;
                                this.val$coreLoadExecutor = executorService;
                            }

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                try {
                                    for (Future future : this.val$futures) {
                                        try {
                                            future.get();
                                        }
                                        catch (InterruptedException e) {
                                            Thread.currentThread().interrupt();
                                        }
                                        catch (ExecutionException e) {
                                            log.error("Error waiting for SolrCore to be created", (Throwable)e);
                                        }
                                    }
                                }
                                finally {
                                    ExecutorUtil.shutdownNowAndAwaitTermination((ExecutorService)this.val$coreLoadExecutor);
                                }
                            }
                        };
                        this.coreContainerWorkExecutor.submit(shutdownThread);
                    } else {
                        ExecutorUtil.shutdownAndAwaitTermination((ExecutorService)coreLoadExecutor);
                    }
                    throw throwable;
                }
                Thread shutdownThread = new /* invalid duplicate definition of identical inner class */;
                this.coreContainerWorkExecutor.submit(shutdownThread);
                break block13;
            }
            ExecutorUtil.shutdownAndAwaitTermination((ExecutorService)coreLoadExecutor);
        }
        if (this.isZooKeeperAware()) {
            this.zkSys.getZkController().checkOverseerDesignate();
        }
    }

    public void securityNodeChanged() {
        log.info("Security node changed");
        ZkStateReader.ConfigData securityConfig = this.getZkController().getZkStateReader().getSecurityProps(false);
        this.initializeAuthorizationPlugin((Map)securityConfig.data.get("authorization"));
        this.initializeAuthenticationPlugin((Map)securityConfig.data.get("authentication"));
    }

    private static void checkForDuplicateCoreNames(List<CoreDescriptor> cds) {
        HashMap addedCores = Maps.newHashMap();
        for (CoreDescriptor cd : cds) {
            String name = cd.getName();
            if (addedCores.containsKey(name)) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, String.format(Locale.ROOT, "Found multiple cores with the name [%s], with instancedirs [%s] and [%s]", name, addedCores.get(name), cd.getInstanceDir()));
            }
            addedCores.put(name, cd.getInstanceDir());
        }
    }

    public boolean isShutDown() {
        return this.isShutDown;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        log.info("Shutting down CoreContainer instance=" + System.identityHashCode(this));
        this.isShutDown = true;
        ExecutorUtil.shutdownAndAwaitTermination((ExecutorService)this.coreContainerWorkExecutor);
        if (this.isZooKeeperAware()) {
            this.cancelCoreRecoveries();
            this.zkSys.publishCoresAsDown(this.solrCores.getCores());
        }
        try {
            if (this.coreAdminHandler != null) {
                this.coreAdminHandler.shutdown();
            }
        }
        catch (Exception e) {
            log.warn("Error shutting down CoreAdminHandler. Continuing to close CoreContainer.", (Throwable)e);
        }
        try {
            Object e;
            block38: {
                e = this.solrCores.getModifyLock();
                synchronized (e) {
                    this.solrCores.getModifyLock().notifyAll();
                }
                if (this.backgroundCloser != null) {
                    try {
                        this.backgroundCloser.join();
                    }
                    catch (InterruptedException e2) {
                        Thread.currentThread().interrupt();
                        if (!log.isDebugEnabled()) break block38;
                        log.debug("backgroundCloser thread was interrupted before finishing");
                    }
                }
            }
            this.solrCores.close();
            e = this.solrCores.getModifyLock();
            synchronized (e) {
                this.solrCores.getModifyLock().notifyAll();
            }
        }
        finally {
            try {
                if (this.shardHandlerFactory != null) {
                    this.shardHandlerFactory.close();
                }
            }
            finally {
                try {
                    if (this.updateShardHandler != null) {
                        this.updateShardHandler.close();
                    }
                }
                finally {
                    this.zkSys.close();
                }
            }
        }
        try {
            if (this.authorizationPlugin != null) {
                ((AuthorizationPlugin)this.authorizationPlugin.plugin).close();
            }
        }
        catch (IOException e) {
            log.warn("Exception while closing authorization plugin.", (Throwable)e);
        }
        try {
            if (this.authenticationPlugin != null) {
                ((AuthenticationPlugin)this.authenticationPlugin.plugin).close();
                this.authenticationPlugin = null;
            }
        }
        catch (Exception e) {
            log.warn("Exception while closing authentication plugin.", (Throwable)e);
        }
        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this.loader});
    }

    public void cancelCoreRecoveries() {
        List<SolrCore> cores = this.solrCores.getCores();
        for (SolrCore core : cores) {
            try {
                core.getSolrCoreState().cancelRecovery();
            }
            catch (Exception e) {
                SolrException.log((Logger)log, (String)"Error canceling recovery for core", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (!this.isShutDown) {
                log.error("CoreContainer was not close prior to finalize(), indicates a bug -- POSSIBLE RESOURCE LEAK!!!  instance=" + System.identityHashCode(this));
            }
        }
        finally {
            super.finalize();
        }
    }

    public CoresLocator getCoresLocator() {
        return this.coresLocator;
    }

    protected SolrCore registerCore(String name, SolrCore core, boolean registerInZk) {
        if (core == null) {
            throw new RuntimeException("Can not register a null core.");
        }
        if (name == null || name.indexOf(47) >= 0 || name.indexOf(92) >= 0) {
            throw new RuntimeException("Invalid core name: " + name);
        }
        CoreDescriptor cd = core.getCoreDescriptor();
        if ((cd.isTransient() || !cd.isLoadOnStartup()) && this.solrCores.getDynamicDescriptor(name) == null) {
            this.solrCores.putDynamicDescriptor(name, cd);
        }
        if (this.isShutDown) {
            core.close();
            throw new IllegalStateException("This CoreContainer has been close");
        }
        SolrCore old = cd.isTransient() ? this.solrCores.putTransientCore(this.cfg, name, core, this.loader) : this.solrCores.putCore(name, core);
        core.setName(name);
        this.coreInitFailures.remove(name);
        if (old == null || old == core) {
            log.info("registering core: " + name);
            if (registerInZk) {
                this.zkSys.registerInZk(core, false);
            }
            return null;
        }
        log.info("replacing core: " + name);
        old.close();
        if (registerInZk) {
            this.zkSys.registerInZk(core, false);
        }
        return old;
    }

    public SolrCore create(CoreDescriptor cd) {
        return this.create(cd, true);
    }

    public SolrCore create(CoreDescriptor dcore, boolean publishState) {
        if (this.isShutDown) {
            throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, "Solr has been shutdown.");
        }
        SolrCore core = null;
        try {
            MDCLoggingContext.setCore(core);
            if (this.zkSys.getZkController() != null) {
                this.zkSys.getZkController().preRegister(dcore);
            }
            ConfigSet coreConfig = this.coreConfigService.getConfig(dcore);
            log.info("Creating SolrCore '{}' using configuration from {}", (Object)dcore.getName(), (Object)coreConfig.getName());
            core = new SolrCore(dcore, coreConfig);
            this.solrCores.addCreated(core);
            if (!this.isZooKeeperAware() && core.getUpdateHandler().getUpdateLog() != null) {
                core.getUpdateHandler().getUpdateLog().recoverFromLog();
            }
            this.registerCore(dcore.getName(), core, publishState);
            SolrCore solrCore = core;
            return solrCore;
        }
        catch (Exception e) {
            this.coreInitFailures.put(dcore.getName(), new CoreLoadFailure(dcore, e));
            log.error("Error creating core [{}]: {}", new Object[]{dcore.getName(), e.getMessage(), e});
            SolrException solrException = new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unable to create core [" + dcore.getName() + "]", (Throwable)e);
            if (core != null && !core.isClosed()) {
                org.apache.solr.common.util.IOUtils.closeQuietly((Closeable)core);
            }
            throw solrException;
        }
        catch (Throwable t) {
            SolrException e = new SolrException(SolrException.ErrorCode.SERVER_ERROR, "JVM Error creating core [" + dcore.getName() + "]: " + t.getMessage(), t);
            log.error("Error creating core [{}]: {}", new Object[]{dcore.getName(), t.getMessage(), t});
            this.coreInitFailures.put(dcore.getName(), new CoreLoadFailure(dcore, (Exception)((Object)e)));
            if (core != null && !core.isClosed()) {
                org.apache.solr.common.util.IOUtils.closeQuietly((Closeable)core);
            }
            throw t;
        }
        finally {
            MDCLoggingContext.clear();
        }
    }

    public Collection<SolrCore> getCores() {
        return this.solrCores.getCores();
    }

    public Collection<String> getCoreNames() {
        return this.solrCores.getCoreNames();
    }

    public Collection<String> getCoreNames(SolrCore core) {
        return this.solrCores.getCoreNames(core);
    }

    public Collection<String> getAllCoreNames() {
        return this.solrCores.getAllCoreNames();
    }

    public Map<String, CoreLoadFailure> getCoreInitFailures() {
        return ImmutableMap.copyOf(this.coreInitFailures);
    }

    public void reload(String name) {
        SolrCore core = this.solrCores.getCoreFromAnyList(name, false);
        if (core == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No such core: " + name);
        }
        CoreDescriptor cd = core.getCoreDescriptor();
        try {
            this.solrCores.waitAddPendingCoreOps(name);
            ConfigSet coreConfig = this.coreConfigService.getConfig(cd);
            log.info("Reloading SolrCore '{}' using configuration from {}", (Object)cd.getName(), (Object)coreConfig.getName());
            SolrCore newCore = core.reload(coreConfig);
            this.registerCore(name, newCore, false);
        }
        catch (Exception e) {
            this.coreInitFailures.put(cd.getName(), new CoreLoadFailure(cd, e));
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unable to reload core [" + cd.getName() + "]", (Throwable)e);
        }
        finally {
            this.solrCores.removeFromPendingOps(name);
        }
    }

    public void swap(String n0, String n1) {
        if (n0 == null || n1 == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Can not swap unnamed cores.");
        }
        this.solrCores.swap(n0, n1);
        this.coresLocator.swap(this, this.solrCores.getCoreDescriptor(n0), this.solrCores.getCoreDescriptor(n1));
        log.info("swapped: " + n0 + " with " + n1);
    }

    public void unload(String name) {
        this.unload(name, false, false, false);
    }

    public void unload(String name, boolean deleteIndexDir, boolean deleteDataDir, boolean deleteInstanceDir) {
        CoreLoadFailure loadFailure;
        if (name != null && (loadFailure = this.coreInitFailures.remove(name)) != null) {
            SolrCore.deleteUnloadedCore(loadFailure.cd, deleteDataDir, deleteInstanceDir);
            return;
        }
        CoreDescriptor cd = this.solrCores.getCoreDescriptor(name);
        if (cd == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Cannot unload non-existent core [" + name + "]");
        }
        boolean close = this.solrCores.isLoadedNotPendingClose(name);
        SolrCore core = this.solrCores.remove(name);
        this.coresLocator.delete(this, cd);
        if (core == null) {
            SolrCore.deleteUnloadedCore(cd, deleteDataDir, deleteInstanceDir);
            return;
        }
        if (this.zkSys.getZkController() != null) {
            core.getSolrCoreState().cancelRecovery();
        }
        core.unloadOnClose(deleteIndexDir, deleteDataDir, deleteInstanceDir);
        if (close) {
            core.close();
        }
        if (this.zkSys.getZkController() != null) {
            try {
                this.zkSys.getZkController().unregister(name, cd);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Interrupted while unregistering core [" + name + "] from cloud state");
            }
            catch (KeeperException e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error unregistering core [" + name + "] from cloud state", (Throwable)e);
            }
        }
    }

    public void rename(String name, String toName) {
        try (SolrCore core = this.getCore(name);){
            if (core != null) {
                this.registerCore(toName, core, true);
                SolrCore old = this.solrCores.remove(name);
                this.coresLocator.rename(this, old.getCoreDescriptor(), core.getCoreDescriptor());
            }
        }
    }

    public List<CoreDescriptor> getCoreDescriptors() {
        return this.solrCores.getCoreDescriptors();
    }

    public CoreDescriptor getCoreDescriptor(String coreName) {
        for (CoreDescriptor cd : this.getCoreDescriptors()) {
            if (!cd.getName().equals(coreName)) continue;
            return cd;
        }
        return null;
    }

    public String getCoreRootDirectory() {
        return this.cfg.getCoreRootDirectory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SolrCore getCore(String name) {
        SolrCore core = this.solrCores.getCoreFromAnyList(name, true);
        if (core != null) {
            return core;
        }
        CoreDescriptor desc = this.solrCores.getDynamicDescriptor(name);
        if (desc == null) {
            CoreLoadFailure loadFailure = this.getCoreInitFailures().get(name);
            if (null != loadFailure) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "SolrCore '" + name + "' is not available due to init failure: " + loadFailure.exception.getMessage(), (Throwable)loadFailure.exception);
            }
            return null;
        }
        core = this.solrCores.waitAddPendingCoreOps(name);
        if (this.isShutDown) {
            return null;
        }
        try {
            if (core == null) {
                if (this.zkSys.getZkController() != null) {
                    this.zkSys.getZkController().throwErrorIfReplicaReplaced(desc);
                }
                core = this.create(desc);
            }
            core.open();
        }
        finally {
            this.solrCores.removeFromPendingOps(name);
        }
        return core;
    }

    public JarRepository getJarRepository() {
        return this.jarRepository;
    }

    public void waitForLoadingCoresToFinish(long timeoutMs) {
        this.solrCores.waitForLoadingCoresToFinish(timeoutMs);
    }

    public void waitForLoadingCore(String name, long timeoutMs) {
        this.solrCores.waitForLoadingCoreToFinish(name, timeoutMs);
    }

    protected <T> T createHandler(String handlerClass, Class<T> clazz) {
        return this.loader.newInstance(handlerClass, clazz, null, new Class[]{CoreContainer.class}, new Object[]{this});
    }

    public CoreAdminHandler getMultiCoreHandler() {
        return this.coreAdminHandler;
    }

    public CollectionsHandler getCollectionsHandler() {
        return this.collectionsHandler;
    }

    public InfoHandler getInfoHandler() {
        return this.infoHandler;
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getManagementPath() {
        return this.cfg.getManagementPath();
    }

    public LogWatcher getLogging() {
        return this.logging;
    }

    public boolean isLoaded(String name) {
        return this.solrCores.isLoaded(name);
    }

    public boolean isLoadedNotPendingClose(String name) {
        return this.solrCores.isLoadedNotPendingClose(name);
    }

    public CoreDescriptor getUnloadedCoreDescriptor(String cname) {
        return this.solrCores.getUnloadedCoreDescriptor(cname);
    }

    public String getSolrHome() {
        return this.solrHome;
    }

    public boolean isZooKeeperAware() {
        return this.zkSys.getZkController() != null;
    }

    public ZkController getZkController() {
        return this.zkSys.getZkController();
    }

    public NodeConfig getConfig() {
        return this.cfg;
    }

    public ShardHandlerFactory getShardHandlerFactory() {
        return this.shardHandlerFactory;
    }

    public UpdateShardHandler getUpdateShardHandler() {
        return this.updateShardHandler;
    }

    public SolrResourceLoader getResourceLoader() {
        return this.loader;
    }

    public boolean isCoreLoading(String name) {
        return this.solrCores.isCoreLoading(name);
    }

    public AuthorizationPlugin getAuthorizationPlugin() {
        return this.authorizationPlugin == null ? null : (AuthorizationPlugin)this.authorizationPlugin.plugin;
    }

    public AuthenticationPlugin getAuthenticationPlugin() {
        return this.authenticationPlugin == null ? null : (AuthenticationPlugin)this.authenticationPlugin.plugin;
    }

    public static class CoreLoadFailure {
        public final CoreDescriptor cd;
        public final Exception exception;

        public CoreLoadFailure(CoreDescriptor cd, Exception loadFailure) {
            this.cd = cd;
            this.exception = loadFailure;
        }
    }
}

