/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.solr.cloud.CloudDescriptor;
import org.apache.solr.cloud.ElectionContext;
import org.apache.solr.cloud.LeaderElector;
import org.apache.solr.cloud.LeaderInitiatedRecoveryThread;
import org.apache.solr.cloud.ShardLeaderElectionContextBase;
import org.apache.solr.cloud.SyncStrategy;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.ZkCoreNodeProps;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.SolrCore;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ShardLeaderElectionContext
extends ShardLeaderElectionContextBase {
    private static Logger log = LoggerFactory.getLogger(ShardLeaderElectionContext.class);
    private final ZkController zkController;
    private final CoreContainer cc;
    private final SyncStrategy syncStrategy;
    private volatile boolean isClosed = false;

    public ShardLeaderElectionContext(LeaderElector leaderElector, String shardId, String collection, String coreNodeName, ZkNodeProps props, ZkController zkController, CoreContainer cc) {
        super(leaderElector, shardId, collection, coreNodeName, props, zkController.getZkStateReader());
        this.zkController = zkController;
        this.cc = cc;
        this.syncStrategy = new SyncStrategy(cc);
    }

    @Override
    public void close() {
        super.close();
        this.isClosed = true;
        this.syncStrategy.close();
    }

    @Override
    public ElectionContext copy() {
        return new ShardLeaderElectionContext(this.leaderElector, this.shardId, this.collection, this.id, this.leaderProps, this.zkController, this.cc);
    }

    /*
     * Exception decompiling
     */
    @Override
    void runLeaderProcess(boolean weAreReplacement, int pauseBeforeStart) throws KeeperException, InterruptedException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[TRYBLOCK]], but top level block is 64[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void startLeaderInitiatedRecoveryOnReplicas(String coreName) throws Exception {
        try (SolrCore core = this.cc.getCore(coreName);){
            CloudDescriptor cloudDesc = core.getCoreDescriptor().getCloudDescriptor();
            String coll = cloudDesc.getCollectionName();
            String shardId = cloudDesc.getShardId();
            String coreNodeName = cloudDesc.getCoreNodeName();
            if (coll == null || shardId == null) {
                log.error("Cannot start leader-initiated recovery on new leader (core=" + coreName + ",coreNodeName=" + coreNodeName + ") because collection and/or shard is null!");
                return;
            }
            String znodePath = this.zkController.getLeaderInitiatedRecoveryZnodePath(coll, shardId);
            List replicas = null;
            try {
                replicas = this.zkClient.getChildren(znodePath, null, false);
            }
            catch (KeeperException.NoNodeException nne) {
                // empty catch block
            }
            if (replicas != null && replicas.size() > 0) {
                for (String replicaCoreNodeName : replicas) {
                    Replica.State lirState;
                    if (coreNodeName.equals(replicaCoreNodeName) || (lirState = this.zkController.getLeaderInitiatedRecoveryState(coll, shardId, replicaCoreNodeName)) != Replica.State.DOWN && lirState != Replica.State.RECOVERY_FAILED) continue;
                    log.info("After core={} coreNodeName={} was elected leader, a replica coreNodeName={} was found in state: " + lirState.toString() + " and needing recovery.", new Object[]{coreName, coreNodeName, replicaCoreNodeName});
                    List replicaProps = this.zkController.getZkStateReader().getReplicaProps(this.collection, shardId, coreNodeName);
                    if (replicaProps == null || replicaProps.size() <= 0) continue;
                    ZkCoreNodeProps coreNodeProps = null;
                    for (ZkCoreNodeProps p : replicaProps) {
                        if (!((Replica)p.getNodeProps()).getName().equals(replicaCoreNodeName)) continue;
                        coreNodeProps = p;
                        break;
                    }
                    LeaderInitiatedRecoveryThread lirThread = new LeaderInitiatedRecoveryThread(this.zkController, this.cc, this.collection, shardId, coreNodeProps, 120, coreNodeName);
                    this.zkController.ensureReplicaInLeaderInitiatedRecovery(this.collection, shardId, coreNodeProps, coreNodeName, false, true);
                    ExecutorService executor = this.cc.getUpdateShardHandler().getUpdateExecutor();
                    executor.execute(lirThread);
                }
            }
        }
    }

    private void waitForReplicasToComeUp(int timeoutms) throws InterruptedException {
        long timeoutAt = System.nanoTime() + TimeUnit.NANOSECONDS.convert(timeoutms, TimeUnit.MILLISECONDS);
        String shardsElectZkPath = this.electionPath + "/election";
        Slice slices = this.zkController.getClusterState().getSlice(this.collection, this.shardId);
        int cnt = 0;
        while (!this.isClosed && !this.cc.isShutDown()) {
            if (slices != null) {
                int found = 0;
                try {
                    found = this.zkClient.getChildren(shardsElectZkPath, null, true).size();
                }
                catch (KeeperException e) {
                    if (e instanceof KeeperException.SessionExpiredException) {
                        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "ZK session expired - cancelling election for " + this.collection + " " + this.shardId);
                    }
                    SolrException.log((Logger)log, (String)"Error checking for the number of election participants", (Throwable)e);
                }
                if (found >= slices.getReplicasMap().size()) {
                    log.info("Enough replicas found to continue.");
                    return;
                }
                if (cnt % 40 == 0) {
                    log.info("Waiting until we see more replicas up for shard {}: total={} found={} timeoutin={}ms", new Object[]{this.shardId, slices.getReplicasMap().size(), found, TimeUnit.MILLISECONDS.convert(timeoutAt - System.nanoTime(), TimeUnit.NANOSECONDS)});
                }
                if (System.nanoTime() > timeoutAt) {
                    log.info("Was waiting for replicas to come up, but they are taking too long - assuming they won't come back till later");
                    return;
                }
            } else {
                log.warn("Shard not found: " + this.shardId + " for collection " + this.collection);
                return;
            }
            Thread.sleep(500L);
            slices = this.zkController.getClusterState().getSlice(this.collection, this.shardId);
            ++cnt;
        }
    }

    private void rejoinLeaderElection(SolrCore core) throws InterruptedException, KeeperException, IOException {
        if (this.cc.isShutDown()) {
            log.info("Not rejoining election because CoreContainer is closed");
            return;
        }
        log.info("There may be a better leader candidate than us - going back into recovery");
        this.cancelElection();
        core.getUpdateHandler().getSolrCoreState().doRecovery(this.cc, core.getCoreDescriptor());
        this.leaderElector.joinElection(this, true);
    }

    private boolean shouldIBeLeader(ZkNodeProps leaderProps, SolrCore core, boolean weAreReplacement) {
        log.info("Checking if I should try and be the leader.");
        if (this.isClosed) {
            log.info("Bailing on leader process because we have been closed");
            return false;
        }
        if (!weAreReplacement) {
            return true;
        }
        if (core.getCoreDescriptor().getCloudDescriptor().getLastPublished() == Replica.State.ACTIVE) {
            Replica.State lirState = this.zkController.getLeaderInitiatedRecoveryState(this.collection, this.shardId, core.getCoreDescriptor().getCloudDescriptor().getCoreNodeName());
            if (lirState == Replica.State.DOWN || lirState == Replica.State.RECOVERING) {
                log.warn("Although my last published state is Active, the previous leader marked me " + core.getName() + " as " + lirState.toString() + " and I haven't recovered yet, so I shouldn't be the leader.");
                return false;
            }
            log.info("My last published State was Active, it's okay to be the leader.");
            return true;
        }
        log.info("My last published State was " + core.getCoreDescriptor().getCloudDescriptor().getLastPublished() + ", I won't be the leader.");
        return false;
    }
}

