/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.net.ConnectException;
import java.net.SocketException;
import java.util.List;
import org.apache.http.NoHttpResponseException;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.request.CoreAdminRequest;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.ZkCoreNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.params.CoreAdminParams;
import org.apache.solr.core.CoreContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LeaderInitiatedRecoveryThread
extends Thread {
    public static final Logger log = LoggerFactory.getLogger(LeaderInitiatedRecoveryThread.class);
    protected ZkController zkController;
    protected CoreContainer coreContainer;
    protected String collection;
    protected String shardId;
    protected ZkCoreNodeProps nodeProps;
    protected int maxTries;
    protected String leaderCoreNodeName;

    public LeaderInitiatedRecoveryThread(ZkController zkController, CoreContainer cc, String collection, String shardId, ZkCoreNodeProps nodeProps, int maxTries, String leaderCoreNodeName) {
        super("LeaderInitiatedRecoveryThread-" + nodeProps.getCoreName());
        this.zkController = zkController;
        this.coreContainer = cc;
        this.collection = collection;
        this.shardId = shardId;
        this.nodeProps = nodeProps;
        this.maxTries = maxTries;
        this.leaderCoreNodeName = leaderCoreNodeName;
        this.setDaemon(true);
    }

    @Override
    public void run() {
        long startMs = System.currentTimeMillis();
        try {
            this.sendRecoveryCommandWithRetry();
        }
        catch (Exception exc) {
            log.error(this.getName() + " failed due to: " + exc, (Throwable)exc);
            if (exc instanceof SolrException) {
                throw (SolrException)((Object)exc);
            }
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)exc);
        }
        long diffMs = System.currentTimeMillis() - startMs;
        log.info(this.getName() + " completed successfully after running for " + Math.round(diffMs / 1000L) + " secs");
    }

    protected void sendRecoveryCommandWithRetry() throws Exception {
        int tries = 0;
        long waitBetweenTriesMs = 5000L;
        boolean continueTrying = true;
        String recoveryUrl = this.nodeProps.getBaseUrl();
        String replicaNodeName = this.nodeProps.getNodeName();
        String coreNeedingRecovery = this.nodeProps.getCoreName();
        String replicaCoreNodeName = ((Replica)this.nodeProps.getNodeProps()).getName();
        String replicaUrl = this.nodeProps.getCoreUrl();
        log.info(this.getName() + " started running to send REQUESTRECOVERY command to " + replicaUrl + "; will try for a max of " + (long)this.maxTries * (waitBetweenTriesMs / 1000L) + " secs");
        CoreAdminRequest.RequestRecovery recoverRequestCmd = new CoreAdminRequest.RequestRecovery();
        recoverRequestCmd.setAction(CoreAdminParams.CoreAdminAction.REQUESTRECOVERY);
        recoverRequestCmd.setCoreName(coreNeedingRecovery);
        block19: while (continueTrying && ++tries <= this.maxTries) {
            if (tries > 1) {
                log.warn("Asking core={} coreNodeName={} on " + recoveryUrl + " to recover; unsuccessful after " + tries + " of " + this.maxTries + " attempts so far ...", (Object)coreNeedingRecovery, (Object)replicaCoreNodeName);
            } else {
                log.info("Asking core={} coreNodeName={} on " + recoveryUrl + " to recover", (Object)coreNeedingRecovery, (Object)replicaCoreNodeName);
            }
            try (HttpSolrClient client = new HttpSolrClient(recoveryUrl);){
                client.setSoTimeout(60000);
                client.setConnectionTimeout(15000);
                try {
                    client.request((SolrRequest)recoverRequestCmd);
                    log.info("Successfully sent " + CoreAdminParams.CoreAdminAction.REQUESTRECOVERY + " command to core={} coreNodeName={} on " + recoveryUrl, (Object)coreNeedingRecovery, (Object)replicaCoreNodeName);
                    continueTrying = false;
                }
                catch (Throwable t) {
                    Throwable rootCause = SolrException.getRootCause((Throwable)t);
                    boolean wasCommError = rootCause instanceof ConnectException || rootCause instanceof ConnectTimeoutException || rootCause instanceof NoHttpResponseException || rootCause instanceof SocketException;
                    SolrException.log((Logger)log, (String)(recoveryUrl + ": Could not tell a replica to recover"), (Throwable)t);
                    if (!wasCommError) {
                        continueTrying = false;
                    }
                }
            }
            if (!continueTrying) continue;
            try {
                Thread.sleep(waitBetweenTriesMs);
            }
            catch (InterruptedException ignoreMe) {
                Thread.currentThread().interrupt();
            }
            if (this.coreContainer.isShutDown()) {
                log.warn("Stop trying to send recovery command to downed replica core={} coreNodeName={} on " + replicaNodeName + " because my core container is closed.", (Object)coreNeedingRecovery, (Object)replicaCoreNodeName);
                continueTrying = false;
                break;
            }
            ZkStateReader zkStateReader = this.zkController.getZkStateReader();
            try {
                zkStateReader.updateClusterState();
            }
            catch (Exception exc) {
                log.warn("Error when updating cluster state: " + exc);
            }
            if (!zkStateReader.getClusterState().liveNodesContain(replicaNodeName)) {
                log.warn("Node " + replicaNodeName + " hosting core " + coreNeedingRecovery + " is no longer live. No need to keep trying to tell it to recover!");
                continueTrying = false;
                break;
            }
            if (this.leaderCoreNodeName != null && this.collection != null) {
                String leaderCoreNodeNameFromZk = null;
                try {
                    leaderCoreNodeNameFromZk = this.zkController.getZkStateReader().getLeaderRetry(this.collection, this.shardId, 1000).getName();
                }
                catch (Exception exc) {
                    log.error("Failed to determine if " + this.leaderCoreNodeName + " is still the leader for " + this.collection + " " + this.shardId + " before starting leader-initiated recovery thread for " + replicaUrl + " due to: " + exc);
                }
                if (!this.leaderCoreNodeName.equals(leaderCoreNodeNameFromZk)) {
                    log.warn("Stop trying to send recovery command to downed replica core=" + coreNeedingRecovery + ",coreNodeName=" + replicaCoreNodeName + " on " + replicaNodeName + " because " + this.leaderCoreNodeName + " is no longer the leader! New leader is " + leaderCoreNodeNameFromZk);
                    continueTrying = false;
                    break;
                }
            }
            if (this.collection == null || this.shardId == null) continue;
            try {
                Replica.State lirState = this.zkController.getLeaderInitiatedRecoveryState(this.collection, this.shardId, replicaCoreNodeName);
                if (lirState == null) {
                    log.warn("Stop trying to send recovery command to downed replica core=" + coreNeedingRecovery + ",coreNodeName=" + replicaCoreNodeName + " on " + replicaNodeName + " because the znode no longer exists.");
                    continueTrying = false;
                    break;
                }
                if (lirState == Replica.State.RECOVERING) {
                    continueTrying = false;
                    log.info("Replica " + coreNeedingRecovery + " on node " + replicaNodeName + " ack'd the leader initiated recovery state, " + "no need to keep trying to send recovery command");
                    continue;
                }
                String leaderCoreNodeName = zkStateReader.getLeaderRetry(this.collection, this.shardId, 5000).getName();
                List replicaProps = zkStateReader.getReplicaProps(this.collection, this.shardId, leaderCoreNodeName);
                if (replicaProps == null || replicaProps.size() <= 0) continue;
                for (ZkCoreNodeProps prop : replicaProps) {
                    Replica replica = (Replica)prop.getNodeProps();
                    if (!replicaCoreNodeName.equals(replica.getName())) continue;
                    if (replica.getState() != Replica.State.ACTIVE || lirState != Replica.State.DOWN) continue block19;
                    log.warn("Replica core={} coreNodeName={} set to active but the leader thinks it should be in recovery; forcing it back to down state to re-run the leader-initiated recovery process; props: " + replicaProps.get(0), (Object)coreNeedingRecovery, (Object)replicaCoreNodeName);
                    this.zkController.ensureReplicaInLeaderInitiatedRecovery(this.collection, this.shardId, this.nodeProps, leaderCoreNodeName, true, true);
                }
            }
            catch (Exception ignoreMe) {
                log.warn("Failed to determine state of core={} coreNodeName={} due to: " + ignoreMe, (Object)coreNeedingRecovery, (Object)replicaCoreNodeName);
            }
        }
        this.zkController.removeReplicaFromLeaderInitiatedRecoveryHandling(replicaUrl);
        if (continueTrying) {
            log.error("Timed out after waiting for " + (long)tries * (waitBetweenTriesMs / 1000L) + " secs to send the recovery request to: " + replicaUrl + "; not much more we can do here?");
        }
    }
}

