/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.fsdataset.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.StorageType;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.VolumeChoosingPolicy;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsDatasetImpl;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsVolumeImpl;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.RamDiskReplicaTracker;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.ReplicaMap;
import org.apache.hadoop.util.DiskChecker;
import org.apache.hadoop.util.Time;

class FsVolumeList {
    volatile List<FsVolumeImpl> volumes = null;
    private final VolumeChoosingPolicy<FsVolumeImpl> blockChooser;
    private volatile int numFailedVolumes;

    FsVolumeList(int failedVols, VolumeChoosingPolicy<FsVolumeImpl> blockChooser) {
        this.blockChooser = blockChooser;
        this.numFailedVolumes = failedVols;
    }

    int numberOfFailedVolumes() {
        return this.numFailedVolumes;
    }

    synchronized FsVolumeImpl getNextVolume(StorageType storageType, long blockSize) throws IOException {
        ArrayList<FsVolumeImpl> list = new ArrayList<FsVolumeImpl>(this.volumes.size());
        for (FsVolumeImpl v : this.volumes) {
            if (v.getStorageType() != storageType) continue;
            list.add(v);
        }
        return this.blockChooser.chooseVolume(list, blockSize);
    }

    synchronized FsVolumeImpl getNextTransientVolume(long blockSize) throws IOException {
        ArrayList<FsVolumeImpl> list = new ArrayList<FsVolumeImpl>(this.volumes.size());
        for (FsVolumeImpl v : this.volumes) {
            if (!v.isTransientStorage()) continue;
            list.add(v);
        }
        return this.blockChooser.chooseVolume(list, blockSize);
    }

    long getDfsUsed() throws IOException {
        long dfsUsed = 0L;
        for (FsVolumeImpl v : this.volumes) {
            dfsUsed += v.getDfsUsed();
        }
        return dfsUsed;
    }

    long getBlockPoolUsed(String bpid) throws IOException {
        long dfsUsed = 0L;
        for (FsVolumeImpl v : this.volumes) {
            dfsUsed += v.getBlockPoolUsed(bpid);
        }
        return dfsUsed;
    }

    long getCapacity() {
        long capacity = 0L;
        for (FsVolumeImpl v : this.volumes) {
            capacity += v.getCapacity();
        }
        return capacity;
    }

    long getRemaining() throws IOException {
        long remaining = 0L;
        for (FsVolumeImpl vol : this.volumes) {
            remaining += vol.getAvailable();
        }
        return remaining;
    }

    void getAllVolumesMap(final String bpid, final ReplicaMap volumeMap, final RamDiskReplicaTracker ramDiskReplicaMap) throws IOException {
        long totalStartTime = Time.monotonicNow();
        final List exceptions = Collections.synchronizedList(new ArrayList());
        ArrayList<1> replicaAddingThreads = new ArrayList<1>();
        for (final FsVolumeImpl fsVolumeImpl : this.volumes) {
            Thread t = new Thread(){

                @Override
                public void run() {
                    try {
                        FsDatasetImpl.LOG.info((Object)("Adding replicas to map for block pool " + bpid + " on volume " + fsVolumeImpl + "..."));
                        long startTime = Time.monotonicNow();
                        fsVolumeImpl.getVolumeMap(bpid, volumeMap, ramDiskReplicaMap);
                        long timeTaken = Time.monotonicNow() - startTime;
                        FsDatasetImpl.LOG.info((Object)("Time to add replicas to map for block pool " + bpid + " on volume " + fsVolumeImpl + ": " + timeTaken + "ms"));
                    }
                    catch (IOException ioe) {
                        FsDatasetImpl.LOG.info((Object)("Caught exception while adding replicas from " + fsVolumeImpl + ". Will throw later."), (Throwable)ioe);
                        exceptions.add(ioe);
                    }
                }
            };
            replicaAddingThreads.add(t);
            t.start();
        }
        for (Thread thread : replicaAddingThreads) {
            try {
                thread.join();
            }
            catch (InterruptedException ie) {
                throw new IOException(ie);
            }
        }
        if (!exceptions.isEmpty()) {
            throw (IOException)exceptions.get(0);
        }
        long totalTimeTaken = Time.monotonicNow() - totalStartTime;
        FsDatasetImpl.LOG.info((Object)("Total time to add all replicas to map: " + totalTimeTaken + "ms"));
    }

    synchronized List<FsVolumeImpl> checkDirs() {
        ArrayList<FsVolumeImpl> removedVols = null;
        ArrayList<FsVolumeImpl> volumeList = new ArrayList<FsVolumeImpl>(this.volumes);
        Iterator i = volumeList.iterator();
        while (i.hasNext()) {
            FsVolumeImpl fsv = (FsVolumeImpl)i.next();
            try {
                fsv.checkDirs();
            }
            catch (DiskChecker.DiskErrorException e) {
                FsDatasetImpl.LOG.warn((Object)("Removing failed volume " + fsv + ": "), (Throwable)e);
                if (removedVols == null) {
                    removedVols = new ArrayList<FsVolumeImpl>(1);
                }
                removedVols.add(fsv);
                fsv.shutdown();
                i.remove();
                ++this.numFailedVolumes;
            }
        }
        if (removedVols != null && removedVols.size() > 0) {
            this.volumes = Collections.unmodifiableList(volumeList);
            FsDatasetImpl.LOG.warn((Object)("Completed checkDirs. Removed " + removedVols.size() + " volumes. Current volumes: " + this));
        }
        return removedVols;
    }

    public String toString() {
        return this.volumes.toString();
    }

    synchronized void addVolume(FsVolumeImpl newVolume) {
        ArrayList<FsVolumeImpl> volumeList = this.volumes == null ? new ArrayList<FsVolumeImpl>() : new ArrayList<FsVolumeImpl>(this.volumes);
        volumeList.add(newVolume);
        this.volumes = Collections.unmodifiableList(volumeList);
        FsDatasetImpl.LOG.info((Object)("Added new volume: " + newVolume.toString()));
    }

    synchronized void removeVolume(String volume) {
        ArrayList<FsVolumeImpl> volumeList = new ArrayList<FsVolumeImpl>(this.volumes);
        Iterator it = volumeList.iterator();
        while (it.hasNext()) {
            FsVolumeImpl fsVolume = (FsVolumeImpl)it.next();
            if (!fsVolume.getBasePath().equals(volume)) continue;
            fsVolume.shutdown();
            it.remove();
            this.volumes = Collections.unmodifiableList(volumeList);
            FsDatasetImpl.LOG.info((Object)("Removed volume: " + volume));
            break;
        }
    }

    void addBlockPool(final String bpid, final Configuration conf) throws IOException {
        long totalStartTime = Time.monotonicNow();
        final List exceptions = Collections.synchronizedList(new ArrayList());
        ArrayList<2> blockPoolAddingThreads = new ArrayList<2>();
        for (final FsVolumeImpl fsVolumeImpl : this.volumes) {
            Thread t = new Thread(){

                @Override
                public void run() {
                    try {
                        FsDatasetImpl.LOG.info((Object)("Scanning block pool " + bpid + " on volume " + fsVolumeImpl + "..."));
                        long startTime = Time.monotonicNow();
                        fsVolumeImpl.addBlockPool(bpid, conf);
                        long timeTaken = Time.monotonicNow() - startTime;
                        FsDatasetImpl.LOG.info((Object)("Time taken to scan block pool " + bpid + " on " + fsVolumeImpl + ": " + timeTaken + "ms"));
                    }
                    catch (IOException ioe) {
                        FsDatasetImpl.LOG.info((Object)("Caught exception while scanning " + fsVolumeImpl + ". Will throw later."), (Throwable)ioe);
                        exceptions.add(ioe);
                    }
                }
            };
            blockPoolAddingThreads.add(t);
            t.start();
        }
        for (Thread thread : blockPoolAddingThreads) {
            try {
                thread.join();
            }
            catch (InterruptedException ie) {
                throw new IOException(ie);
            }
        }
        if (!exceptions.isEmpty()) {
            throw (IOException)exceptions.get(0);
        }
        long totalTimeTaken = Time.monotonicNow() - totalStartTime;
        FsDatasetImpl.LOG.info((Object)("Total time to scan all replicas for block pool " + bpid + ": " + totalTimeTaken + "ms"));
    }

    void removeBlockPool(String bpid) {
        for (FsVolumeImpl v : this.volumes) {
            v.shutdownBlockPool(bpid);
        }
    }

    void shutdown() {
        for (FsVolumeImpl volume : this.volumes) {
            if (volume == null) continue;
            volume.shutdown();
        }
    }
}

