/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.util;

public class TbCommon {
    private static byte[] POSITIVE_INFINITY_FLOAT_BYTES = new byte[]{-1, -128, 0, 0};
    private static byte[] NEGATIVE_INFINITY_FLOAT_BYTES = new byte[]{0, 127, -1, -1};
    private static byte[] MAX_VALUE_FLOAT_BYTES = new byte[]{127, 127, -1, -1};
    private static byte[] MIN_VALUE_FLOAT_BYTES = new byte[]{0, 0, 0, 1};
    private static byte[] NAN_FLOAT_BYTES = new byte[]{-1, -64, 0, 0};
    private static byte[] NEGATIVE_ZERO_FLOAT_BYTES = new byte[]{-128, 0, 0, 0};
    private static byte[] POSITIVE_INFINITY_DOUBLE_BYTES = new byte[]{-1, -16, 0, 0, 0, 0, 0, 0};
    private static byte[] NEGATIVE_INFINITY_DOUBLE_BYTES = new byte[]{0, 15, -1, -1, -1, -1, -1, -1};
    private static byte[] MAX_VALUE_DOUBLE_BYTES = new byte[]{127, -17, -1, -1, -1, -1, -1, -1};
    private static byte[] MIN_VALUE_DOUBLE_BYTES = new byte[]{0, 0, 0, 0, 0, 0, 0, 1};
    private static byte[] NAN_DOUBLE_BYTES = new byte[]{-1, -8, 0, 0, 0, 0, 0, 0};
    private static byte[] NEGATIVE_ZERO_DOUBLE_BYTES = new byte[]{-128, 0, 0, 0, 0, 0, 0, 0};

    private static boolean equalsBytes(byte[] a, byte[] b, int offset, int len) {
        if (a == null || b == null) {
            return false;
        }
        int length = a.length;
        if (len != length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (a[i] == b[offset + i]) continue;
            return false;
        }
        return true;
    }

    public static boolean isPositiveInfinityFloatBytes(byte[] b, int offset, int len) {
        return TbCommon.equalsBytes(POSITIVE_INFINITY_FLOAT_BYTES, b, offset, len);
    }

    public static boolean isNegativeInfinityFloatBytes(byte[] b, int offset, int len) {
        return TbCommon.equalsBytes(NEGATIVE_INFINITY_FLOAT_BYTES, b, offset, len);
    }

    public static boolean isMaxValueFloatBytes(byte[] b, int offset, int len) {
        return TbCommon.equalsBytes(MAX_VALUE_FLOAT_BYTES, b, offset, len);
    }

    public static boolean isMinValueFloatBytes(byte[] b, int offset, int len) {
        return TbCommon.equalsBytes(MIN_VALUE_FLOAT_BYTES, b, offset, len);
    }

    public static boolean isNanFloatBytes(byte[] b, int offset, int len) {
        return TbCommon.equalsBytes(NAN_FLOAT_BYTES, b, offset, len);
    }

    public static boolean isNegativeZeroFloatBytes(byte[] b, int offset, int len) {
        return TbCommon.equalsBytes(NEGATIVE_ZERO_FLOAT_BYTES, b, offset, len);
    }

    public static boolean isPositiveInfinityDoubleBytes(byte[] b, int offset, int len) {
        return TbCommon.equalsBytes(POSITIVE_INFINITY_DOUBLE_BYTES, b, offset, len);
    }

    public static boolean isNegativeInfinityDoubleBytes(byte[] b, int offset, int len) {
        return TbCommon.equalsBytes(NEGATIVE_INFINITY_DOUBLE_BYTES, b, offset, len);
    }

    public static boolean isMaxValueDoubleBytes(byte[] b, int offset, int len) {
        return TbCommon.equalsBytes(MAX_VALUE_DOUBLE_BYTES, b, offset, len);
    }

    public static boolean isMinValueDoubleBytes(byte[] b, int offset, int len) {
        return TbCommon.equalsBytes(MIN_VALUE_DOUBLE_BYTES, b, offset, len);
    }

    public static boolean isNanDoubleBytes(byte[] b, int offset, int len) {
        return TbCommon.equalsBytes(NAN_DOUBLE_BYTES, b, offset, len);
    }

    public static boolean isNegativeZeroDoubleBytes(byte[] b, int offset, int len) {
        return TbCommon.equalsBytes(NEGATIVE_ZERO_DOUBLE_BYTES, b, offset, len);
    }

    public static int bytes2Int(byte[] bytes, int offset, int len) {
        int num = 0;
        for (int i = 0; i < len; ++i) {
            num |= (0xFF & bytes[offset + i]) << 8 * (len - 1 - i);
        }
        return num;
    }

    public static int bytes2IntR(byte[] bytes, int offset, int len) {
        int num = 0;
        for (int i = 0; i < len; ++i) {
            num |= (0xFF & bytes[offset + i]) << 8 * i;
        }
        return num;
    }

    public static long bytes2Long(byte[] bytes, int offset, int len) {
        long num = 0L;
        for (int i = 0; i < len; ++i) {
            num |= (0xFFL & (long)bytes[offset + i]) << 8 * (len - 1 - i);
        }
        return num;
    }

    public static long bytes2LongR(byte[] bytes, int offset, int len) {
        long num = 0L;
        for (int i = 0; i < len; ++i) {
            num |= (0xFFL & (long)bytes[offset + i]) << 8 * i;
        }
        return num;
    }

    public static String bytes2String(byte[] bytes, int offset, int len) {
        StringBuffer sb = new StringBuffer(len * 2);
        for (int i = 0; i < len; ++i) {
            sb.append((char)TbCommon.raw2Hex((byte)((bytes[offset + i] & 0xF0) >> 4)));
            sb.append((char)TbCommon.raw2Hex((byte)(bytes[offset + i] & 0xF)));
        }
        return sb.toString();
    }

    public static boolean getBitmapAt(int position, int bitmap) {
        int base = 1;
        return (bitmap & (base <<= position)) != 0;
    }

    public static String getEmptyString(String str, String defaultStr) {
        return str != null ? str : defaultStr;
    }

    public static int getPadLength(int byteLength) {
        int result = (4 - byteLength % 4) % 4;
        return result == 0 ? 4 : result;
    }

    public static int int2Bytes(int num, byte[] bytes, int offset, int len) {
        for (int i = 0; i < len; ++i) {
            bytes[offset + len - 1 - i] = (byte)(0xFF & num >> 8 * i);
        }
        return len;
    }

    public static int int2BytesR(int num, byte[] bytes, int offset, int len) {
        for (int i = 0; i < len; ++i) {
            bytes[offset + i] = (byte)(0xFF & num >> 8 * i);
        }
        return len;
    }

    public static int long2Bytes(long num, byte[] bytes, int offset, int len) {
        for (int i = 0; i < len; ++i) {
            bytes[offset + len - 1 - i] = (byte)(0xFFL & num >> 8 * i);
        }
        return len;
    }

    public static int long2BytesR(long num, byte[] bytes, int offset, int len) {
        for (int i = 0; i < len; ++i) {
            bytes[offset + i] = (byte)(0xFFL & num >> 8 * i);
        }
        return len;
    }

    private static byte raw2Hex(byte byte0) {
        return (byte)((byte0 = (byte)(byte0 & 0xF)) >= 10 ? byte0 - 10 + 65 : byte0 + 48);
    }

    public static void writePadding(byte[] buf, int startOffset, int padLen) {
        if (padLen != 0) {
            for (int i = 0; i < padLen; ++i) {
                buf[startOffset + i] = 0;
            }
        }
    }

    private TbCommon() {
    }
}

