/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.rowset;

import com.tmax.tibero.jdbc.TbDriver;
import com.tmax.tibero.jdbc.err.TbError;
import com.tmax.tibero.jdbc.rowset.TbCachedRowSet;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import javax.sql.RowSet;
import javax.sql.RowSetInternal;
import javax.sql.RowSetReader;

public class TbCachedRowSetReader
implements RowSetReader,
Serializable {
    private static final long serialVersionUID = 3627327166239927438L;
    private static boolean isInitializedDriver = false;

    Connection getConnection(RowSetInternal rowsetinternal) throws SQLException {
        Connection tmpConn = rowsetinternal.getConnection();
        String url = ((RowSet)((Object)rowsetinternal)).getUrl();
        String user = ((RowSet)((Object)rowsetinternal)).getUsername();
        String pwd = ((RowSet)((Object)rowsetinternal)).getPassword();
        String dataSourceName = ((RowSet)((Object)rowsetinternal)).getDataSourceName();
        if (tmpConn != null && !tmpConn.isClosed()) {
            return tmpConn;
        }
        if (dataSourceName != null && !dataSourceName.equals("")) {
            try {
                InitialContext initialcontext = null;
                try {
                    Properties properties = System.getProperties();
                    initialcontext = new InitialContext(properties);
                }
                catch (SecurityException securityexception) {
                    // empty catch block
                }
                if (initialcontext == null) {
                    initialcontext = new InitialContext();
                }
                DataSource datasource = (DataSource)initialcontext.lookup(dataSourceName);
                if (user == null && pwd == null) {
                    return datasource.getConnection();
                }
                return datasource.getConnection(user, pwd);
            }
            catch (NamingException e) {
                throw TbError.newSQLException(-90828, e.getMessage());
            }
        }
        if (url != null && !url.equals("")) {
            if (!isInitializedDriver) {
                DriverManager.registerDriver(new TbDriver());
                isInitializedDriver = true;
            }
            if (user.equals("") || pwd.equals("")) {
                throw TbError.newSQLException(-90854);
            }
            return DriverManager.getConnection(url, user, pwd);
        }
        throw TbError.newSQLException(-90852);
    }

    @Override
    public synchronized void readData(RowSetInternal rowsetinternal) throws SQLException {
        TbCachedRowSet rowset = (TbCachedRowSet)rowsetinternal;
        Connection conn = this.getConnection(rowsetinternal);
        if (rowset.getCommand() == null) {
            throw TbError.newSQLException(-90826);
        }
        try {
            conn.setTransactionIsolation(rowset.getTransactionIsolation());
        }
        catch (Exception e) {
            // empty catch block
        }
        PreparedStatement pstmt = conn.prepareStatement(rowset.getCommand());
        this.setParams(rowsetinternal.getParams(), pstmt);
        try {
            pstmt.setMaxRows(rowset.getMaxRows());
            pstmt.setMaxFieldSize(rowset.getMaxFieldSize());
            pstmt.setEscapeProcessing(rowset.getEscapeProcessing());
            pstmt.setQueryTimeout(rowset.getQueryTimeout());
        }
        catch (Exception e) {
            // empty catch block
        }
        ResultSet rs = pstmt.executeQuery();
        rowset.populate(rs);
        rs.close();
        pstmt.close();
        try {
            conn.commit();
        }
        catch (SQLException e) {
            // empty catch block
        }
        if (!rowset.isConnectionOpened()) {
            conn.close();
        }
    }

    private void setParams(Object[] params, PreparedStatement pstmt) throws SQLException {
        for (int i = 0; i < params.length; ++i) {
            if (!(params[i] instanceof Object[])) {
                pstmt.setObject(i + 1, params[i]);
                continue;
            }
            Object[] paramObj = (Object[])params[i];
            if (paramObj.length == 2) {
                this.setParams2Arg(i, paramObj, pstmt);
                continue;
            }
            if (paramObj.length != 3) continue;
            this.setParams3Arg(i, paramObj, pstmt);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setParams2Arg(int i, Object[] paramObj, PreparedStatement pstmt) throws SQLException {
        if (paramObj[0] == null) {
            pstmt.setNull(i + 1, (Integer)paramObj[1]);
            return;
        } else if (paramObj[0] instanceof RowId) {
            pstmt.setRowId(i + 1, (RowId)paramObj[0]);
            return;
        } else if (paramObj[0] instanceof NClob) {
            pstmt.setNClob(i + 1, (NClob)paramObj[0]);
            return;
        } else if (paramObj[0] instanceof Date) {
            if (!(paramObj[1] instanceof Calendar)) throw TbError.newSQLException(-90846, paramObj[1].toString());
            pstmt.setDate(i + 1, (Date)paramObj[0], (Calendar)paramObj[1]);
            return;
        } else if (paramObj[0] instanceof Time) {
            if (!(paramObj[1] instanceof Calendar)) throw TbError.newSQLException(-90846, paramObj[1].toString());
            pstmt.setTime(i + 1, (Time)paramObj[0], (Calendar)paramObj[1]);
            return;
        } else if (paramObj[0] instanceof Timestamp) {
            if (!(paramObj[1] instanceof Calendar)) throw TbError.newSQLException(-90846, paramObj[1].toString());
            pstmt.setTimestamp(i + 1, (Timestamp)paramObj[0], (Calendar)paramObj[1]);
            return;
        } else if (paramObj[0] instanceof Reader) {
            pstmt.setCharacterStream(i + 1, (Reader)paramObj[0], (Integer)paramObj[1]);
            return;
        } else {
            if (!(paramObj[1] instanceof Integer)) return;
            if ((Integer)paramObj[1] == 0) {
                pstmt.setNString(i + 1, (String)paramObj[0]);
                return;
            } else {
                pstmt.setObject(i + 1, paramObj[0], (Integer)paramObj[1]);
            }
        }
    }

    private void setParams3Arg(int i, Object[] paramObj, PreparedStatement pstmt) throws SQLException {
        block23: {
            block25: {
                block24: {
                    block22: {
                        if (paramObj[0] != null) break block22;
                        pstmt.setNull(i + 1, (Integer)paramObj[1], (String)paramObj[2]);
                        break block23;
                    }
                    if (!(paramObj[0] instanceof Reader)) break block24;
                    switch ((Integer)paramObj[2]) {
                        case 6: {
                            if (paramObj[1] instanceof Integer) {
                                pstmt.setClob(i + 1, (Reader)paramObj[0], ((Integer)paramObj[1]).intValue());
                            } else {
                                pstmt.setClob(i + 1, (Reader)paramObj[0], (Long)paramObj[1]);
                            }
                            break block23;
                        }
                        case 3: {
                            if (paramObj[1] instanceof Integer) {
                                pstmt.setCharacterStream(i + 1, (Reader)paramObj[0], (Integer)paramObj[1]);
                            } else {
                                pstmt.setCharacterStream(i + 1, (Reader)paramObj[0], (Long)paramObj[1]);
                            }
                            break block23;
                        }
                        case 4: {
                            if (paramObj[1] instanceof Integer) {
                                pstmt.setNCharacterStream(i + 1, (Reader)paramObj[0], ((Integer)paramObj[1]).intValue());
                            } else {
                                pstmt.setNCharacterStream(i + 1, (Reader)paramObj[0], (Long)paramObj[1]);
                            }
                            break block23;
                        }
                        default: {
                            throw TbError.newSQLException(-90846, ((Integer)paramObj[2]).toString());
                        }
                    }
                }
                if (!(paramObj[0] instanceof InputStream)) break block25;
                switch ((Integer)paramObj[2]) {
                    case 2: {
                        if (paramObj[1] instanceof Integer) {
                            pstmt.setBinaryStream(i + 1, (InputStream)paramObj[0], (Integer)paramObj[1]);
                        } else {
                            pstmt.setBinaryStream(i + 1, (InputStream)paramObj[0], (Long)paramObj[1]);
                        }
                        break block23;
                    }
                    case 1: {
                        pstmt.setAsciiStream(i + 1, (InputStream)paramObj[0], (Integer)paramObj[1]);
                        break block23;
                    }
                    case 5: {
                        if (paramObj[1] instanceof Integer) {
                            pstmt.setBlob(i + 1, (InputStream)paramObj[0], ((Integer)paramObj[1]).intValue());
                        } else {
                            pstmt.setBlob(i + 1, (InputStream)paramObj[0], (Long)paramObj[1]);
                        }
                        break block23;
                    }
                    default: {
                        throw TbError.newSQLException(-90846, ((Integer)paramObj[2]).toString());
                    }
                }
            }
            if (paramObj[1] instanceof Integer && paramObj[2] instanceof Integer) {
                pstmt.setObject(i + 1, paramObj[0], (Integer)paramObj[1], (int)((Integer)paramObj[2]));
            } else {
                throw TbError.newSQLException(-90846, paramObj[0].toString());
            }
        }
    }
}

