/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.ext;

import com.tmax.tibero.Debug;
import com.tmax.tibero.jdbc.TbCallableStatement;
import com.tmax.tibero.jdbc.TbResultSet;
import com.tmax.tibero.jdbc.data.BindItem;
import com.tmax.tibero.jdbc.data.ParamContainer;
import com.tmax.tibero.jdbc.data.TbDate;
import com.tmax.tibero.jdbc.data.TbTimestamp;
import com.tmax.tibero.jdbc.err.TbError;
import com.tmax.tibero.jdbc.ext.TbLogicalConnection;
import com.tmax.tibero.jdbc.ext.TbStatementEventHandler;
import com.tmax.tibero.jdbc.msg.TbPivotInfo;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.sql.PooledConnection;
import javax.sql.StatementEvent;
import javax.sql.StatementEventListener;

public class TbLogicalCallableStatement
extends TbCallableStatement
implements TbStatementEventHandler {
    private TbLogicalConnection logicalConn = null;
    private boolean closed = true;
    protected com.tmax.tibero.jdbc.driver.TbCallableStatement physicalStmt = null;
    protected HashMap<StatementEventListener, StatementEventListener> stmtEventMap = null;

    public TbLogicalCallableStatement(TbLogicalConnection tbLogicalConnection, com.tmax.tibero.jdbc.driver.TbCallableStatement stmt) throws SQLException {
        Debug.logMethod("TbLogicalStatement", new Object[]{this, tbLogicalConnection, stmt});
        this.logicalConn = tbLogicalConnection;
        this.stmtEventMap = this.logicalConn.getStatementEventListeners();
        this.physicalStmt = stmt;
        if (stmt.isClosed()) {
            this.closed = true;
            throw TbError.newSQLException(-90658);
        }
        this.closed = false;
    }

    @Override
    public void addBatch() throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.addBatch", new Object[]{this, this.physicalStmt});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.addBatch();
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.addBatch", new Object[]{this, this.physicalStmt, sql});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.addBatch(sql);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void addPivotData(byte[] data) {
        if (this.physicalStmt != null) {
            this.physicalStmt.addPivotData(data);
        }
    }

    @Override
    public void cancel() throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.cancel", new Object[]{this, this.physicalStmt});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.cancel();
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void clearBatch() throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.clearBatch", new Object[]{this, this.physicalStmt});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        this.physicalStmt.clearBatch();
    }

    @Override
    public void clearParameters() throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.clearParameters", new Object[]{this, this.physicalStmt});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.clearParameters();
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.clearWarnings", new Object[]{this, this.physicalStmt});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.clearWarnings();
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void close() throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.close", new Object[]{this, this.physicalStmt});
        if (this.isClosed()) {
            return;
        }
        this.closed = true;
        this.physicalStmt.resetForCache();
        this.notifyClosedEvent();
    }

    @Override
    public void closeInternal() throws SQLException {
        if (this.physicalStmt != null) {
            this.physicalStmt.closeInternal();
        }
    }

    @Override
    public boolean execute() throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.execute", new Object[]{this});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.execute();
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.execute", new Object[]{this, this.physicalStmt, sql});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.execute(sql);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.execute", new Object[]{this, this.physicalStmt, sql, Integer.toString(autoGeneratedKeys)});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.execute(sql, autoGeneratedKeys);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.execute", new Object[]{this, this.physicalStmt, sql, columnIndexes});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.execute(sql, columnIndexes);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.execute", new Object[]{this, this.physicalStmt, sql, columnNames});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.execute(sql, columnNames);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public int[] executeBatch() throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.executeBatch", new Object[]{this, this.physicalStmt});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.executeBatch();
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.executeQuery", new Object[]{this, this.physicalStmt});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.executeQuery();
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.executeQuery", new Object[]{this, this.physicalStmt, sql});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.executeQuery(sql);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public int executeUpdate() throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.executeUpdate", new Object[]{this});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.executeUpdate();
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.executeUpdate", new Object[]{this, this.physicalStmt, sql});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.executeUpdate(sql);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.executeUpdate", new Object[]{this, this.physicalStmt, sql, Integer.toString(autoGeneratedKeys)});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.executeUpdate(sql, autoGeneratedKeys);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.executeUpdate", new Object[]{this, this.physicalStmt, sql, columnIndexes});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.executeUpdate(sql, columnIndexes);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.executeUpdate", new Object[]{this, this.physicalStmt, sql, columnNames});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.executeUpdate(sql, columnNames);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public Array getArray(int i) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.getArray", new Object[]{this, Integer.toString(i)});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getArray(i);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public Array getArray(String parameterName) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.getArray", new Object[]{this, parameterName});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getArray(parameterName);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public BigDecimal getBigDecimal(int i) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.getBigDecimal", new Object[]{this, Integer.toString(i)});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getBigDecimal(i);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(int i, int scale) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.getBigDecimal", new Object[]{this, Integer.toString(i), Integer.toString(scale)});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getBigDecimal(i, scale);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public BigDecimal getBigDecimal(String parameterName) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.getBigDecimal", new Object[]{this, parameterName});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getBigDecimal(parameterName);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public Blob getBlob(int i) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.getBlob", new Object[]{this, Integer.toString(i)});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getBlob(i);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public Blob getBlob(String parameterName) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.getBlob", new Object[]{this, parameterName});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getBlob(parameterName);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public boolean getBoolean(int i) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.getBoolean", new Object[]{this, Integer.toString(i)});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getBoolean(i);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public boolean getBoolean(String parameterName) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.getBoolean", new Object[]{this, parameterName});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getBoolean(parameterName);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public byte getByte(int i) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.getByte", new Object[]{this, Integer.toString(i)});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getByte(i);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public byte getByte(String parameterName) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.getByte", new Object[]{this, parameterName});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getByte(parameterName);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public byte[] getBytes(int i) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.getBytes", new Object[]{this, Integer.toString(i)});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getBytes(i);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public byte[] getBytes(String parameterName) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.getBytes", new Object[]{this, parameterName});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getBytes(parameterName);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public Reader getCharacterStream(int i) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.getCharacterStream", new Object[]{this, Integer.toString(i)});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getCharacterStream(i);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public Reader getCharacterStream(String parameterName) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.getCharacterStream", new Object[]{this, parameterName});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getCharacterStream(parameterName);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public Clob getClob(int i) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.getClob", new Object[]{this, Integer.toString(i)});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getClob(i);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public Clob getClob(String parameterName) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.getClob", new Object[]{this, parameterName});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getClob(parameterName);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.getConnection", new Object[]{this, this.physicalStmt});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        return this.logicalConn;
    }

    @Override
    public Date getDate(int i) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.getDate", new Object[]{this, Integer.toString(i)});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getDate(i);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public Date getDate(int i, Calendar cal) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.getDate", new Object[]{this, Integer.toString(i), cal});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getDate(i, cal);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public Date getDate(String parameterName) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.getDate", new Object[]{this, parameterName});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getDate(parameterName);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public Date getDate(String parameterName, Calendar cal) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.getDate", new Object[]{this, parameterName, cal});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getDate(parameterName, cal);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public double getDouble(int i) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.getDouble", new Object[]{this, Integer.toString(i)});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getDouble(i);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public double getDouble(String parameterName) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.getDouble", new Object[]{this, parameterName});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getDouble(parameterName);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.getFetchDirection", new Object[]{this, this.physicalStmt});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getFetchDirection();
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public int getFetchSize() throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.getFetchDirection", new Object[]{this, this.physicalStmt});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getFetchDirection();
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public float getFloat(int i) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.getFloat", new Object[]{this, Integer.toString(i)});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getFloat(i);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public float getFloat(String parameterName) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.getFloat", new Object[]{this, parameterName});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getFloat(parameterName);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.getGeneratedKeys", new Object[]{this, this.physicalStmt});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getGeneratedKeys();
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public int getInt(int i) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.getInt", new Object[]{this, Integer.toString(i)});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getInt(i);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public int getInt(String parameterName) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.getInt", new Object[]{this, parameterName});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getInt(parameterName);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public long getLong(int i) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.getLong", new Object[]{this, Integer.toString(i)});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getLong(i);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public long getLong(String parameterName) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.getLong", new Object[]{this, parameterName});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getLong(parameterName);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.getMaxFieldSize", new Object[]{this, this.physicalStmt});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getMaxFieldSize();
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public int getMaxRows() throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.getMaxRows", new Object[]{this, this.physicalStmt});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getMaxRows();
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.getMetaData", new Object[]{this, this.physicalStmt});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getMetaData();
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.getMoreResults", new Object[]{this, this.physicalStmt});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getMoreResults();
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.getMoreResults", new Object[]{this, this.physicalStmt});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getMoreResults();
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public Reader getNCharacterStream(int i) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.getNCharacterStream", new Object[]{this, Integer.toString(i)});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getNCharacterStream(i);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public Reader getNCharacterStream(String parameterName) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.getNCharacterStream", new Object[]{this, parameterName});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getNCharacterStream(parameterName);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public NClob getNClob(int i) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.getNClob", new Object[]{this, Integer.toString(i)});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getNClob(i);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public NClob getNClob(String parameterName) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.getNClob", new Object[]{this, parameterName});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getNClob(parameterName);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public String getNString(int i) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.getNString", new Object[]{this, Integer.toString(i)});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getNString(i);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public String getNString(String parameterName) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.getNString", new Object[]{this, parameterName});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getNString(parameterName);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public Object getObject(int i) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.getObject", new Object[]{this, Integer.toString(i)});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getObject(i);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public Object getObject(int i, Map<String, Class<?>> map) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.getObject", new Object[]{this, Integer.toString(i), map});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getObject(i, map);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public Object getObject(String parameterName) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.getObject", new Object[]{this, parameterName});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getObject(parameterName);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public Object getObject(String parameterName, Map<String, Class<?>> map) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.getObject", new Object[]{this, parameterName});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getObject(parameterName);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public String getOriginalSql() {
        if (this.physicalStmt != null) {
            return this.physicalStmt.getOriginalSql();
        }
        return null;
    }

    @Override
    public BindItem getOutItems(int i) {
        if (this.physicalStmt != null) {
            return this.physicalStmt.getOutItems(i);
        }
        return null;
    }

    @Override
    public ParamContainer getParamContainer() {
        if (this.physicalStmt != null) {
            return this.physicalStmt.getParamContainer();
        }
        return null;
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.getParameterMetaData", new Object[]{this, this.physicalStmt});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getParameterMetaData();
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public Vector<byte[]> getPivotData() {
        if (this.physicalStmt != null) {
            return this.physicalStmt.getPivotData();
        }
        return null;
    }

    @Override
    public Vector<byte[]> getPivotData(int paramIndex) throws SQLException {
        if (this.physicalStmt != null) {
            return this.physicalStmt.getPivotData(paramIndex);
        }
        return null;
    }

    @Override
    public TbPivotInfo[] getPivotInfo() {
        if (this.physicalStmt != null) {
            return this.physicalStmt.getPivotInfo();
        }
        return null;
    }

    @Override
    public TbPivotInfo[] getPivotInfo(int paramIndex) throws SQLException {
        if (this.physicalStmt != null) {
            return this.physicalStmt.getPivotInfo(paramIndex);
        }
        return null;
    }

    @Override
    public byte[] getPPID() {
        if (this.physicalStmt != null) {
            return this.physicalStmt.getPPID();
        }
        return null;
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.getQueryTimeout", new Object[]{this, this.physicalStmt});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getQueryTimeout();
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public Ref getRef(int i) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.getRef", new Object[]{this, Integer.toString(i)});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getRef(i);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public Ref getRef(String parameterName) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.getRef", new Object[]{this, parameterName});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getRef(parameterName);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.getResultSet", new Object[]{this, this.physicalStmt});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getResultSet();
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.getResultSetConcurrency", new Object[]{this, this.physicalStmt});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        return this.physicalStmt.getResultSetConcurrency();
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.getResultSetHoldability", new Object[]{this, this.physicalStmt});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getResultSetHoldability();
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public int getResultSetType() throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.getResultSetType", new Object[]{this, this.physicalStmt});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getResultSetType();
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public RowId getRowId(int i) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.getRowId", new Object[]{this, Integer.toString(i)});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getRowId(i);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public RowId getRowId(String parameterName) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.getRowId", new Object[]{this, parameterName});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getRowId(parameterName);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public short getShort(int i) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.getShort", new Object[]{this, Integer.toString(i)});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getShort(i);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public short getShort(String parameterName) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.getShort", new Object[]{this, parameterName});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getShort(parameterName);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public int getSqlType() {
        if (this.physicalStmt != null) {
            return this.physicalStmt.getSqlType();
        }
        return 0;
    }

    @Override
    public SQLXML getSQLXML(int i) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.getSQLXML", new Object[]{this, Integer.toString(i)});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getSQLXML(i);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public SQLXML getSQLXML(String parameterName) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.getSQLXML", new Object[]{this, parameterName});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getSQLXML(parameterName);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public String getString(int i) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.getString", new Object[]{this, Integer.toString(i)});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getString(i);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public String getString(String parameterName) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.getString", new Object[]{this, parameterName});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getString(parameterName);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public Struct getStruct(int i) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.getStruct", new Object[]{this, Integer.toString(i)});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getStruct(i);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public TbDate getTbDate(int i) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.getTbDate", new Object[]{this, Integer.toString(i)});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getTbDate(i);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public TbDate getTbDate(String parameterName) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.getTbDate", new Object[]{this, parameterName});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getTbDate(parameterName);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public TbTimestamp getTbTimestamp(int i) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.getTbTimestamp", new Object[]{this, Integer.toString(i)});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getTbTimestamp(i);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public TbTimestamp getTbTimestamp(String parameterName) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.getTbTimestamp", new Object[]{this, parameterName});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getTbTimestamp(parameterName);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public Time getTime(int i) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.getTime", new Object[]{this, Integer.toString(i)});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getTime(i);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public Time getTime(int i, Calendar cal) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.getTime", new Object[]{this, Integer.toString(i), cal});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getTime(i, cal);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public Time getTime(String parameterName) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.getTime", new Object[]{this, parameterName});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getTime(parameterName);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public Time getTime(String parameterName, Calendar cal) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.getTime", new Object[]{this, parameterName, cal});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getTime(parameterName, cal);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public Timestamp getTimestamp(int i) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.getTimestamp", new Object[]{this, Integer.toString(i)});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getTimestamp(i);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public Timestamp getTimestamp(int i, Calendar cal) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.getTimestamp", new Object[]{this, Integer.toString(i), cal});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getTimestamp(i, cal);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public Timestamp getTimestamp(String parameterName) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.getTimestamp", new Object[]{this, parameterName});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getTimestamp(parameterName);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public Timestamp getTimestamp(String parameterName, Calendar cal) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.getTimestamp", new Object[]{this, parameterName, cal});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getTimestamp(parameterName, cal);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public int getUpdateCount() throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.getUpdateCount", new Object[]{this, this.physicalStmt});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getUpdateCount();
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public URL getURL(int i) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.getURL", new Object[]{this, Integer.toString(i)});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getURL(i);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public URL getURL(String parameterName) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.getURL", new Object[]{this, parameterName});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getURL(parameterName);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.getWarnings", new Object[]{this, this.physicalStmt});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getWarnings();
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    @Override
    public boolean isPoolable() throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.isPoolable", new Object[]{this, this.physicalStmt});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.isPoolable();
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.isWrapperFor", new Object[]{this, this.physicalStmt, iface});
        return iface.isInstance(this);
    }

    @Override
    public void notifyClosedEvent() {
        Debug.logMethod("TbLogicalCallableStatement.notifyClosedEvent", new Object[]{this});
        if (this.physicalStmt != null && this.stmtEventMap != null) {
            Iterator<StatementEventListener> itr = this.stmtEventMap.keySet().iterator();
            while (itr.hasNext()) {
                StatementEventListener listener = this.stmtEventMap.get(itr.next());
                listener.statementClosed(new StatementEvent((PooledConnection)((Object)this.logicalConn.getEventHandler()), this));
            }
        }
    }

    @Override
    public void notifyExceptionEvent(PreparedStatement ps, Exception e) {
        Debug.logMethod("TbLogicalCallableStatement.notifyExceptionEvent", new Object[]{this, e});
        if (this.physicalStmt != null && this.stmtEventMap != null) {
            Iterator<StatementEventListener> itr = this.stmtEventMap.keySet().iterator();
            while (itr.hasNext()) {
                StatementEventListener listener = this.stmtEventMap.get(itr.next());
                listener.statementErrorOccurred(new StatementEvent((PooledConnection)((Object)this.logicalConn.getEventHandler()), this, (SQLException)e));
            }
        }
    }

    @Override
    public void registerOutParameter(int i, int sqlType) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.registerOutParameter", new Object[]{this, Integer.toString(i), Integer.toString(sqlType)});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.registerOutParameter(i, sqlType);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void registerOutParameter(int i, int sqlType, int scale) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.registerOutParameter", new Object[]{this, Integer.toString(i), Integer.toString(sqlType), Integer.toString(scale)});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.registerOutParameter(i, sqlType, scale);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void registerOutParameter(int i, int sqlType, String typeName) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.registerOutParameter", new Object[]{this, Integer.toString(i), Integer.toString(sqlType), typeName});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.registerOutParameter(i, sqlType, typeName);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.registerOutParameter", new Object[]{this, parameterName, Integer.toString(sqlType)});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.registerOutParameter(parameterName, sqlType);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType, int scale) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.registerOutParameter", new Object[]{this, parameterName, Integer.toString(sqlType), Integer.toString(scale)});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.registerOutParameter(parameterName, sqlType, scale);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType, String typeName) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.registerOutParameter", new Object[]{this, parameterName, Integer.toString(sqlType), typeName});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.registerOutParameter(parameterName, sqlType, typeName);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void resetForCache() {
        if (this.physicalStmt != null) {
            this.physicalStmt.resetForCache();
        }
    }

    @Override
    public void setArray(int parameterIndex, Array x) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.setArray", new Object[]{this, this.physicalStmt});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setArray(parameterIndex, x);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setAsciiStream(int i, InputStream x) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.setAsciiStream", new Object[]{this, Integer.toString(i), x});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setAsciiStream(i, x);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setAsciiStream(int i, InputStream x, int length) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.setAsciiStream", new Object[]{this, Integer.toString(i), x, Integer.toString(length)});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setAsciiStream(i, x, length);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setAsciiStream(int i, InputStream x, long length) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.setAsciiStream", new Object[]{this, Integer.toString(i), x, Long.toString(length)});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setAsciiStream(i, x, length);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.setAsciiStream", new Object[]{this, parameterName, x});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setAsciiStream(parameterName, x);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x, int length) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.setAsciiStream", new Object[]{this, parameterName, x, Integer.toString(length)});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setAsciiStream(parameterName, x, length);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x, long length) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.setAsciiStream", new Object[]{this, parameterName, x, Long.toString(length)});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setAsciiStream(parameterName, x, length);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setBigDecimal(int i, BigDecimal x) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.setBigDecimal", new Object[]{this, Integer.toString(i), x});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setBigDecimal(i, x);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setBigDecimal(String parameterName, BigDecimal x) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.setBigDecimal", new Object[]{this, parameterName, x});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setBigDecimal(parameterName, x);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setBinaryDouble(int i, double x) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.setBinaryDouble", new Object[]{this, this.physicalStmt, Integer.toString(i), Long.toHexString(Double.doubleToLongBits(x))});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setBinaryDouble(i, x);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setBinaryFloat(int i, float x) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.setBinaryFloat", new Object[]{this, this.physicalStmt, Integer.toString(i), Long.toHexString(Float.floatToIntBits(x))});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setBinaryFloat(i, x);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setBinaryStream(int i, InputStream x) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.setBinaryStream", new Object[]{this, Integer.toString(i), x});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setBinaryStream(i, x);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setBinaryStream(int i, InputStream x, int length) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.setBinaryStream", new Object[]{this, Integer.toString(i), x, Integer.toString(length)});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setBinaryStream(i, x, length);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setBinaryStream(int i, InputStream x, long length) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.setBinaryStream", new Object[]{this, x, Long.toString(length)});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setBinaryStream(i, x, length);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.setBinaryStream", new Object[]{this, parameterName, x});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setBinaryStream(parameterName, x);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x, int length) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.setBinaryStream", new Object[]{this, parameterName, x, Integer.toString(length)});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setBinaryStream(parameterName, x, length);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x, long length) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.setBinaryStream", new Object[]{this, parameterName, x, Long.toString(length)});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setBinaryStream(parameterName, x, length);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setBlob(int i, Blob x) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.setBlob", new Object[]{this, Integer.toString(i), x});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setBlob(i, x);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setBlob(int i, InputStream x) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.setBlob", new Object[]{this, Integer.toString(i), x});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setBlob(i, x);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setBlob(int i, InputStream x, long length) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.setBlob", new Object[]{this, Integer.toString(i), x, Long.toString(length)});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setBlob(i, x, length);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setBlob(String parameterName, Blob x) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.setBlob", new Object[]{this, parameterName, x});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setBlob(parameterName, x);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setBlob(String parameterName, InputStream x) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.setBlob", new Object[]{this, parameterName, x});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setBlob(parameterName, x);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setBlob(String parameterName, InputStream x, long length) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.setBlob", new Object[]{this, parameterName, x, Long.toString(length)});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setBlob(parameterName, x, length);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setBoolean(int i, boolean x) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.setBoolean", new Object[]{this, Integer.toString(i), new Boolean(x)});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setBoolean(i, x);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setBoolean(String parameterName, boolean x) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.setBoolean", new Object[]{this, parameterName, new Boolean(x)});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setBoolean(parameterName, x);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setByte(int i, byte x) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.setByte", new Object[]{this, Integer.toString(i), Byte.toString(x)});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setByte(i, x);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setByte(String parameterName, byte x) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.setByte", new Object[]{this, parameterName, Byte.toString(x)});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setByte(parameterName, x);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setBytes(int i, byte[] x) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.setBytes", new Object[]{this, Integer.toString(i), x});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setBytes(i, x);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setBytes(int i, int dataType, byte[] x) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.setBytes", new Object[]{this, this.physicalStmt, Integer.toString(i), Integer.toString(dataType), x});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setBytes(i, dataType, x);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setBytes(String parameterName, byte[] x) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.setBytes", new Object[]{this, parameterName, x});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setBytes(parameterName, x);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setCharacterStream(int i, Reader reader) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.setCharacterStream", new Object[]{this, Integer.toString(i), reader});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setCharacterStream(i, reader);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setCharacterStream(int i, Reader reader, int length) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.setCharacterStream", new Object[]{this, Integer.toString(i), reader, Integer.toString(length)});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setCharacterStream(i, reader, length);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setCharacterStream(int i, Reader reader, long length) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.setCharacterStream", new Object[]{this, Integer.toString(i), reader, Long.toString(length)});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setCharacterStream(i, reader, length);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.setCharacterStream", new Object[]{this, parameterName, reader});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setCharacterStream(parameterName, reader);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader, int length) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.setCharacterStream", new Object[]{this, parameterName, reader, Integer.toString(length)});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setCharacterStream(parameterName, reader, length);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader, long length) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.setCharacterStream", new Object[]{this, parameterName, reader, Long.toString(length)});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setCharacterStream(parameterName, reader, length);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setClob(int i, Clob x) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.setClob", new Object[]{this, Integer.toString(i), x});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setClob(i, x);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setClob(int i, Reader reader) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.setClob", new Object[]{this, Integer.toString(i), reader});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setClob(i, reader);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setClob(int i, Reader reader, long length) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.setClob", new Object[]{this, Integer.toString(i), reader, Long.toString(length)});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setClob(i, reader, length);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setClob(String parameterName, Clob x) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.setClob", new Object[]{this, parameterName, x});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setClob(parameterName, x);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setClob(String parameterName, Reader reader) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.setClob", new Object[]{this, parameterName, reader});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setClob(parameterName, reader);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setClob(String parameterName, Reader reader, long length) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.setClob", new Object[]{this, parameterName, reader, Long.toString(length)});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setClob(parameterName, reader, length);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.setCursorName", new Object[]{this, this.physicalStmt, name});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setCursorName(name);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setDate(int i, Date x) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.setDate", new Object[]{this, Integer.toString(i), x});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setDate(i, x);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setDate(int i, Date x, Calendar cal) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.setDate", new Object[]{this, Integer.toString(i), x, cal});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setDate(i, x, cal);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setDate(String parameterName, Date x) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.setDate", new Object[]{this, parameterName, x});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setDate(parameterName, x);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setDate(String parameterName, Date x, Calendar cal) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.setDate", new Object[]{this, parameterName, x, cal});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setDate(parameterName, x, cal);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setDouble(int i, double x) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.setDouble", new Object[]{this, Integer.toString(i), Double.toString(x)});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setDouble(i, x);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setDouble(String parameterName, double x) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.setDouble", new Object[]{this, parameterName, Double.toString(x)});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setDouble(parameterName, x);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.setEscapeProcessing", new Object[]{this, this.physicalStmt, new Boolean(enable)});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setEscapeProcessing(enable);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.setFetchDirection", new Object[]{this, this.physicalStmt, Integer.toString(direction)});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setFetchDirection(direction);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.setFetchSize", new Object[]{this, this.physicalStmt, Integer.toString(rows)});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setFetchSize(rows);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setFixedCHAR(int i, String x) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.setFixedCHAR", new Object[]{this, Integer.toString(i), x});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setFixedCHAR(i, x);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setFloat(int i, float x) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.setFloat", new Object[]{this, Integer.toString(i), Float.toString(x)});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setFloat(i, x);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setFloat(String parameterName, float x) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.setFloat", new Object[]{this, parameterName, Float.toString(x)});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setFloat(parameterName, x);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setInt(int i, int x) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.setInt", new Object[]{this, Integer.toString(i), Integer.toString(x)});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setInt(i, x);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setInt(String parameterName, int x) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.setInt", new Object[]{this, parameterName, Integer.toString(x)});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setInt(parameterName, x);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setLong(int i, long x) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.setLong", new Object[]{this, Integer.toString(i), Long.toString(x)});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setLong(i, x);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setLong(String parameterName, long x) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.setLong", new Object[]{this, parameterName, Long.toString(x)});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setLong(parameterName, x);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.setMaxFieldSize", new Object[]{this, this.physicalStmt, Integer.toString(max)});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setMaxFieldSize(max);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.setMaxRows", new Object[]{this, this.physicalStmt, Integer.toString(max)});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setMaxRows(max);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setNCharacterStream(int i, Reader reader) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.setNCharacterStream", new Object[]{this, Integer.toString(i), reader});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setNCharacterStream(i, reader);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setNCharacterStream(int i, Reader reader, long length) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.setNCharacterStream", new Object[]{this, Integer.toString(i), reader, Long.toString(length)});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setNCharacterStream(i, reader, length);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setNCharacterStream(String parameterName, Reader reader) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.setNCharacterStream", new Object[]{this, parameterName, reader});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setNCharacterStream(parameterName, reader);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setNCharacterStream(String parameterName, Reader reader, long length) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.setNCharacterStream", new Object[]{this, parameterName, reader, Long.toString(length)});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setNCharacterStream(parameterName, reader, length);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setNClob(int i, Clob x) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.setNClob", new Object[]{this, this.physicalStmt, Integer.toString(i), x});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setNClob(i, x);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setNClob(int i, NClob x) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.setNClob", new Object[]{this, Integer.toString(i), x});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setNClob(i, x);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setNClob(int i, Reader reader) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.setNClob", new Object[]{this, Integer.toString(i), reader});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setNClob(i, reader);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setNClob(int i, Reader reader, long length) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.setNClob", new Object[]{this, Integer.toString(i), reader, Long.toString(length)});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setNClob(i, reader, length);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setNClob(String parameterName, NClob x) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.setNClob", new Object[]{this, parameterName, x});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setNClob(parameterName, x);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setNClob(String parameterName, Reader reader) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.setNClob", new Object[]{this, parameterName, reader});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setNClob(parameterName, reader);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setNClob(String parameterName, Reader reader, long length) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.setNClob", new Object[]{this, parameterName, reader, Long.toString(length)});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setNClob(parameterName, reader, length);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setNString(int i, String value) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.setNString", new Object[]{this, Integer.toString(i), value});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setNString(i, value);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setNString(String parameterName, String value) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.setNString", new Object[]{this, parameterName, value});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setNString(parameterName, value);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setNull(int i, int sqlType) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.setNull", new Object[]{this, Integer.toString(i), Integer.toString(sqlType)});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setNull(i, sqlType);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setNull(int i, int sqlType, String typeName) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.setNull", new Object[]{this, Integer.toString(i), Integer.toString(sqlType), typeName});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setNull(i, sqlType, typeName);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setNull(String parameterName, int sqlType) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.setNull", new Object[]{this, parameterName, Integer.toString(sqlType)});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setNull(parameterName, sqlType);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setNull(String parameterName, int sqlType, String typeName) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.setNull", new Object[]{this, parameterName, Integer.toString(sqlType), typeName});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setNull(parameterName, sqlType, typeName);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setObject(int i, Object x) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.setObject", new Object[]{this, Integer.toString(i), x});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setObject(i, x);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setObject(int i, Object x, int targetSqlType) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.setObject", new Object[]{this, Integer.toString(i), x, Integer.toString(targetSqlType)});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setObject(i, x, targetSqlType);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setObject(int i, Object x, int targetSqlType, int scale) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.setObject", new Object[]{this, Integer.toString(i), x, Integer.toString(targetSqlType), Integer.toString(scale)});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setObject(i, x, targetSqlType, scale);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setObject(String parameterName, Object x) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.setObject", new Object[]{this, parameterName, x});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setObject(parameterName, x);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setObject(String parameterName, Object x, int targetSqlType) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.setObject", new Object[]{this, parameterName, x, Integer.toString(targetSqlType)});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setObject(parameterName, x, targetSqlType);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setObject(String parameterName, Object x, int targetSqlType, int scale) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.setObject", new Object[]{this, parameterName, x, Integer.toString(targetSqlType), Integer.toString(scale)});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setObject(parameterName, x, targetSqlType, scale);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setOutParam(int i, int dataType, byte[] x, TbResultSet prefetchedRs) throws SQLException {
        if (this.physicalStmt != null) {
            this.physicalStmt.setOutParam(i, dataType, x, prefetchedRs);
        }
    }

    @Override
    public void setPivotInfo(TbPivotInfo[] info) {
        if (this.physicalStmt != null) {
            this.physicalStmt.setPivotInfo(info);
        }
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.setPoolable", new Object[]{this, this.physicalStmt, new Boolean(poolable)});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setPoolable(poolable);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.setQueryTimeout", new Object[]{this, this.physicalStmt, Integer.toString(seconds)});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setQueryTimeout(seconds);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setRef(int i, Ref x) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.setRef", new Object[]{this, Integer.toString(i), x});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setRef(i, x);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setRowId(int i, RowId x) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.setRowId", new Object[]{this, Integer.toString(i), x});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setRowId(i, x);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setRowId(String parameterName, RowId x) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.setRowId", new Object[]{this, parameterName, x});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setRowId(parameterName, x);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setShort(int i, short x) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.setShort", new Object[]{this, Integer.toString(i), Short.toString(x)});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setShort(i, x);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setShort(String parameterName, short x) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.setShort", new Object[]{this, parameterName, Short.toString(x)});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setShort(parameterName, x);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setSQLXML(int i, SQLXML xmlObject) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.setSQLXML", new Object[]{this, Integer.toString(i), xmlObject});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setSQLXML(i, xmlObject);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setSQLXML(String parameterName, SQLXML xmlObject) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.setSQLXML", new Object[]{this, parameterName, xmlObject});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setSQLXML(parameterName, xmlObject);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setString(int i, String x) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.setString", new Object[]{this, Integer.toString(i), x});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setString(i, x);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setString(String parameterName, String x) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.setString", new Object[]{this, parameterName, x});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setString(parameterName, x);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setTbDate(int i, TbDate x) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.setTbDate", new Object[]{this, this.physicalStmt, Integer.toString(i), x});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setTbDate(i, x);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setTbDate(String parameterName, TbDate x) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.setTbDate", new Object[]{this, this.physicalStmt, parameterName, x});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setTbDate(parameterName, x);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setTbTimestamp(int i, TbTimestamp x) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.setTbTimestamp", new Object[]{this, this.physicalStmt, Integer.toString(i), x});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setTbTimestamp(i, x);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setTbTimestamp(String parameterName, TbTimestamp x) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.setTbTimestamp", new Object[]{this, this.physicalStmt, parameterName, x});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setTbTimestamp(parameterName, x);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setTime(int i, Time x) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.setTime", new Object[]{this, Integer.toString(i), x});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setTime(i, x);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setTime(int i, Time x, Calendar cal) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.setTime", new Object[]{this, Integer.toString(i), x, cal});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setTime(i, x, cal);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setTime(String parameterName, Time x) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.setTime", new Object[]{this, parameterName, x});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setTime(parameterName, x);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setTime(String parameterName, Time x, Calendar cal) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.setTime", new Object[]{this, parameterName, x, cal});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setTime(parameterName, x, cal);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setTimestamp(int i, Timestamp x) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.setTimestamp", new Object[]{this, Integer.toString(i), x});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setTimestamp(i, x);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setTimestamp(int i, Timestamp x, Calendar cal) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.setTimestamp", new Object[]{this, Integer.toString(i), x, cal});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setTimestamp(i, x, cal);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setTimestamp(String parameterName, Timestamp x) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.setTimestamp", new Object[]{this, parameterName, x});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setTimestamp(parameterName, x);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setTimestamp(String parameterName, Timestamp x, Calendar cal) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.setTimestamp", new Object[]{this, parameterName, x, cal});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setTimestamp(parameterName, x, cal);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    @Deprecated
    public void setUnicodeStream(int i, InputStream x, int length) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.setUnicodeStream", new Object[]{this, Integer.toString(i), x, Integer.toString(length)});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setUnicodeStream(i, x, length);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    @Deprecated
    public void setUnicodeStream(String parameterName, InputStream x, int length) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.setUnicodeStream", new Object[]{this, parameterName, x, Integer.toString(length)});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setUnicodeStream(parameterName, x, length);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setURL(int i, URL url) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.setURL", new Object[]{this, Integer.toString(i), url});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setURL(i, url);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setURL(String parameterName, URL url) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.setURL", new Object[]{this, parameterName, url});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setURL(parameterName, url);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.unwrap", new Object[]{this, this.physicalStmt, iface});
        try {
            return iface.cast(this);
        }
        catch (ClassCastException e) {
            throw TbError.newSQLException(-90657);
        }
    }

    @Override
    public boolean wasNull() throws SQLException {
        Debug.logMethod("TbLogicalCallableStatement.registerOutParameter", new Object[]{this});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.wasNull();
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }
}

