/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.ext;

import com.tmax.tibero.Debug;
import com.tmax.tibero.jdbc.ext.TbConnectionPoolDataSource;
import com.tmax.tibero.jdbc.ext.TbDataSource;
import com.tmax.tibero.jdbc.ext.TbXADataSource;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;

public class TbDataSourceFactory
implements ObjectFactory {
    private static String TB_DATASOURCE = "com.tmax.tibero.jdbc.ext.TbDataSource";
    private static String TB_CONN_POOL_DATASOURCE = "com.tmax.tibero.jdbc.ext.TbConnectionPoolDataSource";
    private static String TB_XA_DATASOURCE = "com.tmax.tibero.jdbc.ext.TbXADataSource";

    public Object getObjectInstance(Object obj, Name name, Context context, Hashtable props) throws Exception {
        Debug.logMethod("TbDataSourceFactory.getObjectInstance", new Object[]{obj, name, context, props});
        if (obj == null) {
            return null;
        }
        Reference ref = (Reference)obj;
        String className = ref.getClassName();
        TbDataSource ds = null;
        if (TB_DATASOURCE.equals(className)) {
            ds = new TbDataSource();
        } else if (TB_CONN_POOL_DATASOURCE.equals(className)) {
            ds = new TbConnectionPoolDataSource();
        } else if (TB_XA_DATASOURCE.equals(className)) {
            ds = new TbXADataSource();
        } else {
            return null;
        }
        StringRefAddr strRef = null;
        strRef = (StringRefAddr)ref.get("userName");
        if (strRef != null || (strRef = (StringRefAddr)ref.get("user")) != null || (strRef = (StringRefAddr)ref.get("u")) != null) {
            ds.setUser((String)strRef.getContent());
        }
        if ((strRef = (StringRefAddr)ref.get("password")) != null || (strRef = (StringRefAddr)ref.get("passWord")) != null) {
            ds.setPassword((String)strRef.getContent());
        }
        if ((strRef = (StringRefAddr)ref.get("tdu")) != null) {
            ds.setTdu(Integer.parseInt((String)strRef.getContent()));
        }
        if ((strRef = (StringRefAddr)ref.get("databaseName")) != null || (strRef = (StringRefAddr)ref.get("sid")) != null) {
            ds.setDatabaseName((String)strRef.getContent());
        }
        if ((strRef = (StringRefAddr)ref.get("description")) != null || (strRef = (StringRefAddr)ref.get("describe")) != null) {
            ds.setDescription((String)strRef.getContent());
        }
        if ((strRef = (StringRefAddr)ref.get("dataSourceName")) != null) {
            ds.setDataSourceName((String)strRef.getContent());
        }
        if ((strRef = (StringRefAddr)ref.get("url")) != null || (strRef = (StringRefAddr)ref.get("Url")) != null) {
            ds.setURL((String)strRef.getContent());
        } else {
            strRef = (StringRefAddr)ref.get("networkProtocol");
            if (strRef != null || (strRef = (StringRefAddr)ref.get("protocol")) != null) {
                ds.setNetworkProtocol((String)strRef.getContent());
            }
            if ((strRef = (StringRefAddr)ref.get("serverName")) != null || (strRef = (StringRefAddr)ref.get("host")) != null) {
                ds.setServerName((String)strRef.getContent());
            }
            if ((strRef = (StringRefAddr)ref.get("portNumber")) != null || (strRef = (StringRefAddr)ref.get("port")) != null) {
                ds.setPortNumber(Integer.parseInt((String)strRef.getContent()));
            }
        }
        Properties otherProps = new Properties();
        strRef = (StringRefAddr)ref.get("failover");
        if (strRef != null) {
            otherProps.setProperty("failover", (String)strRef.getContent());
        }
        if ((strRef = (StringRefAddr)ref.get("load_balance")) != null) {
            otherProps.setProperty("load_balance", (String)strRef.getContent());
        }
        if ((strRef = (StringRefAddr)ref.get("failover_retry_count")) != null) {
            otherProps.setProperty("failover_retry_count", (String)strRef.getContent());
        }
        if ((strRef = (StringRefAddr)ref.get("characterset")) != null) {
            otherProps.setProperty("characterset", (String)strRef.getContent());
        }
        if ((strRef = (StringRefAddr)ref.get("statement_cache")) != null) {
            otherProps.setProperty("statement_cache", (String)strRef.getContent());
        }
        if ((strRef = (StringRefAddr)ref.get("statement_cache_max_size")) != null) {
            otherProps.setProperty("statement_cache_max_size", (String)strRef.getContent());
        }
        if ((strRef = (StringRefAddr)ref.get("lobChunkMaxSize")) != null) {
            otherProps.setProperty("lobChunkMaxSize", (String)strRef.getContent());
        }
        if ((strRef = (StringRefAddr)ref.get("includeSynonyms")) != null) {
            otherProps.setProperty("includeSynonyms", (String)strRef.getContent());
        }
        if ((strRef = (StringRefAddr)ref.get("mapDateToTimestamp")) != null) {
            otherProps.setProperty("mapDateToTimestamp", (String)strRef.getContent());
        }
        if ((strRef = (StringRefAddr)ref.get("defaultNChar")) != null) {
            otherProps.setProperty("defaultNChar", (String)strRef.getContent());
        }
        if ((strRef = (StringRefAddr)ref.get("nls_datetime_format_enabled")) != null) {
            otherProps.setProperty("nls_datetime_format_enabled", (String)strRef.getContent());
        }
        ds.setConnectionProperties(otherProps);
        return ds;
    }
}

