/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.driver;

import com.tmax.tibero.Debug;
import com.tmax.tibero.jdbc.data.BigLiteral;
import com.tmax.tibero.jdbc.data.DataTypeConverter;
import com.tmax.tibero.jdbc.data.RsetType;
import com.tmax.tibero.jdbc.driver.TbConnection;
import com.tmax.tibero.jdbc.driver.TbPreparedStatement;
import com.tmax.tibero.jdbc.driver.TbResultSet;
import com.tmax.tibero.jdbc.driver.TbResultSetBase;
import com.tmax.tibero.jdbc.driver.TbResultSetFactory;
import com.tmax.tibero.jdbc.err.TbError;
import com.tmax.tibero.jdbc.msg.TbPivotInfo;
import com.tmax.tibero.jdbc.util.TbSQLParser;
import com.tmax.tibero.jdbc.util.TbSQLTypeScanner;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class TbStatement
extends com.tmax.tibero.jdbc.TbStatement {
    protected int queryTimeout = 0;
    protected int fetchDirection = 1000;
    protected int maxRow = 0;
    protected int sqlType = 0;
    protected TbConnection conn;
    protected DataTypeConverter typeConverter;
    protected RsetType userRsetType;
    protected RsetType realRsetType;
    protected String originalSql;
    protected String sqlWithRowId;
    protected boolean rsetTypeDowngraded;
    protected SQLWarning warnings;
    protected TbSQLTypeScanner sqlTypeScanner;
    protected boolean enableEscapeProcessing = true;
    private boolean closed;
    protected boolean isExecuting;
    protected List<String> batchStmts;
    protected int[] batchCounts;
    protected TbResultSet currentRs;
    protected ArrayList<TbResultSet> subResultSets;
    protected int rowsUpdated = -1;
    protected boolean noMoreUpdateCount;
    protected int curCsrId = -1;
    protected int maxFieldSize = 65535;
    protected int preFetchSize;
    protected int fetchSize = this.preFetchSize = 64000;
    protected TbPivotInfo[] pivotInfo;
    protected Vector<byte[]> pivotData = new Vector();
    protected boolean returnAutoGeneratedKeys = false;
    protected boolean poolable;
    private TbSQLParser sqlParser;

    public TbStatement(TbConnection conn) {
        this(conn, 1003, 1007, 64000);
    }

    public TbStatement(TbConnection conn1, int rsetType, int rsetConcur, int size) {
        Debug.logMethod("TbStatement", new Object[]{this});
        this.conn = conn1;
        this.typeConverter = conn1.typeConverter;
        this.userRsetType = RsetType.getRsetType(rsetType, rsetConcur);
        this.preFetchSize = size;
        this.fetchSize = size;
        this.closed = false;
        this.isExecuting = false;
        this.subResultSets = new ArrayList();
        this.poolable = conn1.info.isStmtCache();
        this.rsetTypeDowngraded = false;
        this.sqlParser = new TbSQLParser();
    }

    @Override
    public synchronized void addBatch(String sql) throws SQLException {
        Debug.logMethod("TbStatement.addBatch", new Object[]{this});
        if (this.batchStmts == null) {
            this.batchStmts = new ArrayList<String>();
        }
        this.batchStmts.add(sql);
    }

    @Override
    public void addPivotData(byte[] data) {
        this.pivotData.add(data);
    }

    public void addWarning(SQLWarning warning) {
        if (this.warnings != null) {
            this.warnings.setNextWarning(warning);
        } else {
            this.warnings = warning;
        }
    }

    @Override
    public void cancel() throws SQLException {
        Debug.logMethod("TbStatement.cancel", new Object[]{this});
        if (this.closed || this.conn == null || this.conn.isClosed()) {
            return;
        }
        if (this.isExecuting) {
            this.conn.getTbComm().cancelStatement();
        }
    }

    protected void checkBatchStmtRemained() throws SQLException {
        if (this.batchStmts.size() > 0) {
            throw TbError.newSQLException(-90606);
        }
    }

    protected void checkConnectionOpen() throws SQLException {
        if (this.conn == null || this.conn.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
    }

    @Override
    public synchronized void clearBatch() throws SQLException {
        Debug.logMethod("TbStatement.clearBatch", new Object[]{this});
        if (this.batchStmts != null) {
            this.batchStmts.clear();
            this.batchStmts = null;
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.warnings = null;
    }

    @Override
    public synchronized void close() throws SQLException {
        Debug.logMethod("TbStatement.close", new Object[]{this});
        if (this.conn != null && this.conn.getStmtCache() != null) {
            Debug.log("TbStatement.close (CACHE ADDED)");
            if (this.conn.getStmtCache().add(this, 0)) {
                return;
            }
        }
        this.closeInternal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void closeInternal() throws SQLException {
        Debug.logMethod("TbStatement.closeInternal", new Object[]{this});
        try {
            this.closeResultSets();
        }
        catch (SQLException e) {
            Debug.log("TbStatement.close (FAILED) : " + e.getMessage());
        }
        finally {
            this.reset();
        }
    }

    private void closeResultSets() throws SQLException {
        if (this.subResultSets.size() > 0) {
            for (ResultSet resultSet : this.subResultSets) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {}
            }
            this.subResultSets.removeAll(this.subResultSets);
        }
        if (this.currentRs != null) {
            this.currentRs.close();
            this.currentRs = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean execute(String sql) throws SQLException {
        Debug.logMethod("TbStatement.execute", new Object[]{this, sql});
        this.checkConnectionOpen();
        if (this.batchStmts != null) {
            this.checkBatchStmtRemained();
            this.initBatchStmts();
        }
        this.initBeforeExecute();
        this.returnAutoGeneratedKeys = false;
        if (this.queryTimeout != 0) {
            this.conn.getTimeout().setTimeout(this.queryTimeout * 1000, this);
        }
        try {
            this.isExecuting = true;
            this.executeInternal(sql);
        }
        finally {
            this.isExecuting = false;
            if (this.queryTimeout != 0) {
                this.conn.getTimeout().cancelTimeout();
            }
        }
        return this.currentRs != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        if (autoGeneratedKeys == 2) {
            return this.execute(sql);
        }
        if (autoGeneratedKeys != 1) {
            TbError.newSQLException(-590733);
        }
        Debug.logMethod("TbStatement.execute", new Object[]{this, sql, Integer.toString(autoGeneratedKeys)});
        this.checkConnectionOpen();
        if (this.batchStmts != null) {
            this.checkBatchStmtRemained();
            this.initBatchStmts();
        }
        this.initBeforeExecute();
        this.returnAutoGeneratedKeys = true;
        if (this.queryTimeout != 0) {
            this.conn.getTimeout().setTimeout(this.queryTimeout * 1000, this);
        }
        try {
            this.isExecuting = true;
            this.executeInternal(sql);
        }
        finally {
            this.isExecuting = false;
            if (this.queryTimeout != 0) {
                this.conn.getTimeout().cancelTimeout();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        if (columnIndexes == null || columnIndexes.length == 0) {
            TbError.newSQLException(-590732);
        }
        Debug.logMethod("TbStatement.execute", new Object[]{this, sql, columnIndexes});
        this.checkConnectionOpen();
        if (this.batchStmts != null) {
            this.checkBatchStmtRemained();
            this.initBatchStmts();
        }
        this.initBeforeExecute();
        this.returnAutoGeneratedKeys = true;
        if (this.queryTimeout != 0) {
            this.conn.getTimeout().setTimeout(this.queryTimeout * 1000, this);
        }
        try {
            this.isExecuting = true;
            this.executeInternal(sql, columnIndexes);
        }
        finally {
            this.isExecuting = false;
            if (this.queryTimeout != 0) {
                this.conn.getTimeout().cancelTimeout();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        if (columnNames == null || columnNames.length == 0) {
            TbError.newSQLException(-590734);
        }
        Debug.logMethod("TbStatement.execute", new Object[]{this, sql, columnNames});
        this.checkConnectionOpen();
        if (this.batchStmts != null) {
            this.checkBatchStmtRemained();
            this.initBatchStmts();
        }
        this.initBeforeExecute();
        this.returnAutoGeneratedKeys = true;
        if (this.queryTimeout != 0) {
            this.conn.getTimeout().setTimeout(this.queryTimeout * 1000, this);
        }
        try {
            this.isExecuting = true;
            this.executeInternal(sql, columnNames);
        }
        finally {
            this.isExecuting = false;
            if (this.queryTimeout != 0) {
                this.conn.getTimeout().cancelTimeout();
            }
        }
        return false;
    }

    boolean isInsertStmt(String sql) {
        if (sql != null) {
            return this.sqlType == 36;
        }
        return false;
    }

    @Override
    public synchronized int[] executeBatch() throws SQLException {
        Debug.logMethod("TbStatement.executeBatch", new Object[]{this});
        this.checkConnectionOpen();
        this.initBeforeExecute();
        if (this.batchStmts == null) {
            return new int[0];
        }
        int size = this.batchStmts.size();
        if (size <= 0) {
            return new int[0];
        }
        this.batchCounts = new int[size];
        int i = 0;
        try {
            if (this.queryTimeout != 0) {
                this.conn.getTimeout().setTimeout(this.queryTimeout * 1000, this);
            }
            this.isExecuting = true;
            for (i = 0; i < size; ++i) {
                this.batchCounts[i] = this.executeInternal(this.batchStmts.get(i));
                if (this.currentRs == null) continue;
                throw TbError.newSQLException(-90630);
            }
            int[] nArray = this.batchCounts;
            return nArray;
        }
        catch (SQLException e) {
            int[] newResultCount = new int[i];
            System.arraycopy(this.batchCounts, 0, newResultCount, 0, i);
            this.batchCounts = newResultCount;
            throw new BatchUpdateException(e.getMessage(), e.getSQLState(), e.getErrorCode(), this.batchCounts);
        }
        finally {
            this.isExecuting = false;
            if (this.queryTimeout != 0) {
                this.conn.getTimeout().cancelTimeout();
            }
            this.clearBatch();
        }
    }

    private synchronized int executeInternal(String sql) throws SQLException {
        return this.executeInternal(sql, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized int executeInternal(String sql, Object keyArr) throws SQLException {
        TbConnection tbConnection;
        Object literal;
        String sqlForLog = sql == null ? "null" : (sql.length() <= 20 ? sql : sql.substring(0, 19));
        Debug.logMethod("TbStatement.executeInternal", new Object[]{this, this.conn, sqlForLog});
        this.initSql(sql);
        if (!this.isInsertStmt(sql)) {
            this.returnAutoGeneratedKeys = false;
        }
        int maxByteCount = this.conn.typeConverter.getMaxBytesPerChar();
        if (this.originalSql.length() > 65535 / maxByteCount) {
            literal = new ArrayList<BigLiteral>();
            String nsql = TbSQLParser.getBigLiteral(this.originalSql, maxByteCount, literal);
            int count = ((ArrayList)literal).size();
            if (count > 0) {
                TbPreparedStatement pstmt = (TbPreparedStatement)this.conn.prepareStatement(nsql);
                for (int i = 0; i < count; ++i) {
                    BigLiteral bl = (BigLiteral)((ArrayList)literal).get(i);
                    pstmt.setString(i + 1, bl.getLiteralValue());
                }
                ((ArrayList)literal).clear();
                return pstmt.impl().executeInternal(nsql);
            }
        }
        if (TbSQLTypeScanner.isQueryStmt(this.sqlType)) {
            if (this.userRsetType.getType() == 1005 || this.userRsetType.getConcurrency() == 1008) {
                this.sqlWithRowId = this.getQueryWithRowId(this.originalSql);
                try {
                    this.realRsetType = this.userRsetType;
                    literal = this.conn;
                    synchronized (literal) {
                        return this.conn.getTbComm().executeDirect(this, this.sqlWithRowId);
                    }
                }
                catch (SQLException se) {
                    this.realRsetType = RsetType.getDownGradedRsetType(this.userRsetType.getRank());
                    tbConnection = this.conn;
                    synchronized (tbConnection) {
                        return this.conn.getTbComm().executeDirect(this, this.originalSql);
                    }
                }
            }
            try {
                this.realRsetType = this.userRsetType;
                TbConnection se = this.conn;
                synchronized (se) {
                    return this.conn.getTbComm().executeDirect(this, this.originalSql);
                }
            }
            catch (SQLException e) {
                if (this.conn.isClosed() || !this.conn.info.isFailoverCursorEnabled() || e.getErrorCode() != -90700) {
                    throw e;
                }
                Debug.log("Failover cursor: re-execute query " + this);
                tbConnection = this.conn;
                synchronized (tbConnection) {
                    int ucnt = this.conn.getTbComm().executeDirect(this, this.originalSql);
                    this.addWarning(TbError.newSQLWarning(-90700, e));
                    return ucnt;
                }
            }
        }
        if (TbSQLTypeScanner.isDMLStmt(this.sqlType) || !TbSQLTypeScanner.isQueryStmt(this.sqlType) && !TbSQLTypeScanner.isPSMStmt(this.sqlType)) {
            this.realRsetType = this.userRsetType;
            String autoGeneratedValuesSql = this.originalSql;
            if (this.returnAutoGeneratedKeys) {
                if (this.realRsetType.isSensitive() || this.realRsetType.isUpdatable()) {
                    this.realRsetType = RsetType.SIRD;
                }
                if (keyArr == null) {
                    autoGeneratedValuesSql = this.getAutoGenSql(this.originalSql);
                } else if (keyArr instanceof int[]) {
                    autoGeneratedValuesSql = this.getAutoGenSql(this.originalSql, (int[])keyArr);
                } else if (keyArr instanceof String[]) {
                    autoGeneratedValuesSql = this.getAutoGenSql(this.originalSql, (String[])keyArr);
                }
            }
            tbConnection = this.conn;
            synchronized (tbConnection) {
                this.rowsUpdated = this.conn.getTbComm().executeDirect(this, autoGeneratedValuesSql);
            }
            return this.rowsUpdated;
        }
        this.realRsetType = this.userRsetType;
        TbConnection tbConnection2 = this.conn;
        synchronized (tbConnection2) {
            return this.conn.getTbComm().executeDirect(this, this.originalSql);
        }
    }

    protected String getAutoGenSql(String originalSql) {
        StringBuffer sb = new StringBuffer();
        sb.append(originalSql).append(" RETURNING ROWID INTO GENKEY0");
        return sb.toString();
    }

    protected String getAutoGenSql(String originalSql, String[] colNames) {
        int i;
        StringBuffer sb = new StringBuffer();
        sb.append(originalSql).append(" RETURNING ");
        int colCnt = colNames.length;
        for (i = 0; i < colCnt; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(colNames[i]);
        }
        sb.append(" INTO ");
        for (i = 0; i < colCnt; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append("GENKEY").append(i);
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getAutoGenSql(String originalSql, int[] colIndexes) throws SQLException {
        int endIndex;
        int beginIndex;
        StringBuffer sb = new StringBuffer();
        sb.append(originalSql).append(" RETURNING ");
        int colCnt = colIndexes.length;
        int intoIndex = originalSql.toUpperCase().indexOf("INTO", this.sqlTypeScanner.getCurrentIndex());
        if (intoIndex < 0) {
            TbError.newSQLException(-90608);
        }
        int sqlLen = originalSql.length();
        for (beginIndex = intoIndex + 5; beginIndex < sqlLen && originalSql.charAt(beginIndex) == ' '; ++beginIndex) {
        }
        if (beginIndex >= sqlLen) {
            TbError.newSQLException(-90608);
        }
        for (endIndex = beginIndex + 1; endIndex < sqlLen && originalSql.charAt(endIndex) != ' ' && originalSql.charAt(endIndex) != '('; ++endIndex) {
        }
        String tableName = originalSql.substring(beginIndex, endIndex);
        Statement tempstmt = null;
        try {
            int i;
            tempstmt = this.conn.createStatement();
            ResultSet temprs = tempstmt.executeQuery("SELECT * FROM " + tableName);
            ResultSetMetaData temprsmd = temprs.getMetaData();
            int rsColCnt = temprsmd.getColumnCount();
            for (i = 0; i < colCnt; ++i) {
                if (colIndexes[i] < 1 || colIndexes[i] > rsColCnt) {
                    TbError.newSQLException(-90608);
                }
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(temprsmd.getColumnName(colIndexes[i]));
            }
            sb.append(" INTO ");
            for (i = 0; i < colCnt; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append("GENKEY").append(i);
            }
            String string = sb.toString();
            return string;
        }
        finally {
            if (tempstmt != null) {
                try {
                    tempstmt.close();
                }
                catch (Exception ignore) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized ResultSet executeQuery(String sql) throws SQLException {
        Debug.logMethod("TbStatement.executeQuery", new Object[]{this, sql});
        this.checkConnectionOpen();
        if (this.batchStmts != null) {
            this.checkBatchStmtRemained();
            this.initBatchStmts();
        }
        this.initBeforeExecute();
        if (this.queryTimeout > 0) {
            this.conn.getTimeout().setTimeout(this.queryTimeout * 1000, this);
        }
        try {
            this.isExecuting = true;
            this.executeInternal(sql);
        }
        finally {
            this.isExecuting = false;
            if (this.queryTimeout > 0) {
                this.conn.getTimeout().cancelTimeout();
            }
        }
        if (this.currentRs == null) {
            this.currentRs = TbResultSetFactory.buildResultSet(this, -1, 0, 0, null);
        }
        return this.currentRs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int executeUpdate(String sql) throws SQLException {
        Debug.logMethod("TbStatement.executeUpdate", new Object[]{this, sql});
        this.checkConnectionOpen();
        if (this.batchStmts != null) {
            this.checkBatchStmtRemained();
            this.initBatchStmts();
        }
        this.initBeforeExecute();
        this.returnAutoGeneratedKeys = false;
        if (this.queryTimeout != 0) {
            this.conn.getTimeout().setTimeout(this.queryTimeout * 1000, this);
        }
        try {
            this.isExecuting = true;
            int n = this.executeInternal(sql);
            return n;
        }
        finally {
            this.isExecuting = false;
            if (this.queryTimeout != 0) {
                this.conn.getTimeout().cancelTimeout();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        if (autoGeneratedKeys == 2) {
            return this.executeUpdate(sql);
        }
        if (autoGeneratedKeys != 1) {
            TbError.newSQLException(-590733);
        }
        Debug.logMethod("TbStatement.executeUpdate", new Object[]{this, sql});
        this.checkConnectionOpen();
        if (this.batchStmts != null) {
            this.checkBatchStmtRemained();
            this.initBatchStmts();
        }
        this.initBeforeExecute();
        this.returnAutoGeneratedKeys = true;
        if (this.queryTimeout != 0) {
            this.conn.getTimeout().setTimeout(this.queryTimeout * 1000, this);
        }
        try {
            this.isExecuting = true;
            int n = this.executeInternal(sql);
            return n;
        }
        finally {
            this.isExecuting = false;
            if (this.queryTimeout != 0) {
                this.conn.getTimeout().cancelTimeout();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        if (columnIndexes == null || columnIndexes.length == 0) {
            TbError.newSQLException(-590732);
        }
        Debug.logMethod("TbStatement.executeUpdate", new Object[]{this, sql});
        this.checkConnectionOpen();
        if (this.batchStmts != null) {
            this.checkBatchStmtRemained();
            this.initBatchStmts();
        }
        this.initBeforeExecute();
        this.returnAutoGeneratedKeys = true;
        if (this.queryTimeout != 0) {
            this.conn.getTimeout().setTimeout(this.queryTimeout * 1000, this);
        }
        try {
            this.isExecuting = true;
            int n = this.executeInternal(sql, columnIndexes);
            return n;
        }
        finally {
            this.isExecuting = false;
            if (this.queryTimeout != 0) {
                this.conn.getTimeout().cancelTimeout();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        if (columnNames == null || columnNames.length == 0) {
            TbError.newSQLException(-590732);
        }
        Debug.logMethod("TbStatement.executeUpdate", new Object[]{this, sql});
        this.checkConnectionOpen();
        if (this.batchStmts != null) {
            this.checkBatchStmtRemained();
            this.initBatchStmts();
        }
        this.initBeforeExecute();
        this.returnAutoGeneratedKeys = true;
        if (this.queryTimeout != 0) {
            this.conn.getTimeout().setTimeout(this.queryTimeout * 1000, this);
        }
        try {
            this.isExecuting = true;
            int n = this.executeInternal(sql, columnNames);
            return n;
        }
        finally {
            this.isExecuting = false;
            if (this.queryTimeout != 0) {
                this.conn.getTimeout().cancelTimeout();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void fetch(TbResultSetBase rs) throws SQLException {
        TbConnection tbConnection = this.conn;
        synchronized (tbConnection) {
            this.conn.getTbComm().fetch(this, rs);
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        this.checkConnectionOpen();
        return this.conn;
    }

    public int getCurCsrId() {
        return this.curCsrId;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return this.fetchDirection;
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.fetchSize;
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        Debug.logMethod("getGeneratedKeys", new Object[]{this, this.currentRs});
        if (this.returnAutoGeneratedKeys) {
            return this.currentRs;
        }
        throw TbError.newSQLException(-90600);
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return this.maxFieldSize;
    }

    @Override
    public int getMaxRows() throws SQLException {
        return this.maxRow;
    }

    @Override
    public synchronized boolean getMoreResults() throws SQLException {
        return false;
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    @Override
    public String getOriginalSql() {
        return this.originalSql;
    }

    protected void initSql(String userSql) throws SQLException {
        if (userSql == null || userSql.length() <= 0) {
            throw TbError.newSQLException(-590737);
        }
        String returnSql = null;
        returnSql = this.conn.serverInfo.getServerCharSet() == 3 ? TbSQLParser.replaceIDEOGraphicSpace(userSql) : userSql;
        this.sqlTypeScanner = new TbSQLTypeScanner();
        this.sqlType = this.sqlTypeScanner.getSQLType(returnSql);
        if (136 != this.sqlType) {
            if (this.enableEscapeProcessing && returnSql.indexOf(123) >= 0) {
                returnSql = this.sqlParser.parse(returnSql);
            }
            if (returnSql.indexOf(63) > 0) {
                returnSql = TbSQLParser.replace(returnSql);
            }
        }
        this.originalSql = returnSql;
    }

    @Override
    public Vector<byte[]> getPivotData() {
        return this.pivotData;
    }

    @Override
    public TbPivotInfo[] getPivotInfo() {
        return this.pivotInfo;
    }

    public int getPreFetchSize() {
        if (TbSQLTypeScanner.isQueryStmt(this.getSqlType()) && this.getRealRsetType().getType() != 1005) {
            return this.preFetchSize;
        }
        return 0;
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return this.queryTimeout;
    }

    protected String getQueryWithRowId(String sql) {
        StringBuffer sqlBuffer = new StringBuffer(100);
        sqlBuffer.append("select ROWIDTOCHAR(ROWID) _ROWID_CHAR0_, ROWID_ALIAS0.* from (").append(sql).append(") ROWID_ALIAS0");
        return sqlBuffer.toString();
    }

    public RsetType getUserRsetType() {
        return this.userRsetType;
    }

    public RsetType getRealRsetType() {
        return this.realRsetType;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        if (this.returnAutoGeneratedKeys) {
            return null;
        }
        return this.currentRs;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return this.userRsetType.getConcurrency();
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return this.userRsetType.getHoldability();
    }

    @Override
    public int getResultSetType() throws SQLException {
        return this.userRsetType.getType();
    }

    @Override
    public int getSqlType() {
        return this.sqlType;
    }

    public String getSqlWithRowId() {
        return this.sqlWithRowId;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        Debug.logMethod("TbStatement.getUpdateCount", new Object[]{this});
        if (this.batchCounts != null) {
            int updateCount = 0;
            for (int i = 0; i < this.batchCounts.length; ++i) {
                updateCount += this.batchCounts[i];
            }
            return updateCount;
        }
        if (!this.noMoreUpdateCount) {
            this.noMoreUpdateCount = true;
            return this.rowsUpdated;
        }
        return -1;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.warnings;
    }

    protected void initBatchStmts() {
        if (this.batchStmts != null) {
            this.batchStmts.clear();
            this.batchStmts = null;
        }
    }

    protected void initBeforeExecute() throws SQLException {
        this.batchCounts = null;
        this.rowsUpdated = -1;
        this.noMoreUpdateCount = false;
        if (this.currentRs != null) {
            this.currentRs.close();
            this.currentRs = null;
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        Debug.logMethod("TbStatement.isClosed", new Object[]{this});
        return this.closed;
    }

    @Override
    public boolean isPoolable() throws SQLException {
        Debug.logMethod("TbStatement.isPoolable", new Object[]{this});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        return this.poolable;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        Debug.logMethod("TbStatement.isWrapperFor", new Object[]{iface});
        return iface.isInstance(this);
    }

    protected void reset() {
        this.closed = true;
        this.warnings = null;
        this.conn = null;
        this.typeConverter = null;
        this.userRsetType = null;
        this.noMoreUpdateCount = false;
        this.returnAutoGeneratedKeys = false;
        this.currentRs = null;
        this.batchCounts = null;
        this.maxRow = 0;
        this.rsetTypeDowngraded = false;
        this.subResultSets.removeAll(this.subResultSets);
        if (this.batchStmts != null) {
            this.batchStmts.clear();
            this.batchStmts = null;
        }
    }

    @Override
    public void resetForCache() {
        this.currentRs = null;
        this.batchCounts = null;
        this.warnings = null;
        this.subResultSets.removeAll(this.subResultSets);
        if (this.batchStmts != null) {
            this.batchStmts.clear();
            this.batchStmts = null;
        }
    }

    public void setCurCsrId(int csrId) {
        this.curCsrId = csrId;
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    @Override
    public synchronized void setEscapeProcessing(boolean enable) throws SQLException {
        Debug.logMethod("TbStatement.setEscapeProcessing", new Object[]{this, new Boolean(enable)});
        this.enableEscapeProcessing = enable;
    }

    @Override
    public synchronized void setFetchDirection(int direction) throws SQLException {
        Debug.logMethod("TbStatement.setFethDirection", new Object[]{this, Integer.toString(direction)});
        switch (direction) {
            case 1000: 
            case 1002: {
                this.fetchDirection = 1000;
                return;
            }
            case 1001: {
                this.fetchDirection = 1001;
            }
        }
        throw TbError.newSQLException(-590738);
    }

    @Override
    public synchronized void setFetchSize(int rows) throws SQLException {
        Debug.logMethod("TbStatement.setFetchSize", new Object[]{this, Integer.toString(rows)});
        if (rows == 0) {
            this.fetchSize = 50;
        } else if (rows > 0) {
            this.fetchSize = rows;
        } else {
            throw TbError.newSQLException(-590735);
        }
    }

    public synchronized void setPreparedFetchSize(int size) throws SQLException {
        Debug.logMethod("TbStatement.setPreparedFetchSize", new Object[]{this, Integer.toString(size)});
        if (size == 0) {
            this.fetchSize = 50;
        } else if (size > 0) {
            this.fetchSize = size > 64 ? -64 : size * -1;
        } else {
            throw TbError.newSQLException(-590735);
        }
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        Debug.logMethod("TbStatement.setMaxFieldSize", new Object[]{this, Integer.toString(max)});
        if (max < 0) {
            throw TbError.newSQLException(-590739);
        }
        this.maxFieldSize = max;
    }

    @Override
    public synchronized void setMaxRows(int max) throws SQLException {
        Debug.logMethod("TbStatement.setMaxRows", new Object[]{this, Integer.toString(max)});
        if (max < 0) {
            throw TbError.newSQLException(-590740);
        }
        this.maxRow = max;
    }

    @Override
    public void setPivotInfo(TbPivotInfo[] info) {
        this.pivotInfo = info;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        Debug.logMethod("TbStatement.setPoolable", new Object[]{this, Boolean.toString(poolable)});
        this.poolable = poolable;
    }

    @Override
    public synchronized void setQueryTimeout(int seconds) throws SQLException {
        Debug.logMethod("TbStatement.setQueryTimeout", new Object[]{this, Integer.toString(seconds)});
        if (seconds < 0) {
            throw TbError.newSQLException(-590741);
        }
        this.queryTimeout = seconds;
    }

    public void setResultSet(TbResultSet rs1) {
        this.currentRs = rs1;
    }

    public void addSubResultSet(TbResultSet subRs) {
        this.subResultSets.add(subRs);
    }

    public synchronized void setRowPreFetch(int fetchSize) throws SQLException {
        Debug.logMethod("TbStatement.setFetchSize", new Object[]{this, Integer.toString(fetchSize)});
        if (fetchSize < 0) {
            throw TbError.newSQLException(-590735);
        }
        this.preFetchSize = fetchSize;
        if (fetchSize == 0) {
            this.setFetchSize(50);
        } else {
            this.setFetchSize(fetchSize);
        }
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        Debug.logMethod("TbStatement.unwrap", new Object[]{iface});
        try {
            return iface.cast(this);
        }
        catch (ClassCastException e) {
            throw TbError.newSQLException(-90657);
        }
    }

    boolean isReturnAutoGeneratedKeys() {
        return this.returnAutoGeneratedKeys;
    }

    protected void setReturnAutoGeneratedKeys(boolean returnAutoGeneratedKeys) {
        Debug.logMethod("setReturnAutoGeneratedKeys", new Object[]{String.valueOf(returnAutoGeneratedKeys)});
        this.returnAutoGeneratedKeys = returnAutoGeneratedKeys;
    }
}

