/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.driver;

import com.tmax.tibero.Debug;
import com.tmax.tibero.jdbc.TbTypeDescriptor;
import com.tmax.tibero.jdbc.data.Column;
import com.tmax.tibero.jdbc.data.DataType;
import com.tmax.tibero.jdbc.err.TbError;
import java.sql.SQLException;

public class TbResultSetMetaData
implements com.tmax.tibero.jdbc.TbResultSetMetaData {
    private Column[] columnInfoArr = null;

    public TbResultSetMetaData(Column[] columnInfoArr, int beginColumnIndex) {
        Debug.logMethod("TbResultSetMetaData", new Object[]{this, columnInfoArr, Integer.toString(beginColumnIndex)});
        if (columnInfoArr != null) {
            int colCnt = columnInfoArr.length - beginColumnIndex;
            this.columnInfoArr = new Column[colCnt];
            for (int i = 0; i < colCnt; ++i) {
                this.columnInfoArr[i] = new Column(columnInfoArr[i + beginColumnIndex]);
            }
        }
    }

    @Override
    public String getCatalogName(int column) throws SQLException {
        this.checkColumnIndex(column);
        return "";
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        Debug.logMethod("TbResultSetMetaData.getColumnClassName", new Object[]{this, Integer.toString(column)});
        this.checkColumnIndex(column);
        return DataType.getDataTypeClassName(this.getColumnDataType(column));
    }

    @Override
    public int getColumnCount() throws SQLException {
        Debug.logMethod("TbResultSetMetaData.getColumnCount", new Object[]{this});
        if (this.columnInfoArr != null) {
            return this.columnInfoArr.length;
        }
        throw TbError.newSQLException(-590784);
    }

    private int getColumnDataType(int column) throws SQLException {
        return this.columnInfoArr[column - 1].getDataType();
    }

    private int getColumnMaxLength(int column) throws SQLException {
        return this.columnInfoArr[column - 1].getMaxLength();
    }

    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        Debug.logMethod("TbResultSetMetaData.getColumnDisplaySize", new Object[]{this, Integer.toString(column)});
        this.checkColumnIndex(column);
        int dataType = this.getColumnDataType(column);
        int maxLen = this.getColumnMaxLength(column);
        switch (dataType) {
            case 2: 
            case 3: {
                if (maxLen > 0) {
                    return maxLen;
                }
                int columnNameLen = this.getColumnName(column).length();
                if (columnNameLen == 0) {
                    return 1;
                }
                return columnNameLen;
            }
            case 1: {
                return 45;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                return 24;
            }
            case 15: {
                return 14;
            }
            case 12: 
            case 13: {
                return 400000000;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                return 0;
            }
        }
        if (maxLen > 0) {
            return maxLen;
        }
        return 65535;
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        return this.getColumnName(column);
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        Debug.logMethod("TbResultSetMetaData.getColumnName", new Object[]{this, Integer.toString(column)});
        this.checkColumnIndex(column);
        if (this.columnInfoArr != null) {
            return this.columnInfoArr[column - 1].getName();
        }
        throw TbError.newSQLException(-590784);
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        Debug.logMethod("TbResultSetMetaData.getColumnType", new Object[]{this, Integer.toString(column)});
        this.checkColumnIndex(column);
        if (this.columnInfoArr != null) {
            return this.columnInfoArr[column - 1].getSqlType();
        }
        throw TbError.newSQLException(-590784);
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        TbTypeDescriptor descriptor;
        Debug.logMethod("TbResultSetMetaData.getColumnTypeName", new Object[]{this, Integer.toString(column)});
        this.checkColumnIndex(column);
        int dataType = this.getColumnDataType(column);
        if (DataType.isUDTCategory(dataType) && (descriptor = this.columnInfoArr[column - 1].getDescriptor()) instanceof TbTypeDescriptor) {
            return descriptor.getSQLTypeName();
        }
        return DataType.getDBTypeName(dataType, this.getColumnPrecision(column));
    }

    private int getColumnPrecision(int column) throws SQLException {
        return this.columnInfoArr[column - 1].getPrecision();
    }

    @Override
    public int getPrecision(int column) throws SQLException {
        Debug.logMethod("TbResultSetMetaData.getPrecision", new Object[]{this, Integer.toString(column)});
        this.checkColumnIndex(column);
        int prec = this.getColumnPrecision(column);
        int type = this.getColumnDataType(column);
        switch (type) {
            case 2: 
            case 3: {
                return this.getColumnMaxLength(column);
            }
            case 12: 
            case 13: {
                return -1;
            }
            case 10: 
            case 11: {
                return Integer.MAX_VALUE;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                return 0;
            }
        }
        return prec < 0 ? 0 : prec;
    }

    @Override
    public int getScale(int column) throws SQLException {
        Debug.logMethod("TbResultSetMetaData.getScale", new Object[]{this, Integer.toString(column)});
        this.checkColumnIndex(column);
        int scale = 0;
        int type = this.getColumnDataType(column);
        switch (type) {
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                return 0;
            }
        }
        scale = this.columnInfoArr[column - 1].getScale();
        return scale < 0 ? 0 : scale;
    }

    private void checkColumnIndex(int index) throws SQLException {
        if (this.columnInfoArr != null) {
            int columnCount = this.columnInfoArr.length;
            if (columnCount < 0) {
                throw TbError.newSQLException(-90607);
            }
            if (index <= 0 || index > columnCount) {
                throw TbError.newSQLException(-90609, Integer.toString(index));
            }
        } else {
            throw TbError.newSQLException(-590784);
        }
    }

    @Override
    public String getSchemaName(int column) throws SQLException {
        this.checkColumnIndex(column);
        return "";
    }

    @Override
    public String getTableName(int column) throws SQLException {
        this.checkColumnIndex(column);
        return "";
    }

    @Override
    public boolean isAutoIncrement(int column) throws SQLException {
        this.checkColumnIndex(column);
        return false;
    }

    @Override
    public boolean isCaseSensitive(int column) throws SQLException {
        Debug.logMethod("TbResultSetMetaData.isCaseSensitive", new Object[]{this, Integer.toString(column)});
        this.checkColumnIndex(column);
        int dataType = this.getColumnDataType(column);
        return DataType.isCharacterCategory(dataType) || dataType == 13 || dataType == 10;
    }

    @Override
    public boolean isCurrency(int column) throws SQLException {
        Debug.logMethod("TbResultSetMetaData.isCurrency", new Object[]{this, Integer.toString(column)});
        this.checkColumnIndex(column);
        int dataType = this.getColumnDataType(column);
        return dataType == 1;
    }

    @Override
    public boolean isDefinitelyWritable(int column) throws SQLException {
        this.checkColumnIndex(column);
        return false;
    }

    @Override
    public int isNullable(int column) throws SQLException {
        Debug.logMethod("TbResultSetMetaData.isNullable", new Object[]{this, Integer.toString(column)});
        this.checkColumnIndex(column);
        if (this.columnInfoArr == null) {
            throw TbError.newSQLException(-590784);
        }
        boolean isNullable = this.columnInfoArr[column - 1].isNullable();
        return isNullable ? 1 : 0;
    }

    @Override
    public boolean isReadOnly(int column) throws SQLException {
        this.checkColumnIndex(column);
        return false;
    }

    @Override
    public boolean isSearchable(int column) throws SQLException {
        Debug.logMethod("TbResultSetMetaData.isSearchable", new Object[]{this, Integer.toString(column)});
        this.checkColumnIndex(column);
        int dataType = this.getColumnDataType(column);
        return dataType != 11 && dataType != 10 && dataType != 12 && dataType != 13;
    }

    @Override
    public boolean isSigned(int column) throws SQLException {
        Debug.logMethod("TbResultSetMetaData.isSigned", new Object[]{this, Integer.toString(column)});
        this.checkColumnIndex(column);
        return DataType.isNumberCategory(this.getColumnDataType(column));
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        Debug.logMethod("TbResultSetMetaData.isWrapperFor", new Object[]{iface});
        return iface.isInstance(this);
    }

    @Override
    public boolean isWritable(int column) throws SQLException {
        this.checkColumnIndex(column);
        return true;
    }

    @Override
    public void reset() {
        this.columnInfoArr = null;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        Debug.logMethod("TbResultSetMetaData.unwrap", new Object[]{iface});
        try {
            return iface.cast(this);
        }
        catch (ClassCastException e) {
            throw TbError.newSQLException(-90657);
        }
    }
}

