/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.driver;

import com.tmax.tibero.Debug;
import com.tmax.tibero.jdbc.TbBlob;
import com.tmax.tibero.jdbc.TbClob;
import com.tmax.tibero.jdbc.TbClobBase;
import com.tmax.tibero.jdbc.TbNClob;
import com.tmax.tibero.jdbc.TbRowId;
import com.tmax.tibero.jdbc.TbSQLXML;
import com.tmax.tibero.jdbc.data.Column;
import com.tmax.tibero.jdbc.data.ParamContainer;
import com.tmax.tibero.jdbc.data.Row;
import com.tmax.tibero.jdbc.data.RsetType;
import com.tmax.tibero.jdbc.data.TbDate;
import com.tmax.tibero.jdbc.data.TbTimestamp;
import com.tmax.tibero.jdbc.driver.TbPreparedStatement;
import com.tmax.tibero.jdbc.driver.TbRSSensitive;
import com.tmax.tibero.jdbc.driver.TbResultSet;
import com.tmax.tibero.jdbc.driver.TbResultSetBase;
import com.tmax.tibero.jdbc.driver.TbResultSetMetaData;
import com.tmax.tibero.jdbc.err.TbError;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;

public class TbRSUpdatable
extends TbResultSet {
    private TbResultSetBase rset = null;
    private boolean onInserting = false;
    private boolean onUpdating = false;
    private Object[] columnBuffer = null;
    private int[] columnLength = null;
    private boolean[] hasChanged = null;
    private int columnCount = 0;
    private int beginColumnIndex = 0;
    private boolean lastColumnWasNull = false;

    protected TbRSUpdatable(TbResultSetBase rset, RsetType type) throws SQLException {
        super(type);
        if (rset == null) {
            throw TbError.newSQLException(-90607);
        }
        this.rset = rset;
        this.beginColumnIndex = rset.getBeginColumnIndex();
        this.columnCount = rset.getColumnCount() + this.beginColumnIndex;
        this.rsetType = type;
        Debug.logMethod("TbRSUpdatable", new Object[]{this});
    }

    @Override
    public synchronized boolean absolute(int i) throws SQLException {
        Debug.logMethod("TbRSUpdatable.absolute", new Object[]{this, Integer.toString(i)});
        this.cancelChanges();
        return this.rset.absolute(i);
    }

    @Override
    public synchronized void afterLast() throws SQLException {
        Debug.logMethod("TbRSUpdatable.afterLast", new Object[]{this});
        this.cancelChanges();
        this.rset.afterLast();
    }

    @Override
    public synchronized void beforeFirst() throws SQLException {
        Debug.logMethod("TbRSUpdatable.beforeFirst", new Object[]{this});
        this.cancelChanges();
        this.rset.beforeFirst();
    }

    private void bindInsertRowChangedData(TbPreparedStatement stmt) throws SQLException {
        int paramCnt = this.hasChanged.length;
        int i = 1;
        if (this.rset.stmt instanceof ParamContainer) {
            i = ((ParamContainer)((Object)this.rset.stmt)).getParameterCnt() + 1;
        }
        for (int colIndex = this.beginColumnIndex; colIndex < paramCnt; ++colIndex) {
            if (this.hasChanged[colIndex]) {
                Object data = this.columnBuffer[colIndex];
                if (data instanceof Clob) {
                    stmt.setClob(i, (Clob)data);
                } else if (data instanceof Blob) {
                    stmt.setBlob(i, (Blob)data);
                } else if (data instanceof Reader) {
                    stmt.setCharacterStream(i, (Reader)data, this.columnLength[colIndex]);
                } else if (data instanceof InputStream) {
                    stmt.setBinaryStream(i, (InputStream)data, this.columnLength[colIndex]);
                } else if (data instanceof byte[]) {
                    int dataType = this.rset.getColumnDataType(this.getRevisedColumnIndex(colIndex));
                    if (this.columnLength[colIndex] == 0) {
                        stmt.setBytes(i, dataType, null);
                    } else {
                        stmt.setBytes(i, dataType, (byte[])data);
                    }
                }
                ++i;
                continue;
            }
            stmt.setBytes(i, this.rset.getColumnDataType(i), null);
        }
    }

    private void bindUpdateRowChangedData(TbPreparedStatement stmt) throws SQLException {
        int paramCnt = this.hasChanged.length;
        int i = 1;
        if (this.rset.stmt instanceof ParamContainer) {
            i = ((ParamContainer)((Object)this.rset.stmt)).getParameterCnt() + 1;
        }
        for (int colIndex = this.beginColumnIndex; colIndex < paramCnt; ++colIndex) {
            if (this.hasChanged[colIndex]) {
                Object data = this.columnBuffer[colIndex];
                if (data instanceof Clob) {
                    stmt.setClob(i, (Clob)data);
                } else if (data instanceof Blob) {
                    stmt.setBlob(i, (Blob)data);
                } else if (data instanceof Reader) {
                    stmt.setCharacterStream(i, (Reader)data, this.columnLength[colIndex]);
                } else if (data instanceof InputStream) {
                    stmt.setBinaryStream(i, (InputStream)data, this.columnLength[colIndex]);
                } else if (data instanceof byte[]) {
                    int dataType = this.rset.getColumnDataType(this.getRevisedColumnIndex(colIndex));
                    if (this.columnLength[colIndex] == 0) {
                        stmt.setBytes(i, dataType, null);
                    } else {
                        stmt.setBytes(i, dataType, (byte[])data);
                    }
                }
                ++i;
                continue;
            }
            stmt.setBytes(i, this.rset.getColumnDataType(i), null);
        }
        stmt.setBytes(i, 3, this.rset.getColumnRawData(0));
    }

    @Override
    public void buildRowTable(int rowCount, byte[] chunk) throws SQLException {
        this.rset.buildRowTable(rowCount, chunk);
    }

    protected void cancelChanges() throws SQLException {
        Debug.logMethod("TbRSUpdatable.cancelChanges", new Object[]{this});
        if (this.onInserting) {
            this.cancelRowInserts();
        }
        if (this.onUpdating) {
            this.cancelRowUpdates();
        }
    }

    protected void cancelRowInserts() throws SQLException {
        Debug.logMethod("TbRSUpdatable.cancelRowInserts", new Object[]{this});
        this.onInserting = false;
        this.resetBuffer();
    }

    @Override
    public synchronized void cancelRowUpdates() throws SQLException {
        Debug.logMethod("TbRSUpdatable.cancelRowUpdates", new Object[]{this});
        this.onUpdating = false;
        this.resetBuffer();
    }

    void checkColumnIndex(int index) throws SQLException {
        int columnCount = this.getColumnCount();
        if (columnCount < 0) {
            throw TbError.newSQLException(-90607);
        }
        if (index <= 0 || index > columnCount) {
            throw TbError.newSQLException(-90609);
        }
    }

    protected void checkUpdateCursorPosition() throws SQLException {
        if (this.isBeforeFirst() || this.isAfterLast()) {
            throw TbError.newSQLException(-90624);
        }
        this.onUpdating = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() throws SQLException {
        Debug.logMethod("TbRSUpdatable.close", new Object[]{this});
        try {
            if (this.rset != null) {
                this.rset.close();
            }
        }
        finally {
            this.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void deleteRow() throws SQLException {
        Debug.logMethod("TbRSUpdatable.deleteRow", new Object[]{this});
        if (this.onInserting) {
            throw TbError.newSQLException(-590773);
        }
        TbPreparedStatement pstmt = null;
        try {
            pstmt = this.getDeleteRowStatement();
            int retCnt = pstmt.executeUpdate();
            if (retCnt <= 0) {
                throw TbError.newSQLException(-590777, retCnt);
            }
            if (retCnt > 1) {
                throw TbError.newSQLException(-590778, retCnt);
            }
            this.rset.removeCurrentRow();
        }
        finally {
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    public synchronized int findColumn(String columnName) throws SQLException {
        Debug.logMethod("TbRSUpdatable.findColumn", new Object[]{this, columnName});
        return this.rset.findColumn(columnName);
    }

    @Override
    public synchronized boolean first() throws SQLException {
        Debug.logMethod("TbRSUpdatable.first", new Object[]{this});
        this.cancelChanges();
        return this.rset.first();
    }

    private int getRevisedColumnIndex(int i) throws SQLException {
        int retIndex = i + this.beginColumnIndex - 1;
        this.checkColumnIndex(retIndex);
        return retIndex;
    }

    @Override
    public Array getArray(int i) throws SQLException {
        throw TbError.newSQLException(-590726);
    }

    @Override
    public Array getArray(String label) throws SQLException {
        return this.getArray(this.findColumn(label));
    }

    @Override
    public synchronized InputStream getAsciiStream(int i) throws SQLException {
        return this.getBinaryStream(i);
    }

    @Override
    public InputStream getAsciiStream(String label) throws SQLException {
        return this.getBinaryStream(this.findColumn(label));
    }

    @Override
    public BigDecimal getBigDecimal(int i) throws SQLException {
        return this.getBigDecimal(i, 0);
    }

    @Override
    @Deprecated
    public synchronized BigDecimal getBigDecimal(int i, int scale) throws SQLException {
        Debug.logMethod("TbRSUpdatable.getBigDecimal", new Object[]{this, Integer.toString(i), Integer.toString(scale)});
        this.checkColumnIndex(i);
        if (this.setLastColumnWasNull(i)) {
            return null;
        }
        if (this.hasBufferChanged(i)) {
            return this.rset.typeConverter.toBigDecimal(this.columnBuffer[this.getRevisedColumnIndex(i)], 0, this.columnLength[this.getRevisedColumnIndex(i)], this.getColumnDataType(i));
        }
        return this.rset.getBigDecimal(i);
    }

    @Override
    public BigDecimal getBigDecimal(String label) throws SQLException {
        return this.getBigDecimal(this.findColumn(label));
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(String label, int scale) throws SQLException {
        return this.getBigDecimal(this.findColumn(label), scale);
    }

    @Override
    public synchronized InputStream getBinaryStream(int i) throws SQLException {
        Debug.logMethod("TbRSUpdatable.getBinaryStream", new Object[]{this, Integer.toString(i)});
        this.checkColumnIndex(i);
        if (this.setLastColumnWasNull(i)) {
            return null;
        }
        if (this.hasBufferChanged(i)) {
            Object data = this.columnBuffer[this.getRevisedColumnIndex(i)];
            if (data instanceof InputStream) {
                return (InputStream)data;
            }
            if (data instanceof Blob) {
                return ((TbBlob)data).getBinaryStream();
            }
            throw TbError.newSQLException(-590705, data.toString());
        }
        return this.rset.getBinaryStream(i);
    }

    @Override
    public InputStream getBinaryStream(String label) throws SQLException {
        return this.getBinaryStream(this.findColumn(label));
    }

    @Override
    public Blob getBlob(int i) throws SQLException {
        Debug.logMethod("TbRSUpdatable.getBlob", new Object[]{this, Integer.toString(i)});
        this.checkColumnIndex(i);
        if (this.setLastColumnWasNull(i)) {
            return null;
        }
        if (this.hasBufferChanged(i)) {
            Object data = this.columnBuffer[this.getRevisedColumnIndex(i)];
            if (data instanceof Blob) {
                return (Blob)data;
            }
            throw TbError.newSQLException(-590705, data.toString());
        }
        return this.rset.getBlob(i);
    }

    @Override
    public Blob getBlob(String label) throws SQLException {
        return this.getBlob(this.findColumn(label));
    }

    @Override
    public synchronized boolean getBoolean(int i) throws SQLException {
        Debug.logMethod("TbRSUpdatable.getBoolean", new Object[]{this, Integer.toString(i)});
        this.checkColumnIndex(i);
        if (this.setLastColumnWasNull(i)) {
            return false;
        }
        if (this.hasBufferChanged(i)) {
            return this.rset.typeConverter.toBoolean(this.columnBuffer[this.getRevisedColumnIndex(i)], 0, this.columnLength[this.getRevisedColumnIndex(i)], this.getColumnDataType(i));
        }
        return this.rset.getBoolean(i);
    }

    @Override
    public boolean getBoolean(String label) throws SQLException {
        return this.getBoolean(this.findColumn(label));
    }

    @Override
    public synchronized byte getByte(int i) throws SQLException {
        Debug.logMethod("TbRSUpdatable.getByte", new Object[]{this, Integer.toString(i)});
        this.checkColumnIndex(i);
        if (this.setLastColumnWasNull(i)) {
            return 0;
        }
        if (this.hasBufferChanged(i)) {
            return this.rset.typeConverter.toByte(this.columnBuffer[this.getRevisedColumnIndex(i)], 0, this.columnLength[this.getRevisedColumnIndex(i)], this.getColumnDataType(i));
        }
        return this.rset.getByte(i);
    }

    @Override
    public byte getByte(String label) throws SQLException {
        return this.getByte(this.findColumn(label));
    }

    @Override
    public synchronized byte[] getBytes(int i) throws SQLException {
        Debug.logMethod("TbRSUpdatable.getBytes", new Object[]{this, Integer.toString(i)});
        this.checkColumnIndex(i);
        if (this.setLastColumnWasNull(i)) {
            return null;
        }
        if (this.hasBufferChanged(i)) {
            return this.rset.typeConverter.toBytes(this.columnBuffer[this.getRevisedColumnIndex(i)], 0, this.columnLength[this.getRevisedColumnIndex(i)], this.getColumnDataType(i), false);
        }
        return this.rset.getBytes(i);
    }

    @Override
    public byte[] getBytes(String label) throws SQLException {
        return this.getBytes(this.findColumn(label));
    }

    @Override
    public synchronized Reader getCharacterStream(int i) throws SQLException {
        Debug.logMethod("TbRSUpdatable.getChracterStream", new Object[]{this, Integer.toString(i)});
        this.checkColumnIndex(i);
        if (this.setLastColumnWasNull(i)) {
            return null;
        }
        if (this.hasBufferChanged(i)) {
            Object data = this.columnBuffer[this.getRevisedColumnIndex(i)];
            if (data instanceof Reader) {
                return (Reader)data;
            }
            if (data instanceof Clob) {
                return ((TbClob)data).getCharacterStream();
            }
            throw TbError.newSQLException(-590705, data.toString());
        }
        return this.rset.getCharacterStream(i);
    }

    @Override
    public Reader getCharacterStream(String label) throws SQLException {
        return this.getCharacterStream(this.findColumn(label));
    }

    @Override
    public Clob getClob(int i) throws SQLException {
        Debug.logMethod("TbRSUpdatable.getClob", new Object[]{this, Integer.toString(i)});
        this.checkColumnIndex(i);
        if (this.setLastColumnWasNull(i)) {
            return null;
        }
        if (this.hasBufferChanged(i)) {
            Object data = this.columnBuffer[this.getRevisedColumnIndex(i)];
            if (data instanceof Clob) {
                return (Clob)data;
            }
            throw TbError.newSQLException(-590705, data.toString());
        }
        return this.rset.getClob(i);
    }

    @Override
    public Clob getClob(String label) throws SQLException {
        return this.getClob(this.findColumn(label));
    }

    @Override
    public Column[] getCols() {
        return this.rset.getCols();
    }

    public int getColumnCount() {
        return this.rset.getColumnCount();
    }

    @Override
    protected int getColumnDataType(int i) throws SQLException {
        return this.rset.getColumnDataType(i);
    }

    @Override
    protected int getColumnMaxLength(int i) throws SQLException {
        return this.rset.getColumnMaxLength(i);
    }

    @Override
    protected String getColumnName(int i) throws SQLException {
        return this.rset.getColumnName(i);
    }

    @Override
    protected boolean getColumnNullable(int i) throws SQLException {
        return this.rset.getColumnNullable(i);
    }

    @Override
    protected int getColumnPrecision(int i) throws SQLException {
        return this.rset.getColumnPrecision(i);
    }

    @Override
    protected int getColumnScale(int i) throws SQLException {
        return this.rset.getColumnScale(i);
    }

    @Override
    protected int getColumnSqlType(int i) throws SQLException {
        return this.rset.getColumnSqlType(i);
    }

    protected Row getCurrentRow() throws SQLException {
        return this.rset.getCurrentRow();
    }

    private int getColumnOffset(Row row, int i) {
        return row.getColumnOffset(i + this.beginColumnIndex);
    }

    private int getColumnLength(Row row, int i) {
        return row.getColumnLength(i + this.beginColumnIndex);
    }

    @Override
    public String getCursorName() throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    @Override
    public synchronized Date getDate(int i) throws SQLException {
        Debug.logMethod("TbRSUpdatable.getDate", new Object[]{this, Integer.toString(i)});
        return this.getDateInternal(i);
    }

    @Override
    public Date getDate(int i, Calendar cal) throws SQLException {
        Debug.logMethod("TbRSUpdatable.getDate", new Object[]{this, Integer.toString(i), cal});
        Date date = this.getDateInternal(i);
        if (cal != null) {
            cal.setTime(date);
            date = (Date)cal.getTime();
        }
        return date;
    }

    @Override
    public Date getDate(String label) throws SQLException {
        return this.getDate(this.findColumn(label));
    }

    @Override
    public Date getDate(String label, Calendar cal) throws SQLException {
        return this.getDate(this.findColumn(label), cal);
    }

    private Date getDateInternal(int i) throws SQLException {
        this.checkColumnIndex(i);
        if (this.setLastColumnWasNull(i)) {
            return null;
        }
        if (this.hasBufferChanged(i)) {
            return this.rset.typeConverter.toDate(this.columnBuffer[this.getRevisedColumnIndex(i)], 0, this.columnLength[this.getRevisedColumnIndex(i)], this.getColumnDataType(i));
        }
        return this.rset.getDate(i);
    }

    @Override
    public TbDate getTbDate(int i) throws SQLException {
        Debug.logMethod("TbRSUpdatable.getTbDate", new Object[]{this, Integer.toString(i)});
        return this.getTbDateInternal(i);
    }

    private TbDate getTbDateInternal(int i) throws SQLException {
        this.checkColumnIndex(i);
        if (this.setLastColumnWasNull(i)) {
            return null;
        }
        if (this.hasBufferChanged(i)) {
            Row row = this.getCurrentRow();
            return this.rset.typeConverter.toTbDate(row.getRowChunk(i + this.beginColumnIndex), this.getColumnOffset(row, i), this.getColumnLength(row, i), this.getColumnDataType(i));
        }
        return this.rset.getTbDate(i);
    }

    private TbPreparedStatement getDeleteRowStatement() throws SQLException {
        StringBuffer sb = new StringBuffer();
        sb.append("DELETE FROM ( ");
        sb.append(this.rset.stmt.getOriginalSql());
        sb.append(" ) WHERE ROWIDTOCHAR(ROWID) = ? ");
        Debug.logReturn("TbRSUpdatable.getDeleteRowStatement", sb.toString());
        TbPreparedStatement pstmt = new TbPreparedStatement(this.rset.stmt.conn, sb.toString());
        if (this.rset.stmt instanceof ParamContainer) {
            pstmt.impl().copyBindParamInfo((ParamContainer)((Object)this.rset.stmt));
            pstmt.setBytes(((ParamContainer)((Object)this.rset.stmt)).getParameterCnt() + 1, 3, this.rset.getColumnRawData(0));
        } else {
            pstmt.setBytes(1, 3, this.rset.getColumnRawData(0));
        }
        return pstmt;
    }

    @Override
    public synchronized double getDouble(int i) throws SQLException {
        Debug.logMethod("TbRSUpdatable.getDouble", new Object[]{this, Integer.toString(i)});
        this.checkColumnIndex(i);
        if (this.setLastColumnWasNull(i)) {
            return 0.0;
        }
        if (this.hasBufferChanged(i)) {
            return this.rset.typeConverter.toDouble(this.columnBuffer[this.getRevisedColumnIndex(i)], 0, this.columnLength[this.getRevisedColumnIndex(i)], this.getColumnDataType(i));
        }
        return this.rset.getDouble(i);
    }

    @Override
    public double getDouble(String label) throws SQLException {
        return this.getDouble(this.findColumn(label));
    }

    @Override
    public synchronized int getFetchDirection() throws SQLException {
        return this.rset.getFetchDirection();
    }

    @Override
    public synchronized int getFetchSize() throws SQLException {
        return this.rset.getFetchSize();
    }

    @Override
    public synchronized float getFloat(int i) throws SQLException {
        Debug.logMethod("TbRSUpdatable.getFloat", new Object[]{this, Integer.toString(i)});
        this.checkColumnIndex(i);
        if (this.setLastColumnWasNull(i)) {
            return 0.0f;
        }
        if (this.hasBufferChanged(i)) {
            return this.rset.typeConverter.toFloat(this.columnBuffer[this.getRevisedColumnIndex(i)], 0, this.columnLength[this.getRevisedColumnIndex(i)], this.getColumnDataType(i));
        }
        return this.rset.getFloat(i);
    }

    @Override
    public float getFloat(String label) throws SQLException {
        return this.getFloat(this.findColumn(label));
    }

    private TbPreparedStatement getInsertRowStatement() throws SQLException {
        StringBuffer sb = new StringBuffer();
        sb.append("INSERT INTO ( ");
        sb.append(this.rset.stmt.getOriginalSql());
        sb.append(" ) VALUES ( ");
        int paramCnt = this.hasChanged.length;
        for (int i = this.beginColumnIndex; i < paramCnt; ++i) {
            if (i != this.beginColumnIndex) {
                sb.append(" , ");
            }
            sb.append("?");
        }
        sb.append(" ) ");
        Debug.logReturn("TbRSUpdatable.getInsertRowStatement", sb.toString());
        TbPreparedStatement pstmt = new TbPreparedStatement(this.rset.stmt.conn, sb.toString());
        if (this.rset.stmt instanceof ParamContainer) {
            pstmt.impl().copyBindParamInfo((ParamContainer)((Object)this.rset.stmt));
        }
        return pstmt;
    }

    @Override
    public synchronized int getInt(int i) throws SQLException {
        Debug.logMethod("TbRSUpdatable.getInt", new Object[]{this, Integer.toString(i)});
        this.checkColumnIndex(i);
        if (this.setLastColumnWasNull(i)) {
            return 0;
        }
        if (this.hasBufferChanged(i)) {
            return this.rset.typeConverter.toInt(this.columnBuffer[this.getRevisedColumnIndex(i)], 0, this.columnLength[this.getRevisedColumnIndex(i)], this.getColumnDataType(i));
        }
        return this.rset.getInt(i);
    }

    @Override
    public int getInt(String label) throws SQLException {
        return this.getInt(this.findColumn(label));
    }

    @Override
    public synchronized long getLong(int i) throws SQLException {
        Debug.logMethod("TbRSUpdatable.getLong", new Object[]{this, Integer.toString(i)});
        this.checkColumnIndex(i);
        if (this.setLastColumnWasNull(i)) {
            return 0L;
        }
        if (this.hasBufferChanged(i)) {
            return this.rset.typeConverter.toLong(this.columnBuffer[this.getRevisedColumnIndex(i)], 0, this.columnLength[this.getRevisedColumnIndex(i)], this.getColumnDataType(i));
        }
        return this.rset.getLong(i);
    }

    @Override
    public long getLong(String label) throws SQLException {
        return this.getLong(this.findColumn(label));
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return new TbResultSetMetaData(this.rset.cols, this.rset.beginColumnIndex);
    }

    @Override
    public Reader getNCharacterStream(int i) throws SQLException {
        Debug.logMethod("TbRSUpdatable.getNChracterStream", new Object[]{this, Integer.toString(i)});
        this.checkColumnIndex(i);
        if (this.setLastColumnWasNull(i)) {
            return null;
        }
        if (this.hasBufferChanged(i)) {
            Object data = this.columnBuffer[this.getRevisedColumnIndex(i)];
            if (data instanceof Reader) {
                return (Reader)data;
            }
            if (data instanceof NClob) {
                return ((TbNClob)data).getCharacterStream();
            }
            throw TbError.newSQLException(-590705, data.toString());
        }
        return this.rset.getNCharacterStream(i);
    }

    @Override
    public Reader getNCharacterStream(String label) throws SQLException {
        return this.getNCharacterStream(this.findColumn(label));
    }

    @Override
    public NClob getNClob(int i) throws SQLException {
        Debug.logMethod("TbRSUpdatable.getNClob", new Object[]{this, Integer.toString(i)});
        this.checkColumnIndex(i);
        if (this.setLastColumnWasNull(i)) {
            return null;
        }
        if (this.hasBufferChanged(i)) {
            Object data = this.columnBuffer[this.getRevisedColumnIndex(i)];
            if (data instanceof NClob) {
                return (NClob)data;
            }
            throw TbError.newSQLException(-590705, data.toString());
        }
        return this.rset.getNClob(i);
    }

    @Override
    public NClob getNClob(String label) throws SQLException {
        return this.getNClob(this.findColumn(label));
    }

    @Override
    public String getNString(int i) throws SQLException {
        Debug.logMethod("TbRSUpdatable.getNString", new Object[]{this, Integer.toString(i)});
        this.checkColumnIndex(i);
        if (this.setLastColumnWasNull(i)) {
            return null;
        }
        if (this.hasBufferChanged(i)) {
            Object data = this.columnBuffer[this.getRevisedColumnIndex(i)];
            if (data instanceof TbNClob) {
                long clobLength = ((TbNClob)data).length();
                return ((TbNClob)data).getSubString(1L, (int)clobLength);
            }
            return this.rset.typeConverter.toString(data, 0, this.columnLength[this.getRevisedColumnIndex(i)], this.getColumnDataType(i), this.getColumnPrecision(i), this.getColumnScale(i), !this.rset.getRsetType().isScrollable());
        }
        return this.rset.getNString(i);
    }

    @Override
    public String getNString(String label) throws SQLException {
        return this.getNString(this.findColumn(label));
    }

    @Override
    public synchronized Object getObject(int i) throws SQLException {
        Debug.logMethod("TbRSUpdatable.getObject", new Object[]{this, Integer.toString(i)});
        this.checkColumnIndex(i);
        if (this.setLastColumnWasNull(i)) {
            return null;
        }
        if (this.hasBufferChanged(i)) {
            this.rset.checkRsetAndConnClosed();
            Object data = this.columnBuffer[this.getRevisedColumnIndex(i)];
            if (data instanceof byte[]) {
                return this.rset.typeConverter.toObject(data, 0, this.columnLength[this.getRevisedColumnIndex(i)], this.getColumnDataType(i), this.getColumnSqlType(i), this.getColumnPrecision(i), this.getColumnScale(i), !this.rset.getRsetType().isScrollable(), null, null, this.rset.stmt.conn.typeMap);
            }
            return data;
        }
        return this.rset.getObject(i);
    }

    @Override
    public Object getObject(int i, Map<String, Class<?>> map) throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    @Override
    public Object getObject(String label) throws SQLException {
        return this.getObject(this.findColumn(label));
    }

    @Override
    public Object getObject(String label, Map<String, Class<?>> map) throws SQLException {
        return this.getObject(this.findColumn(label), map);
    }

    @Override
    public Ref getRef(int i) throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    @Override
    public Ref getRef(String label) throws SQLException {
        return this.getRef(this.findColumn(label));
    }

    @Override
    public synchronized int getRow() throws SQLException {
        return this.rset.getRow();
    }

    @Override
    public byte[] getRowChunk(int size) {
        return this.rset.getRowChunk(size);
    }

    @Override
    public RowId getRowId(int i) throws SQLException {
        Debug.logMethod("TbRSUpdatable.getRowId", new Object[]{this, Integer.toString(i)});
        this.checkColumnIndex(i);
        if (this.setLastColumnWasNull(i)) {
            return null;
        }
        if (this.hasBufferChanged(i)) {
            return this.rset.typeConverter.toRowId(this.columnBuffer[this.getRevisedColumnIndex(i)], 0, this.columnLength[this.getRevisedColumnIndex(i)], this.getColumnDataType(i));
        }
        return this.rset.getRowId(i);
    }

    @Override
    public RowId getRowId(String label) throws SQLException {
        return this.getRowId(this.findColumn(label));
    }

    @Override
    public synchronized short getShort(int i) throws SQLException {
        Debug.logMethod("TbRSUpdatable.getShort", new Object[]{this, Integer.toString(i)});
        this.checkColumnIndex(i);
        if (this.setLastColumnWasNull(i)) {
            return 0;
        }
        if (this.hasBufferChanged(i)) {
            return this.rset.typeConverter.toShort(this.columnBuffer[this.getRevisedColumnIndex(i)], 0, this.columnLength[this.getRevisedColumnIndex(i)], this.getColumnDataType(i));
        }
        return this.rset.getShort(i);
    }

    @Override
    public short getShort(String label) throws SQLException {
        return this.getShort(this.findColumn(label));
    }

    @Override
    public SQLXML getSQLXML(int i) throws SQLException {
        Debug.logMethod("TbRSUpdatable.getSQLXML", new Object[]{this, Integer.toString(i)});
        this.checkColumnIndex(i);
        if (this.setLastColumnWasNull(i)) {
            return null;
        }
        if (this.hasBufferChanged(i)) {
            return this.rset.typeConverter.toSQLXML(this.columnBuffer[this.getRevisedColumnIndex(i)], 0, this.columnLength[this.getRevisedColumnIndex(i)], this.getColumnDataType(i), false);
        }
        return this.rset.getSQLXML(i);
    }

    @Override
    public SQLXML getSQLXML(String label) throws SQLException {
        return this.getSQLXML(this.findColumn(label));
    }

    @Override
    public Statement getStatement() throws SQLException {
        return this.rset.getStatement();
    }

    @Override
    public synchronized String getString(int i) throws SQLException {
        Debug.logMethod("TbRSUpdatable.getString", new Object[]{this, Integer.toString(i)});
        this.checkColumnIndex(i);
        if (this.setLastColumnWasNull(i)) {
            return null;
        }
        if (this.hasBufferChanged(i)) {
            Object data = this.columnBuffer[this.getRevisedColumnIndex(i)];
            if (data instanceof TbClobBase) {
                long clobLength = ((TbClobBase)data).length();
                return ((TbClobBase)data).getSubString(1L, (int)clobLength);
            }
            return this.rset.typeConverter.toString(this.columnBuffer[this.getRevisedColumnIndex(i)], 0, this.columnLength[this.getRevisedColumnIndex(i)], this.getColumnDataType(i), this.getColumnPrecision(i), this.getColumnScale(i), !this.rset.getRsetType().isScrollable());
        }
        return this.rset.getString(i);
    }

    @Override
    public String getString(String label) throws SQLException {
        return this.getString(this.findColumn(label));
    }

    @Override
    public synchronized Time getTime(int i) throws SQLException {
        Debug.logMethod("TbRSUpdatable.getTime", new Object[]{this, Integer.toString(i)});
        return this.getTimeInternal(i);
    }

    @Override
    public Time getTime(int i, Calendar cal) throws SQLException {
        Debug.logMethod("TbRSUpdatable.getTime", new Object[]{this, Integer.toString(i), cal});
        Time time = this.getTimeInternal(i);
        if (cal != null) {
            cal.setTime(time);
            time = (Time)cal.getTime();
        }
        return time;
    }

    @Override
    public Time getTime(String label) throws SQLException {
        return this.getTime(this.findColumn(label));
    }

    @Override
    public Time getTime(String label, Calendar cal) throws SQLException {
        return this.getTime(this.findColumn(label), cal);
    }

    private Time getTimeInternal(int i) throws SQLException {
        this.checkColumnIndex(i);
        if (this.setLastColumnWasNull(i)) {
            return null;
        }
        if (this.hasBufferChanged(i)) {
            return this.rset.typeConverter.toTime(this.columnBuffer[this.getRevisedColumnIndex(i)], 0, this.columnLength[this.getRevisedColumnIndex(i)], this.getColumnDataType(i));
        }
        return this.rset.getTime(i);
    }

    @Override
    public synchronized Timestamp getTimestamp(int i) throws SQLException {
        Debug.logMethod("TbRSUpdatable.getTimestamp", new Object[]{this, Integer.toString(i)});
        return this.getTimestampInternal(i);
    }

    @Override
    public Timestamp getTimestamp(int i, Calendar cal) throws SQLException {
        Debug.logMethod("TbRSUpdatable.getTimestamp", new Object[]{this, Integer.toString(i), cal});
        Timestamp ts = this.getTimestampInternal(i);
        if (cal != null) {
            cal.setTime(ts);
            ts = (Timestamp)cal.getTime();
        }
        return ts;
    }

    @Override
    public Timestamp getTimestamp(String label) throws SQLException {
        return this.getTimestamp(this.findColumn(label));
    }

    @Override
    public Timestamp getTimestamp(String label, Calendar cal) throws SQLException {
        return this.getTimestamp(this.findColumn(label), cal);
    }

    private Timestamp getTimestampInternal(int i) throws SQLException {
        this.checkColumnIndex(i);
        if (this.setLastColumnWasNull(i)) {
            return null;
        }
        if (this.hasBufferChanged(i)) {
            return this.rset.typeConverter.toTimestamp(this.columnBuffer[this.getRevisedColumnIndex(i)], 0, this.columnLength[this.getRevisedColumnIndex(i)], this.getColumnDataType(i));
        }
        return this.rset.getTimestamp(i);
    }

    @Override
    public TbTimestamp getTbTimestamp(int i) throws SQLException {
        Debug.logMethod("TbResultSetBase.getTbTimestamp", new Object[]{this, Integer.toString(i)});
        return this.getTbTimestampInternal(i);
    }

    private TbTimestamp getTbTimestampInternal(int i) throws SQLException {
        this.checkColumnIndex(i);
        if (this.setLastColumnWasNull(i)) {
            return null;
        }
        if (this.hasBufferChanged(i)) {
            Row row = this.getCurrentRow();
            return this.rset.typeConverter.toTbTimestamp(row.getRowChunk(i + this.beginColumnIndex), this.getColumnOffset(row, i), this.getColumnLength(row, i), this.getColumnDataType(i));
        }
        return this.rset.getTbTimestamp(i);
    }

    @Override
    @Deprecated
    public synchronized InputStream getUnicodeStream(int i) throws SQLException {
        Debug.logMethod("TbRSUpdatable.getUnicodeStream", new Object[]{this, Integer.toString(i)});
        this.checkColumnIndex(i);
        if (this.setLastColumnWasNull(i)) {
            return null;
        }
        if (this.hasBufferChanged(i)) {
            Object data = this.columnBuffer[this.getRevisedColumnIndex(i)];
            if (data instanceof InputStream) {
                return (InputStream)data;
            }
            if (data instanceof byte[]) {
                return new ByteArrayInputStream((byte[])data);
            }
            throw TbError.newSQLException(-590705);
        }
        return this.rset.getAsciiStream(i);
    }

    @Override
    @Deprecated
    public InputStream getUnicodeStream(String label) throws SQLException {
        return this.getUnicodeStream(this.findColumn(label));
    }

    private TbPreparedStatement getUpdateRowStatement() throws SQLException {
        StringBuffer sb = new StringBuffer();
        sb.append("UPDATE ( ");
        sb.append(this.rset.stmt.getOriginalSql());
        sb.append(" ) SET ");
        int colCnt = this.hasChanged.length;
        for (int j = 0; j < colCnt; ++j) {
            if (!this.hasChanged[j]) continue;
            if (j != 0 && this.hasChanged[j - 1]) {
                sb.append(" , ");
            }
            sb.append(this.rset.getColumnName(j)).append(" = ? ");
        }
        sb.append(" WHERE ROWIDTOCHAR(ROWID) = ? ");
        Debug.logReturn("TbRSUpdatable.getUpdateRowStatement", sb.toString());
        TbPreparedStatement pstmt = new TbPreparedStatement(this.rset.stmt.conn, sb.toString());
        if (this.rset.stmt instanceof ParamContainer) {
            pstmt.impl().copyBindParamInfo((ParamContainer)((Object)this.rset.stmt));
        }
        return pstmt;
    }

    @Override
    public URL getURL(int i) throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    @Override
    public URL getURL(String label) throws SQLException {
        return this.getURL(this.findColumn(label));
    }

    protected boolean hasBufferChanged(int i) throws SQLException {
        int revisedColumnIndex = i + this.beginColumnIndex - 1;
        this.checkColumnIndex(revisedColumnIndex);
        return (this.onInserting || this.onUpdating) && this.hasChanged[revisedColumnIndex];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void insertRow() throws SQLException {
        Debug.logMethod("TbRSUpdatable.insertRow", new Object[]{this});
        if (!this.onInserting) {
            throw TbError.newSQLException(-590774);
        }
        TbPreparedStatement insertStmt = null;
        try {
            insertStmt = this.getInsertRowStatement();
            this.bindInsertRowChangedData(insertStmt);
            int retCnt = insertStmt.executeUpdate();
            if (retCnt <= 0) {
                throw TbError.newSQLException(-590779, retCnt);
            }
            if (retCnt > 1) {
                throw TbError.newSQLException(-590780, retCnt);
            }
        }
        finally {
            if (insertStmt != null) {
                try {
                    insertStmt.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    public synchronized boolean isAfterLast() throws SQLException {
        Debug.logMethod("TbRSUpdatable.isAfterLast", new Object[]{this});
        if (this.onInserting) {
            return false;
        }
        return this.rset.isAfterLast();
    }

    @Override
    public synchronized boolean isBeforeFirst() throws SQLException {
        Debug.logMethod("TbRSUpdatable.isBeforeFirst", new Object[]{this});
        if (this.onInserting) {
            return false;
        }
        return this.rset.isBeforeFirst();
    }

    @Override
    public boolean isClosed() throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    @Override
    public synchronized boolean isFirst() throws SQLException {
        Debug.logMethod("TbRSUpdatable.isFirst", new Object[]{this});
        if (this.onInserting) {
            return false;
        }
        return this.rset.isFirst();
    }

    @Override
    public synchronized boolean isLast() throws SQLException {
        Debug.logMethod("TbRSUpdatable.isLast", new Object[]{this});
        if (this.onInserting) {
            return false;
        }
        return this.rset.isLast();
    }

    @Override
    public synchronized boolean last() throws SQLException {
        Debug.logMethod("TbRSUpdatable.last", new Object[]{this});
        this.cancelChanges();
        return this.rset.last();
    }

    @Override
    public synchronized void moveToCurrentRow() throws SQLException {
        Debug.logMethod("TbRSUpdatable.moveToCurrentRow", new Object[]{this});
        this.cancelRowInserts();
    }

    @Override
    public synchronized void moveToInsertRow() throws SQLException {
        Debug.logMethod("TbRSUpdatable.moveToInsertRow", new Object[]{this});
        if (this.onInserting) {
            return;
        }
        this.onInserting = true;
        if (this.columnBuffer == null) {
            this.columnBuffer = new Object[this.columnCount];
            this.columnLength = new int[this.columnCount];
            this.hasChanged = new boolean[this.columnCount];
        } else {
            this.resetBuffer();
        }
    }

    @Override
    public synchronized boolean next() throws SQLException {
        Debug.logMethod("TbRSUpdatable.next", new Object[]{this});
        this.cancelChanges();
        return this.rset.next();
    }

    @Override
    public synchronized boolean previous() throws SQLException {
        Debug.logMethod("TbRSUpdatable.previous", new Object[]{this});
        this.cancelChanges();
        return this.rset.previous();
    }

    @Override
    public synchronized void refreshRow() throws SQLException {
        Debug.logMethod("TbRSUpdatable.refreshRow", new Object[]{this});
        if (this.onInserting) {
            throw TbError.newSQLException(-590775);
        }
        this.rset.refreshRow();
    }

    @Override
    public synchronized boolean relative(int i) throws SQLException {
        Debug.logMethod("TbRSUpdatable.relative", new Object[]{Integer.toString(i)});
        this.cancelChanges();
        return this.rset.relative(i);
    }

    @Override
    public void reset() {
        super.reset();
        this.rset = null;
        this.columnBuffer = null;
        this.columnLength = null;
        this.hasChanged = null;
        this.lastColumnWasNull = false;
    }

    protected void resetBuffer() {
        if (this.columnBuffer != null) {
            for (int i = 0; i < this.columnCount - this.beginColumnIndex; ++i) {
                this.columnBuffer[i] = null;
                this.columnLength[i] = 0;
                this.hasChanged[i] = false;
            }
        }
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        Debug.logMethod("TbRSUpdatable.rowDeleted", new Object[]{this});
        return false;
    }

    @Override
    public boolean rowInserted() throws SQLException {
        Debug.logMethod("TbRSUpdatable.rowInserted", new Object[]{this});
        return false;
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        Debug.logMethod("TbRSUpdatable.rowUpdated", new Object[]{this});
        return false;
    }

    protected void setColumnBuffer(int i, int length, Object data) throws SQLException {
        Debug.logMethod("TbRSUpdatable.setColumnBuffer", new Object[]{this, Integer.toString(i), Integer.toString(length), data});
        this.checkColumnIndex(i);
        if (this.columnBuffer == null) {
            this.columnBuffer = new Object[this.columnCount];
        }
        if (this.columnLength == null) {
            this.columnLength = new int[this.columnCount];
        }
        if (this.hasChanged == null) {
            this.hasChanged = new boolean[this.columnCount];
        }
        int revisedColumnIndex = this.getRevisedColumnIndex(i);
        this.hasChanged[revisedColumnIndex] = true;
        this.columnLength[revisedColumnIndex] = length;
        this.columnBuffer[revisedColumnIndex] = data;
    }

    @Override
    public synchronized void setFetchCompleted(int fetchResultBitmap) {
        Debug.logMethod("TbRSUpdatable.setFetchCompleted", new Object[]{Integer.toBinaryString(fetchResultBitmap)});
        this.rset.setFetchCompleted(fetchResultBitmap);
    }

    @Override
    public synchronized void setFetchDirection(int direction) throws SQLException {
        Debug.logMethod("TbRSUpdatable.setFetchDirection", new Object[]{this, Integer.toString(direction)});
        this.rset.setFetchDirection(direction);
    }

    @Override
    public synchronized void setFetchSize(int rows) throws SQLException {
        Debug.logMethod("TbRSUpdatable.setFetchSize", new Object[]{this, Integer.toString(rows)});
        this.rset.setFetchSize(rows);
    }

    private boolean setLastColumnWasNull(int i) throws SQLException {
        this.lastColumnWasNull = this.getCurrentRow().isNull(i + this.beginColumnIndex);
        return this.lastColumnWasNull;
    }

    private void storeUpdatedRowChunk() throws SQLException {
        int paramCnt = this.hasChanged.length;
        Row row = this.rset.getCurrentRow();
        for (int i = 0; i < paramCnt; ++i) {
            if (!this.hasChanged[i]) continue;
            row.setUpdatedColumn(i + 1, this.columnLength[i], this.columnBuffer[i]);
        }
    }

    @Override
    public synchronized void updateArray(int i, Array x) throws SQLException {
        throw TbError.newSQLException(-590725);
    }

    @Override
    public void updateArray(String label, Array x) throws SQLException {
        this.updateArray(this.findColumn(label), x);
    }

    @Override
    public synchronized void updateAsciiStream(int i, InputStream x) throws SQLException {
        Debug.logMethod("TbRSUpdatable.updateAsciiStream", new Object[]{this, Integer.toString(i), x});
        this.updateBinaryStream(i, x, Integer.MAX_VALUE);
    }

    @Override
    public synchronized void updateAsciiStream(int i, InputStream x, int length) throws SQLException {
        Debug.logMethod("TbRSUpdatable.updateAsciiStream", new Object[]{this, Integer.toString(i), x, Integer.toString(length)});
        this.updateBinaryStream(i, x, length);
    }

    @Override
    public synchronized void updateAsciiStream(int i, InputStream x, long len) throws SQLException {
        Debug.logMethod("TbRSUpdatable.updateAsciiStream", new Object[]{this, Integer.toString(i), x, Long.toString(len)});
        if (len > Integer.MAX_VALUE) {
            throw TbError.newSQLException(-90656, len);
        }
        this.updateBinaryStream(i, x, (int)len);
    }

    @Override
    public void updateAsciiStream(String label, InputStream x) throws SQLException {
        this.updateAsciiStream(this.findColumn(label), x);
    }

    @Override
    public void updateAsciiStream(String label, InputStream x, int length) throws SQLException {
        this.updateAsciiStream(this.findColumn(label), x, length);
    }

    @Override
    public void updateAsciiStream(String label, InputStream x, long length) throws SQLException {
        this.updateAsciiStream(this.findColumn(label), x, length);
    }

    @Override
    public synchronized void updateBigDecimal(int i, BigDecimal x) throws SQLException {
        Debug.logMethod("TbRSUpdatable.updateBigDecimal", new Object[]{this, Integer.toString(i), x});
        this.checkUpdateCursorPosition();
        if (x == null) {
            this.updateNull(i);
            return;
        }
        byte[] data = this.rset.typeConverter.castFromBigDecimal(x, this.rset.getColumnDataType(i));
        this.setColumnBuffer(i, data.length, data);
    }

    @Override
    public void updateBigDecimal(String label, BigDecimal x) throws SQLException {
        this.updateBigDecimal(this.findColumn(label), x);
    }

    @Override
    public synchronized void updateBinaryStream(int i, InputStream x) throws SQLException {
        Debug.logMethod("TbRSUpdatable.updateBinaryStream", new Object[]{this, Integer.toString(i), x});
        if (x == null) {
            this.updateNull(i);
        } else {
            this.checkUpdateCursorPosition();
            this.setColumnBuffer(i, Integer.MAX_VALUE, x);
        }
    }

    @Override
    public synchronized void updateBinaryStream(int i, InputStream x, int length) throws SQLException {
        Debug.logMethod("TbRSUpdatable.updateBinaryStream", new Object[]{this, Integer.toString(i), x, Integer.toString(length)});
        if (x == null || length <= 0) {
            this.updateNull(i);
        } else {
            this.checkUpdateCursorPosition();
            this.setColumnBuffer(i, length, x);
        }
    }

    @Override
    public synchronized void updateBinaryStream(int i, InputStream x, long len) throws SQLException {
        Debug.logMethod("TbRSUpdatable.updateBinaryStream", new Object[]{this, Integer.toString(i), x, Long.toString(len)});
        if (x == null || len <= 0L) {
            this.updateNull(i);
        } else {
            if (len > Integer.MAX_VALUE) {
                throw TbError.newSQLException(-90656, Long.toString(len));
            }
            this.checkUpdateCursorPosition();
            this.setColumnBuffer(i, (int)len, x);
        }
    }

    @Override
    public void updateBinaryStream(String label, InputStream x) throws SQLException {
        this.updateBinaryStream(this.findColumn(label), x);
    }

    @Override
    public void updateBinaryStream(String label, InputStream x, int length) throws SQLException {
        this.updateBinaryStream(this.findColumn(label), x, length);
    }

    @Override
    public void updateBinaryStream(String label, InputStream x, long length) throws SQLException {
        this.updateBinaryStream(this.findColumn(label), x, length);
    }

    @Override
    public synchronized void updateBlob(int i, Blob x) throws SQLException {
        Debug.logMethod("TbRSUpdatable.updateBlob", new Object[]{this, Integer.toString(i), x});
        if (x == null) {
            this.updateNull(i);
        } else {
            if (!(x instanceof TbBlob)) {
                throw TbError.newSQLException(-590702, x.toString());
            }
            this.checkUpdateCursorPosition();
            this.setColumnBuffer(i, Integer.MAX_VALUE, x);
        }
    }

    @Override
    public synchronized void updateBlob(int i, InputStream x) throws SQLException {
        Debug.logMethod("TbRSUpdatable.updateBlob", new Object[]{this, Integer.toString(i), x});
        if (x == null) {
            this.updateNull(i);
        } else {
            this.checkUpdateCursorPosition();
            this.setColumnBuffer(i, Integer.MAX_VALUE, x);
        }
    }

    @Override
    public synchronized void updateBlob(int i, InputStream x, long len) throws SQLException {
        Debug.logMethod("TbRSUpdatable.updateBlob", new Object[]{this, Integer.toString(i), x, Long.toString(len)});
        if (x == null || len <= 0L) {
            this.updateNull(i);
        } else {
            if (len > Integer.MAX_VALUE) {
                throw TbError.newSQLException(-90656, Long.toString(len));
            }
            this.checkUpdateCursorPosition();
            this.setColumnBuffer(i, (int)len, x);
        }
    }

    @Override
    public void updateBlob(String label, Blob x) throws SQLException {
        this.updateBlob(this.findColumn(label), x);
    }

    @Override
    public void updateBlob(String label, InputStream x) throws SQLException {
        this.updateBlob(this.findColumn(label), x);
    }

    @Override
    public void updateBlob(String label, InputStream x, long length) throws SQLException {
        this.updateBlob(this.findColumn(label), x, length);
    }

    @Override
    public synchronized void updateBoolean(int i, boolean x) throws SQLException {
        Debug.logMethod("TbRSUpdatable.updateBoolean", new Object[]{this, Integer.toString(i), new Boolean(x)});
        this.checkUpdateCursorPosition();
        byte[] data = this.rset.typeConverter.castFromBoolean(x, this.rset.getColumnDataType(i));
        this.setColumnBuffer(i, data.length, data);
    }

    @Override
    public void updateBoolean(String label, boolean x) throws SQLException {
        this.updateBoolean(this.findColumn(label), x);
    }

    @Override
    public synchronized void updateByte(int i, byte x) throws SQLException {
        Debug.logMethod("TbRSUpdatable.updateByte", new Object[]{this, Integer.toString(i), Byte.toString(x)});
        this.checkUpdateCursorPosition();
        byte[] data = this.rset.typeConverter.castFromByte(x, this.rset.getColumnDataType(i));
        this.setColumnBuffer(i, data.length, data);
    }

    @Override
    public void updateByte(String label, byte x) throws SQLException {
        this.updateByte(this.findColumn(label), x);
    }

    @Override
    public synchronized void updateBytes(int i, byte[] x) throws SQLException {
        Debug.logMethod("TbRSUpdatable.updateBytes", new Object[]{this, Integer.toString(i), new String(x)});
        this.checkUpdateCursorPosition();
        if (x == null) {
            this.updateNull(i);
            return;
        }
        byte[] data = this.rset.typeConverter.castFromBytes(x, this.rset.getColumnDataType(i));
        this.setColumnBuffer(i, data.length, data);
    }

    @Override
    public void updateBytes(String label, byte[] x) throws SQLException {
        this.updateBytes(this.findColumn(label), x);
    }

    @Override
    public synchronized void updateCharacterStream(int i, Reader x) throws SQLException {
        Debug.logMethod("TbRSUpdatable.updateCharacterStream", new Object[]{this, Integer.toString(i), x});
        if (x == null) {
            this.updateNull(i);
        } else {
            this.checkUpdateCursorPosition();
            this.setColumnBuffer(i, Integer.MAX_VALUE, x);
        }
    }

    @Override
    public synchronized void updateCharacterStream(int i, Reader x, int length) throws SQLException {
        Debug.logMethod("TbRSUpdatable.updateCharacterStream", new Object[]{this, Integer.toString(i), x, Integer.toString(length)});
        if (x == null || length <= 0) {
            this.updateNull(i);
        } else {
            this.checkUpdateCursorPosition();
            this.setColumnBuffer(i, Integer.MAX_VALUE, x);
        }
    }

    @Override
    public synchronized void updateCharacterStream(int i, Reader x, long len) throws SQLException {
        Debug.logMethod("TbRSUpdatable.updateCharacterStream", new Object[]{this, Integer.toString(i), x, Long.toString(len)});
        if (x == null || len <= 0L) {
            this.updateNull(i);
        } else {
            if (len > Integer.MAX_VALUE) {
                throw TbError.newSQLException(-90656, Long.toString(len));
            }
            this.checkUpdateCursorPosition();
            this.setColumnBuffer(i, (int)len, x);
        }
    }

    @Override
    public void updateCharacterStream(String label, Reader x) throws SQLException {
        this.updateCharacterStream(this.findColumn(label), x);
    }

    @Override
    public void updateCharacterStream(String label, Reader x, int length) throws SQLException {
        this.updateCharacterStream(this.findColumn(label), x, length);
    }

    @Override
    public void updateCharacterStream(String label, Reader x, long length) throws SQLException {
        this.updateCharacterStream(this.findColumn(label), x, length);
    }

    @Override
    public synchronized void updateClob(int i, Clob x) throws SQLException {
        Debug.logMethod("TbRSUpdatable.updateClob", new Object[]{this, Integer.toString(i), x});
        if (x == null) {
            this.updateNull(i);
        } else {
            if (!(x instanceof TbClobBase)) {
                throw TbError.newSQLException(-590702, x.toString());
            }
            this.checkUpdateCursorPosition();
            this.setColumnBuffer(i, Integer.MAX_VALUE, x);
        }
    }

    @Override
    public synchronized void updateClob(int i, Reader x) throws SQLException {
        Debug.logMethod("TbRSUpdatable.updateClob", new Object[]{this, Integer.toString(i), x});
        if (x == null) {
            this.updateNull(i);
        } else {
            this.checkUpdateCursorPosition();
            this.setColumnBuffer(i, Integer.MAX_VALUE, x);
        }
    }

    @Override
    public synchronized void updateClob(int i, Reader x, long len) throws SQLException {
        Debug.logMethod("TbRSUpdatable.updateClob", new Object[]{this, Integer.toString(i), x, Long.toString(len)});
        if (x == null || len <= 0L) {
            this.updateNull(i);
        } else {
            if (len > Integer.MAX_VALUE) {
                throw TbError.newSQLException(-90656, Long.toString(len));
            }
            this.checkUpdateCursorPosition();
            this.setColumnBuffer(i, (int)len, x);
        }
    }

    @Override
    public void updateClob(String label, Clob x) throws SQLException {
        this.updateClob(this.findColumn(label), x);
    }

    @Override
    public void updateClob(String label, Reader x) throws SQLException {
        this.updateClob(this.findColumn(label), x);
    }

    @Override
    public void updateClob(String label, Reader x, long length) throws SQLException {
        this.updateClob(this.findColumn(label), x, length);
    }

    @Override
    public synchronized void updateDate(int i, Date x) throws SQLException {
        Debug.logMethod("TbRSUpdatable.updateDate", new Object[]{this, Integer.toString(i), x});
        this.checkUpdateCursorPosition();
        if (x == null) {
            this.updateNull(i);
            return;
        }
        byte[] data = this.rset.typeConverter.castFromDate(x, this.rset.getColumnDataType(i));
        this.setColumnBuffer(i, data.length, data);
    }

    @Override
    public void updateDate(String label, Date x) throws SQLException {
        this.updateDate(this.findColumn(label), x);
    }

    @Override
    public synchronized void updateDouble(int i, double x) throws SQLException {
        Debug.logMethod("TbRSUpdatable.updateDouble", new Object[]{this, Integer.toString(i), Double.toString(x)});
        this.checkUpdateCursorPosition();
        byte[] data = this.rset.typeConverter.castFromDouble(x, this.rset.getColumnDataType(i));
        this.setColumnBuffer(i, data.length, data);
    }

    @Override
    public void updateDouble(String label, double x) throws SQLException {
        this.updateDouble(this.findColumn(label), x);
    }

    @Override
    public synchronized void updateFloat(int i, float x) throws SQLException {
        Debug.logMethod("TbRSUpdatable.updateFloat", new Object[]{this, Integer.toString(i), Float.toString(x)});
        this.checkUpdateCursorPosition();
        byte[] data = this.rset.typeConverter.castFromFloat(x, this.rset.getColumnDataType(i));
        this.setColumnBuffer(i, data.length, data);
    }

    @Override
    public void updateFloat(String label, float x) throws SQLException {
        this.updateFloat(this.findColumn(label), x);
    }

    @Override
    public synchronized void updateInt(int i, int x) throws SQLException {
        Debug.logMethod("TbRSUpdatable.updateInt", new Object[]{this, Integer.toString(i), Integer.toString(x)});
        this.checkUpdateCursorPosition();
        byte[] data = this.rset.typeConverter.castFromInt(x, this.rset.getColumnDataType(i));
        this.setColumnBuffer(i, data.length, data);
    }

    @Override
    public void updateInt(String label, int x) throws SQLException {
        this.updateInt(this.findColumn(label), x);
    }

    @Override
    public synchronized void updateLong(int i, long x) throws SQLException {
        Debug.logMethod("TbRSUpdatable.updateLong", new Object[]{this, Integer.toString(i), Long.toString(x)});
        this.checkUpdateCursorPosition();
        byte[] data = this.rset.typeConverter.castFromLong(x, this.rset.getColumnDataType(i));
        this.setColumnBuffer(i, data.length, data);
    }

    @Override
    public void updateLong(String label, long x) throws SQLException {
        this.updateLong(this.findColumn(label), x);
    }

    @Override
    public synchronized void updateNCharacterStream(int i, Reader x) throws SQLException {
        Debug.logMethod("TbRSUpdatable.updateNCharacterStream", new Object[]{this, Integer.toString(i), x});
        if (x == null) {
            this.updateNull(i);
        } else {
            this.checkUpdateCursorPosition();
            this.setColumnBuffer(i, Integer.MAX_VALUE, x);
        }
    }

    @Override
    public synchronized void updateNCharacterStream(int i, Reader x, long len) throws SQLException {
        Debug.logMethod("TbRSUpdatable.updateNCharacterStream", new Object[]{this, Integer.toString(i), x, Long.toString(len)});
        if (x == null || len <= 0L) {
            this.updateNull(i);
        } else {
            if (len > Integer.MAX_VALUE) {
                throw TbError.newSQLException(-90656, Long.toString(len));
            }
            this.checkUpdateCursorPosition();
            this.setColumnBuffer(i, (int)len, x);
        }
    }

    @Override
    public void updateNCharacterStream(String label, Reader x) throws SQLException {
        this.updateNCharacterStream(this.findColumn(label), x);
    }

    @Override
    public void updateNCharacterStream(String label, Reader x, long length) throws SQLException {
        this.updateNCharacterStream(this.findColumn(label), x, length);
    }

    @Override
    public synchronized void updateNClob(int i, NClob x) throws SQLException {
        Debug.logMethod("TbRSUpdatable.updateNClob", new Object[]{this, Integer.toString(i), x});
        if (x == null) {
            this.updateNull(i);
        } else {
            if (!(x instanceof TbNClob)) {
                throw TbError.newSQLException(-590702, x.toString());
            }
            this.checkUpdateCursorPosition();
            this.setColumnBuffer(i, Integer.MAX_VALUE, x);
        }
    }

    @Override
    public synchronized void updateNClob(int i, Reader x) throws SQLException {
        this.updateNClob(i, x, Integer.MAX_VALUE);
    }

    @Override
    public synchronized void updateNClob(int i, Reader x, long length) throws SQLException {
        Debug.logMethod("TbRSUpdatable.updateNClob", new Object[]{this, Integer.toString(i), x, Long.toString(length)});
        if (length > Integer.MAX_VALUE) {
            throw TbError.newSQLException(-90656, Long.toString(length));
        }
        if (x == null || length <= 0L) {
            this.updateNull(i);
        } else {
            this.checkUpdateCursorPosition();
            this.setColumnBuffer(i, Integer.MAX_VALUE, x);
        }
    }

    @Override
    public void updateNClob(String label, NClob x) throws SQLException {
        this.updateNClob(this.findColumn(label), x);
    }

    @Override
    public void updateNClob(String label, Reader x) throws SQLException {
        this.updateNClob(this.findColumn(label), x);
    }

    @Override
    public void updateNClob(String label, Reader x, long length) throws SQLException {
        this.updateNClob(this.findColumn(label), x, length);
    }

    @Override
    public synchronized void updateNString(int i, String x) throws SQLException {
        Debug.logMethod("TbRSUpdatable.updateNString", new Object[]{this, Integer.toString(i), x});
        this.checkUpdateCursorPosition();
        byte[] data = this.rset.typeConverter.castFromString(x, this.rset.getColumnDataType(i));
        this.setColumnBuffer(i, data.length, data);
    }

    @Override
    public void updateNString(String label, String x) throws SQLException {
        this.updateNString(this.findColumn(label), x);
    }

    @Override
    public synchronized void updateNull(int i) throws SQLException {
        Debug.logMethod("TbRSUpdatable.updateNull", new Object[]{this, Integer.toString(i)});
        this.checkUpdateCursorPosition();
        this.setColumnBuffer(i, 0, new byte[0]);
    }

    @Override
    public void updateNull(String label) throws SQLException {
        this.updateNull(this.findColumn(label));
    }

    @Override
    public synchronized void updateObject(int i, Object x) throws SQLException {
        this.updateObject(i, x, 0);
    }

    @Override
    public synchronized void updateObject(int i, Object x, int scale) throws SQLException {
        Debug.logMethod("TbRSUpdatable.updateObject", new Object[]{this, Integer.toString(i), x, Integer.toString(scale)});
        if (x == null) {
            this.updateNull(i);
            return;
        }
        this.checkUpdateCursorPosition();
        byte[] data = this.rset.typeConverter.castFromObject(x, this.rset.getColumnDataType(i));
        this.setColumnBuffer(i, data.length, data);
    }

    @Override
    public void updateObject(String label, Object x) throws SQLException {
        this.updateObject(this.findColumn(label), x);
    }

    @Override
    public void updateObject(String label, Object x, int scaleOrLength) throws SQLException {
        this.updateObject(this.findColumn(label), x);
    }

    @Override
    public synchronized void updateRef(int i, Ref x) throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    @Override
    public void updateRef(String label, Ref x) throws SQLException {
        this.updateRef(this.findColumn(label), x);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void updateRow() throws SQLException {
        Debug.logMethod("TbRSUpdatable.updateRow", new Object[]{this});
        if (this.onInserting) {
            throw TbError.newSQLException(-590776);
        }
        TbPreparedStatement updateStmt = null;
        try {
            updateStmt = this.getUpdateRowStatement();
            this.bindUpdateRowChangedData(updateStmt);
            int retCnt = updateStmt.executeUpdate();
            if (retCnt <= 0) {
                throw TbError.newSQLException(-590781, retCnt);
            }
            if (retCnt > 1) {
                throw TbError.newSQLException(-590782, retCnt);
            }
            if (this.rset instanceof TbRSSensitive) {
                ((TbRSSensitive)this.rset).refreshRowForced(1);
            }
            this.storeUpdatedRowChunk();
        }
        finally {
            if (updateStmt != null) {
                try {
                    updateStmt.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    public synchronized void updateRowId(int i, RowId x) throws SQLException {
        Debug.logMethod("TbRSUpdatable.updateRowId", new Object[]{this, Integer.toString(i), x});
        this.checkUpdateCursorPosition();
        if (!(x instanceof TbRowId)) {
            throw TbError.newSQLException(-590771, ((Object)x).toString());
        }
        byte[] data = x.getBytes();
        this.setColumnBuffer(i, data.length, data);
    }

    @Override
    public void updateRowId(String label, RowId x) throws SQLException {
        this.updateRowId(this.findColumn(label), x);
    }

    @Override
    public synchronized void updateShort(int i, short x) throws SQLException {
        Debug.logMethod("TbRSUpdatable.updateShort", new Object[]{this, Integer.toString(i), Short.toString(x)});
        this.checkUpdateCursorPosition();
        byte[] data = this.rset.typeConverter.castFromShort(x, this.rset.getColumnDataType(i));
        this.setColumnBuffer(i, data.length, data);
    }

    @Override
    public void updateShort(String label, short x) throws SQLException {
        this.updateShort(this.findColumn(label), x);
    }

    @Override
    public synchronized void updateSQLXML(int i, SQLXML x) throws SQLException {
        Debug.logMethod("TbRSUpdatable.updateSQLXML", new Object[]{this, Integer.toString(i), x});
        if (x == null) {
            this.updateNull(i);
        } else {
            if (!(x instanceof TbSQLXML)) {
                throw TbError.newSQLException(-590702, x.toString());
            }
            this.checkUpdateCursorPosition();
            this.setColumnBuffer(i, Integer.MAX_VALUE, x);
        }
    }

    @Override
    public void updateSQLXML(String label, SQLXML x) throws SQLException {
        this.updateSQLXML(this.findColumn(label), x);
    }

    @Override
    public synchronized void updateString(int i, String x) throws SQLException {
        Debug.logMethod("TbRSUpdatable.updateString", new Object[]{this, Integer.toString(i), x});
        this.checkUpdateCursorPosition();
        byte[] data = this.rset.typeConverter.castFromString(x, this.rset.getColumnDataType(i));
        this.setColumnBuffer(i, data.length, data);
    }

    @Override
    public void updateString(String label, String x) throws SQLException {
        this.updateString(this.findColumn(label), x);
    }

    @Override
    public synchronized void updateTime(int i, Time x) throws SQLException {
        Debug.logMethod("TbRSUpdatable.updateTime", new Object[]{this, Integer.toString(i), x});
        this.checkUpdateCursorPosition();
        byte[] data = this.rset.typeConverter.castFromTime(x, this.rset.getColumnDataType(i));
        this.setColumnBuffer(i, data.length, data);
    }

    @Override
    public void updateTime(String label, Time x) throws SQLException {
        this.updateTime(this.findColumn(label), x);
    }

    @Override
    public synchronized void updateTimestamp(int i, Timestamp x) throws SQLException {
        Debug.logMethod("TbRSUpdatable.updateTimestamp", new Object[]{this, Integer.toString(i), x});
        this.checkUpdateCursorPosition();
        byte[] data = this.rset.typeConverter.castFromTimestamp(x, this.rset.getColumnDataType(i));
        this.setColumnBuffer(i, data.length, data);
    }

    @Override
    public void updateTimestamp(String label, Timestamp x) throws SQLException {
        this.updateTimestamp(this.findColumn(label), x);
    }

    @Override
    public synchronized void updateTbTimestamp(int i, TbTimestamp x) throws SQLException {
        Debug.logMethod("TbRSUpdatable.updateTimestamp", new Object[]{this, Integer.toString(i), x});
        this.checkUpdateCursorPosition();
        TbTimestamp tbTimestamp = new TbTimestamp(x.getBytes());
        byte[] data = tbTimestamp.getBytes();
        this.setColumnBuffer(i, data.length, data);
    }

    @Override
    public void updateTbTimestamp(String label, TbTimestamp x) throws SQLException {
        this.updateTbTimestamp(this.findColumn(label), x);
    }

    @Override
    public synchronized boolean wasNull() throws SQLException {
        Debug.logMethod("TbRSUpdatable.wasNull", new Object[]{this});
        return this.lastColumnWasNull;
    }
}

