/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.driver;

import com.tmax.tibero.Debug;
import com.tmax.tibero.jdbc.driver.TbKeepAlivePollingThread;
import com.tmax.tibero.jdbc.util.TbCommon;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;

public class TbKeepAlive {
    private static final int FIELD_OFFSET__MSG_TYPE = 0;
    private static final int FIELD_LEN__MSG_TYPE = 4;
    private static final int FIELD_OFFSET__BODY_SIZE = 4;
    private static final int FIELD_LEN__BODY_SIZE = 4;
    private static final int FIELD_OFFSET_FROM_END__MTHR_PID = 16;
    private static final int FIELD_LEN__MTHR_PID = 4;
    private static final int BUFFER_SIZE = 256;
    public static final int STATE_UNKNOWN = 0;
    public static final int STATE_SVR_IS_ALIVE = 1;
    public static final int STATE_REPLY_NOT_FINISHED = 2;
    public static final int STATE_NO_REPLY = 3;
    public static final int STATE_REPLY_FROM_WRONG_SVR = 4;
    public static final int STATE_CHECK_FAILED = 5;
    private Socket socket;
    private int svrIntanceIdFromMthrPid;
    private SocketAddress address;
    private SocketChannel channel;
    private int replyMsgBodySize;
    private int tryCount;
    private long baseTime;
    private ByteBuffer buf;
    private int maxRetryCount;
    private long idleMillis;
    private long intervalMillis;
    private String connNameForLog;
    private boolean registered = false;
    private static final TbKeepAlivePollingThread pollingThread = new TbKeepAlivePollingThread();

    public static TbKeepAlive register(Socket socket, long idleTimeMillis, long intervalTimeMillis, int maxRetryCount, int svrMthrPid, String connName) {
        Debug.logMethod("TbKeepAlive.register", new String[]{"socket", "idleTimeMillis", "intervalTimeMillis", "maxRetryCount"}, new Object[]{socket, new Long(idleTimeMillis), new Long(intervalTimeMillis), new Integer(maxRetryCount)});
        TbKeepAlive keepAlive = new TbKeepAlive(socket, idleTimeMillis, intervalTimeMillis, maxRetryCount, svrMthrPid, connName);
        pollingThread.add(keepAlive);
        keepAlive.registered = true;
        return keepAlive;
    }

    public static void register(TbKeepAlive keepAlive) {
        Debug.logMethod("TbKeepAlive.register", new String[]{"keepAlive"}, new Object[]{keepAlive});
        pollingThread.add(keepAlive);
        keepAlive.registered = true;
    }

    public static void unregister(TbKeepAlive keepAlive) {
        Debug.logMethod("TbKeepAlive.unregister", new String[]{"keepAlive"}, new Object[]{keepAlive});
        pollingThread.remove(keepAlive);
        keepAlive.registered = false;
    }

    TbKeepAlive(Socket socket, long idleTimeMillis, long intervalTimeMillis, int maxRetryCount, int svrMthrPid, String connName) {
        this.socket = socket;
        this.address = socket.getRemoteSocketAddress();
        this.baseTime = System.currentTimeMillis();
        this.channel = null;
        this.replyMsgBodySize = -1;
        this.tryCount = 0;
        this.idleMillis = idleTimeMillis;
        this.intervalMillis = intervalTimeMillis;
        this.maxRetryCount = maxRetryCount;
        this.svrIntanceIdFromMthrPid = svrMthrPid >> 16;
        this.connNameForLog = connName;
        this.buf = ByteBuffer.allocate(256);
    }

    void resetBaseTime() {
        this.baseTime = System.currentTimeMillis();
        this.tryCount = 0;
    }

    synchronized SocketChannel getChannel() {
        if (this.registered) {
            return this.channel;
        }
        return null;
    }

    synchronized void closeCheckChannel(int state) {
        Debug.logMethod("TbKeepAlive.closeCheckChannel", new String[]{"TbKeepAlive", "state"}, new Object[]{this, new Integer(state)});
        if (this.channel != null) {
            try {
                this.channel.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.channel = null;
        }
    }

    void closeOrgConnSocket(int state) {
        Debug.logMethod("TbKeepAlive.closeOrgConnSocket", new Object[]{this, new Integer(state), this.connNameForLog});
        try {
            this.socket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    synchronized void tryConnect() throws IOException {
        Debug.logMethod("TbKeepAlive.tryConnect", new Object[]{this, this.connNameForLog});
        if (this.registered && !this.socket.isClosed()) {
            ++this.tryCount;
            this.buf.position(0);
            this.replyMsgBodySize = -1;
            this.baseTime = System.currentTimeMillis();
            this.channel = SocketChannel.open();
            this.channel.configureBlocking(false);
            this.channel.connect(this.address);
        } else {
            Debug.log("Keep alive connection open failed. Socket is already closed.");
        }
    }

    synchronized int checkReply() throws IOException {
        if (!this.registered) {
            return 1;
        }
        this.channel.read(this.buf);
        if (this.replyMsgBodySize < 0) {
            if (this.buf.position() < 16) {
                return 2;
            }
            if (0 != TbCommon.bytes2Int(this.buf.array(), 0, 4)) {
                return 4;
            }
            this.replyMsgBodySize = TbCommon.bytes2Int(this.buf.array(), 4, 4);
        }
        if (this.replyMsgBodySize > 0 && this.buf.position() >= 16 + this.replyMsgBodySize - 16 + 4) {
            int instIdFromMthrPid = TbCommon.bytes2Int(this.buf.array(), 16 + this.replyMsgBodySize - 16, 4) >> 16;
            if (this.svrIntanceIdFromMthrPid == instIdFromMthrPid) {
                return 1;
            }
            return 4;
        }
        return 2;
    }

    long getBaseTime() {
        return this.baseTime;
    }

    int getTryCount() {
        return this.tryCount;
    }

    long getIdleMillis() {
        return this.idleMillis;
    }

    long getIntervalMillis() {
        return this.intervalMillis;
    }

    int getMaxRetryCount() {
        return this.maxRetryCount;
    }

    String getTargetAddressWithSvrInstId() {
        return String.valueOf(this.address) + ":" + this.svrIntanceIdFromMthrPid;
    }
}

