/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.dpl.binder;

import com.tmax.tibero.jdbc.comm.TbStreamDataWriter;
import com.tmax.tibero.jdbc.data.StreamBuffer;
import com.tmax.tibero.jdbc.dpl.TbDirPathStream;
import com.tmax.tibero.jdbc.dpl.binder.DPLBinder;
import com.tmax.tibero.jdbc.driver.TbConnection;
import com.tmax.tibero.jdbc.err.TbError;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;

public class DPLStreamBinder
extends DPLBinder {
    @Override
    public void bind(TbConnection conn, TbDirPathStream stream, TbStreamDataWriter writer, int paramIndex, int length) throws SQLException {
        InputStream inputStream = stream.getParamStream(paramIndex);
        StreamBuffer buf = writer.getStreamBuf();
        int readBufferBytes = 0;
        int availableBytes = 0;
        int readBytes = 0;
        try {
            if (buf.getRemained() <= 8) {
                stream.dirPathLoadStream(writer, 0);
            }
            while (length >= 0) {
                writer.writeInt(0, 4);
                availableBytes = buf.getRemained();
                readBytes = length > availableBytes - 4 ? availableBytes - 4 : length;
                readBufferBytes = inputStream.read(buf.getRawBytes(), buf.getCurDataSize(), readBytes);
                if (readBufferBytes == -1) {
                    readBufferBytes = 0;
                }
                writer.setCurDataSize(buf.getCurDataSize() + readBufferBytes);
                writer.reWriteInt(buf.getCurDataSize() - readBufferBytes - 4, readBufferBytes, 4);
                int padLen = writer.writePaddingDPL(readBufferBytes);
                if (availableBytes - (readBufferBytes + padLen) > 4) {
                    return;
                }
                stream.dirPathLoadStream(writer, 1);
                length -= readBufferBytes;
            }
        }
        catch (IOException e) {
            throw TbError.newSQLException(-90202, e.getMessage());
        }
    }
}

