/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.dpl;

import com.tmax.tibero.jdbc.err.TbError;
import com.tmax.tibero.jdbc.msg.TbColumnDesc;
import java.sql.SQLException;

public class TbDirPathMetaData {
    public static final boolean NO_LOG = false;
    public static final boolean LOG = true;
    public static final boolean NO_PARALLEL = false;
    public static final boolean PARALLEL = true;
    public static final int NO_BIND = 0;
    public static final int BIND = 256;
    public static final int MANUAL = 0;
    public static final int AUTO = 16;
    public static final int COMPLETE = 0;
    public static final int PARTIAL = 1;
    public static final int INIT_BUF_SIZE = 131072;
    public static final int CHAR_BUF_SIZE = 4096;
    public static final int BYTE_BUF_SIZE = 16384;
    private String schema;
    private String table;
    private String partition;
    private int columnCnt;
    private boolean logFlag = false;
    private boolean parallelFlag = false;
    private String clientCharset = null;
    private int bufferSize = 131072;
    private String[] columnNames;
    private TbColumnDesc[] columnMetas;

    public TbDirPathMetaData() {
        this.reset();
    }

    public TbDirPathMetaData(String schema, String table, String[] colName, boolean flag) throws SQLException {
        this.setSchema(schema);
        this.setTable(table);
        this.partition = "";
        this.columnNames = colName;
        this.logFlag = flag;
        this.columnCnt = colName.length;
        for (int i = 0; i < this.columnCnt; ++i) {
            this.setColumn(i + 1, colName[i]);
        }
    }

    public void checkDirPathMetaData() throws SQLException {
        if (this.schema == null || this.schema.length() == 0) {
            throw TbError.newSQLException(-90637);
        }
        if (this.table == null || this.table.length() == 0) {
            throw TbError.newSQLException(-90638);
        }
        if (this.columnNames == null) {
            throw TbError.newSQLException(-90640);
        }
        for (int i = 0; i < this.columnNames.length; ++i) {
            if (this.columnNames[i] != null && this.columnNames[i].length() != 0) continue;
            throw TbError.newSQLException(-90640);
        }
    }

    private void checkParameterIndex(int i) throws SQLException {
        if (i < 1 || i > this.columnCnt) {
            throw TbError.newSQLException(-90609);
        }
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public String getClientCharSet() {
        return this.clientCharset;
    }

    public String getColumn(int i) throws SQLException {
        if (this.columnNames == null) {
            throw TbError.newSQLException(-90640);
        }
        this.checkParameterIndex(i);
        return this.columnNames[i - 1];
    }

    public int getColumnCnt() {
        return this.columnNames.length;
    }

    public TbColumnDesc[] getColumnMetas() {
        return this.columnMetas;
    }

    public int getDataType(int i) throws SQLException {
        this.checkParameterIndex(i);
        return this.columnMetas[i - 1].dataType;
    }

    private String getDBString(String token) {
        int startQuoteIndex = token.indexOf(34);
        int endQuoteIndex = token.lastIndexOf(34);
        token = endQuoteIndex > startQuoteIndex ? token.substring(startQuoteIndex + 1, endQuoteIndex) : token.toUpperCase();
        return token;
    }

    public boolean getLogFlag() {
        return this.logFlag;
    }

    public String getSchema() {
        return this.schema;
    }

    public String getTable() {
        return this.table;
    }

    public void reset() {
        this.schema = null;
        this.table = null;
        this.partition = "";
        this.columnCnt = 0;
        this.logFlag = false;
        this.parallelFlag = false;
        this.clientCharset = null;
        this.columnNames = null;
        this.columnMetas = null;
    }

    public void setBufferSize(int size) {
        this.bufferSize = size;
    }

    public void setClientCharSet(String charset) {
        this.clientCharset = charset;
    }

    public void setColumn(int i, String name) throws SQLException {
        if (this.columnNames == null) {
            throw TbError.newSQLException(-90640);
        }
        this.checkParameterIndex(i);
        this.columnNames[i - 1] = this.getDBString(name);
    }

    public void setColumnCnt(int count) {
        this.columnCnt = count;
        if (this.columnNames == null) {
            this.columnNames = new String[count];
            for (int i = 0; i < count; ++i) {
                this.columnNames[i] = new String();
            }
        }
    }

    public void setColumnMetas(TbColumnDesc[] metas) {
        this.columnMetas = metas;
    }

    public void setLogFlag(boolean flag) {
        this.logFlag = flag;
    }

    public void setSchema(String name) throws SQLException {
        if (name == null || name.length() == 0) {
            throw TbError.newSQLException(-90637);
        }
        this.schema = this.getDBString(name);
    }

    public void setTable(String name) throws SQLException {
        if (name == null || name.length() == 0) {
            throw TbError.newSQLException(-90638);
        }
        this.table = this.getDBString(name);
    }

    public String getPartition() {
        return this.partition;
    }

    public void setPartition(String name) throws SQLException {
        if (name == null) {
            throw TbError.newSQLException(-90661);
        }
        this.partition = this.getDBString(name);
    }

    public boolean getParallelFlag() {
        return this.parallelFlag;
    }

    public void setParallelFlag(boolean flag) {
        this.parallelFlag = flag;
    }
}

