/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.data.charset;

import com.tmax.tibero.jdbc.err.TbError;
import java.sql.SQLException;

public class TCVN3ByteToCharConverter {
    protected boolean subMode = true;
    protected char[] subChars = new char[]{'?'};
    private static final char[] TCVN3_TO_UNICODE_PAGE = new char[]{'\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\u0102', '\u00c2', '\u00ca', '\u00d4', '\u01a0', '\u01af', '\u0110', '\u0103', '\u00e2', '\u00ea', '\u00f4', '\u01a1', '\u01b0', '\u0111', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\u00e0', '\u1ea3', '\u00e3', '\u00e1', '\u1ea1', '\ufffd', '\u1eb1', '\u1eb3', '\u1eb5', '\u1eaf', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\u1eb7', '\u1ea7', '\u1ea9', '\u1eab', '\u1ea5', '\u1ead', '\u00e8', '\ufffd', '\u1ebb', '\u1ebd', '\u00e9', '\u1eb9', '\u1ec1', '\u1ec3', '\u1ec5', '\u1ebf', '\u1ec7', '\u00ec', '\u1ec9', '\ufffd', '\ufffd', '\ufffd', '\u0129', '\u00ed', '\u1ecb', '\u00f2', '\ufffd', '\u1ecf', '\u00f5', '\u00f3', '\u1ecd', '\u1ed3', '\u1ed5', '\u1ed7', '\u1ed1', '\u1ed9', '\u1edd', '\u1edf', '\u1ee1', '\u1edb', '\u1ee3', '\u00f9', '\ufffd', '\u1ee7', '\u0169', '\u00fa', '\u1ee5', '\u1eeb', '\u1eed', '\u1eef', '\u1ee9', '\u1ef1', '\u1ef3', '\u1ef7', '\u1ef9', '\u00fd', '\u1ef5', '\ufffd'};

    private int decodeFromUcs(byte high, byte low) {
        return (high << 8) + (low & 0xFF);
    }

    private void encodeUCharToUCS2(char[] buf, int offset, int wc) {
        boolean high = false;
        byte low = (byte)wc;
        buf[offset] = (char)(high ? 1 : 0);
        buf[offset++] = (char)low;
    }

    public int convert(byte[] src, int srcStartOffset, int srcEndOffset, char[] dest, int destStartOffset, int destEndOffset) throws SQLException {
        int j;
        int i = srcStartOffset;
        for (j = destStartOffset; i < srcEndOffset && j < destEndOffset; ++i, ++j) {
            int wc = this.decodeFromUcs((byte)0, src[i]);
            if (wc < 128) {
                dest[j] = (char)wc;
                continue;
            }
            int k = wc - 128;
            if ((wc = TCVN3_TO_UNICODE_PAGE[k]) != 65533) {
                dest[j] = (char)wc;
                continue;
            }
            if (this.subMode) {
                this.encodeUCharToUCS2(dest, j, this.subChars[0]);
                continue;
            }
            throw TbError.newSQLException(-590742, wc);
        }
        return j - destStartOffset;
    }
}

