/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.data.charset;

import java.sql.SQLException;

public class ISO8859P15CharToByteConverter {
    protected boolean subMode = true;
    protected byte[] subBytes = new byte[]{63};
    private static final char[] UNICODE_TO_ISO8859P15_IDX_PAGE00 = new char[]{'\u00a0', '\u00a1', '\u00a2', '\u00a3', '\u0000', '\u00a5', '\u0000', '\u00a7', '\u0000', '\u00a9', '\u00aa', '\u00ab', '\u00ac', '\u00ad', '\u00ae', '\u00af', '\u00b0', '\u00b1', '\u00b2', '\u00b3', '\u0000', '\u00b5', '\u00b6', '\u00b7', '\u0000', '\u00b9', '\u00ba', '\u00bb', '\u0000', '\u0000', '\u0000', '\u00bf'};
    private static final char[] UNICODE_TO_ISO8859P15_IDX_PAGE01 = new char[]{'\u0000', '\u0000', '\u00bc', '\u00bd', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u00a6', '\u00a8', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u00be', '\u0000', '\u0000', '\u0000', '\u0000', '\u00b4', '\u00b8', '\u0000'};

    public int convCharArr(char[] src, int srcStartOffset, int srcEndOffset, byte[] dest, int destStartOffset, int destEndOffset) throws SQLException {
        int j = destStartOffset;
        for (int i = srcStartOffset; i < srcEndOffset && j < destEndOffset; ++i) {
            char wc = src[i];
            if (wc < '\u00a0') {
                dest[j++] = (byte)wc;
                continue;
            }
            int c1 = wc >= '\u00a0' && wc < '\u00c0' ? UNICODE_TO_ISO8859P15_IDX_PAGE00[wc - 160] : (wc >= '\u00c0' && wc < '\u0100' ? (int)wc : (wc >= '\u0150' && wc < '\u0180' ? UNICODE_TO_ISO8859P15_IDX_PAGE01[wc - 336] : (wc == '\u20ac' ? 164 : 63)));
            if (c1 == 0) {
                c1 = 63;
            }
            dest[j++] = (byte)c1;
        }
        return j - destStartOffset;
    }

    public int convString(String srcStr, int srcCharOffset, int srcCharEndOffset, byte[] destByteBuf, int destByteOffset, int destBufSize) throws SQLException {
        return this.convCharArr(srcStr.toCharArray(), srcCharOffset, srcCharEndOffset, destByteBuf, destByteOffset, destBufSize);
    }

    public int getMaxBytesPerChar() {
        return 1;
    }
}

