/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.data.charset;

import com.tmax.tibero.jdbc.data.charset.CharsetEncoder;
import com.tmax.tibero.jdbc.data.charset.GBKCharToByteConverter;
import java.sql.SQLException;

public class GBKEncoder
implements CharsetEncoder {
    private GBKCharToByteConverter conv = new GBKCharToByteConverter();
    private int maxBytesPerChar = this.conv.getMaxBytesPerChar();

    @Override
    public int charsToBytes(char[] srcChars, int srcStart, int srcLen, byte[] destBytes, int destStart, int destLen) throws SQLException {
        return this.conv.convCharArr(srcChars, srcStart, srcStart + srcLen, destBytes, destStart, destStart + destLen);
    }

    @Override
    public int charsToFixedBytes(char[] srcChars, int srcStart, int srcLen, byte[] destBytes, int destStart, int destLen) throws SQLException {
        return 0;
    }

    @Override
    public int getEndingBytePos(byte[] byteArr, int offset) {
        if (this.isEndingByte(byteArr, offset)) {
            return offset;
        }
        return offset + 1;
    }

    @Override
    public int getLeadingBytePos(byte[] byteArr, int offset) {
        if (this.isLeadingByte(byteArr, offset)) {
            return offset;
        }
        return offset - 1;
    }

    @Override
    public int getMaxBytesPerChar() {
        return this.maxBytesPerChar;
    }

    @Override
    public boolean isEndingByte(byte[] byteArr, int offset) {
        if (byteArr[offset] >= 0) {
            return true;
        }
        return !this.isLeadingByte(byteArr, offset);
    }

    @Override
    public boolean isLeadingByte(byte[] byteArr, int offset) {
        int i;
        for (i = offset; i >= 0 && byteArr[i] < 0; --i) {
        }
        return i == offset || (offset - i) % 2 == 1;
    }

    @Override
    public byte[] stringToBytes(String src) throws SQLException {
        byte[] temp = new byte[src.length() * this.getMaxBytesPerChar()];
        int byteLen = this.conv.convString(src, 0, src.length(), temp, 0, temp.length);
        byte[] dest = new byte[byteLen];
        System.arraycopy(temp, 0, dest, 0, byteLen);
        return dest;
    }

    @Override
    public int stringToBytes(byte[] buf, int offset, String src) throws SQLException {
        return this.conv.convString(src, 0, src.length(), buf, offset, buf.length);
    }
}

