/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.data.charset;

import com.tmax.tibero.jdbc.data.charset.JIS0201ByteToCharConverter;
import com.tmax.tibero.jdbc.data.charset.JIS0208ByteToCharConverter;
import com.tmax.tibero.jdbc.data.charset.JIS0212ByteToCharConverter;
import com.tmax.tibero.jdbc.data.charset.JIS0213ByteToCharConverter;
import com.tmax.tibero.jdbc.err.TbError;
import java.sql.SQLException;

public class EUCJPTILDEByteToCharConverter
extends JIS0208ByteToCharConverter {
    private JIS0201ByteToCharConverter JIS0201bc = new JIS0201ByteToCharConverter();
    private JIS0212ByteToCharConverter JIS0212bc = new JIS0212ByteToCharConverter();
    short[] JIS0208Index1;
    String[] JIS0208Index2;

    public EUCJPTILDEByteToCharConverter() {
        this.start = 161;
        this.end = 254;
        this.JIS0208Index1 = super.getIndex1();
        this.JIS0208Index2 = super.getIndex2();
    }

    protected char decode0212(int byte1, int byte2) throws SQLException {
        if (byte1 == -126 && byte2 == 55) {
            return '\uff5e';
        }
        return this.JIS0212bc.getUnicode(byte1, byte2);
    }

    @Override
    protected char getUnicode(int byte1, int byte2) throws SQLException {
        if (byte1 == 161 && byte2 == 193) {
            return '\uff5e';
        }
        if ((byte1 & 0xFF) == 161 && (byte2 & 0xFF) == 189) {
            return '\u2015';
        }
        if (byte1 == 142) {
            return this.JIS0201bc.getUnicode(byte2 - 256);
        }
        if (byte1 < 0 || byte1 > this.getIndex1().length || byte2 < this.start || byte2 > this.end) {
            return '\ufffd';
        }
        try {
            int n = (this.JIS0208Index1[byte1 - 128] & 0xF) * (this.end - this.start + 1) + (byte2 - this.start);
            return this.JIS0208Index2[this.JIS0208Index1[byte1 - 128] >> 4].charAt(n);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw TbError.newSQLException(-590743, e.getMessage());
        }
    }

    @Override
    public int convert(byte[] src, int srcStart, int srcLen, char[] dest, int destStart, int destLen) throws SQLException {
        int inputCharByteSize;
        int charOff = 0;
        int byteOff = 0;
        charOff = destStart;
        int outputChar = 65533;
        for (byteOff = srcStart; byteOff < srcLen; byteOff += inputCharByteSize) {
            int targetChar3;
            int targetChar2;
            boolean checkjisx0213 = false;
            int targetChar1 = src[byteOff] & 0xFF;
            inputCharByteSize = 1;
            if ((targetChar1 & 0x80) == 0) {
                outputChar = (char)targetChar1;
            } else {
                targetChar2 = src[byteOff + 1] & 0xFF;
                if ((targetChar1 & 0xFF) == 143) {
                    if (targetChar2 >= 161 && targetChar2 < 255) {
                        if (byteOff + 3 > srcLen) {
                            return charOff;
                        }
                        targetChar3 = src[byteOff + 2] & 0xFF;
                        inputCharByteSize += 2;
                        outputChar = this.decode0212(targetChar2 - 128, targetChar3 - 128);
                    }
                } else {
                    if (byteOff + 2 > srcLen) {
                        return charOff;
                    }
                    if (targetChar2 >= 161 && targetChar2 < 255) {
                        ++inputCharByteSize;
                        outputChar = this.getUnicode(targetChar1, targetChar2);
                    }
                }
                boolean bl = checkjisx0213 = outputChar == 65533;
            }
            if (checkjisx0213) {
                char[] ret0213;
                if (byteOff + 2 > srcLen) {
                    return charOff;
                }
                targetChar2 = src[byteOff + 1] & 0xFF;
                if (targetChar1 == 143) {
                    if (byteOff + 3 > srcLen) {
                        return charOff;
                    }
                    targetChar3 = src[byteOff + 2] & 0xFF;
                    ret0213 = JIS0213ByteToCharConverter.decode(384 + targetChar2, targetChar3 ^ 0x80);
                } else {
                    ret0213 = JIS0213ByteToCharConverter.decode(128 + targetChar1, targetChar2 ^ 0x80);
                }
                if (ret0213.length == 1) {
                    outputChar = ret0213[0];
                } else {
                    if (charOff + ret0213.length > destLen) {
                        return charOff - destStart;
                    }
                    System.arraycopy(ret0213, 0, dest, charOff, ret0213.length);
                    charOff += ret0213.length;
                    continue;
                }
            }
            if (charOff + 1 > destLen) {
                return charOff - destStart;
            }
            dest[charOff++] = outputChar;
        }
        return charOff - destStart;
    }
}

