/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.data.binder;

import com.tmax.tibero.jdbc.comm.TbStreamDataWriter;
import com.tmax.tibero.jdbc.data.ParamContainer;
import com.tmax.tibero.jdbc.data.binder.Binder;
import com.tmax.tibero.jdbc.driver.TbConnection;
import java.sql.SQLException;

public class BytesBinder
extends Binder {
    @Override
    public void bind(TbConnection conn, ParamContainer bpc, TbStreamDataWriter writer, int rowIndex, int paramIndex, int length) throws SQLException {
        int rpcolLen;
        byte[] bindParam = bpc.getParamBytes(rowIndex, paramIndex);
        int maxLength = length;
        int offset = writer.getBufferedDataSize();
        writer.makeBufferAvailable(maxLength + 3);
        byte[] byteBuf = writer.getStreamBuf().getRawBytes();
        if (maxLength <= 250) {
            byteBuf[offset] = (byte)maxLength;
            System.arraycopy(bindParam, 0, byteBuf, offset + 1, maxLength);
            rpcolLen = 1;
        } else {
            byteBuf[offset] = -2;
            byteBuf[offset + 1] = (byte)(0xFF & maxLength >> 8);
            byteBuf[offset + 2] = (byte)(0xFF & maxLength);
            System.arraycopy(bindParam, 0, byteBuf, offset + 3, maxLength);
            rpcolLen = 3;
        }
        writer.moveOffset(maxLength + rpcolLen);
        writer.writePadding(maxLength + rpcolLen);
    }

    @Override
    public void bind(TbConnection conn, ParamContainer bpc, TbStreamDataWriter writer, int rowIndex, int paramIndex, int length, boolean pad) throws SQLException {
        int rpcolLen;
        byte[] bindParam = bpc.getParamBytes(rowIndex, paramIndex);
        int maxLength = bindParam.length;
        int offset = writer.getBufferedDataSize();
        writer.makeBufferAvailable(maxLength + 3);
        byte[] byteBuf = writer.getStreamBuf().getRawBytes();
        if (maxLength <= 250) {
            byteBuf[offset] = (byte)maxLength;
            System.arraycopy(bindParam, 0, byteBuf, offset + 1, maxLength);
            rpcolLen = 1;
        } else {
            byteBuf[offset] = -2;
            byteBuf[offset + 1] = (byte)(0xFF & maxLength >> 8);
            byteBuf[offset + 2] = (byte)(0xFF & maxLength);
            System.arraycopy(bindParam, 0, byteBuf, offset + 3, maxLength);
            rpcolLen = 3;
        }
        writer.moveOffset(maxLength + rpcolLen);
        if (pad) {
            writer.writePadding(maxLength + rpcolLen);
        }
    }

    @Override
    public void bindDFR(TbConnection conn, ParamContainer bpc, TbStreamDataWriter writer, int rowIndex, int paramIndex, long length) throws SQLException {
    }
}

