/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.data;

public class StreamBuffer {
    private byte[] rawBytes;
    private int initSize;
    private int curSize;
    private int curDataSize;

    public StreamBuffer(int size) {
        this.rawBytes = new byte[size];
        this.initSize = size;
        this.curSize = size;
        this.curDataSize = 0;
    }

    public void copyMultiBytes(int size, int dataStartOffset, byte[] data) {
        this.makeBufferAvailable(size);
        System.arraycopy(data, dataStartOffset, this.rawBytes, this.curDataSize, size);
        this.moveOffset(size);
    }

    public void copySingleByte(byte data) {
        this.makeBufferAvailable(1);
        this.rawBytes[this.curDataSize++] = data;
    }

    public void delete() {
        this.initSize = 0;
        this.reset();
    }

    public int getCurDataSize() {
        return this.curDataSize;
    }

    public byte[] getRawBytes() {
        return this.rawBytes;
    }

    public int getRemained() {
        return this.curSize - this.curDataSize;
    }

    public int getSize() {
        return this.curSize;
    }

    public void growDoubleUp(int len) {
        int newSize = len > this.curSize ? len + this.curSize : this.curSize * 2;
        byte[] oldBuf = this.rawBytes;
        this.rawBytes = new byte[newSize];
        System.arraycopy(oldBuf, 0, this.rawBytes, 0, this.curDataSize);
        oldBuf = null;
        this.curSize = newSize;
    }

    public void init() {
        this.curDataSize = 0;
        if (this.rawBytes == null) {
            this.resize(this.curSize);
        }
    }

    public void init(int size) {
        if (this.curSize < size) {
            this.resize(size);
        } else {
            this.init();
        }
    }

    public void makeBufferAvailable(int len) {
        if (this.curDataSize + len > this.curSize) {
            this.growDoubleUp(len);
        }
    }

    public void moveOffset(int offset) {
        this.curDataSize += offset;
    }

    public void putData(int size, byte ch) {
        this.makeBufferAvailable(size);
        for (int i = 0; i < size; ++i) {
            this.rawBytes[this.curDataSize + i] = ch;
        }
        this.moveOffset(size);
    }

    public void reset() {
        this.rawBytes = null;
        this.curSize = 0;
        this.curDataSize = 0;
    }

    public void resize(int size) {
        this.rawBytes = new byte[size];
        this.curSize = size;
        this.curDataSize = 0;
    }

    public void setCurDataSize(int dataSize) {
        this.curDataSize = dataSize;
    }
}

