/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.data;

public class RsetType {
    public static final RsetType NULL = new RsetType(0, -1, -1);
    public static final RsetType FWRD = new RsetType(1, 1003, 1007);
    public static final RsetType FWUP = new RsetType(2, 1003, 1008);
    public static final RsetType SIRD = new RsetType(3, 1004, 1007);
    public static final RsetType SIUP = new RsetType(4, 1004, 1008);
    public static final RsetType SSRD = new RsetType(5, 1005, 1007);
    public static final RsetType SSUP = new RsetType(6, 1005, 1008);
    public static final int DEFAULT_TYPE = 1003;
    public static final int DEFAULT_CONCURRENCY = 1007;
    private int rank;
    private int type;
    private int concurrency;

    private RsetType(int rank1, int type1, int concur1) {
        this.type = type1;
        this.concurrency = concur1;
        this.rank = rank1;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof RsetType)) {
            return false;
        }
        return ((RsetType)obj).rank == this.rank && ((RsetType)obj).type == this.type && ((RsetType)obj).concurrency == this.concurrency;
    }

    public static RsetType getDownGradedRsetType(int rank) {
        switch (rank) {
            case 0: {
                return NULL;
            }
            case 1: {
                return FWRD;
            }
            case 2: {
                return FWRD;
            }
            case 3: {
                return SIRD;
            }
            case 4: {
                return SIRD;
            }
            case 5: {
                return SIRD;
            }
            case 6: {
                return SIRD;
            }
        }
        return FWRD;
    }

    public int getConcurrency() {
        return this.concurrency;
    }

    public RsetType getCopy() {
        switch (this.rank) {
            case 0: {
                return NULL;
            }
            case 1: {
                return FWRD;
            }
            case 2: {
                return FWUP;
            }
            case 3: {
                return SIRD;
            }
            case 4: {
                return SIUP;
            }
            case 5: {
                return SSRD;
            }
            case 6: {
                return SSUP;
            }
        }
        return FWRD;
    }

    public int getRank() {
        return this.rank;
    }

    public static RsetType getRsetType(int type, int concurrency) {
        if (type == 1003 && concurrency == 1007) {
            return FWRD;
        }
        if (type == 1003 && concurrency == 1008) {
            return FWUP;
        }
        if (type == 1004 && concurrency == 1007) {
            return SIRD;
        }
        if (type == 1004 && concurrency == 1008) {
            return SIUP;
        }
        if (type == 1005 && concurrency == 1007) {
            return SSRD;
        }
        if (type == 1005 && concurrency == 1008) {
            return SSUP;
        }
        if (type < 1004) {
            return FWRD;
        }
        return SIRD;
    }

    public int getType() {
        return this.type;
    }

    public boolean isScrollable() {
        return this.rank > 2;
    }

    public boolean isSensitive() {
        return this.rank == 5 || this.rank == 6;
    }

    public boolean isUpdatable() {
        return this.rank == 2 || this.rank == 4 || this.rank == 6;
    }

    public boolean useRowId() {
        return this.rank != 0 && this.rank != 1 && this.rank != 3;
    }

    public int getHoldability() {
        return 1;
    }

    public String toString() {
        switch (this.rank) {
            case 1: {
                return "RsetType@FWRD";
            }
            case 2: {
                return "RsetType@FWUP";
            }
            case 3: {
                return "RsetType@SIRD";
            }
            case 4: {
                return "RsetType@SIUP";
            }
            case 5: {
                return "RsetType@SSRD";
            }
            case 6: {
                return "RsetType@SSUP";
            }
        }
        return "RsetType@NULL";
    }
}

