/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.data;

import com.tmax.tibero.jdbc.data.Column;
import com.tmax.tibero.jdbc.err.TbError;
import com.tmax.tibero.jdbc.util.TbCommon;
import java.sql.SQLException;

public class Row {
    private int columnCount;
    private int[] columnOffset;
    private int[] columnLength;
    private int[] columnLengthQuotient;
    private Object[] rowChunk;

    public Row() {
    }

    public Row(int count) {
        this.columnCount = count;
        this.columnOffset = new int[count];
        this.columnLength = new int[count];
        this.columnLengthQuotient = new int[count];
        this.rowChunk = new Object[count];
    }

    public int buildRowData(byte[] rawBytes, int offset, Column[] cols) {
        int ptr = offset + 3;
        for (int i = 0; i < this.columnCount; ++i) {
            int len = TbCommon.bytes2Int(rawBytes, ptr, 1);
            if (len <= 250) {
                ++ptr;
            } else {
                len = TbCommon.bytes2Int(rawBytes, ptr + 1, 2);
                ptr += 3;
            }
            this.rowChunk[i] = rawBytes;
            if (len > 0 && cols[i].getDataType() == 1) {
                this.columnOffset[i] = ptr - 1;
                this.columnLength[i] = len + 1;
            } else {
                this.columnOffset[i] = ptr;
                this.columnLength[i] = len;
            }
            ptr += len < 0 ? 0 : len;
        }
        return ptr - offset;
    }

    public void close() {
        this.columnCount = 0;
        this.columnOffset = null;
        this.columnLength = null;
        this.columnLengthQuotient = null;
        this.rowChunk = null;
    }

    public void duplicate(Row srcRow) {
        this.columnCount = srcRow.columnCount;
        if (this.columnLength == null) {
            this.columnLength = new int[this.columnCount];
        }
        System.arraycopy(srcRow.columnLength, 0, this.columnLength, 0, this.columnCount);
        if (this.columnLengthQuotient == null) {
            this.columnLengthQuotient = new int[this.columnCount];
        }
        System.arraycopy(srcRow.columnLengthQuotient, 0, this.columnLengthQuotient, 0, this.columnCount);
        if (this.columnOffset == null) {
            this.columnOffset = new int[this.columnCount];
        }
        System.arraycopy(srcRow.columnOffset, 0, this.columnOffset, 0, this.columnCount);
        if (this.rowChunk == null) {
            this.rowChunk = new Object[this.columnCount];
        }
        System.arraycopy(srcRow.rowChunk, 0, this.rowChunk, 0, this.columnCount);
    }

    public int getColCnt() {
        return this.columnCount;
    }

    public int getColumnLength(int colIndex) {
        return this.columnLength[colIndex - 1];
    }

    public int getColumnLengthQuotient(int colIndex) {
        return this.columnLengthQuotient[colIndex - 1];
    }

    public int getColumnOffset(int colIndex) {
        return this.columnOffset[colIndex - 1];
    }

    public byte[] getRawBytes(int colIndex) throws SQLException {
        byte[] bytes = new byte[this.columnLength[colIndex - 1]];
        Object data = this.rowChunk[colIndex - 1];
        if (!(data instanceof byte[])) {
            throw TbError.newSQLException(-590705, data.toString());
        }
        System.arraycopy((byte[])data, this.columnOffset[colIndex - 1], bytes, 0, this.columnLength[colIndex - 1]);
        return bytes;
    }

    public Object getRowChunk(int colIndex) {
        return this.rowChunk[colIndex - 1];
    }

    public boolean isNull(int colIndex) throws SQLException {
        return this.columnLength[colIndex - 1] <= 0;
    }

    public void setUpdatedColumn(int i, int length, Object data) {
        if (this.rowChunk == null) {
            this.rowChunk = new Object[this.columnCount];
        }
        this.columnOffset[i - 1] = 0;
        this.columnLength[i - 1] = length;
        this.rowChunk[i - 1] = data;
    }
}

