/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.data;

import com.tmax.tibero.Debug;
import com.tmax.tibero.jdbc.TbLob;
import com.tmax.tibero.jdbc.data.NodeInfo;
import com.tmax.tibero.jdbc.err.TbError;
import com.tmax.tibero.jdbc.util.TbCommon;
import com.tmax.tibero.jdbc.util.TbRandom;
import java.sql.SQLException;
import java.util.Properties;
import java.util.Vector;

public class ConnectionInfo
implements Cloneable {
    public static final String DATABASENAME = "databaseName";
    public static final String DATASOURCENAME = "dataSourceName";
    public static final String DESCRIPTION = "description";
    public static final String DRIVERTYPE = "driverType";
    public static final String NETWORKPROTOCOL = "networkProtocol";
    public static final String PASSWORD = "password";
    public static final String PORTNUMBER = "portNumber";
    public static final String SERVERNAME = "serverName";
    public static final String USER = "user";
    public static final String TDU = "tdu";
    public static final String URL = "url";
    public static final String LOGIN_TIMEOUT = "login_timeout";
    public static final String READ_TIMEOUT = "read_timeout";
    public static final String LOAD_BALANCE = "load_balance";
    public static final String FAILOVER_RETRY_CNT = "failover_retry_count";
    public static final String FAILOVER = "failover";
    public static final String BACKUP_SERVER = "backup_server";
    public static final String BACKUP_PORT = "backup_port";
    public static final String CHARACTERSET = "characterset";
    public static final String PROGNAME = "program_name";
    public static final String STATEMENT_CACHE = "statement_cache";
    public static final String STATEMENT_CACHE_MAX_SIZE = "statement_cache_max_size";
    public static final String LOB_CHUNK_MAX_SIZE = "lobChunkMaxSize";
    public static final String INCLUDE_SYNONYMS = "includeSynonyms";
    public static final String MAP_DATE_TO_TIMESTAMP = "mapDateToTimestamp";
    public static final String DEFAULT_NCHAR = "defaultNChar";
    public static final String RELOAD_CONFIG = "reload_config";
    public static final String SELF_KEEPALIVE = "self_keepalive";
    public static final String SELF_KEEPALIVE_IDLE_TIME = "self_keepidle";
    public static final String SELF_KEEPALIVE_MAX_TRY_COUNT = "self_keepcnt";
    public static final String SELF_KEEPALIVE_INTERVAL_TIME = "self_keepintvl";
    public static final String NLS_DATETIME_FORMAT_ENABLED = "nls_datetime_format_enabled";
    private static final String NEW_PASSWORD = "new_password";
    private static final String DATABASE_PRODUCT_NAME = "databaseProductName";
    private static final String DATABASE_PRODUCT_VERSION = "databaseProductVersion";
    private static final String DRIVER_NAME = "driverName";
    private static final String DRIVER_VERSION = "driverVersion";
    private static final int DEFAULT_RETRY_COUNT = 3;
    private static final int DEFAULT_STMT_CACHE_MAX_SIZE = 5;
    private static final int DEFAULT_SELF_KEEPALIVE_IDLE_TIME = 60;
    private static final int DEFAULT_SELF_KEEPALIVE_MAX_TRY_COUNT = 3;
    private static final int DEFAULT_SELF_KEEPALIVE_INTERVAL_TIME = 10;
    private int failover = 0;
    private boolean loadBalance = false;
    private boolean connectedToPrimary = false;
    private int curNodeIdx = 0;
    private int visitedNodeCount = 0;
    private boolean[] visitedNodes = null;
    private Vector nodeList = null;
    private int tryCount = 0;
    private int retryCount = 3;
    private boolean selfKeepAlive = false;
    private int selfKeepIdle = 60;
    private int selfKeepCount = 3;
    private int selfKeepInterval = 10;
    private boolean nlsDTFormatEnabled = false;
    private String user;
    private String databaseName;
    private String datasourceName;
    private String description;
    private String driverType = "thin";
    private String protocol = "tcp";
    private String password;
    private String newPassword;
    private String url;
    private String databaseProductName;
    private String databaseProductVersion;
    private String driverName;
    private String driverVersion;
    private int tdu = 4096;
    private int loginTimeout = 0;
    private int readTimeout = 0;
    private String charset = null;
    private String progname = null;
    private boolean isXA = false;
    private boolean isInternal = false;
    private boolean stmtCache = false;
    private int stmtCacheMaxSize = 5;
    private boolean includeSynonyms = false;
    private boolean mapDateToTimestamp = true;
    private boolean defaultNChar = false;
    private int lobMaxChunkSize = TbLob.getMaxChunkSize();

    public ConnectionInfo() {
    }

    public ConnectionInfo(Properties props) {
        this.set(props);
    }

    public ConnectionInfo(String address, String username, String host, int port, String database, Properties connInfos) {
        host = TbCommon.getEmptyString(host, "localhost");
        if (port <= 0) {
            port = 8629;
        }
        NodeInfo node = new NodeInfo(host, port);
        if (this.nodeList == null) {
            this.nodeList = new Vector();
        }
        this.nodeList.add(node);
        this.setUser(username);
        this.setDatabaseName(database);
        this.url = address;
        if (connInfos != null) {
            this.datasourceName = connInfos.getProperty(DATASOURCENAME, "");
            this.description = connInfos.getProperty(DESCRIPTION, "");
            this.driverType = connInfos.getProperty(DRIVERTYPE, "thin");
            this.protocol = connInfos.getProperty(NETWORKPROTOCOL, "tcp");
            this.password = connInfos.getProperty(PASSWORD, "");
            this.newPassword = connInfos.getProperty(NEW_PASSWORD, "");
            String failoverVal = connInfos.getProperty(FAILOVER);
            this.failover = failoverVal == null ? 0 : ("ON".equalsIgnoreCase(failoverVal) || "SESSION".equalsIgnoreCase(failoverVal) ? 1 : ("CURSOR".equalsIgnoreCase(failoverVal) ? 3 : 0));
            this.loadBalance = connInfos.getProperty(LOAD_BALANCE, "").equalsIgnoreCase("ON");
            try {
                this.retryCount = Integer.parseInt(connInfos.getProperty(FAILOVER_RETRY_CNT));
                if (this.retryCount < 1) {
                    this.retryCount = 3;
                }
            }
            catch (NumberFormatException e) {
                this.retryCount = 3;
            }
            try {
                this.loginTimeout = Integer.parseInt(connInfos.getProperty(LOGIN_TIMEOUT));
            }
            catch (NumberFormatException e) {
                this.loginTimeout = 0;
            }
            try {
                this.readTimeout = Integer.parseInt(connInfos.getProperty(READ_TIMEOUT));
            }
            catch (NumberFormatException e) {
                this.readTimeout = 0;
            }
            try {
                this.tdu = Integer.parseInt(connInfos.getProperty(TDU));
            }
            catch (NumberFormatException ne) {
                this.tdu = 4096;
            }
            this.progname = connInfos.getProperty(PROGNAME);
            this.charset = connInfos.getProperty(CHARACTERSET);
            this.stmtCache = connInfos.getProperty(STATEMENT_CACHE, "OFF").equalsIgnoreCase("ON");
            try {
                this.stmtCacheMaxSize = Integer.parseInt(connInfos.getProperty(STATEMENT_CACHE_MAX_SIZE));
            }
            catch (NumberFormatException e) {
                this.stmtCacheMaxSize = 5;
            }
            try {
                this.lobMaxChunkSize = Integer.parseInt(connInfos.getProperty(LOB_CHUNK_MAX_SIZE));
                TbLob.setMaxChunkSize(this.lobMaxChunkSize);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            this.includeSynonyms = connInfos.getProperty(INCLUDE_SYNONYMS, "false").equalsIgnoreCase("true");
            this.mapDateToTimestamp = connInfos.getProperty(MAP_DATE_TO_TIMESTAMP, "true").equalsIgnoreCase("true");
            this.defaultNChar = connInfos.getProperty(DEFAULT_NCHAR, "false").equalsIgnoreCase("true");
            this.databaseProductName = connInfos.getProperty(DATABASE_PRODUCT_NAME, "");
            this.databaseProductVersion = connInfos.getProperty(DATABASE_PRODUCT_VERSION, "");
            this.driverName = connInfos.getProperty(DRIVER_NAME, "");
            this.driverVersion = connInfos.getProperty(DRIVER_VERSION, "");
            this.selfKeepAlive = connInfos.getProperty(SELF_KEEPALIVE, "false").equalsIgnoreCase("true");
            try {
                this.selfKeepIdle = Integer.parseInt(connInfos.getProperty(SELF_KEEPALIVE_IDLE_TIME));
            }
            catch (NumberFormatException e) {
                this.selfKeepIdle = 60;
            }
            try {
                this.selfKeepInterval = Integer.parseInt(connInfos.getProperty(SELF_KEEPALIVE_INTERVAL_TIME));
            }
            catch (NumberFormatException e) {
                this.selfKeepInterval = 10;
            }
            try {
                this.selfKeepCount = Integer.parseInt(connInfos.getProperty(SELF_KEEPALIVE_MAX_TRY_COUNT));
            }
            catch (NumberFormatException e) {
                this.selfKeepCount = 3;
            }
            this.nlsDTFormatEnabled = connInfos.getProperty(NLS_DATETIME_FORMAT_ENABLED, "false").equalsIgnoreCase("true");
        }
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (Exception e) {
            throw new RuntimeException("ConnectionInfo clone() failed:" + e.getMessage());
        }
    }

    public String getCharacterSet() {
        return this.charset;
    }

    public NodeInfo getClusterNode() throws SQLException {
        if (this.connectedToPrimary) {
            return this.getSecondaryNode();
        }
        return this.getPrimaryNode();
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getDataSourceName() {
        return this.datasourceName;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDriverType() {
        return this.driverType;
    }

    public int getFailover() {
        return this.failover;
    }

    public int getLoginTimeout() {
        return this.loginTimeout;
    }

    public String getNetworkProtocol() {
        return this.protocol;
    }

    public Vector getNodeList() {
        return this.nodeList;
    }

    public String getPassword() {
        return this.password;
    }

    public String getNewPassword() {
        return this.newPassword;
    }

    public int getFailoverRetryCount() {
        return this.retryCount;
    }

    public boolean getIncludeSynonyms() {
        return this.includeSynonyms;
    }

    public void setIncludeSynonyms(boolean synonyms) {
        this.includeSynonyms = synonyms;
    }

    public boolean getMapDateToTimestamp() {
        return this.mapDateToTimestamp;
    }

    public void setMapDateToTimestamp(boolean flag) {
        this.mapDateToTimestamp = flag;
    }

    public boolean getDefaultNChar() {
        return this.defaultNChar;
    }

    public void setDefaultNChar(boolean flag) {
        this.defaultNChar = flag;
    }

    public void setFailoverRetryCount(int count) {
        this.retryCount = this.retryCount < 1 ? 3 : count;
    }

    public boolean isStmtCache() {
        return this.stmtCache;
    }

    public void setStmtCache(boolean stmtCache) {
        this.stmtCache = stmtCache;
    }

    public int getStmtCacheMaxSize() {
        return this.stmtCacheMaxSize;
    }

    public void setStmtCacheMaxSize(int stmtCacheMaxSize) {
        this.stmtCacheMaxSize = stmtCacheMaxSize;
    }

    private synchronized NodeInfo getPrimaryNode() throws SQLException {
        Debug.logMethod("ConnectionInfo.getPrimaryNode", null, null);
        NodeInfo node = null;
        if (this.nodeList == null || this.nodeList.size() == 0) {
            throw TbError.newSQLException(-90400, "Node list is empty");
        }
        this.visitedNodes = new boolean[this.nodeList.size()];
        this.curNodeIdx = 0;
        if (this.loadBalance) {
            this.curNodeIdx = TbRandom.nextInt(this.nodeList.size());
        } else if (this.isFailoverSessionEnabled()) {
            for (int i = 0; i < this.nodeList.size(); ++i) {
                node = (NodeInfo)this.nodeList.get(i);
                if (node.getNodeType() != 1) continue;
                this.curNodeIdx = i;
                break;
            }
        }
        this.visitedNodeCount = 1;
        this.visitedNodes[this.curNodeIdx] = true;
        this.connectedToPrimary = true;
        return (NodeInfo)this.nodeList.get(this.curNodeIdx);
    }

    public String getProgramName() {
        return this.progname;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public synchronized NodeInfo getSecondaryNode() {
        Debug.logMethod("ConnectionInfo.getSecondaryNode", null, null);
        int i = 0;
        NodeInfo node = null;
        if (this.nodeList == null || this.nodeList.size() <= 1 || !this.isFailoverSessionEnabled()) {
            return null;
        }
        if (this.visitedNodeCount == this.nodeList.size()) {
            if (++this.tryCount == this.retryCount) {
                return null;
            }
            for (i = 0; i < this.nodeList.size(); ++i) {
                this.visitedNodes[i] = false;
            }
            this.visitedNodeCount = 0;
        }
        for (i = 0; i < this.nodeList.size(); ++i) {
            node = (NodeInfo)this.nodeList.get(i);
            if (node.getNodeType() != 2) continue;
            this.curNodeIdx = i;
            ++this.visitedNodeCount;
            this.visitedNodes[this.curNodeIdx] = true;
            return node;
        }
        do {
            int n = this.curNodeIdx = this.curNodeIdx + 1 >= this.nodeList.size() ? 0 : this.curNodeIdx + 1;
        } while (this.visitedNodes[this.curNodeIdx]);
        ++this.visitedNodeCount;
        this.visitedNodes[this.curNodeIdx] = true;
        return (NodeInfo)this.nodeList.get(this.curNodeIdx);
    }

    public int getTDU() {
        return this.tdu;
    }

    public String getURL() {
        return this.url;
    }

    public String getUser() {
        return this.user;
    }

    private String getUserName(String user) {
        if (user.length() >= 2 && user.startsWith("\"") && user.endsWith("\"")) {
            return user.substring(1, user.length() - 1);
        }
        return user.toUpperCase();
    }

    public boolean isFailoverSessionEnabled() {
        return (this.failover & 1) > 0;
    }

    public boolean isFailoverCursorEnabled() {
        return (this.failover & 2) > 0;
    }

    public boolean isInternal() {
        return this.isInternal;
    }

    public boolean isLoadBalance() {
        return this.loadBalance;
    }

    public boolean isXA() {
        return this.isXA;
    }

    public void set(Properties props) {
        int portNum;
        if (props == null) {
            return;
        }
        this.databaseName = props.getProperty(DATABASENAME, "");
        this.datasourceName = props.getProperty(DATASOURCENAME, "");
        this.description = props.getProperty(DESCRIPTION, "");
        this.setUser(props.getProperty(USER, ""));
        this.password = props.getProperty(PASSWORD, "");
        this.newPassword = props.getProperty(NEW_PASSWORD, "");
        this.url = props.getProperty(URL, "");
        this.driverType = props.getProperty(DRIVERTYPE, "thin");
        this.protocol = props.getProperty(NETWORKPROTOCOL, "tcp");
        String serverName = props.getProperty(SERVERNAME, "localhost");
        String portStr = props.getProperty(PORTNUMBER, "");
        try {
            portNum = Integer.parseInt(portStr);
        }
        catch (Exception ignore) {
            portNum = 8629;
        }
        if (this.nodeList == null) {
            this.nodeList = new Vector();
        }
        NodeInfo node = new NodeInfo(serverName, portNum);
        this.nodeList.add(node);
        String failoverVal = props.getProperty(FAILOVER);
        this.failover = failoverVal == null ? 0 : ("ON".equalsIgnoreCase(failoverVal) || "SESSION".equalsIgnoreCase(failoverVal) ? 1 : ("CURSOR".equalsIgnoreCase(failoverVal) ? 3 : 0));
        this.loadBalance = props.getProperty(LOAD_BALANCE, "").equalsIgnoreCase("ON");
        try {
            this.retryCount = Integer.parseInt(props.getProperty(FAILOVER_RETRY_CNT));
            if (this.retryCount < 1) {
                this.retryCount = 3;
            }
        }
        catch (NumberFormatException e) {
            this.retryCount = 3;
        }
        try {
            this.loginTimeout = Integer.parseInt(props.getProperty(LOGIN_TIMEOUT));
        }
        catch (NumberFormatException e) {
            this.loginTimeout = 0;
        }
        try {
            this.readTimeout = Integer.parseInt(props.getProperty(READ_TIMEOUT));
        }
        catch (NumberFormatException e) {
            this.readTimeout = 0;
        }
        try {
            this.tdu = Integer.parseInt(props.getProperty(TDU));
        }
        catch (Exception ignore) {
            this.tdu = 4096;
        }
        this.progname = props.getProperty(PROGNAME);
        this.charset = props.getProperty(CHARACTERSET);
        this.stmtCache = props.getProperty(STATEMENT_CACHE, "OFF").equalsIgnoreCase("ON");
        try {
            this.stmtCacheMaxSize = Integer.parseInt(props.getProperty(STATEMENT_CACHE_MAX_SIZE));
        }
        catch (NumberFormatException e) {
            this.stmtCacheMaxSize = 5;
        }
        try {
            this.lobMaxChunkSize = Integer.parseInt(props.getProperty(LOB_CHUNK_MAX_SIZE));
            TbLob.setMaxChunkSize(this.lobMaxChunkSize);
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        this.includeSynonyms = props.getProperty(INCLUDE_SYNONYMS, "false").equalsIgnoreCase("true");
        this.mapDateToTimestamp = props.getProperty(MAP_DATE_TO_TIMESTAMP, "true").equalsIgnoreCase("true");
        this.defaultNChar = props.getProperty(DEFAULT_NCHAR, "false").equalsIgnoreCase("true");
        this.databaseProductName = props.getProperty(DATABASE_PRODUCT_NAME, "");
        this.databaseProductVersion = props.getProperty(DATABASE_PRODUCT_VERSION, "");
        this.driverName = props.getProperty(DRIVER_NAME, "");
        this.driverVersion = props.getProperty(DRIVER_VERSION, "");
        this.selfKeepAlive = props.getProperty(SELF_KEEPALIVE, "false").equalsIgnoreCase("true");
        try {
            this.selfKeepIdle = Integer.parseInt(props.getProperty(SELF_KEEPALIVE_IDLE_TIME));
        }
        catch (NumberFormatException e) {
            this.selfKeepIdle = 60;
        }
        try {
            this.selfKeepInterval = Integer.parseInt(props.getProperty(SELF_KEEPALIVE_INTERVAL_TIME));
        }
        catch (NumberFormatException e) {
            this.selfKeepInterval = 10;
        }
        try {
            this.selfKeepCount = Integer.parseInt(props.getProperty(SELF_KEEPALIVE_MAX_TRY_COUNT));
        }
        catch (NumberFormatException e) {
            this.selfKeepCount = 3;
        }
        this.nlsDTFormatEnabled = props.getProperty(NLS_DATETIME_FORMAT_ENABLED, "false").equalsIgnoreCase("true");
    }

    public void update(Properties props) {
        String failoverVal;
        if (props == null) {
            return;
        }
        if (props.getProperty(DATABASENAME) != null) {
            this.databaseName = props.getProperty(DATABASENAME);
        }
        if (props.getProperty(DATASOURCENAME) != null) {
            this.datasourceName = props.getProperty(DATASOURCENAME);
        }
        if (props.getProperty(DESCRIPTION) != null) {
            this.description = props.getProperty(DESCRIPTION);
        }
        if (props.getProperty(USER) != null) {
            this.setUser(props.getProperty(USER));
        }
        if (props.getProperty(PASSWORD) != null) {
            this.password = props.getProperty(PASSWORD);
        }
        if (props.getProperty(NEW_PASSWORD) != null) {
            this.newPassword = props.getProperty(NEW_PASSWORD);
        }
        if (props.getProperty(URL) != null) {
            this.url = props.getProperty(URL);
        }
        if (props.getProperty(DRIVERTYPE) != null) {
            this.driverType = props.getProperty(DRIVERTYPE, "thin");
        }
        if (props.getProperty(NETWORKPROTOCOL) != null) {
            this.protocol = props.getProperty(NETWORKPROTOCOL, "tcp");
        }
        String serverName = null;
        if (props.getProperty(SERVERNAME) != null) {
            serverName = props.getProperty(SERVERNAME, "localhost");
        }
        int portNum = -1;
        if (props.getProperty(PORTNUMBER) != null) {
            String portStr = props.getProperty(PORTNUMBER);
            try {
                portNum = Integer.parseInt(portStr);
            }
            catch (Exception ignore) {
                portNum = 8629;
            }
        }
        if (serverName != null && portNum > 0) {
            this.nodeList = new Vector();
            NodeInfo node = new NodeInfo(serverName, portNum);
            this.nodeList.add(node);
        }
        if ((failoverVal = props.getProperty(FAILOVER)) != null) {
            this.failover = "ON".equalsIgnoreCase(failoverVal) || "SESSION".equalsIgnoreCase(failoverVal) ? 1 : ("CURSOR".equalsIgnoreCase(failoverVal) ? 3 : 0);
        }
        this.loadBalance = props.getProperty(LOAD_BALANCE, "").equalsIgnoreCase("ON");
        if (props.getProperty(LOAD_BALANCE) != null) {
            this.loadBalance = props.getProperty(LOAD_BALANCE, "").equalsIgnoreCase("ON");
        }
        if (props.getProperty(FAILOVER_RETRY_CNT) != null) {
            try {
                this.retryCount = Integer.parseInt(props.getProperty(FAILOVER_RETRY_CNT));
                if (this.retryCount < 1) {
                    this.retryCount = 3;
                }
            }
            catch (NumberFormatException e) {
                this.retryCount = 3;
            }
        }
        if (props.getProperty(LOGIN_TIMEOUT) != null) {
            try {
                this.loginTimeout = Integer.parseInt(props.getProperty(LOGIN_TIMEOUT));
            }
            catch (NumberFormatException e) {
                this.loginTimeout = 0;
            }
        }
        if (props.getProperty(READ_TIMEOUT) != null) {
            try {
                this.readTimeout = Integer.parseInt(props.getProperty(READ_TIMEOUT));
            }
            catch (NumberFormatException e) {
                this.readTimeout = 0;
            }
        }
        if (props.getProperty(TDU) != null) {
            try {
                this.tdu = Integer.parseInt(props.getProperty(TDU));
            }
            catch (Exception ignore) {
                this.tdu = 4096;
            }
        }
        if (props.getProperty(PROGNAME) != null) {
            this.progname = props.getProperty(PROGNAME);
        }
        if (props.getProperty(CHARACTERSET) != null) {
            this.charset = props.getProperty(CHARACTERSET);
        }
        if (props.getProperty(STATEMENT_CACHE) != null) {
            this.stmtCache = props.getProperty(STATEMENT_CACHE, "OFF").equalsIgnoreCase("ON");
        }
        if (props.getProperty(STATEMENT_CACHE_MAX_SIZE) != null) {
            try {
                this.stmtCacheMaxSize = Integer.parseInt(props.getProperty(STATEMENT_CACHE_MAX_SIZE));
            }
            catch (NumberFormatException e) {
                this.stmtCacheMaxSize = 5;
            }
        }
        if (props.getProperty(LOB_CHUNK_MAX_SIZE) != null) {
            try {
                this.lobMaxChunkSize = Integer.parseInt(props.getProperty(LOB_CHUNK_MAX_SIZE));
                TbLob.setMaxChunkSize(this.lobMaxChunkSize);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if (props.getProperty(INCLUDE_SYNONYMS) != null) {
            this.includeSynonyms = props.getProperty(INCLUDE_SYNONYMS, "false").equalsIgnoreCase("true");
        }
        if (props.getProperty(MAP_DATE_TO_TIMESTAMP) != null) {
            this.mapDateToTimestamp = props.getProperty(MAP_DATE_TO_TIMESTAMP, "true").equalsIgnoreCase("true");
        }
        if (props.getProperty(DEFAULT_NCHAR) != null) {
            this.defaultNChar = props.getProperty(DEFAULT_NCHAR, "false").equalsIgnoreCase("true");
        }
        if (props.getProperty(DATABASE_PRODUCT_NAME) != null) {
            this.databaseProductName = props.getProperty(DATABASE_PRODUCT_NAME, "");
        }
        if (props.getProperty(DATABASE_PRODUCT_VERSION) != null) {
            this.databaseProductVersion = props.getProperty(DATABASE_PRODUCT_VERSION, "");
        }
        if (props.getProperty(DRIVER_NAME) != null) {
            this.driverName = props.getProperty(DRIVER_NAME, "");
        }
        if (props.getProperty(DRIVER_VERSION) != null) {
            this.driverVersion = props.getProperty(DRIVER_VERSION, "");
        }
        if (props.getProperty(SELF_KEEPALIVE) != null) {
            this.selfKeepAlive = props.getProperty(SELF_KEEPALIVE, "false").equalsIgnoreCase("true");
        }
        if (props.getProperty(SELF_KEEPALIVE_IDLE_TIME) != null) {
            try {
                this.selfKeepIdle = Integer.parseInt(props.getProperty(SELF_KEEPALIVE_IDLE_TIME));
            }
            catch (NumberFormatException e) {
                this.selfKeepIdle = 60;
            }
        }
        if (props.getProperty(SELF_KEEPALIVE_INTERVAL_TIME) != null) {
            try {
                this.selfKeepInterval = Integer.parseInt(props.getProperty(SELF_KEEPALIVE_INTERVAL_TIME));
            }
            catch (NumberFormatException e) {
                this.selfKeepInterval = 10;
            }
        }
        if (props.getProperty(SELF_KEEPALIVE_MAX_TRY_COUNT) != null) {
            try {
                this.selfKeepCount = Integer.parseInt(props.getProperty(SELF_KEEPALIVE_MAX_TRY_COUNT));
            }
            catch (NumberFormatException e) {
                this.selfKeepCount = 3;
            }
        }
        if (props.getProperty(NLS_DATETIME_FORMAT_ENABLED) != null) {
            this.nlsDTFormatEnabled = props.getProperty(NLS_DATETIME_FORMAT_ENABLED, "false").equalsIgnoreCase("true");
        }
    }

    public void setDatabaseName(String str) {
        this.databaseName = TbCommon.getEmptyString(str, "");
    }

    public void setDatabaseProductName(String str) {
        this.databaseProductName = TbCommon.getEmptyString(str, "");
    }

    public void setDatabaseProductVersion(String str) {
        this.databaseProductVersion = TbCommon.getEmptyString(str, "");
    }

    public void setDriverName(String str) {
        this.driverName = TbCommon.getEmptyString(str, "");
    }

    public void setDriverVersion(String str) {
        this.driverVersion = TbCommon.getEmptyString(str, "");
    }

    public void setDataSourceName(String str) {
        this.datasourceName = TbCommon.getEmptyString(str, "");
    }

    public void setDescription(String str) {
        this.description = TbCommon.getEmptyString(str, "");
    }

    public void setDriverType(String str) {
        this.driverType = TbCommon.getEmptyString(str, "thin");
    }

    public void setFailover(int flag) {
        this.failover = flag;
    }

    public void setInternal(boolean flag) {
        this.isInternal = flag;
    }

    public void setLoadBalance(boolean flag) {
        this.loadBalance = flag;
    }

    public void setLobMaxChunkSize(int size) {
        this.lobMaxChunkSize = size;
    }

    public void setLoginTimeout(int timeout) {
        this.loginTimeout = timeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public void setCharacterSet(String charset) {
        this.charset = charset;
    }

    public void setProgramName(String name) {
        this.progname = TbCommon.getEmptyString(name, "");
    }

    public void setNetworkProtocol(String str) {
        this.protocol = TbCommon.getEmptyString(str, "tcp");
    }

    public void setNodeList(Vector nodes) {
        this.nodeList = nodes;
    }

    public void setPassword(String str) {
        this.password = TbCommon.getEmptyString(str, "");
    }

    public void setTDU(int i) {
        this.tdu = i <= 0 ? 4096 : i;
    }

    public void setURL(String address) {
        this.url = address;
    }

    public void setUser(String username) {
        this.user = this.getUserName(TbCommon.getEmptyString(username, ""));
    }

    public void setUser(String username, boolean removeQuote) {
        if (removeQuote) {
            this.setUser(username);
        } else {
            this.user = TbCommon.getEmptyString(username, "");
        }
    }

    public void setXA(boolean flag) {
        this.isXA = flag;
    }

    public String getDatabaseProductName() {
        return this.databaseProductName;
    }

    public String getDatabaseProductVersion() {
        return this.databaseProductVersion;
    }

    public String getDriverName() {
        return this.driverName;
    }

    public String getDriverVersion() {
        return this.driverVersion;
    }

    public int getLobMaxChunkSize() {
        return this.lobMaxChunkSize;
    }

    public boolean useSelfKeepAlive() {
        return this.selfKeepAlive;
    }

    public void setSelfKeepAlive(boolean selfKeepAlive) {
        this.selfKeepAlive = selfKeepAlive;
    }

    public int getSelfKeepIdle() {
        return this.selfKeepIdle;
    }

    public void setSelfKeepIdle(int selfKeepIdle) {
        this.selfKeepIdle = selfKeepIdle;
    }

    public int getSelfKeepCount() {
        return this.selfKeepCount;
    }

    public void setSelfKeepCount(int selfKeepCount) {
        this.selfKeepCount = selfKeepCount;
    }

    public int getSelfKeepInterval() {
        return this.selfKeepInterval;
    }

    public void setSelfKeepInterval(int selfKeepInterval) {
        this.selfKeepInterval = selfKeepInterval;
    }

    public boolean getNlsDatetimeFormatEnabled() {
        return this.nlsDTFormatEnabled;
    }

    public void setNlsDatetimeFormatEnabled(boolean enabled) {
        this.nlsDTFormatEnabled = enabled;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(256);
        buf.append("ConnInfo[").append("User=").append(this.user).append("/Password=").append(this.password != null ? "********" : null).append("/URL=").append(this.url).append("/DriverType=").append(this.driverType).append("/NetworkProtocol=").append(this.protocol).append("/TDU=").append(this.tdu).append("/DatabaseName=").append(this.databaseName).append("/DataSourceName=").append(this.datasourceName).append("/Failover=").append(this.failover).append("/LoadBalance=").append(this.loadBalance).append("/Description=").append(this.description).append("/ProgramName=").append(this.progname).append("/isXA=").append(this.isXA).append("/LoginTimeout=").append(this.loginTimeout).append("/ReadTimeout=").append(this.readTimeout).append("/SelfKeepAlive=").append(this.selfKeepAlive).append("/SelfKeepIdle=").append(this.selfKeepIdle).append("/SelfKeepInterval=").append(this.selfKeepInterval).append("/SelfKeepCount=").append(this.selfKeepCount).append("/IncludeSynonyms=").append(this.includeSynonyms).append("/MapDateToTimestamp=").append(this.mapDateToTimestamp).append("/NlsDatetimeFormatEnabled=").append(this.nlsDTFormatEnabled).append("]");
        return buf.toString();
    }
}

