/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.data;

import com.tmax.tibero.jdbc.TbTypeDescriptor;
import com.tmax.tibero.jdbc.data.DataType;
import com.tmax.tibero.jdbc.msg.TbColumnDesc;
import com.tmax.tibero.jdbc.util.TbCommon;
import java.sql.SQLException;

public class Column {
    private int colIdx = 0;
    private int dataType = 0;
    private int maxSize = 0;
    private String name = null;
    private int precision = 0;
    private int scale = 0;
    private int sqlType = 0;
    private boolean isNullable = false;
    private boolean mapDateToTimestamp;
    private TbTypeDescriptor descriptor;

    public Column() {
        this.mapDateToTimestamp = true;
    }

    public Column(boolean mapDateToTimestamp) {
        this.mapDateToTimestamp = mapDateToTimestamp;
    }

    public Column(Column src) {
        this.colIdx = src.colIdx;
        this.dataType = src.dataType;
        this.maxSize = src.maxSize;
        this.name = src.name;
        this.precision = src.precision;
        this.scale = src.scale;
        this.sqlType = src.sqlType;
        this.isNullable = src.isNullable;
        this.mapDateToTimestamp = src.mapDateToTimestamp;
        this.descriptor = src.descriptor;
    }

    public final int getDataType() {
        return this.dataType;
    }

    public final TbTypeDescriptor getDescriptor() {
        return this.descriptor;
    }

    public final int getMaxLength() {
        return this.maxSize;
    }

    public final String getName() {
        if (this.name == null || this.name.length() == 0) {
            return "column" + this.colIdx;
        }
        return this.name;
    }

    public final int getPrecision() {
        return this.precision;
    }

    public final int getScale() {
        return this.scale;
    }

    public final int getSqlType() {
        return this.sqlType;
    }

    public final boolean isNullable() {
        return this.isNullable;
    }

    public void set(int colIdx, TbColumnDesc colMeta) throws SQLException {
        this.colIdx = colIdx;
        this.dataType = colMeta.dataType;
        this.maxSize = colMeta.maxSize;
        this.name = colMeta.name;
        this.precision = colMeta.precision;
        this.scale = colMeta.scale;
        this.sqlType = colMeta.dataType == 16 ? -1 : DataType.getSqlType(colMeta.dataType, colMeta.precision, this.mapDateToTimestamp);
        this.isNullable = TbCommon.getBitmapAt(0, colMeta.etcMeta);
    }

    public void set(int colIdx, TbColumnDesc colMeta, TbTypeDescriptor descriptor) throws SQLException {
        this.set(colIdx, colMeta);
        this.descriptor = descriptor;
    }
}

