/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc;

import com.tmax.tibero.Debug;
import com.tmax.tibero.jdbc.TbBlob;
import com.tmax.tibero.jdbc.TbClob;
import com.tmax.tibero.jdbc.TbClobBase;
import com.tmax.tibero.jdbc.TbLob;
import com.tmax.tibero.jdbc.err.TbError;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;

public class TbLobOutputStream
extends OutputStream {
    private TbLob lob = null;
    private int bufOffset = 0;
    private long lobOffset = 0L;
    private boolean opened = false;
    private boolean isBlob = false;
    private byte[] byteBuf = null;
    private char[] charBuf = null;

    public TbLobOutputStream(TbLob lob, long pos) throws SQLException {
        Debug.logMethod("TbLobOutputStream", new Object[]{this, lob, Long.toString(pos)});
        if (lob == null) {
            throw TbError.newSQLException(-590767);
        }
        if (pos < 1L) {
            throw TbError.newSQLException(-590764, pos);
        }
        this.lob = lob;
        this.lobOffset = pos - 1L;
        this.bufOffset = 0;
        this.opened = true;
        if (lob instanceof TbClobBase) {
            this.charBuf = new char[TbLob.getMaxChunkSize()];
            this.isBlob = false;
        } else if (lob instanceof TbBlob) {
            this.byteBuf = new byte[TbLob.getMaxChunkSize()];
            this.isBlob = true;
        } else {
            throw TbError.newSQLException(-590770, lob.toString());
        }
    }

    private void checkClosed() throws IOException {
        if (!this.opened) {
            throw new IOException(TbError.getMsg(-90900));
        }
    }

    @Override
    public void close() throws IOException {
        Debug.logMethod("TbLobOutputStream.close", new Object[]{this, this.lob});
        try {
            this.flushBuffer();
        }
        catch (SQLException e) {
            throw new IOException(e.getMessage());
        }
        this.opened = false;
    }

    @Override
    public void flush() throws IOException {
        Debug.logMethod("TbLobOutputStream.flush", new Object[]{this, this.lob});
        try {
            this.flushBuffer();
        }
        catch (SQLException e) {
            throw new IOException(e.getMessage());
        }
    }

    private void flushBuffer() throws SQLException {
        int writeNum = 0;
        writeNum = this.isBlob ? ((TbBlob)this.lob).setBytes(this.lobOffset + 1L, this.byteBuf, 0, this.bufOffset) : ((TbClob)this.lob).putChars(this.lobOffset + 1L, this.charBuf, 0L, this.bufOffset);
        this.lobOffset += (long)writeNum;
        this.bufOffset = 0;
    }

    private int getRemainedInBuffer() {
        return TbLob.getMaxChunkSize() - this.bufOffset;
    }

    @Override
    public void write(int b) throws IOException {
        this.checkClosed();
        if (this.getRemainedInBuffer() == 0) {
            try {
                this.flushBuffer();
            }
            catch (SQLException e) {
                throw new IOException(e.getMessage());
            }
        }
        if (this.isBlob) {
            this.byteBuf[this.bufOffset++] = (byte)b;
        } else {
            this.charBuf[this.bufOffset++] = (char)b;
        }
    }
}

