/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc;

import com.tmax.tibero.jdbc.util.TbCommon;
import java.text.NumberFormat;

public class TbIntervalYtm {
    private final int MID_INT = 0x40000000;
    public static final int TB_INTERVAL_YTM_SIZE = 5;
    private byte[] bytes;
    private int precision = 2;

    public TbIntervalYtm(byte[] bytes, int precision) {
        this.bytes = bytes;
        if (precision >= 0) {
            this.precision = precision;
        }
    }

    public TbIntervalYtm(int year, int month) {
        if (this.bytes == null) {
            this.bytes = new byte[5];
        }
        TbCommon.int2Bytes(year += 0x40000000, this.bytes, 0, 4);
        this.bytes[4] = (byte)(month += 11);
    }

    public String toString() {
        int year = this.getIntFromBigEndianBytes(this.bytes, 0);
        int month = (0xFF & this.bytes[4]) - 11;
        NumberFormat nfYear = NumberFormat.getIntegerInstance();
        nfYear.setGroupingUsed(false);
        nfYear.setMinimumIntegerDigits(this.precision);
        NumberFormat nfMonth = NumberFormat.getIntegerInstance();
        nfMonth.setGroupingUsed(false);
        nfMonth.setMinimumIntegerDigits(2);
        month = Math.abs(month);
        StringBuffer sb = new StringBuffer();
        if (year >= 0) {
            sb.append("+");
        }
        sb.append(nfYear.format(year) + "-" + nfMonth.format(month));
        return sb.toString();
    }

    private int getIntFromBigEndianBytes(byte[] bytes, int offset) {
        int value = 0;
        for (int i = 0; i < 4; ++i) {
            value |= (0xFF & bytes[offset + i]) << 8 * (3 - i);
        }
        return value -= 0x40000000;
    }

    public byte[] getBytes() {
        return this.bytes;
    }
}

